/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetry;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.util.SecretDetector;

public class TelemetryData {
    private final ObjectNode message;
    private final long timeStamp;
    private static final ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();

    TelemetryData(ObjectNode message, long timeStamp) {
        this.message = (ObjectNode)SecretDetector.maskJacksonNode((JsonNode)message);
        this.timeStamp = timeStamp;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public ObjectNode getMessage() {
        return this.message;
    }

    public ObjectNode toJson() {
        ObjectNode node = mapper.createObjectNode();
        node.put("timestamp", this.timeStamp + "");
        node.set("message", (JsonNode)this.message);
        return node;
    }

    public String toString() {
        return this.toJson().toString();
    }
}

