/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLoggerFactory;
import org.apache.commons.logging.LogFactory;

public class SFLoggerUtil {
    public static void initializeSnowflakeLogger() {
        String logger = SnowflakeUtil.systemGetProperty("net.snowflake.jdbc.loggerImpl");
        SFLoggerFactory.LoggerImpl loggerImplementation = SFLoggerFactory.LoggerImpl.fromString(logger);
        if (loggerImplementation == null) {
            loggerImplementation = SFLoggerFactory.LoggerImpl.JDK14LOGGER;
        }
        System.setProperty("org.apache.commons.logging.LogFactory", "org.apache.commons.logging.impl.LogFactoryImpl");
        LogFactory logFactory = LogFactory.getFactory();
        switch (loggerImplementation) {
            case SLF4JLOGGER: {
                logFactory.setAttribute("org.apache.commons.logging.Log", (Object)"net.snowflake.client.log.SLF4JJCLWrapper");
                break;
            }
            default: {
                logFactory.setAttribute("org.apache.commons.logging.Log", (Object)"net.snowflake.client.log.JDK14JCLWrapper");
            }
        }
    }
}

