/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.snowflake.client.core.AssertUtil;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.CredentialManager;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.PrivateLinkDetector;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFLoginOutput;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SFTrustManager;
import net.snowflake.client.core.SessionUtilExternalBrowser;
import net.snowflake.client.core.SessionUtilKeyPair;
import net.snowflake.client.core.UUIDUtils;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeReauthenticationRequest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ClientAuthnDTO;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ClientAuthnParameter;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SecretDetector;
import net.snowflake.client.util.Stopwatch;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SessionUtil {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SessionUtil.class);
    private static final String SF_QUERY_DATABASE = "databaseName";
    private static final String SF_QUERY_SCHEMA = "schemaName";
    private static final String SF_QUERY_WAREHOUSE = "warehouse";
    private static final String SF_QUERY_ROLE = "roleName";
    private static final String SF_PATH_LOGIN_REQUEST = "/session/v1/login-request";
    private static final String SF_PATH_TOKEN_REQUEST = "/session/token-request";
    public static final String SF_PATH_AUTHENTICATOR_REQUEST = "/session/authenticator-request";
    public static final String SF_PATH_CONSOLE_LOGIN_REQUEST = "/console/login";
    public static final String SF_QUERY_SESSION_DELETE = "delete";
    @Deprecated
    public static final String SF_HEADER_AUTHORIZATION = "Authorization";
    private static final String SF_HEADER_BASIC_AUTHTYPE = "Basic";
    private static final String CLIENT_STORE_TEMPORARY_CREDENTIAL = "CLIENT_STORE_TEMPORARY_CREDENTIAL";
    private static final String CLIENT_REQUEST_MFA_TOKEN = "CLIENT_REQUEST_MFA_TOKEN";
    private static final String SERVICE_NAME = "SERVICE_NAME";
    private static final String CLIENT_IN_BAND_TELEMETRY_ENABLED = "CLIENT_TELEMETRY_ENABLED";
    private static final String CLIENT_OUT_OF_BAND_TELEMETRY_ENABLED = "CLIENT_OUT_OF_BAND_TELEMETRY_ENABLED";
    private static final String CLIENT_RESULT_COLUMN_CASE_INSENSITIVE = "CLIENT_RESULT_COLUMN_CASE_INSENSITIVE";
    private static final String JDBC_RS_COLUMN_CASE_INSENSITIVE = "JDBC_RS_COLUMN_CASE_INSENSITIVE";
    private static final String JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC = "JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC";
    private static final String JDBC_FORMAT_DATE_WITH_TIMEZONE = "JDBC_FORMAT_DATE_WITH_TIMEZONE";
    private static final String JDBC_USE_SESSION_TIMEZONE = "JDBC_USE_SESSION_TIMEZONE";
    public static final String JDBC_CHUNK_DOWNLOADER_MAX_RETRY = "JDBC_CHUNK_DOWNLOADER_MAX_RETRY";
    private static final String CLIENT_RESULT_CHUNK_SIZE_JVM = "net.snowflake.jdbc.clientResultChunkSize";
    public static final String CLIENT_RESULT_CHUNK_SIZE = "CLIENT_RESULT_CHUNK_SIZE";
    public static final String CLIENT_MEMORY_LIMIT_JVM = "net.snowflake.jdbc.clientMemoryLimit";
    public static final String CLIENT_MEMORY_LIMIT = "CLIENT_MEMORY_LIMIT";
    public static final String QUERY_CONTEXT_CACHE_SIZE = "QUERY_CONTEXT_CACHE_SIZE";
    public static final String JDBC_ENABLE_PUT_GET = "JDBC_ENABLE_PUT_GET";
    public static final String CLIENT_PREFETCH_THREADS_JVM = "net.snowflake.jdbc.clientPrefetchThreads";
    public static final String CLIENT_PREFETCH_THREADS = "CLIENT_PREFETCH_THREADS";
    public static final String CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE_JVM = "net.snowflake.jdbc.clientEnableConservativeMemoryUsage";
    public static final String CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE = "CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE";
    public static final String CLIENT_CONSERVATIVE_MEMORY_ADJUST_STEP = "CLIENT_CONSERVATIVE_MEMORY_ADJUST_STEP";
    public static final String OCSP_FAIL_OPEN_JVM = "net.snowflake.jdbc.ocspFailOpen";
    private static final String OCSP_FAIL_OPEN = "ocspFailOpen";
    public static final String CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY = "CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY";
    public static final String CLIENT_SFSQL = "CLIENT_SFSQL";
    public static final String CLIENT_VALIDATE_DEFAULT_PARAMETERS = "CLIENT_VALIDATE_DEFAULT_PARAMETERS";
    public static final String CLIENT_ENABLE_LOG_INFO_STATEMENT_PARAMETERS = "CLIENT_ENABLE_LOG_INFO_STATEMENT_PARAMETERS";
    public static final String CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX = "CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX";
    public static final String CLIENT_METADATA_USE_SESSION_DATABASE = "CLIENT_METADATA_USE_SESSION_DATABASE";
    public static final String ENABLE_STAGE_S3_PRIVATELINK_FOR_US_EAST_1 = "ENABLE_STAGE_S3_PRIVATELINK_FOR_US_EAST_1";
    static final String SF_HEADER_SERVICE_NAME = "X-Snowflake-Service";
    public static final String SF_HEADER_CLIENT_APP_ID = "CLIENT_APP_ID";
    public static final String SF_HEADER_CLIENT_APP_VERSION = "CLIENT_APP_VERSION";
    private static final String ID_TOKEN_AUTHENTICATOR = "ID_TOKEN";
    private static final String NO_QUERY_ID = "";
    private static final String SF_PATH_SESSION = "/session";
    public static long DEFAULT_CLIENT_MEMORY_LIMIT = 1536L;
    public static int DEFAULT_CLIENT_PREFETCH_THREADS = 4;
    public static int MIN_CLIENT_CHUNK_SIZE = 48;
    public static int MAX_CLIENT_CHUNK_SIZE = 160;
    public static Map<String, String> JVM_PARAMS_TO_PARAMS = Stream.of({"net.snowflake.jdbc.clientResultChunkSize", "CLIENT_RESULT_CHUNK_SIZE"}, {"net.snowflake.jdbc.clientMemoryLimit", "CLIENT_MEMORY_LIMIT"}, {"net.snowflake.jdbc.clientPrefetchThreads", "CLIENT_PREFETCH_THREADS"}, {"net.snowflake.jdbc.ocspFailOpen", "ocspFailOpen"}, {"net.snowflake.jdbc.clientEnableConservativeMemoryUsage", "CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE"}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
    private static ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
    private static int DEFAULT_HEALTH_CHECK_INTERVAL = 45;
    private static Set<String> STRING_PARAMS = new HashSet<String>(Arrays.asList("TIMEZONE", "TIMESTAMP_OUTPUT_FORMAT", "TIMESTAMP_NTZ_OUTPUT_FORMAT", "TIMESTAMP_LTZ_OUTPUT_FORMAT", "TIMESTAMP_TZ_OUTPUT_FORMAT", "DATE_OUTPUT_FORMAT", "TIME_OUTPUT_FORMAT", "BINARY_OUTPUT_FORMAT", "CLIENT_TIMESTAMP_TYPE_MAPPING", "SERVICE_NAME", "GEOGRAPHY_OUTPUT_FORMAT"));
    private static final Set<String> INT_PARAMS = new HashSet<String>(Arrays.asList("CLIENT_PREFETCH_THREADS", "CLIENT_MEMORY_LIMIT", "CLIENT_RESULT_CHUNK_SIZE", "CLIENT_STAGE_ARRAY_BINDING_THRESHOLD", "CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY"));
    private static final Set<String> BOOLEAN_PARAMS = new HashSet<String>(Arrays.asList("CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY", "CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ", "CLIENT_DISABLE_INCIDENTS", "CLIENT_SESSION_KEEP_ALIVE", "CLIENT_ENABLE_LOG_INFO_STATEMENT_PARAMETERS", "CLIENT_TELEMETRY_ENABLED", "CLIENT_OUT_OF_BAND_TELEMETRY_ENABLED", "CLIENT_STORE_TEMPORARY_CREDENTIAL", "CLIENT_REQUEST_MFA_TOKEN", "JDBC_USE_JSON_PARSER", "AUTOCOMMIT", "JDBC_EFFICIENT_CHUNK_STORAGE", "JDBC_RS_COLUMN_CASE_INSENSITIVE", "JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC", "JDBC_FORMAT_DATE_WITH_TIMEZONE", "JDBC_USE_SESSION_TIMEZONE", "CLIENT_RESULT_COLUMN_CASE_INSENSITIVE", "CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX", "CLIENT_METADATA_USE_SESSION_DATABASE", "JDBC_TREAT_DECIMAL_AS_INT", "JDBC_ENABLE_COMBINED_DESCRIBE", "CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE", "CLIENT_VALIDATE_DEFAULT_PARAMETERS", "ENABLE_STAGE_S3_PRIVATELINK_FOR_US_EAST_1", "SNOWPARK_LAZY_ANALYSIS"));

    private static ClientAuthnDTO.AuthenticatorType getAuthenticator(SFLoginInput loginInput) {
        if (loginInput.getAuthenticator() != null) {
            if (loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER.name())) {
                return ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER;
            }
            if (loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.OAUTH.name())) {
                return ClientAuthnDTO.AuthenticatorType.OAUTH;
            }
            if (loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT.name())) {
                return ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT;
            }
            if (loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.USERNAME_PASSWORD_MFA.name())) {
                return ClientAuthnDTO.AuthenticatorType.USERNAME_PASSWORD_MFA;
            }
            if (!loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.SNOWFLAKE.name())) {
                return ClientAuthnDTO.AuthenticatorType.OKTA;
            }
        }
        return loginInput.getPrivateKey() != null || loginInput.getPrivateKeyFile() != null ? ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT : ClientAuthnDTO.AuthenticatorType.SNOWFLAKE;
    }

    static SFLoginOutput openSession(SFLoginInput loginInput, Map<SFSessionProperty, Object> connectionPropertiesMap, String tracingLevel) throws SFException, SnowflakeSQLException {
        AssertUtil.assertTrue(loginInput.getServerUrl() != null, "missing server URL for opening session");
        AssertUtil.assertTrue(loginInput.getAppId() != null, "missing app id for opening session");
        AssertUtil.assertTrue(loginInput.getLoginTimeout() >= 0, "negative login timeout for opening session");
        ClientAuthnDTO.AuthenticatorType authenticator = SessionUtil.getAuthenticator(loginInput);
        if (!authenticator.equals((Object)ClientAuthnDTO.AuthenticatorType.OAUTH)) {
            AssertUtil.assertTrue(loginInput.getUserName() != null, "missing user name for opening session");
        } else {
            AssertUtil.assertTrue(loginInput.getToken() != null || loginInput.getPassword() != null, "missing token or password for opening session");
        }
        if (authenticator.equals((Object)ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER)) {
            if (Constants.getOS() == Constants.OS.MAC || Constants.getOS() == Constants.OS.WINDOWS) {
                loginInput.getSessionParameters().put(CLIENT_STORE_TEMPORARY_CREDENTIAL, true);
            } else if (!loginInput.getSessionParameters().containsKey(CLIENT_STORE_TEMPORARY_CREDENTIAL)) {
                loginInput.getSessionParameters().put(CLIENT_STORE_TEMPORARY_CREDENTIAL, false);
            }
        } else {
            Object value = loginInput.getSessionParameters().get(CLIENT_STORE_TEMPORARY_CREDENTIAL);
            if (value != null) {
                loginInput.getSessionParameters().put(CLIENT_STORE_TEMPORARY_CREDENTIAL, SessionUtil.asBoolean(value));
            }
        }
        if (authenticator.equals((Object)ClientAuthnDTO.AuthenticatorType.USERNAME_PASSWORD_MFA) && (Constants.getOS() == Constants.OS.MAC || Constants.getOS() == Constants.OS.WINDOWS)) {
            loginInput.getSessionParameters().put(CLIENT_REQUEST_MFA_TOKEN, true);
        }
        SessionUtil.preNewSession(loginInput);
        try {
            return SessionUtil.newSession(loginInput, connectionPropertiesMap, tracingLevel);
        }
        catch (SnowflakeReauthenticationRequest ex) {
            logger.debug("ID Token being used has expired. Reauthenticating with ID Token cleared...", new Object[0]);
            return SessionUtil.newSession(loginInput, connectionPropertiesMap, tracingLevel);
        }
    }

    private static void preNewSession(SFLoginInput loginInput) throws SFException {
        if (SessionUtil.asBoolean(loginInput.getSessionParameters().get(CLIENT_STORE_TEMPORARY_CREDENTIAL))) {
            CredentialManager.getInstance().fillCachedIdToken(loginInput);
        }
        if (SessionUtil.asBoolean(loginInput.getSessionParameters().get(CLIENT_REQUEST_MFA_TOKEN))) {
            CredentialManager.getInstance().fillCachedMfaToken(loginInput);
        }
    }

    private static boolean asBoolean(Object value) {
        if (value == null) {
            return false;
        }
        switch (value.getClass().getName()) {
            case "java.lang.Boolean": {
                return (Boolean)value;
            }
            case "java.lang.String": {
                return Boolean.valueOf((String)value);
            }
        }
        return false;
    }

    private static SFLoginOutput newSession(SFLoginInput loginInput, Map<SFSessionProperty, Object> connectionPropertiesMap, String tracingLevel) throws SFException, SnowflakeSQLException {
        Map<String, Object> commonParams;
        String sessionWarehouse;
        String sessionRole;
        String sessionSchema;
        String sessionDatabase;
        String sessionId;
        long masterTokenValidityInSeconds;
        String mfaToken;
        String idToken;
        String masterToken;
        String sessionToken;
        URI loginURI;
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        String tokenOrSamlResponse = null;
        String samlProofKey = null;
        boolean consentCacheIdToken = true;
        String databaseVersion = null;
        int databaseMajorVersion = 0;
        int databaseMinorVersion = 0;
        int healthCheckInterval = DEFAULT_HEALTH_CHECK_INTERVAL;
        int httpClientSocketTimeout = loginInput.getSocketTimeoutInMillis();
        ClientAuthnDTO.AuthenticatorType authenticatorType = SessionUtil.getAuthenticator(loginInput);
        String oktaUsername = loginInput.getOKTAUserName();
        logger.debug("Authenticating user: {}, host: {} with authentication method: {}. Login timeout: {} s, auth timeout: {} s, OCSP mode: {}{}", new Object[]{loginInput.getUserName(), loginInput.getHostFromServerUrl(), authenticatorType, loginInput.getLoginTimeout(), loginInput.getAuthTimeout(), loginInput.getOCSPMode(), Strings.isNullOrEmpty((String)oktaUsername) ? NO_QUERY_ID : ", okta username: " + oktaUsername});
        try {
            Object s;
            URIBuilder uriBuilder = new URIBuilder(loginInput.getServerUrl());
            if (loginInput.getDatabaseName() != null) {
                uriBuilder.addParameter(SF_QUERY_DATABASE, loginInput.getDatabaseName());
            }
            if (loginInput.getSchemaName() != null) {
                uriBuilder.addParameter(SF_QUERY_SCHEMA, loginInput.getSchemaName());
            }
            if (loginInput.getWarehouse() != null) {
                uriBuilder.addParameter(SF_QUERY_WAREHOUSE, loginInput.getWarehouse());
            }
            if (loginInput.getRole() != null) {
                uriBuilder.addParameter(SF_QUERY_ROLE, loginInput.getRole());
            }
            if (authenticatorType == ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER) {
                if (loginInput.getIdToken() == null) {
                    s = SessionUtilExternalBrowser.createInstance(loginInput);
                    ((SessionUtilExternalBrowser)s).authenticate();
                    tokenOrSamlResponse = ((SessionUtilExternalBrowser)s).getToken();
                    samlProofKey = ((SessionUtilExternalBrowser)s).getProofKey();
                    consentCacheIdToken = ((SessionUtilExternalBrowser)s).isConsentCacheIdToken();
                }
            } else if (authenticatorType == ClientAuthnDTO.AuthenticatorType.OKTA) {
                tokenOrSamlResponse = SessionUtil.getSamlResponseUsingOkta(loginInput);
            } else if (authenticatorType == ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT) {
                s = new SessionUtilKeyPair(loginInput.getPrivateKey(), loginInput.getPrivateKeyFile(), loginInput.getPrivateKeyFilePwd(), loginInput.getAccountName(), loginInput.getUserName());
                loginInput.setToken(((SessionUtilKeyPair)s).issueJwtToken());
                loginInput.setAuthTimeout(SessionUtilKeyPair.getTimeout());
            }
            uriBuilder.addParameter("requestId", UUIDUtils.getUUID().toString());
            uriBuilder.setPath(SF_PATH_LOGIN_REQUEST);
            loginURI = uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            logger.error("Exception when building URL", ex);
            throw new SFException(ex, ErrorCode.INTERNAL_ERROR, "unexpected URI syntax exception:1");
        }
        try {
            SessionUtil.resetOCSPUrlIfNecessary(loginInput.getServerUrl());
        }
        catch (IOException ex) {
            throw new SFException(ex, ErrorCode.IO_ERROR, "unexpected URL syntax exception");
        }
        HttpPost postRequest = null;
        try {
            ClientAuthnDTO authnData = new ClientAuthnDTO();
            authnData.setInFlightCtx(loginInput.getInFlightCtx());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(ClientAuthnParameter.CLIENT_APP_ID.name(), loginInput.getAppId());
            data.put(ClientAuthnParameter.LOGIN_NAME.name(), loginInput.getUserName());
            if (authenticatorType == ClientAuthnDTO.AuthenticatorType.SNOWFLAKE) {
                data.put(ClientAuthnParameter.PASSWORD.name(), loginInput.getPassword());
            } else if (authenticatorType == ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER) {
                if (loginInput.getIdToken() != null) {
                    data.put(ClientAuthnParameter.AUTHENTICATOR.name(), ID_TOKEN_AUTHENTICATOR);
                    data.put(ClientAuthnParameter.TOKEN.name(), loginInput.getIdToken());
                } else {
                    data.put(ClientAuthnParameter.AUTHENTICATOR.name(), ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER.name());
                    data.put(ClientAuthnParameter.PROOF_KEY.name(), samlProofKey);
                    data.put(ClientAuthnParameter.TOKEN.name(), tokenOrSamlResponse);
                }
            } else if (authenticatorType == ClientAuthnDTO.AuthenticatorType.OKTA) {
                data.put(ClientAuthnParameter.RAW_SAML_RESPONSE.name(), tokenOrSamlResponse);
            } else if (authenticatorType == ClientAuthnDTO.AuthenticatorType.OAUTH) {
                data.put(ClientAuthnParameter.AUTHENTICATOR.name(), authenticatorType.name());
                if (loginInput.getToken() != null) {
                    data.put(ClientAuthnParameter.TOKEN.name(), loginInput.getToken());
                } else {
                    data.put(ClientAuthnParameter.TOKEN.name(), loginInput.getPassword());
                }
            } else if (authenticatorType == ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT) {
                data.put(ClientAuthnParameter.AUTHENTICATOR.name(), authenticatorType.name());
                data.put(ClientAuthnParameter.TOKEN.name(), loginInput.getToken());
            } else if (authenticatorType == ClientAuthnDTO.AuthenticatorType.USERNAME_PASSWORD_MFA) {
                data.put(ClientAuthnParameter.PASSWORD.name(), loginInput.getPassword());
                if (loginInput.getMfaToken() != null) {
                    data.put(ClientAuthnParameter.TOKEN.name(), loginInput.getMfaToken());
                }
            }
            HashMap<String, String> clientEnv = new HashMap<String, String>();
            clientEnv.put("OS", SnowflakeUtil.systemGetProperty("os.name"));
            clientEnv.put("OS_VERSION", SnowflakeUtil.systemGetProperty("os.version"));
            clientEnv.put("JAVA_VERSION", SnowflakeUtil.systemGetProperty("java.version"));
            clientEnv.put("JAVA_RUNTIME", SnowflakeUtil.systemGetProperty("java.runtime.name"));
            clientEnv.put("JAVA_VM", SnowflakeUtil.systemGetProperty("java.vm.name"));
            clientEnv.put("OCSP_MODE", loginInput.getOCSPMode().name());
            if (loginInput.getApplication() != null) {
                clientEnv.put("APPLICATION", loginInput.getApplication());
            } else {
                String appName = SnowflakeUtil.systemGetProperty("sun.java.command");
                if (appName != null) {
                    if (appName.indexOf(" ") > 0) {
                        appName = appName.substring(0, appName.indexOf(" "));
                    }
                    clientEnv.put("APPLICATION", appName);
                }
            }
            String clientInfoJSONStr = connectionPropertiesMap.containsKey((Object)SFSessionProperty.CLIENT_INFO) ? (String)connectionPropertiesMap.get((Object)SFSessionProperty.CLIENT_INFO) : SnowflakeUtil.systemGetProperty("snowflake.client.info");
            if (clientInfoJSONStr != null) {
                JsonNode clientInfoJSON = null;
                try {
                    clientInfoJSON = mapper.readTree(clientInfoJSONStr);
                }
                catch (Throwable throwable) {
                    logger.debug("failed to process snowflake.client.info property as JSON: {}", clientInfoJSONStr, throwable);
                }
                if (clientInfoJSON != null) {
                    Iterator iterator = clientInfoJSON.fields();
                    while (iterator.hasNext()) {
                        Map.Entry field = (Map.Entry)iterator.next();
                        clientEnv.put((String)field.getKey(), ((JsonNode)field.getValue()).asText());
                    }
                }
            }
            for (Map.Entry entry : connectionPropertiesMap.entrySet()) {
                if (((SFSessionProperty)((Object)entry.getKey())).equals((Object)SFSessionProperty.APP_ID) || ((SFSessionProperty)((Object)entry.getKey())).equals((Object)SFSessionProperty.APP_VERSION)) continue;
                String propKey = ((SFSessionProperty)((Object)entry.getKey())).getPropertyKey();
                String propVal = SecretDetector.maskParameterValue(propKey, entry.getValue().toString());
                clientEnv.put(propKey, propVal);
            }
            if (!connectionPropertiesMap.containsKey((Object)SFSessionProperty.TRACING)) {
                clientEnv.put(SFSessionProperty.TRACING.getPropertyKey(), tracingLevel);
            }
            clientEnv.put("JDBC_JAR_NAME", SnowflakeDriver.getJdbcJarname());
            data.put(ClientAuthnParameter.CLIENT_ENVIRONMENT.name(), clientEnv);
            Map<String, Object> sessionParameter = loginInput.getSessionParameters();
            if (loginInput.isValidateDefaultParameters()) {
                sessionParameter.put(CLIENT_VALIDATE_DEFAULT_PARAMETERS, true);
            }
            if (sessionParameter != null) {
                data.put(ClientAuthnParameter.SESSION_PARAMETERS.name(), loginInput.getSessionParameters());
            }
            if (loginInput.getAccountName() != null) {
                data.put(ClientAuthnParameter.ACCOUNT_NAME.name(), loginInput.getAccountName());
            }
            if (loginInput.isPasscodeInPassword()) {
                data.put(ClientAuthnParameter.EXT_AUTHN_DUO_METHOD.name(), "passcode");
            } else if (loginInput.getPasscode() != null) {
                data.put(ClientAuthnParameter.EXT_AUTHN_DUO_METHOD.name(), "passcode");
                data.put(ClientAuthnParameter.PASSCODE.name(), loginInput.getPasscode());
            } else {
                data.put(ClientAuthnParameter.EXT_AUTHN_DUO_METHOD.name(), "push");
            }
            data.put(ClientAuthnParameter.CLIENT_APP_VERSION.name(), loginInput.getAppVersion());
            authnData.setData(data);
            String string = mapper.writeValueAsString((Object)authnData);
            postRequest = new HttpPost(loginURI);
            HttpUtil.applyAdditionalHeadersForSnowsight((HttpRequestBase)postRequest, loginInput.getAdditionalHttpHeadersForSnowsight());
            postRequest.addHeader(SF_HEADER_CLIENT_APP_ID, loginInput.getAppId());
            postRequest.addHeader(SF_HEADER_CLIENT_APP_VERSION, loginInput.getAppVersion());
            StringEntity input = new StringEntity(string, StandardCharsets.UTF_8);
            input.setContentType("application/json");
            postRequest.setEntity((HttpEntity)input);
            postRequest.addHeader("accept", "application/json");
            postRequest.addHeader("Accept-Encoding", NO_QUERY_ID);
            postRequest.setHeader(SF_HEADER_AUTHORIZATION, SF_HEADER_BASIC_AUTHTYPE);
            SessionUtil.setServiceNameHeader(loginInput, postRequest);
            String theString = null;
            int leftRetryTimeout = loginInput.getLoginTimeout();
            int leftsocketTimeout = loginInput.getSocketTimeoutInMillis();
            int retryCount = 0;
            Exception lastRestException = null;
            while (true) {
                try {
                    theString = HttpUtil.executeGeneralRequest((HttpRequestBase)postRequest, leftRetryTimeout, loginInput.getAuthTimeout(), leftsocketTimeout, retryCount, loginInput.getHttpClientSettingsKey());
                }
                catch (SnowflakeSQLException ex) {
                    lastRestException = ex;
                    if (ex.getErrorCode() == ErrorCode.AUTHENTICATOR_REQUEST_TIMEOUT.getMessageCode().intValue()) {
                        if (authenticatorType != ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT && authenticatorType != ClientAuthnDTO.AuthenticatorType.OKTA) break;
                        if (authenticatorType == ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT) {
                            SessionUtilKeyPair s = new SessionUtilKeyPair(loginInput.getPrivateKey(), loginInput.getPrivateKeyFile(), loginInput.getPrivateKeyFilePwd(), loginInput.getAccountName(), loginInput.getUserName());
                            data.put(ClientAuthnParameter.TOKEN.name(), s.issueJwtToken());
                        } else if (authenticatorType == ClientAuthnDTO.AuthenticatorType.OKTA) {
                            logger.debug("Retrieve new token for Okta authentication.", new Object[0]);
                            tokenOrSamlResponse = SessionUtil.getSamlResponseUsingOkta(loginInput);
                            data.put(ClientAuthnParameter.RAW_SAML_RESPONSE.name(), tokenOrSamlResponse);
                            authnData.setData(data);
                            String updatedJson = mapper.writeValueAsString((Object)authnData);
                            StringEntity updatedInput = new StringEntity(updatedJson, StandardCharsets.UTF_8);
                            updatedInput.setContentType("application/json");
                            postRequest.setEntity((HttpEntity)updatedInput);
                        }
                        long elapsedSeconds = ex.getElapsedSeconds();
                        if (loginInput.getLoginTimeout() > 0) {
                            leftRetryTimeout = (long)leftRetryTimeout > elapsedSeconds ? (int)((long)leftRetryTimeout - elapsedSeconds) : 1;
                        }
                        if (loginInput.getSocketTimeoutInMillis() > 0) {
                            leftsocketTimeout = ex.issocketTimeoutNoBackoff() ? ((long)leftsocketTimeout > elapsedSeconds ? (int)((long)leftsocketTimeout - elapsedSeconds) : 1) : loginInput.getSocketTimeoutInMillis();
                        }
                        retryCount = ex.getRetryCount();
                        continue;
                    }
                    throw ex;
                }
                catch (Exception ex) {
                    lastRestException = ex;
                }
                break;
            }
            if (theString == null) {
                if (lastRestException != null) {
                    logger.error("Failed to open new session for user: {}, host: {}. Error: {}", loginInput.getUserName(), loginInput.getHostFromServerUrl(), lastRestException);
                    throw lastRestException;
                }
                SnowflakeSQLException exception = new SnowflakeSQLException(NO_QUERY_ID, "empty authentication response", "08000", ErrorCode.CONNECTION_ERROR.getMessageCode());
                logger.error("Failed to open new session for user: {}, host: {}. Error: {}", loginInput.getUserName(), loginInput.getHostFromServerUrl(), exception);
                throw exception;
            }
            JsonNode jsonNode = mapper.readTree(theString);
            if (!jsonNode.path("success").asBoolean()) {
                logger.debug("Response: {}", theString);
                int errorCode = jsonNode.path("code").asInt();
                if (errorCode == 390195) {
                    loginInput.setIdToken(null);
                    SessionUtil.deleteIdTokenCache(loginInput.getHostFromServerUrl(), loginInput.getUserName());
                    logger.debug("ID Token Expired / Not Applicable. Reauthenticating without ID Token...: {}", errorCode);
                    SnowflakeUtil.checkErrorAndThrowExceptionIncludingReauth(jsonNode);
                }
                if (authenticatorType == ClientAuthnDTO.AuthenticatorType.USERNAME_PASSWORD_MFA) {
                    SessionUtil.deleteMfaTokenCache(loginInput.getHostFromServerUrl(), loginInput.getUserName());
                }
                String errorMessage = jsonNode.path("message").asText();
                logger.error("Failed to open new session for user: {}, host: {}. Error: {}", loginInput.getUserName(), loginInput.getHostFromServerUrl(), errorMessage);
                throw new SnowflakeSQLException(NO_QUERY_ID, errorMessage, "08001", errorCode);
            }
            sessionToken = jsonNode.path("data").path("token").asText();
            masterToken = jsonNode.path("data").path("masterToken").asText();
            idToken = SessionUtil.nullStringAsEmptyString(jsonNode.path("data").path("idToken").asText());
            mfaToken = SessionUtil.nullStringAsEmptyString(jsonNode.path("data").path("mfaToken").asText());
            masterTokenValidityInSeconds = jsonNode.path("data").path("masterValidityInSeconds").asLong();
            String serverVersion = jsonNode.path("data").path("serverVersion").asText();
            sessionId = jsonNode.path("data").path("sessionId").asText();
            JsonNode dbNode = jsonNode.path("data").path("sessionInfo").path(SF_QUERY_DATABASE);
            sessionDatabase = dbNode.isNull() ? null : dbNode.asText();
            JsonNode schemaNode = jsonNode.path("data").path("sessionInfo").path(SF_QUERY_SCHEMA);
            sessionSchema = schemaNode.isNull() ? null : schemaNode.asText();
            JsonNode roleNode = jsonNode.path("data").path("sessionInfo").path(SF_QUERY_ROLE);
            sessionRole = roleNode.isNull() ? null : roleNode.asText();
            JsonNode warehouseNode = jsonNode.path("data").path("sessionInfo").path("warehouseName");
            sessionWarehouse = warehouseNode.isNull() ? null : warehouseNode.asText();
            commonParams = SessionUtil.getCommonParams(jsonNode.path("data").path("parameters"));
            if (serverVersion != null) {
                logger.debug("Server version: {}", serverVersion);
                databaseVersion = serverVersion.indexOf(" ") > 0 ? serverVersion.substring(0, serverVersion.indexOf(" ")) : serverVersion;
            } else {
                logger.debug("Server version is null", false);
            }
            if (databaseVersion != null) {
                String[] components = databaseVersion.split("\\.");
                if (components.length >= 2) {
                    try {
                        databaseMajorVersion = Integer.parseInt(components[0]);
                        databaseMinorVersion = Integer.parseInt(components[1]);
                    }
                    catch (Exception ex) {
                        logger.error("Exception encountered when parsing server version: {} Exception: {}", databaseVersion, ex.getMessage());
                    }
                }
            } else {
                logger.debug("database version is null", false);
            }
            if (!jsonNode.path("data").path("newClientForUpgrade").isNull()) {
                String newClientForUpgrade = jsonNode.path("data").path("newClientForUpgrade").asText();
                logger.debug("New client: {}", newClientForUpgrade);
            }
            int healthCheckIntervalFromGS = jsonNode.path("data").path("healthCheckInterval").asInt();
            logger.debug("Health check interval: {}", healthCheckIntervalFromGS);
            if (healthCheckIntervalFromGS > 0 && healthCheckIntervalFromGS != healthCheckInterval) {
                httpClientSocketTimeout = loginInput.getSocketTimeoutInMillis() + healthCheckIntervalFromGS * 1000;
                RequestConfig requestConfig = RequestConfig.copy((RequestConfig)HttpUtil.getRequestConfigWithoutCookies()).setConnectTimeout((int)loginInput.getConnectionTimeout().toMillis()).setSocketTimeout(httpClientSocketTimeout).build();
                HttpUtil.setRequestConfig(requestConfig);
                logger.debug("Adjusted connection timeout to: {}", loginInput.getConnectionTimeout());
                logger.debug("Adjusted socket timeout to: {}", httpClientSocketTimeout);
            }
        }
        catch (SnowflakeSQLException ex) {
            throw ex;
        }
        catch (IOException ex) {
            logger.error("IOException when creating session: " + postRequest, ex);
            throw new SnowflakeSQLException((Throwable)ex, "58030", (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "Exception encountered when opening connection: " + ex.getMessage());
        }
        catch (Throwable ex) {
            logger.error("Exception when creating session: " + postRequest, ex);
            throw new SnowflakeSQLException(ex, "08001", (int)ErrorCode.CONNECTION_ERROR.getMessageCode(), ErrorCode.CONNECTION_ERROR.getMessageCode(), ex.getMessage());
        }
        SFLoginOutput ret = new SFLoginOutput(sessionToken, masterToken, masterTokenValidityInSeconds, idToken, mfaToken, databaseVersion, databaseMajorVersion, databaseMinorVersion, httpClientSocketTimeout, sessionDatabase, sessionSchema, sessionRole, sessionWarehouse, sessionId, commonParams);
        if (consentCacheIdToken && SessionUtil.asBoolean(loginInput.getSessionParameters().get(CLIENT_STORE_TEMPORARY_CREDENTIAL))) {
            CredentialManager.getInstance().writeIdToken(loginInput, ret);
        }
        if (SessionUtil.asBoolean(loginInput.getSessionParameters().get(CLIENT_REQUEST_MFA_TOKEN))) {
            CredentialManager.getInstance().writeMfaToken(loginInput, ret);
        }
        stopwatch.stop();
        logger.debug("User: {}, host: {} with authentication method: {} authenticated successfully in {} ms", new Object[]{loginInput.getUserName(), loginInput.getHostFromServerUrl(), authenticatorType, stopwatch.elapsedMillis()});
        return ret;
    }

    private static void setServiceNameHeader(SFLoginInput loginInput, HttpPost postRequest) {
        if (!Strings.isNullOrEmpty((String)loginInput.getServiceName())) {
            postRequest.setHeader(SF_HEADER_SERVICE_NAME, loginInput.getServiceName());
        }
    }

    private static String nullStringAsEmptyString(String value) {
        if (Strings.isNullOrEmpty((String)value) || "null".equals(value)) {
            return NO_QUERY_ID;
        }
        return value;
    }

    public static void deleteIdTokenCache(String host, String user) {
        CredentialManager.getInstance().deleteIdTokenCache(host, user);
    }

    public static void deleteMfaTokenCache(String host, String user) {
        CredentialManager.getInstance().deleteMfaTokenCache(host, user);
    }

    static SFLoginOutput renewSession(SFLoginInput loginInput) throws SFException, SnowflakeSQLException {
        return SessionUtil.tokenRequest(loginInput, TokenRequestType.RENEW);
    }

    private static SFLoginOutput tokenRequest(SFLoginInput loginInput, TokenRequestType requestType) throws SFException, SnowflakeSQLException {
        String masterToken;
        String sessionToken;
        HttpPost postRequest;
        AssertUtil.assertTrue(loginInput.getServerUrl() != null, "missing server URL for tokenRequest");
        AssertUtil.assertTrue(loginInput.getMasterToken() != null, "missing master token for tokenRequest");
        AssertUtil.assertTrue(loginInput.getSessionToken() != null, "missing session token for tokenRequest");
        AssertUtil.assertTrue(loginInput.getLoginTimeout() >= 0, "negative login timeout for tokenRequest");
        try {
            URIBuilder uriBuilder = new URIBuilder(loginInput.getServerUrl());
            uriBuilder.setPath(SF_PATH_TOKEN_REQUEST);
            uriBuilder.addParameter("requestId", UUIDUtils.getUUID().toString());
            postRequest = new HttpPost(uriBuilder.build());
            postRequest.addHeader(SF_HEADER_CLIENT_APP_ID, loginInput.getAppId());
            postRequest.addHeader(SF_HEADER_CLIENT_APP_VERSION, loginInput.getAppVersion());
            HttpUtil.applyAdditionalHeadersForSnowsight((HttpRequestBase)postRequest, loginInput.getAdditionalHttpHeadersForSnowsight());
        }
        catch (URISyntaxException ex) {
            logger.error("Exception when creating http request", ex);
            throw new SFException(ex, ErrorCode.INTERNAL_ERROR, "unexpected URI syntax exception:3");
        }
        try {
            HashMap<String, String> payload = new HashMap<String, String>();
            String headerToken = loginInput.getMasterToken();
            payload.put("oldSessionToken", loginInput.getSessionToken());
            payload.put("requestType", requestType.value);
            String json = mapper.writeValueAsString(payload);
            StringEntity input = new StringEntity(json, StandardCharsets.UTF_8);
            input.setContentType("application/json");
            postRequest.setEntity((HttpEntity)input);
            postRequest.addHeader("accept", "application/json");
            postRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + headerToken + "\"");
            SessionUtil.setServiceNameHeader(loginInput, postRequest);
            logger.debug("Request type: {}, old session token: {}, master token: {}", requestType.value, () -> loginInput.getSessionToken() != null ? "******" : null, () -> loginInput.getMasterToken() != null ? "******" : null);
            String theString = HttpUtil.executeGeneralRequest((HttpRequestBase)postRequest, loginInput.getLoginTimeout(), loginInput.getAuthTimeout(), loginInput.getSocketTimeoutInMillis(), 0, loginInput.getHttpClientSettingsKey());
            JsonNode jsonNode = mapper.readTree(theString);
            if (!jsonNode.path("success").asBoolean()) {
                logger.debug("Response: {}", theString);
                String errorCode = jsonNode.path("code").asText();
                String message = jsonNode.path("message").asText();
                EventUtil.triggerBasicEvent(Event.EventType.NETWORK_ERROR, "SessionUtil:renewSession failure, error code=" + errorCode + ", message=" + message, true);
                SnowflakeUtil.checkErrorAndThrowExceptionIncludingReauth(jsonNode);
            }
            sessionToken = jsonNode.path("data").path("sessionToken").asText();
            masterToken = jsonNode.path("data").path("masterToken").asText();
        }
        catch (IOException ex) {
            logger.error("IOException when renewing session: " + postRequest, ex);
            throw new SFException(ex, ErrorCode.NETWORK_ERROR, ex.getMessage());
        }
        SFLoginOutput loginOutput = new SFLoginOutput();
        loginOutput.setSessionToken(sessionToken).setMasterToken(masterToken);
        return loginOutput;
    }

    static void closeSession(SFLoginInput loginInput) throws SFException, SnowflakeSQLException {
        block4: {
            logger.trace("void close() throws SFException", new Object[0]);
            AssertUtil.assertTrue(loginInput.getServerUrl() != null, "missing server URL for closing session");
            AssertUtil.assertTrue(loginInput.getSessionToken() != null, "missing session token for closing session");
            AssertUtil.assertTrue(loginInput.getLoginTimeout() >= 0, "missing login timeout for closing session");
            HttpPost postRequest = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(loginInput.getServerUrl());
                uriBuilder.addParameter(SF_QUERY_SESSION_DELETE, Boolean.TRUE.toString());
                uriBuilder.addParameter("requestId", UUIDUtils.getUUID().toString());
                uriBuilder.setPath(SF_PATH_SESSION);
                postRequest = new HttpPost(uriBuilder.build());
                HttpUtil.applyAdditionalHeadersForSnowsight((HttpRequestBase)postRequest, loginInput.getAdditionalHttpHeadersForSnowsight());
                postRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + loginInput.getSessionToken() + "\"");
                SessionUtil.setServiceNameHeader(loginInput, postRequest);
                String theString = HttpUtil.executeGeneralRequest((HttpRequestBase)postRequest, loginInput.getLoginTimeout(), loginInput.getAuthTimeout(), loginInput.getSocketTimeoutInMillis(), 0, loginInput.getHttpClientSettingsKey());
                logger.debug("Connection close response: {}", theString);
                JsonNode rootNode = mapper.readTree(theString);
                SnowflakeUtil.checkErrorAndThrowException(rootNode);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException("Unexpected URI syntax exception", ex);
            }
            catch (IOException ex) {
                logger.error("Unexpected IO exception for: " + postRequest, ex);
            }
            catch (SnowflakeSQLException ex) {
                if (ex.getErrorCode() == 390112 || ex.getErrorCode() == 390111) break block4;
                throw ex;
            }
        }
    }

    private static String federatedFlowStep4(SFLoginInput loginInput, String ssoUrl, String oneTimeToken) throws SnowflakeSQLException {
        String responseHtml = NO_QUERY_ID;
        try {
            URL url = new URL(ssoUrl);
            URI oktaGetUri = new URIBuilder().setScheme(url.getProtocol()).setHost(url.getHost()).setPath(url.getPath()).setParameter("RelayState", "%2Fsome%2Fdeep%2Flink").setParameter("onetimetoken", oneTimeToken).build();
            HttpGet httpGet = new HttpGet(oktaGetUri);
            HeaderGroup headers = new HeaderGroup();
            headers.addHeader((Header)new BasicHeader("Accept", "*/*"));
            httpGet.setHeaders(headers.getAllHeaders());
            responseHtml = HttpUtil.executeGeneralRequest((HttpRequestBase)httpGet, loginInput.getLoginTimeout(), loginInput.getAuthTimeout(), loginInput.getSocketTimeoutInMillis(), 0, loginInput.getHttpClientSettingsKey());
            SessionUtil.validateSAML(responseHtml, loginInput);
        }
        catch (IOException | URISyntaxException ex) {
            SessionUtil.handleFederatedFlowError(loginInput, ex);
        }
        return responseHtml;
    }

    private static void validateSAML(String responseHtml, SFLoginInput loginInput) throws SnowflakeSQLException, MalformedURLException {
        String postBackUrl;
        if (!loginInput.getDisableSamlURLCheck() && !SessionUtil.isPrefixEqual(postBackUrl = SessionUtil.getPostBackUrlFromHTML(responseHtml), loginInput.getServerUrl())) {
            URL idpDestinationUrl = new URL(postBackUrl);
            URL clientDestinationUrl = new URL(loginInput.getServerUrl());
            String idpDestinationHostName = idpDestinationUrl.getHost();
            String clientDestinationHostName = clientDestinationUrl.getHost();
            logger.error("The Snowflake hostname specified in the client connection {} does not match the destination hostname in the SAML response returned by the IdP: {}", clientDestinationHostName, idpDestinationHostName);
            throw new SnowflakeSQLLoggedException(null, (int)ErrorCode.IDP_INCORRECT_DESTINATION.getMessageCode(), "08001");
        }
    }

    private static String federatedFlowStep3(SFLoginInput loginInput, String tokenUrl) throws SnowflakeSQLException {
        String oneTimeToken = NO_QUERY_ID;
        try {
            URL url = new URL(tokenUrl);
            URI tokenUri = url.toURI();
            HttpPost postRequest = new HttpPost(tokenUri);
            String userName = Strings.isNullOrEmpty((String)loginInput.getOKTAUserName()) ? loginInput.getUserName() : loginInput.getOKTAUserName();
            StringEntity params = new StringEntity("{\"username\":\"" + userName + "\",\"password\":\"" + loginInput.getPassword() + "\"}");
            postRequest.setEntity((HttpEntity)params);
            HeaderGroup headers = new HeaderGroup();
            headers.addHeader((Header)new BasicHeader("Accept", "application/json"));
            headers.addHeader((Header)new BasicHeader("Content-Type", "application/json"));
            postRequest.setHeaders(headers.getAllHeaders());
            String idpResponse = HttpUtil.executeRequestWithoutCookies((HttpRequestBase)postRequest, loginInput.getLoginTimeout(), loginInput.getAuthTimeout(), loginInput.getSocketTimeoutInMillis(), 0, 0, null, loginInput.getHttpClientSettingsKey());
            logger.debug("User is authenticated against {}.", loginInput.getAuthenticator());
            JsonNode jsonNode = mapper.readTree(idpResponse);
            oneTimeToken = jsonNode.get("sessionToken") != null ? jsonNode.get("sessionToken").asText() : jsonNode.get("cookieToken").asText();
        }
        catch (IOException | URISyntaxException ex) {
            SessionUtil.handleFederatedFlowError(loginInput, ex);
        }
        return oneTimeToken;
    }

    private static void federatedFlowStep2(SFLoginInput loginInput, String tokenUrl, String ssoUrl) throws SnowflakeSQLException {
        try {
            if (!SessionUtil.isPrefixEqual(loginInput.getAuthenticator(), tokenUrl) || !SessionUtil.isPrefixEqual(loginInput.getAuthenticator(), ssoUrl)) {
                logger.debug("The specified authenticator {} is not supported.", loginInput.getAuthenticator());
                throw new SnowflakeSQLLoggedException(null, (int)ErrorCode.IDP_CONNECTION_ERROR.getMessageCode(), "08001");
            }
        }
        catch (MalformedURLException ex) {
            SessionUtil.handleFederatedFlowError(loginInput, ex);
        }
    }

    private static JsonNode federatedFlowStep1(SFLoginInput loginInput) throws SnowflakeSQLException {
        JsonNode dataNode = null;
        try {
            URIBuilder fedUriBuilder = new URIBuilder(loginInput.getServerUrl());
            fedUriBuilder.setPath(SF_PATH_AUTHENTICATOR_REQUEST);
            URI fedUrlUri = fedUriBuilder.build();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(ClientAuthnParameter.ACCOUNT_NAME.name(), loginInput.getAccountName());
            data.put(ClientAuthnParameter.AUTHENTICATOR.name(), loginInput.getAuthenticator());
            data.put(ClientAuthnParameter.CLIENT_APP_ID.name(), loginInput.getAppId());
            data.put(ClientAuthnParameter.CLIENT_APP_VERSION.name(), loginInput.getAppVersion());
            ClientAuthnDTO authnData = new ClientAuthnDTO();
            authnData.setData(data);
            String json = mapper.writeValueAsString((Object)authnData);
            StringEntity input = new StringEntity(json, StandardCharsets.UTF_8);
            input.setContentType("application/json");
            HttpPost postRequest = new HttpPost(fedUrlUri);
            postRequest.setEntity((HttpEntity)input);
            postRequest.addHeader("accept", "application/json");
            postRequest.addHeader(SF_HEADER_CLIENT_APP_ID, loginInput.getAppId());
            postRequest.addHeader(SF_HEADER_CLIENT_APP_VERSION, loginInput.getAppVersion());
            String gsResponse = HttpUtil.executeGeneralRequest((HttpRequestBase)postRequest, loginInput.getLoginTimeout(), loginInput.getAuthTimeout(), loginInput.getSocketTimeoutInMillis(), 0, loginInput.getHttpClientSettingsKey());
            logger.debug("Authenticator-request response: {}", gsResponse);
            JsonNode jsonNode = mapper.readTree(gsResponse);
            if (!jsonNode.path("success").asBoolean()) {
                logger.debug("Response: {}", gsResponse);
                int errorCode = jsonNode.path("code").asInt();
                throw new SnowflakeSQLException(NO_QUERY_ID, jsonNode.path("message").asText(), "08001", errorCode);
            }
            dataNode = jsonNode.path("data");
        }
        catch (IOException | URISyntaxException ex) {
            SessionUtil.handleFederatedFlowError(loginInput, ex);
        }
        return dataNode;
    }

    private static void handleFederatedFlowError(SFLoginInput loginInput, Exception ex) throws SnowflakeSQLException {
        if (ex instanceof IOException) {
            logger.error("IOException when authenticating with " + loginInput.getAuthenticator(), ex);
            throw new SnowflakeSQLException((Throwable)ex, "58030", (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "Exception encountered when opening connection: " + ex.getMessage());
        }
        logger.error("Exception when authenticating with " + loginInput.getAuthenticator(), ex);
        throw new SnowflakeSQLException((Throwable)ex, "08001", (int)ErrorCode.CONNECTION_ERROR.getMessageCode(), ErrorCode.CONNECTION_ERROR.getMessageCode(), ex.getMessage());
    }

    private static String getSamlResponseUsingOkta(SFLoginInput loginInput) throws SnowflakeSQLException {
        while (true) {
            try {
                JsonNode dataNode = SessionUtil.federatedFlowStep1(loginInput);
                String tokenUrl = dataNode.path("tokenUrl").asText();
                String ssoUrl = dataNode.path("ssoUrl").asText();
                SessionUtil.federatedFlowStep2(loginInput, tokenUrl, ssoUrl);
                String oneTimeToken = SessionUtil.federatedFlowStep3(loginInput, tokenUrl);
                return SessionUtil.federatedFlowStep4(loginInput, ssoUrl, oneTimeToken);
            }
            catch (SnowflakeSQLException ex) {
                if (ex.getErrorCode() == ErrorCode.AUTHENTICATOR_REQUEST_TIMEOUT.getMessageCode().intValue()) {
                    logger.debug("Failed to get Okta SAML response. Retrying without changing retry count.", new Object[0]);
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    static boolean isPrefixEqual(String aUrlStr, String bUrlStr) throws MalformedURLException {
        URL aUrl = new URL(aUrlStr);
        URL bUrl = new URL(bUrlStr);
        int aPort = aUrl.getPort();
        int bPort = bUrl.getPort();
        if (aPort == -1 && "https".equals(aUrl.getProtocol())) {
            aPort = 443;
        }
        if (bPort == -1 && "https".equals(bUrl.getProtocol())) {
            bPort = 443;
        }
        return aUrl.getHost().equalsIgnoreCase(bUrl.getHost()) && aUrl.getProtocol().equalsIgnoreCase(bUrl.getProtocol()) && aPort == bPort;
    }

    private static String getPostBackUrlFromHTML(String html) {
        Document doc = Jsoup.parse((String)html);
        Elements e1 = doc.getElementsByTag("body");
        Elements e2 = ((Element)e1.get(0)).getElementsByTag("form");
        return e2.first().attr("action");
    }

    public static Map<String, Object> getCommonParams(JsonNode paramsNode) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (JsonNode child : paramsNode) {
            if (!child.hasNonNull("name")) {
                logger.error("Common Parameter JsonNode encountered with no parameter name!", false);
                continue;
            }
            String paramName = child.path("name").asText();
            if (!child.hasNonNull("value")) {
                logger.debug("No value found for Common Parameter: {}", child.path("name").asText());
                continue;
            }
            if (STRING_PARAMS.contains(paramName.toUpperCase())) {
                parameters.put(paramName, child.path("value").asText());
            } else if (INT_PARAMS.contains(paramName.toUpperCase())) {
                parameters.put(paramName, child.path("value").asInt());
            } else if (BOOLEAN_PARAMS.contains(paramName.toUpperCase())) {
                parameters.put(paramName, child.path("value").asBoolean());
            } else {
                try {
                    parameters.put(paramName, mapper.treeToValue((TreeNode)child.path("value"), Object.class));
                }
                catch (Exception e) {
                    logger.debug("Unknown Common Parameter Failed to Parse: {} -> {}. Exception: {}", paramName, child.path("value"), e.getMessage());
                }
                logger.debug("Unknown Common Parameter: {}", paramName);
            }
            logger.debug("Parameter {}: {}", paramName, child.path("value").asText());
        }
        return parameters;
    }

    static void updateSfDriverParamValues(Map<String, Object> parameters, SFBaseSession session) {
        if (parameters != null && !parameters.isEmpty()) {
            session.setCommonParameters(parameters);
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            logger.debug("Processing parameter {}", entry.getKey());
            if ("CLIENT_DISABLE_INCIDENTS".equalsIgnoreCase(entry.getKey())) {
                SnowflakeDriver.setDisableIncidents((Boolean)entry.getValue());
                continue;
            }
            if ("CLIENT_SESSION_KEEP_ALIVE".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setEnableHeartbeat((Boolean)entry.getValue());
                continue;
            }
            if (CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setHeartbeatFrequency((Integer)entry.getValue());
                continue;
            }
            if (CLIENT_ENABLE_LOG_INFO_STATEMENT_PARAMETERS.equalsIgnoreCase(entry.getKey())) {
                boolean enableLogging = (Boolean)entry.getValue();
                if (session == null || session.getPreparedStatementLogging() == enableLogging) continue;
                session.setPreparedStatementLogging(enableLogging);
                continue;
            }
            if ("AUTOCOMMIT".equalsIgnoreCase(entry.getKey())) {
                boolean autoCommit = (Boolean)entry.getValue();
                if (session == null || session.getAutoCommit() == autoCommit) continue;
                session.setAutoCommit(autoCommit);
                continue;
            }
            if (JDBC_RS_COLUMN_CASE_INSENSITIVE.equalsIgnoreCase(entry.getKey()) || CLIENT_RESULT_COLUMN_CASE_INSENSITIVE.equalsIgnoreCase(entry.getKey())) {
                if (session == null || session.isResultColumnCaseInsensitive()) continue;
                session.setResultColumnCaseInsensitive((Boolean)entry.getValue());
                continue;
            }
            if (CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setMetadataRequestUseConnectionCtx((Boolean)entry.getValue());
                continue;
            }
            if (CLIENT_METADATA_USE_SESSION_DATABASE.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setMetadataRequestUseSessionDatabase((Boolean)entry.getValue());
                continue;
            }
            if (JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setTreatNTZAsUTC((Boolean)entry.getValue());
                continue;
            }
            if (JDBC_FORMAT_DATE_WITH_TIMEZONE.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setFormatDateWithTimezone((Boolean)entry.getValue());
                continue;
            }
            if (JDBC_USE_SESSION_TIMEZONE.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setUseSessionTimezone((Boolean)entry.getValue());
                continue;
            }
            if ("CLIENT_TIMESTAMP_TYPE_MAPPING".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setTimestampMappedType(SnowflakeType.valueOf(((String)entry.getValue()).toUpperCase()));
                continue;
            }
            if ("JDBC_TREAT_DECIMAL_AS_INT".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setJdbcTreatDecimalAsInt((Boolean)entry.getValue());
                continue;
            }
            if ("JDBC_ENABLE_COMBINED_DESCRIBE".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setEnableCombineDescribe((Boolean)entry.getValue());
                continue;
            }
            if (CLIENT_IN_BAND_TELEMETRY_ENABLED.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setClientTelemetryEnabled((Boolean)entry.getValue());
                continue;
            }
            if ("CLIENT_STAGE_ARRAY_BINDING_THRESHOLD".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setArrayBindStageThreshold((Integer)entry.getValue());
                continue;
            }
            if (CLIENT_STORE_TEMPORARY_CREDENTIAL.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setStoreTemporaryCredential((Boolean)entry.getValue());
                continue;
            }
            if (SERVICE_NAME.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setServiceName((String)entry.getValue());
                continue;
            }
            if (CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setEnableConservativeMemoryUsage((Boolean)entry.getValue());
                continue;
            }
            if (CLIENT_CONSERVATIVE_MEMORY_ADJUST_STEP.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setConservativeMemoryAdjustStep((Integer)entry.getValue());
                continue;
            }
            if (CLIENT_MEMORY_LIMIT.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setClientMemoryLimit((Integer)entry.getValue());
                continue;
            }
            if (CLIENT_RESULT_CHUNK_SIZE.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setClientResultChunkSize((Integer)entry.getValue());
                continue;
            }
            if (CLIENT_PREFETCH_THREADS.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setClientPrefetchThreads((Integer)entry.getValue());
                continue;
            }
            if (CLIENT_OUT_OF_BAND_TELEMETRY_ENABLED.equalsIgnoreCase(entry.getKey())) {
                TelemetryService.disableOOBTelemetry();
                continue;
            }
            if (CLIENT_VALIDATE_DEFAULT_PARAMETERS.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setValidateDefaultParameters(SFLoginInput.getBooleanValue(entry.getValue()));
                continue;
            }
            if (ENABLE_STAGE_S3_PRIVATELINK_FOR_US_EAST_1.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setUseRegionalS3EndpointsForPresignedURL(SFLoginInput.getBooleanValue(entry.getValue()));
                continue;
            }
            if (QUERY_CONTEXT_CACHE_SIZE.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setQueryContextCacheSize((Integer)entry.getValue());
                continue;
            }
            if (JDBC_ENABLE_PUT_GET.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setJdbcEnablePutGet(SFLoginInput.getBooleanValue(entry.getValue()));
                continue;
            }
            if (session == null) continue;
            session.setOtherParameter(entry.getKey(), entry.getValue());
        }
    }

    public static void resetOCSPUrlIfNecessary(String serverUrl) throws IOException {
        if (PrivateLinkDetector.isPrivateLink(serverUrl)) {
            URL url = new URL(serverUrl);
            String host = url.getHost();
            logger.debug("HOST: {}", host);
            String ocspCacheServerUrl = String.format("http://ocsp.%s/%s", host, "ocsp_response_cache.json");
            logger.debug("OCSP Cache Server for Privatelink: {}", ocspCacheServerUrl);
            SFTrustManager.resetOCSPResponseCacherServerURL(ocspCacheServerUrl);
        }
    }

    public static String generateJWTToken(PrivateKey privateKey, String privateKeyFile, String privateKeyFilePwd, String accountName, String userName) throws SFException {
        SessionUtilKeyPair s = new SessionUtilKeyPair(privateKey, privateKeyFile, privateKeyFilePwd, accountName, userName);
        return s.issueJwtToken();
    }

    public static boolean isNewRetryStrategyRequest(HttpRequestBase request) {
        URI requestURI = request.getURI();
        String requestPath = requestURI.getPath();
        return requestPath != null && (requestPath.equals(SF_PATH_LOGIN_REQUEST) || requestPath.equals(SF_PATH_AUTHENTICATOR_REQUEST) || requestPath.equals(SF_PATH_TOKEN_REQUEST));
    }

    static enum TokenRequestType {
        RENEW("RENEW"),
        CLONE("CLONE"),
        ISSUE("ISSUE");

        private String value;

        private TokenRequestType(String value) {
            this.value = value;
        }
    }
}

