/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.FieldSchemaCreator;
import net.snowflake.client.core.JsonSqlOutput;
import net.snowflake.client.core.ParameterBindingDTO;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFPreparedStatementMetaData;
import net.snowflake.client.core.SfSqlArray;
import net.snowflake.client.core.SfTimestampUtil;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.jdbc.BindingParameterMetadata;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeLoggedFeatureNotSupportedException;
import net.snowflake.client.jdbc.SnowflakeParameterMetadata;
import net.snowflake.client.jdbc.SnowflakePreparedStatement;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaDataV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinary;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.VariableTypeArray;

class SnowflakePreparedStatementV1
extends SnowflakeStatementV1
implements PreparedStatement,
SnowflakePreparedStatement {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakePreparedStatementV1.class);
    private static final Integer ERROR_CODE_TABLE_BIND_VARIABLE_NOT_SET = 2128;
    private static final Integer ERROR_CODE_OBJECT_BIND_NOT_SET = 2129;
    private static final Integer ERROR_CODE_STATEMENT_CANNOT_BE_PREPARED = 7;
    private static final Integer ERROR_CODE_FORMAT_ARGUMENT_NOT_STRING = 1026;
    private static final Set<Integer> errorCodesIgnoredInDescribeMode = new HashSet<Integer>(Arrays.asList(ERROR_CODE_TABLE_BIND_VARIABLE_NOT_SET, ERROR_CODE_STATEMENT_CANNOT_BE_PREPARED, ERROR_CODE_OBJECT_BIND_NOT_SET, ERROR_CODE_FORMAT_ARGUMENT_NOT_STRING));
    private final String sql;
    private SFPreparedStatementMetaData preparedStatementMetaData;
    private boolean showStatementParameters;
    private Map<String, ParameterBindingDTO> parameterBindings = new HashMap<String, ParameterBindingDTO>();
    private Map<String, ParameterBindingDTO> batchParameterBindings = new HashMap<String, ParameterBindingDTO>();
    private Map<String, Boolean> wasPrevValueNull = new HashMap<String, Boolean>();
    private int batchSize = 0;
    private boolean alreadyDescribed = false;

    SnowflakePreparedStatementV1(SnowflakeConnectionV1 connection, String sql, boolean skipParsing, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.sql = sql;
        this.preparedStatementMetaData = SFPreparedStatementMetaData.emptyMetaData();
        this.showStatementParameters = connection.getShowStatementParameters();
    }

    private void describeSqlIfNotTried() throws SQLException {
        if (!this.alreadyDescribed) {
            try {
                this.preparedStatementMetaData = this.sfBaseStatement.describe(this.sql);
            }
            catch (SFException e) {
                throw new SnowflakeSQLLoggedException(this.connection.getSFBaseSession(), e);
            }
            catch (SnowflakeSQLException e) {
                if (!errorCodesIgnoredInDescribeMode.contains(e.getErrorCode())) {
                    throw e;
                }
                this.preparedStatementMetaData = SFPreparedStatementMetaData.emptyMetaData();
            }
            this.alreadyDescribed = true;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ExecTimeTelemetryData execTimeData = new ExecTimeTelemetryData("ResultSet PreparedStatement.executeQuery(String)", this.batchID);
        if (this.showStatementParameters) {
            logger.info("executeQuery()", false);
        } else {
            logger.trace("executeQuery()", false);
        }
        ResultSet rs = this.executeQueryInternal(this.sql, false, this.parameterBindings, execTimeData);
        execTimeData.setQueryEnd();
        execTimeData.generateTelemetry();
        logger.debug("Query completed. {}", execTimeData.getLogString());
        return rs;
    }

    @Override
    public ResultSet executeAsyncQuery() throws SQLException {
        ExecTimeTelemetryData execTimeData = new ExecTimeTelemetryData("ResultSet PreparedStatement.executeAsyncQuery(String)", this.batchID);
        if (this.showStatementParameters) {
            logger.info("executeAsyncQuery()", false);
        } else {
            logger.trace("executeAsyncQuery()", false);
        }
        ResultSet rs = this.executeQueryInternal(this.sql, true, this.parameterBindings, execTimeData);
        execTimeData.setQueryEnd();
        execTimeData.generateTelemetry();
        logger.debug("Query completed. {}", execTimeData.getLogString());
        return rs;
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        ExecTimeTelemetryData execTimeTelemetryData = new ExecTimeTelemetryData("long PreparedStatement.executeLargeUpdate()", this.batchID);
        logger.trace("executeLargeUpdate()", false);
        long updates = this.executeUpdateInternal(this.sql, this.parameterBindings, true, execTimeTelemetryData);
        return updates;
    }

    @Override
    public int executeUpdate() throws SQLException {
        logger.trace("executeUpdate()", false);
        return (int)this.executeLargeUpdate();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        logger.trace("setNull(parameterIndex: {}, sqlType: {})", new Object[]{parameterIndex, SnowflakeType.JavaSQLType.find(sqlType)});
        this.raiseSQLExceptionIfStatementIsClosed();
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeType.ANY.toString(), null);
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        logger.trace("setBoolean(parameterIndex: {}, boolean x)", parameterIndex);
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(16, this.connection.getSFBaseSession()), String.valueOf(x));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        logger.trace("setByte(parameterIndex: {}, byte x)", parameterIndex);
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(-6, this.connection.getSFBaseSession()), String.valueOf(x));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        logger.trace("setShort(parameterIndex: {}, short x)", parameterIndex);
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(5, this.connection.getSFBaseSession()), String.valueOf(x));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        logger.trace("setInt(parameterIndex: {}, int x)", parameterIndex);
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(4, this.connection.getSFBaseSession()), String.valueOf(x));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        logger.trace("setLong(parameterIndex: {}, long x)", parameterIndex);
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(-5, this.connection.getSFBaseSession()), String.valueOf(x));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setBigInteger(int parameterIndex, BigInteger x) throws SQLException {
        logger.trace("setBigInteger(parameterIndex: {}, BigInteger x)", parameterIndex);
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(-5, this.connection.getSFBaseSession()), String.valueOf(x));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        logger.trace("setFloat(parameterIndex: {}, float x)", parameterIndex);
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(6, this.connection.getSFBaseSession()), String.valueOf(x));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        logger.trace("setDouble(parameterIndex: {}, double x)", parameterIndex);
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(8, this.connection.getSFBaseSession()), String.valueOf(x));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        logger.trace("setBigDecimal(parameterIndex: {}, BigDecimal x)", parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(3, this.connection.getSFBaseSession()), String.valueOf(x));
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        logger.trace("setString(parameterIndex: {}, String x)", parameterIndex);
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(12, this.connection.getSFBaseSession()), x);
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        logger.trace("setBytes(parameterIndex: {}, byte[] x)", parameterIndex);
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(-2, this.connection.getSFBaseSession()), new SFBinary(x).toHex());
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    private void setObjectInternal(int parameterIndex, SQLData sqlData) throws SQLException {
        logger.debug("setObjectInternal(parameterIndex: {}, SqlData sqlData)", parameterIndex);
        JsonSqlOutput stream = new JsonSqlOutput(sqlData, this.connection.getSFBaseSession());
        sqlData.writeSQL(stream);
        ParameterBindingDTO binding = new ParameterBindingDTO("json", SnowflakeUtil.javaTypeToSFTypeString(2002, this.connection.getSFBaseSession()), stream.getJsonString(), stream.getSchema());
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        logger.trace("setDate(parameterIndex: {}, Date x)", parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(91, this.connection.getSFBaseSession()), String.valueOf(x.getTime() + (long)TimeZone.getDefault().getOffset(x.getTime()) - ResultUtil.msDiffJulianToGregorian(x)));
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        logger.trace("setTime(parameterIndex: {}, Time x)", parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 92);
        } else {
            long nanosSinceMidnight = SfTimestampUtil.getTimeInNanoseconds(x);
            ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(92, this.connection.getSFBaseSession()), String.valueOf(nanosSinceMidnight));
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        logger.trace("setTimestamp(parameterIndex: {}, Timestamp x)", parameterIndex);
        this.setTimestampWithType(parameterIndex, x, 93);
    }

    private void setTimestampWithType(int parameterIndex, Timestamp x, int snowflakeType) throws SQLException {
        String bindingTypeName;
        String value = x == null ? null : String.valueOf(BigDecimal.valueOf((x.getTime() - ResultUtil.msDiffJulianToGregorian(x)) / 1000L).scaleByPowerOfTen(9).add(BigDecimal.valueOf(x.getNanos())));
        switch (snowflakeType) {
            case 50000: {
                bindingTypeName = SnowflakeType.TIMESTAMP_LTZ.name();
                break;
            }
            case 50002: {
                bindingTypeName = SnowflakeType.TIMESTAMP_NTZ.name();
                break;
            }
            default: {
                bindingTypeName = this.connection.getSFBaseSession().getTimestampMappedType().name();
            }
        }
        ParameterBindingDTO binding = new ParameterBindingDTO(bindingTypeName, value);
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameterBindings.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
        } else if (targetSqlType == 91) {
            this.setDate(parameterIndex, (Date)x);
        } else if (targetSqlType == 92) {
            this.setTime(parameterIndex, (Time)x);
        } else if (targetSqlType == 93) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (targetSqlType == 50000 || targetSqlType == 50002) {
            this.setTimestampWithType(parameterIndex, (Timestamp)x, targetSqlType);
        } else {
            logger.trace("setObject(parameterIndex: {}, Object x, sqlType: {})", new Object[]{parameterIndex, SnowflakeType.JavaSQLType.find(targetSqlType)});
            ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(targetSqlType, this.connection.getSFBaseSession()), String.valueOf(x));
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof BigInteger) {
            this.setBigInteger(parameterIndex, (BigInteger)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof SQLData) {
            this.setObjectInternal(parameterIndex, (SQLData)x);
        } else {
            throw new SnowflakeSQLLoggedException(this.connection.getSFBaseSession(), (int)ErrorCode.DATA_TYPE_NOT_SUPPORTED.getMessageCode(), "0A000", "Object type: " + x.getClass());
        }
    }

    @Override
    public boolean execute() throws SQLException {
        ExecTimeTelemetryData execTimeData = new ExecTimeTelemetryData("boolean PreparedStatement.execute(String)", this.batchID);
        logger.debug("Execute: {}", this.sql);
        boolean success = this.executeInternal(this.sql, this.parameterBindings, execTimeData);
        execTimeData.setQueryEnd();
        execTimeData.generateTelemetry();
        logger.debug("Query completed. {}", execTimeData.getLogString());
        return success;
    }

    @Override
    public void addBatch() throws SQLException {
        logger.trace("addBatch()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        this.describeSqlIfNotTried();
        if (this.preparedStatementMetaData.isArrayBindSupported()) {
            for (Map.Entry<String, ParameterBindingDTO> binding : this.parameterBindings.entrySet()) {
                List<String> values;
                ParameterBindingDTO bindingValueAndType = this.batchParameterBindings.get(binding.getKey());
                Object newValue = binding.getValue().getValue();
                if (bindingValueAndType == null) {
                    values = new ArrayList();
                    bindingValueAndType = new ParameterBindingDTO(binding.getValue().getType(), values);
                    this.batchParameterBindings.put(binding.getKey(), bindingValueAndType);
                    this.wasPrevValueNull.put(binding.getKey(), binding.getValue().getValue() == null);
                } else {
                    String prevType = bindingValueAndType.getType();
                    String newType = binding.getValue().getType();
                    if (this.wasPrevValueNull.get(binding.getKey()).booleanValue() && newValue != null) {
                        bindingValueAndType = this.batchParameterBindings.remove(binding.getKey());
                        bindingValueAndType.setType(newType);
                        this.batchParameterBindings.put(binding.getKey(), bindingValueAndType);
                        prevType = newType;
                        this.wasPrevValueNull.put(binding.getKey(), false);
                    }
                    if (SnowflakeType.ANY.name().equalsIgnoreCase(prevType) && !SnowflakeType.ANY.name().equalsIgnoreCase(newType)) {
                        bindingValueAndType.setType(newType);
                    } else if (binding.getValue().getValue() != null && !prevType.equalsIgnoreCase(newType)) {
                        String row = "Unknown";
                        if (bindingValueAndType.getValue() instanceof Collection) {
                            List typeCheckedList = (List)bindingValueAndType.getValue();
                            values = typeCheckedList;
                            row = Integer.toString(values.size() + 1);
                        }
                        throw new SnowflakeSQLLoggedException(this.connection.getSFBaseSession(), (int)ErrorCode.ARRAY_BIND_MIXED_TYPES_NOT_SUPPORTED.getMessageCode(), "0A000", SnowflakeType.getJavaType(SnowflakeType.fromString(prevType), false).name(), SnowflakeType.getJavaType(SnowflakeType.fromString(newType), false).name(), binding.getKey(), row);
                    }
                    List typeCheckedList = (List)bindingValueAndType.getValue();
                    values = typeCheckedList;
                }
                values.add((String)newValue);
                bindingValueAndType.setValue(values);
            }
            ++this.batchSize;
        } else {
            this.batch.add(new SnowflakeStatementV1.BatchEntry(this.sql, this.parameterBindings));
            this.parameterBindings = new HashMap<String, ParameterBindingDTO>();
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setString(parameterIndex, x == null ? null : x.toString());
    }

    @Override
    public void setArray(int parameterIndex, Array array) throws SQLException {
        if (array instanceof SfSqlArray) {
            SfSqlArray sfArray = (SfSqlArray)array;
            ParameterBindingDTO binding = new ParameterBindingDTO("json", SnowflakeUtil.javaTypeToSFTypeString(2003, this.connection.getSFBaseSession()), sfArray.getJsonString(), sfArray.getSchema());
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        } else {
            SfSqlArray sfArray = new SfSqlArray(4, array);
            ParameterBindingDTO binding = new ParameterBindingDTO("json", SnowflakeUtil.javaTypeToSFTypeString(2003, this.connection.getSFBaseSession()), sfArray.getJsonString(), sfArray.getSchema());
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public <T> void setMap(int parameterIndex, Map<String, T> map, int type) throws SQLException {
        BindingParameterMetadata valueTypeSchema;
        if (2002 == type) {
            SQLData sqlData = map.values().stream().findFirst().orElse(null);
            JsonSqlOutput stream = new JsonSqlOutput(sqlData, this.connection.getSFBaseSession());
            sqlData.writeSQL(stream);
            valueTypeSchema = stream.getSchema();
        } else {
            valueTypeSchema = FieldSchemaCreator.buildBindingSchemaForType(type, false);
        }
        BindingParameterMetadata schema = BindingParameterMetadata.BindingParameterMetadataBuilder.bindingParameterMetadata().withType("map").withFields(Arrays.asList(FieldSchemaCreator.buildBindingSchemaForType(12, false), valueTypeSchema)).build();
        ParameterBindingDTO binding = null;
        try {
            binding = new ParameterBindingDTO("json", SnowflakeUtil.javaTypeToSFTypeString(2002, this.connection.getSFBaseSession()), SnowflakeUtil.mapJson(map), schema);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        logger.trace("getMetaData()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        this.describeSqlIfNotTried();
        return new SnowflakeResultSetMetaDataV1(this.preparedStatementMetaData.getResultSetMetaData());
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        logger.trace("setDate(int parameterIndex, Date x, Calendar cal)", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            String value = String.valueOf(x.getTime() + (long)cal.getTimeZone().getOffset(x.getTime()) - ResultUtil.msDiffJulianToGregorian(x));
            ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(91, this.connection.getSFBaseSession()), value);
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        logger.trace("setTime(int parameterIndex, Time x, Calendar cal)", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        this.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        logger.trace("setTimestamp(int parameterIndex, Timestamp x, Calendar cal)", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        String value = null;
        SnowflakeType sfType = SnowflakeUtil.javaTypeToSFType(93, this.connection.getSFBaseSession());
        if (x != null) {
            long milliSecSinceEpoch = x.getTime();
            if (sfType == SnowflakeType.TIMESTAMP) {
                sfType = this.connection.getSFBaseSession().getTimestampMappedType();
            }
            if (sfType == SnowflakeType.TIMESTAMP_TZ) {
                value = String.valueOf(BigDecimal.valueOf(milliSecSinceEpoch / 1000L).scaleByPowerOfTen(9).add(BigDecimal.valueOf(x.getNanos())));
                int offset = cal.getTimeZone().getOffset(milliSecSinceEpoch) / 60000 + 1440;
                value = value + " " + offset;
            } else {
                milliSecSinceEpoch += (long)cal.getTimeZone().getOffset(milliSecSinceEpoch);
                value = String.valueOf(BigDecimal.valueOf(milliSecSinceEpoch / 1000L).scaleByPowerOfTen(9).add(BigDecimal.valueOf(x.getNanos())));
            }
        }
        ParameterBindingDTO binding = new ParameterBindingDTO(sfType.name(), value);
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        logger.trace("setNull(int parameterIndex, int sqlType, String typeName)", false);
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.describeSqlIfNotTried();
        return new SnowflakeParameterMetadata(this.preparedStatementMetaData, this.connection.getSFBaseSession());
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        logger.trace("setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength)", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
        } else if (targetSqlType == 3 || targetSqlType == 2) {
            BigDecimal decimalObj = new BigDecimal(String.valueOf(x));
            decimalObj.setScale(scaleOrLength);
            this.setBigDecimal(parameterIndex, decimalObj);
        } else {
            this.setObject(parameterIndex, x, targetSqlType);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        logger.debug("executeUpdate(String sql)", false);
        throw new SnowflakeSQLException(ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, StmtUtil.truncateSQL(sql));
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        logger.debug("execute(String sql)", false);
        throw new SnowflakeSQLException(ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, StmtUtil.truncateSQL(sql));
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SnowflakeSQLException(ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, StmtUtil.truncateSQL(sql));
    }

    @Override
    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.batchParameterBindings.clear();
        this.parameterBindings.clear();
        this.wasPrevValueNull.clear();
        this.batchSize = 0;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        logger.trace("executeBatch()", false);
        return this.executeBatchInternalWithArrayBind((boolean)false).intArr;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        logger.trace("executeLargeBatch()", false);
        return this.executeBatchInternalWithArrayBind((boolean)true).longArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VariableTypeArray executeBatchInternalWithArrayBind(boolean isLong) throws SQLException {
        VariableTypeArray updateCounts;
        this.raiseSQLExceptionIfStatementIsClosed();
        this.describeSqlIfNotTried();
        if (this.preparedStatementMetaData.getStatementType().isGenerateResultSet()) {
            throw new SnowflakeSQLException(ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, StmtUtil.truncateSQL(this.sql));
        }
        if (isLong) {
            long[] arr = new long[this.batch.size()];
            updateCounts = new VariableTypeArray(null, arr);
        } else {
            int size = this.batch.size();
            int[] arr = new int[size];
            updateCounts = new VariableTypeArray(arr, null);
        }
        try {
            if (this.preparedStatementMetaData.isArrayBindSupported()) {
                if (this.batchSize <= 0) {
                    VariableTypeArray size;
                    if (isLong) {
                        logger.debug("executeLargeBatch() using array bind with no batch data. Return long[0] directly", false);
                        size = new VariableTypeArray(null, new long[0]);
                        return size;
                    }
                    logger.debug("executeBatch() using array bind with no batch data. Return int[0] directly", false);
                    size = new VariableTypeArray(new int[0], null);
                    return size;
                }
                int updateCount = (int)this.executeUpdateInternal(this.sql, this.batchParameterBindings, false, new ExecTimeTelemetryData());
                if (updateCount == this.batchSize) {
                    if (isLong) {
                        updateCounts = new VariableTypeArray(null, new long[updateCount]);
                        for (int idx = 0; idx < updateCount; ++idx) {
                            updateCounts.longArr[idx] = 1L;
                        }
                    } else {
                        updateCounts = new VariableTypeArray(new int[updateCount], null);
                        for (int idx = 0; idx < updateCount; ++idx) {
                            updateCounts.intArr[idx] = 1;
                        }
                    }
                } else if (isLong) {
                    updateCounts.longArr = new long[]{updateCount};
                } else {
                    updateCounts.intArr = new int[]{updateCount};
                }
            } else if (isLong) {
                updateCounts.longArr = this.executeBatchInternal((boolean)true).longArr;
            } else {
                updateCounts.intArr = this.executeBatchInternal((boolean)false).intArr;
            }
        }
        finally {
            this.clearBatch();
        }
        return updateCounts;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    Map<String, ParameterBindingDTO> getBatchParameterBindings() {
        return this.batchParameterBindings;
    }

    Map<String, ParameterBindingDTO> getParameterBindings() {
        return this.parameterBindings;
    }

    public boolean isAlreadyDescribed() {
        return this.alreadyDescribed;
    }

    public boolean isArrayBindSupported() {
        return this.preparedStatementMetaData.isArrayBindSupported();
    }

    @Override
    public void resultSetMetadataHandler(SFBaseResultSet resultSet) throws SQLException {
        if (!this.preparedStatementMetaData.isValidMetaData()) {
            this.preparedStatementMetaData = new SFPreparedStatementMetaData(resultSet.getMetaData(), resultSet.getStatementType(), resultSet.getNumberOfBinds(), resultSet.isArrayBindSupported(), resultSet.getMetaDataOfBinds(), true);
            this.alreadyDescribed = true;
        }
    }

    public String toString() {
        return this.sql != null ? this.sql + " - Query ID: " + this.getQueryID() : super.toString();
    }
}

