/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow.tostringhelpers;

import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.SnowflakeType;

@SnowflakeJdbcInternalApi
public abstract class ArrowStringRepresentationBuilderBase {
    private final StringJoiner joiner;
    private static final Set<SnowflakeType> quotableTypes = new HashSet<SnowflakeType>();

    public ArrowStringRepresentationBuilderBase(String delimiter, String prefix, String suffix) {
        this.joiner = new StringJoiner(delimiter, prefix, suffix);
    }

    protected ArrowStringRepresentationBuilderBase add(String string) {
        this.joiner.add(string);
        return this;
    }

    private boolean shouldQuoteValue(SnowflakeType type) {
        return quotableTypes.contains((Object)type);
    }

    protected String quoteIfNeeded(String string, SnowflakeType type) {
        if (type == SnowflakeType.BOOLEAN) {
            string = string.toLowerCase();
        }
        if (this.shouldQuoteValue(type)) {
            return '\"' + string + '\"';
        }
        return string;
    }

    public String toString() {
        return this.joiner.toString();
    }

    static {
        quotableTypes.add(SnowflakeType.ANY);
        quotableTypes.add(SnowflakeType.CHAR);
        quotableTypes.add(SnowflakeType.TEXT);
        quotableTypes.add(SnowflakeType.VARIANT);
        quotableTypes.add(SnowflakeType.BINARY);
        quotableTypes.add(SnowflakeType.DATE);
        quotableTypes.add(SnowflakeType.TIME);
        quotableTypes.add(SnowflakeType.TIMESTAMP_LTZ);
        quotableTypes.add(SnowflakeType.TIMESTAMP_NTZ);
        quotableTypes.add(SnowflakeType.TIMESTAMP_TZ);
    }
}

