/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.List;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.ColumnTypeInfo;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.SnowflakeUtil;

public class SnowflakeColumnMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String typeName;
    private int type;
    private boolean nullable;
    private int length;
    private int precision;
    private int scale;
    private boolean fixed;
    private SnowflakeType base;
    private List<FieldMetadata> fields;
    private String columnSrcTable;
    private String columnSrcSchema;
    private String columnSrcDatabase;
    private boolean isAutoIncrement;
    private int dimension;

    @SnowflakeJdbcInternalApi
    public SnowflakeColumnMetadata(String name, int type, boolean nullable, int length, int precision, int scale, String typeName, boolean fixed, SnowflakeType base, List<FieldMetadata> fields, String columnSrcDatabase, String columnSrcSchema, String columnSrcTable, boolean isAutoIncrement, int dimension) {
        this.name = name;
        this.type = type;
        this.nullable = nullable;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.typeName = typeName;
        this.fixed = fixed;
        this.base = base;
        this.fields = fields;
        this.columnSrcDatabase = columnSrcDatabase;
        this.columnSrcSchema = columnSrcSchema;
        this.columnSrcTable = columnSrcTable;
        this.isAutoIncrement = isAutoIncrement;
        this.dimension = dimension;
    }

    @Deprecated
    public SnowflakeColumnMetadata(String name, int type, boolean nullable, int length, int precision, int scale, String typeName, boolean fixed, SnowflakeType base, String columnSrcDatabase, String columnSrcSchema, String columnSrcTable, boolean isAutoIncrement) {
        this.name = name;
        this.type = type;
        this.nullable = nullable;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.typeName = typeName;
        this.fixed = fixed;
        this.base = base;
        this.columnSrcDatabase = columnSrcDatabase;
        this.columnSrcSchema = columnSrcSchema;
        this.columnSrcTable = columnSrcTable;
        this.isAutoIncrement = isAutoIncrement;
    }

    @SnowflakeJdbcInternalApi
    public SnowflakeColumnMetadata(JsonNode colNode, boolean jdbcTreatDecimalAsInt, SFBaseSession session) throws SnowflakeSQLLoggedException {
        this.name = colNode.path("name").asText();
        this.nullable = colNode.path("nullable").asBoolean();
        this.precision = colNode.path("precision").asInt();
        this.scale = colNode.path("scale").asInt();
        this.length = colNode.path("length").asInt();
        int dimension = colNode.path("dimension").asInt();
        int vectorDimension = colNode.path("vectorDimension").asInt();
        this.dimension = dimension > 0 ? dimension : vectorDimension;
        this.fixed = colNode.path("fixed").asBoolean();
        JsonNode udtOutputType = colNode.path("outputType");
        JsonNode extColTypeNameNode = colNode.path("extTypeName");
        String extColTypeName = null;
        if (!extColTypeNameNode.isMissingNode() && !Strings.isNullOrEmpty((String)extColTypeNameNode.asText())) {
            extColTypeName = extColTypeNameNode.asText();
        }
        String internalColTypeName = colNode.path("type").asText();
        List<FieldMetadata> fieldsMetadata = SnowflakeUtil.getFieldMetadata(jdbcTreatDecimalAsInt, internalColTypeName, colNode);
        int fixedColType = jdbcTreatDecimalAsInt && this.scale == 0 ? -5 : 3;
        ColumnTypeInfo columnTypeInfo = SnowflakeUtil.getSnowflakeType(internalColTypeName, extColTypeName, udtOutputType, session, fixedColType, !fieldsMetadata.isEmpty(), SnowflakeUtil.isVectorType(internalColTypeName));
        this.typeName = columnTypeInfo.getExtColTypeName();
        this.type = columnTypeInfo.getColumnType();
        this.base = columnTypeInfo.getSnowflakeType();
        this.fields = fieldsMetadata;
        this.columnSrcDatabase = colNode.path("database").asText();
        this.columnSrcSchema = colNode.path("schema").asText();
        this.columnSrcTable = colNode.path("table").asText();
        this.isAutoIncrement = colNode.path("isAutoIncrement").asBoolean();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public SnowflakeType getBase() {
        return this.base;
    }

    @SnowflakeJdbcInternalApi
    public List<FieldMetadata> getFields() {
        return this.fields;
    }

    @SnowflakeJdbcInternalApi
    public void setFields(List<FieldMetadata> fields) {
        this.fields = fields;
    }

    public String getColumnSrcTable() {
        return this.columnSrcTable;
    }

    public String getColumnSrcSchema() {
        return this.columnSrcSchema;
    }

    public String getColumnSrcDatabase() {
        return this.columnSrcDatabase;
    }

    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.isAutoIncrement = autoIncrement;
    }

    @SnowflakeJdbcInternalApi
    public int getDimension() {
        return this.dimension;
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("name=").append(this.name);
        sBuilder.append(",typeName=").append(this.typeName);
        sBuilder.append(",type=").append(this.type);
        sBuilder.append(",nullable=").append(this.nullable);
        sBuilder.append(",length=").append(this.length);
        sBuilder.append(",precision=").append(this.precision);
        sBuilder.append(",scale=").append(this.scale);
        sBuilder.append(",fixed=").append(this.fixed);
        sBuilder.append(",database=").append(this.columnSrcDatabase);
        sBuilder.append(",schema=").append(this.columnSrcSchema);
        sBuilder.append(",table=").append(this.columnSrcTable);
        sBuilder.append(",isAutoIncrement=").append(this.isAutoIncrement);
        sBuilder.append(",dimension=").append(this.dimension);
        return sBuilder.toString();
    }
}

