/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.TimeZone;
import net.snowflake.client.core.JsonSqlInput;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.arrow.StructObjectWrapper;
import net.snowflake.client.core.json.Converters;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public abstract class SFJsonResultSet
extends SFBaseResultSet {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFJsonResultSet.class);
    protected final Converters converters;

    protected SFJsonResultSet(TimeZone sessionTimeZone, Converters converters) {
        this.sessionTimeZone = sessionTimeZone;
        this.converters = converters;
    }

    protected abstract Object getObjectInternal(int var1) throws SFException;

    @Override
    public Object getObject(int columnIndex) throws SFException {
        int type = this.resultSetMetaData.getColumnType(columnIndex);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        switch (type) {
            case 1: 
            case 12: 
            case 50003: {
                return this.getString(columnIndex);
            }
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 4: {
                return this.getInt(columnIndex);
            }
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case -5: {
                return this.getBigInt(columnIndex, obj);
            }
            case 8: {
                return this.getDouble(columnIndex);
            }
            case 93: 
            case 2014: {
                return this.getTimestamp(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 16: {
                return this.getBoolean(columnIndex);
            }
            case 2002: {
                if (this.resultSetMetaData.isStructuredTypeColumn(columnIndex)) {
                    return new StructObjectWrapper((String)obj, this.getSqlInput((String)obj, columnIndex));
                }
                throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "data type: " + type);
            }
            case 2003: {
                if (this.resultSetMetaData.isStructuredTypeColumn(columnIndex)) {
                    return this.getArray(columnIndex);
                }
                throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "data type: " + type);
            }
        }
        throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "data type: " + type);
    }

    @Override
    @SnowflakeJdbcInternalApi
    public Object getObjectWithoutString(int columnIndex) throws SFException {
        return this.getObject(columnIndex);
    }

    private Object getBigInt(int columnIndex, Object obj) throws SFException {
        return this.converters.getNumberConverter().getBigInt(obj, columnIndex);
    }

    @Override
    public Array getArray(int columnIndex) throws SFException {
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        return this.getJsonArray((String)obj, columnIndex);
    }

    @Override
    public String getString(int columnIndex) throws SFException {
        logger.trace("String getString(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        int columnSubType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        int scale = this.resultSetMetaData.getScale(columnIndex);
        return this.converters.getStringConverter().getString(obj, columnType, columnSubType, scale);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SFException {
        logger.trace("boolean getBoolean(int columnIndex)", false);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getBooleanConverter().getBoolean(this.getObjectInternal(columnIndex), columnType);
    }

    @Override
    public byte getByte(int columnIndex) throws SFException {
        logger.trace("short getByte(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        return this.converters.getNumberConverter().getByte(obj);
    }

    @Override
    public short getShort(int columnIndex) throws SFException {
        logger.trace("short getShort(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getNumberConverter().getShort(obj, columnType);
    }

    @Override
    public int getInt(int columnIndex) throws SFException {
        logger.trace("int getInt(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getNumberConverter().getInt(obj, columnType);
    }

    @Override
    public long getLong(int columnIndex) throws SFException {
        logger.trace("long getLong(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getNumberConverter().getLong(obj, columnType);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SFException {
        logger.trace("BigDecimal getBigDecimal(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getNumberConverter().getBigDecimal(obj, columnType);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SFException {
        logger.trace("BigDecimal getBigDecimal(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getNumberConverter().getBigDecimal(obj, columnType, scale);
    }

    @Override
    public Time getTime(int columnIndex) throws SFException {
        logger.trace("Time getTime(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        int columnSubType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        int scale = this.resultSetMetaData.getScale(columnIndex);
        return this.converters.getDateTimeConverter().getTime(obj, columnType, columnSubType, TimeZone.getDefault(), scale);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, TimeZone tz) throws SFException {
        logger.trace("Timestamp getTimestamp(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        int columnSubType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        int scale = this.resultSetMetaData.getScale(columnIndex);
        return this.converters.getDateTimeConverter().getTimestamp(obj, columnType, columnSubType, tz, scale);
    }

    @Override
    public float getFloat(int columnIndex) throws SFException {
        logger.trace("float getFloat(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getNumberConverter().getFloat(obj, columnType);
    }

    @Override
    public double getDouble(int columnIndex) throws SFException {
        logger.trace("double getDouble(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getNumberConverter().getDouble(obj, columnType);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SFException {
        logger.trace("byte[] getBytes(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        int columnSubType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        int scale = this.resultSetMetaData.getScale(columnIndex);
        return this.converters.getBytesConverter().getBytes(obj, columnType, columnSubType, scale);
    }

    public Date getDate(int columnIndex) throws SFException {
        return this.getDate(columnIndex, TimeZone.getDefault());
    }

    @Override
    public Date getDate(int columnIndex, TimeZone tz) throws SFException {
        logger.trace("Date getDate(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        int columnSubType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        int scale = this.resultSetMetaData.getScale(columnIndex);
        return this.converters.getDateTimeConverter().getDate(obj, columnType, columnSubType, tz, scale);
    }

    @Override
    @SnowflakeJdbcInternalApi
    public SQLInput createSqlInputForColumn(Object input, Class<?> parentObjectClass, int columnIndex, SFBaseSession session, List<FieldMetadata> fields) {
        return this.createJsonSqlInputForColumn(input, session, fields);
    }

    @Override
    @SnowflakeJdbcInternalApi
    public Date convertToDate(Object object, TimeZone tz) throws SFException {
        return this.convertStringToDate((String)object, tz);
    }

    @Override
    @SnowflakeJdbcInternalApi
    public Time convertToTime(Object object, int scale) throws SFException {
        return this.convertStringToTime((String)object, scale);
    }

    @Override
    @SnowflakeJdbcInternalApi
    public Timestamp convertToTimestamp(Object object, int columnType, int columnSubType, TimeZone tz, int scale) throws SFException {
        return this.convertStringToTimestamp((String)object, columnType, columnSubType, tz, scale);
    }

    private Timestamp getTimestamp(int columnIndex) throws SFException {
        return this.getTimestamp(columnIndex, TimeZone.getDefault());
    }

    @Override
    @SnowflakeJdbcInternalApi
    public Converters getConverters() {
        return this.converters;
    }

    private Object getSqlInput(String input, int columnIndex) throws SFException {
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(input);
            return new JsonSqlInput(input, jsonNode, this.session, this.converters, this.resultSetMetaData.getColumnFields(columnIndex), this.sessionTimeZone);
        }
        catch (JsonProcessingException e) {
            throw new SFException(e, ErrorCode.INVALID_STRUCT_DATA, new Object[0]);
        }
    }
}

