/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.ArrowVectorConverterUtil;
import net.snowflake.client.core.arrow.tostringhelpers.ArrowArrayStringRepresentationBuilder;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.ListVector;

public class ArrayConverter
extends AbstractArrowVectorConverter {
    private final ListVector vector;

    public ArrayConverter(ListVector valueVector, int vectorIndex, DataConversionContext context) {
        super(SnowflakeType.ARRAY.name(), valueVector, vectorIndex, context);
        this.vector = valueVector;
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.isNull(index) ? null : this.vector.getObject(index);
    }

    @Override
    public byte[] toBytes(int index) throws SFException {
        return this.isNull(index) ? null : this.toString(index).getBytes();
    }

    @Override
    public String toString(int index) throws SFException {
        ArrowVectorConverter converter;
        FieldVector vectorUnpacked = this.vector.getChildrenFromFields().get(0);
        SnowflakeType logicalType = ArrowVectorConverterUtil.getSnowflakeTypeFromFieldMetadata(vectorUnpacked.getField());
        ArrowArrayStringRepresentationBuilder builder = new ArrowArrayStringRepresentationBuilder(logicalType);
        try {
            converter = ArrowVectorConverterUtil.initConverter(vectorUnpacked, this.context, this.columnIndex);
        }
        catch (SnowflakeSQLException e) {
            return this.vector.getObject(index).toString();
        }
        for (int i = this.vector.getElementStartIndex(index); i < this.vector.getElementEndIndex(index); ++i) {
            builder.appendValue(converter.toString(i));
        }
        return builder.toString();
    }
}

