/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.client.builder.ExecutorFactory;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.AmazonS3EncryptionClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSSLConnectionSocketFactory;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.EncryptionProvider;
import net.snowflake.client.jdbc.cloud.storage.QueryIdHelper;
import net.snowflake.client.jdbc.cloud.storage.S3HttpUtil;
import net.snowflake.client.jdbc.cloud.storage.S3ObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.S3StorageObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StorageHelper;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummaryCollection;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;
import net.snowflake.client.jdbc.internal.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SFPair;
import net.snowflake.client.util.Stopwatch;
import org.apache.commons.io.IOUtils;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;

public class SnowflakeS3Client
implements SnowflakeStorageClient {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeS3Client.class);
    private static final String localFileSep = SnowflakeUtil.systemGetProperty("file.separator");
    private static final String AES = "AES";
    private static final String AMZ_KEY = "x-amz-key";
    private static final String AMZ_IV = "x-amz-iv";
    private static final String S3_STREAMING_INGEST_CLIENT_NAME = "ingestclientname";
    private static final String S3_STREAMING_INGEST_CLIENT_KEY = "ingestclientkey";
    private static final String EXPIRED_AWS_TOKEN_ERROR_CODE = "ExpiredToken";
    private int encryptionKeySize = 0;
    private AmazonS3 amazonClient = null;
    private RemoteStoreFileEncryptionMaterial encMat = null;
    private ClientConfiguration clientConfig = null;
    private Properties proxyProperties = null;
    private String stageRegion = null;
    private String stageEndPoint = null;
    private SFBaseSession session = null;
    private boolean isClientSideEncrypted = true;
    private boolean isUseS3RegionalUrl = false;
    private static SSLConnectionSocketFactory s3ConnectionSocketFactory = null;

    public SnowflakeS3Client(Map<?, ?> stageCredentials, ClientConfiguration clientConfig, RemoteStoreFileEncryptionMaterial encMat, Properties proxyProperties, String stageRegion, String stageEndPoint, boolean isClientSideEncrypted, SFBaseSession session, boolean useS3RegionalUrl) throws SnowflakeSQLException {
        logger.debug("Initializing Snowflake S3 client with encryption: {}, client side encrypted: {}", encMat != null, isClientSideEncrypted);
        this.session = session;
        this.isUseS3RegionalUrl = useS3RegionalUrl;
        this.setupSnowflakeS3Client(stageCredentials, clientConfig, encMat, proxyProperties, stageRegion, stageEndPoint, isClientSideEncrypted, session);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupSnowflakeS3Client(Map<?, ?> stageCredentials, ClientConfiguration clientConfig, RemoteStoreFileEncryptionMaterial encMat, Properties proxyProperties, String stageRegion, String stageEndPoint, boolean isClientSideEncrypted, SFBaseSession session) throws SnowflakeSQLException {
        this.clientConfig = clientConfig;
        this.stageRegion = stageRegion;
        this.encMat = encMat;
        this.proxyProperties = proxyProperties;
        this.stageEndPoint = stageEndPoint;
        this.session = session;
        this.isClientSideEncrypted = isClientSideEncrypted;
        logger.debug("Setting up AWS client ", false);
        String awsID = (String)stageCredentials.get("AWS_KEY_ID");
        String awsKey = (String)stageCredentials.get("AWS_SECRET_KEY");
        String awsToken = (String)stageCredentials.get("AWS_TOKEN");
        BasicSessionCredentials awsCredentials = awsToken != null ? new BasicSessionCredentials(awsID, awsKey, awsToken) : new BasicAWSCredentials(awsID, awsKey);
        clientConfig.withSignerOverride("AWSS3V4SignerType");
        clientConfig.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)SnowflakeS3Client.getSSLConnectionSocketFactory());
        if (session != null) {
            S3HttpUtil.setProxyForS3(session.getHttpClientKey(), clientConfig);
        } else {
            S3HttpUtil.setSessionlessProxyForS3(proxyProperties, clientConfig);
        }
        AmazonS3ClientBuilder amazonS3Builder = AmazonS3Client.builder();
        if (encMat != null) {
            byte[] decodedKey = Base64.getDecoder().decode(encMat.getQueryStageMasterKey());
            this.encryptionKeySize = decodedKey.length * 8;
            if (this.encryptionKeySize == 256) {
                SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, AES);
                EncryptionMaterials encryptionMaterials = new EncryptionMaterials((SecretKey)queryStageMasterKey);
                encryptionMaterials.addDescription("queryId", encMat.getQueryId());
                encryptionMaterials.addDescription("smkId", Long.toString(encMat.getSmkId()));
                CryptoConfiguration cryptoConfig = new CryptoConfiguration(CryptoMode.EncryptionOnly);
                amazonS3Builder = ((AmazonS3EncryptionClientBuilder)((AmazonS3EncryptionClientBuilder)AmazonS3EncryptionClient.encryptionBuilder().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials))).withEncryptionMaterials((EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials)).withClientConfiguration(clientConfig)).withCryptoConfiguration(cryptoConfig);
            } else {
                if (this.encryptionKeySize != 128) throw new SnowflakeSQLLoggedException(QueryIdHelper.queryIdFromEncMatOr(encMat, null), session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "unsupported key size", this.encryptionKeySize);
                amazonS3Builder = (AmazonS3Builder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials))).withClientConfiguration(clientConfig);
            }
        } else {
            amazonS3Builder = (AmazonS3Builder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials))).withClientConfiguration(clientConfig);
        }
        Region region = RegionUtils.getRegion((String)stageRegion);
        if (this.stageEndPoint != null && this.stageEndPoint != "" && this.stageEndPoint != "null") {
            amazonS3Builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.stageEndPoint, region.getName()));
        } else if (region != null) {
            if (this.isUseS3RegionalUrl) {
                String domainSuffixForRegionalUrl = SnowflakeS3Client.getDomainSuffixForRegionalUrl(region.getName());
                amazonS3Builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration("s3." + region.getName() + "." + domainSuffixForRegionalUrl, region.getName()));
            } else {
                amazonS3Builder.withRegion(region.getName());
            }
        }
        amazonS3Builder.withPathStyleAccessEnabled(Boolean.valueOf(false));
        this.amazonClient = (AmazonS3)amazonS3Builder.build();
    }

    static String getDomainSuffixForRegionalUrl(String regionName) {
        return regionName.toLowerCase().startsWith("cn-") ? "amazonaws.com.cn" : "amazonaws.com";
    }

    @Override
    public int getMaxRetries() {
        if (this.session != null && this.session.getConnectionPropertiesMap().containsKey((Object)SFSessionProperty.PUT_GET_MAX_RETRIES)) {
            return (Integer)this.session.getConnectionPropertiesMap().get((Object)SFSessionProperty.PUT_GET_MAX_RETRIES);
        }
        return 25;
    }

    @Override
    public int getRetryBackoffMaxExponent() {
        return 4;
    }

    @Override
    public int getRetryBackoffMin() {
        return 1000;
    }

    @Override
    public boolean isEncrypting() {
        return this.encryptionKeySize > 0 && this.isClientSideEncrypted;
    }

    @Override
    public int getEncryptionKeySize() {
        return this.encryptionKeySize;
    }

    @Override
    public void renew(Map<?, ?> stageCredentials) throws SnowflakeSQLException {
        logger.debug("Renewing the Snowflake S3 client", new Object[0]);
        this.setupSnowflakeS3Client(stageCredentials, this.clientConfig, this.encMat, this.proxyProperties, this.stageRegion, this.stageEndPoint, this.isClientSideEncrypted, this.session);
    }

    @Override
    public void shutdown() {
        logger.debug("Shutting down the Snowflake S3 client", new Object[0]);
        this.amazonClient.shutdown();
    }

    @Override
    public StorageObjectSummaryCollection listObjects(String remoteStorageLocation, String prefix) throws StorageProviderException {
        ObjectListing objListing = this.amazonClient.listObjects(remoteStorageLocation, prefix);
        return new StorageObjectSummaryCollection(objListing.getObjectSummaries());
    }

    @Override
    public StorageObjectMetadata getObjectMetadata(String remoteStorageLocation, String prefix) throws StorageProviderException {
        return new S3ObjectMetadata(this.amazonClient.getObjectMetadata(remoteStorageLocation, prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(SFSession session, String command, String localLocation, String destFileName, final int parallelism, String remoteStorageLocation, String stageFilePath, String stageRegion, String presignedUrl, String queryId) throws SnowflakeSQLException {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        String localFilePath = localLocation + localFileSep + destFileName;
        logger.debug("Staring download of file from S3 stage path: {} to {}", stageFilePath, localFilePath);
        TransferManager tx = null;
        int retryCount = 0;
        do {
            try {
                File localFile = new File(localFilePath);
                logger.debug("Creating executor service for transfer manager with {} threads", parallelism);
                tx = TransferManagerBuilder.standard().withS3Client(this.amazonClient).withExecutorFactory(new ExecutorFactory(){

                    public ExecutorService newExecutor() {
                        return SnowflakeUtil.createDefaultExecutorService("s3-transfer-manager-downloader-", parallelism);
                    }
                }).build();
                Download myDownload = tx.download(remoteStorageLocation, stageFilePath, localFile);
                ObjectMetadata meta = this.amazonClient.getObjectMetadata(remoteStorageLocation, stageFilePath);
                Map<String, String> metaMap = SnowflakeUtil.createCaseInsensitiveMap(meta.getUserMetadata());
                String key = metaMap.get(AMZ_KEY);
                String iv = metaMap.get(AMZ_IV);
                myDownload.waitForCompletion();
                stopwatch.stop();
                long downloadMillis = stopwatch.elapsedMillis();
                if (this.isEncrypting() && this.getEncryptionKeySize() < 256) {
                    stopwatch.restart();
                    if (key == null || iv == null) {
                        throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "File metadata incomplete");
                    }
                    try {
                        EncryptionProvider.decrypt(localFile, key, iv, this.encMat);
                        stopwatch.stop();
                        long decryptMillis = stopwatch.elapsedMillis();
                        logger.info("S3 file {} downloaded to {}. It took {} ms (download: {} ms, decryption: {} ms) with {} retries", stageFilePath, localFile.getAbsolutePath(), downloadMillis + decryptMillis, downloadMillis, decryptMillis, retryCount);
                    }
                    catch (Exception ex) {
                        logger.error("Error decrypting file", ex);
                        throw ex;
                    }
                } else {
                    logger.info("S3 file {} downloaded to {}. It took {} ms with {} retries", stageFilePath, localFile.getAbsolutePath(), downloadMillis, retryCount);
                }
                return;
            }
            catch (Exception ex) {
                SnowflakeS3Client.handleS3Exception(ex, ++retryCount, "download", session, command, this, queryId);
            }
            finally {
                if (tx != null) {
                    tx.shutdownNow(false);
                }
            }
        } while (retryCount <= this.getMaxRetries());
        throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected: download unsuccessful without exception!");
    }

    @Override
    public InputStream downloadToStream(SFSession session, String command, int parallelism, String remoteStorageLocation, String stageFilePath, String stageRegion, String presignedUrl, String queryId) throws SnowflakeSQLException {
        logger.debug("Staring download of file from S3 stage path: {} to input stream", stageFilePath);
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        int retryCount = 0;
        while (true) {
            try {
                S3Object file = this.amazonClient.getObject(remoteStorageLocation, stageFilePath);
                ObjectMetadata meta = this.amazonClient.getObjectMetadata(remoteStorageLocation, stageFilePath);
                S3ObjectInputStream stream = file.getObjectContent();
                stopwatch.stop();
                long downloadMillis = stopwatch.elapsedMillis();
                Map<String, String> metaMap = SnowflakeUtil.createCaseInsensitiveMap(meta.getUserMetadata());
                String key = metaMap.get(AMZ_KEY);
                String iv = metaMap.get(AMZ_IV);
                if (this.isEncrypting() && this.getEncryptionKeySize() < 256) {
                    stopwatch.restart();
                    if (key == null || iv == null) {
                        throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "File metadata incomplete");
                    }
                    try {
                        InputStream is = EncryptionProvider.decryptStream((InputStream)stream, key, iv, this.encMat);
                        stopwatch.stop();
                        long decryptMillis = stopwatch.elapsedMillis();
                        logger.info("S3 file {} downloaded to input stream. It took {} ms (download: {} ms, decryption: {} ms) with {} retries", stageFilePath, downloadMillis + decryptMillis, downloadMillis, decryptMillis, retryCount);
                        return is;
                    }
                    catch (Exception ex) {
                        logger.error("Error in decrypting file", ex);
                        throw ex;
                    }
                }
                logger.info("S3 file {} downloaded to input stream. Download took {} ms with {} retries", stageFilePath, downloadMillis, retryCount);
                return stream;
            }
            catch (Exception ex) {
                SnowflakeS3Client.handleS3Exception(ex, ++retryCount, "download", session, command, this, queryId);
                if (retryCount <= this.getMaxRetries()) continue;
                throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected: download unsuccessful without exception!");
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(SFSession session, String command, final int parallelism, boolean uploadFromStream, String remoteStorageLocation, File srcFile, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, StorageObjectMetadata meta, String stageRegion, String presignedUrl, String queryId) throws SnowflakeSQLException {
        logger.info(StorageHelper.getStartUploadLog("S3", uploadFromStream, inputStream, fileBackedOutputStream, srcFile, destFileName), new Object[0]);
        long originalContentLength = meta.getContentLength();
        ArrayList<FileInputStream> toClose = new ArrayList<FileInputStream>();
        SFPair<InputStream, Boolean> uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, fileBackedOutputStream, ((S3ObjectMetadata)meta).getS3ObjectMetadata(), originalContentLength, toClose, queryId);
        if (!(meta instanceof S3ObjectMetadata)) {
            throw new IllegalArgumentException("Unexpected metadata object type");
        }
        ObjectMetadata s3Meta = ((S3ObjectMetadata)meta).getS3ObjectMetadata();
        TransferManager tx = null;
        int retryCount = 0;
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        do {
            try {
                Upload myUpload;
                logger.debug("Creating executor service for transfermanager with {} threads", parallelism);
                tx = TransferManagerBuilder.standard().withS3Client(this.amazonClient).withExecutorFactory(new ExecutorFactory(){

                    public ExecutorService newExecutor() {
                        return SnowflakeUtil.createDefaultExecutorService("s3-transfer-manager-uploader-", parallelism);
                    }
                }).build();
                if (!this.isClientSideEncrypted) {
                    s3Meta.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                }
                if (((Boolean)uploadStreamInfo.right).booleanValue()) {
                    myUpload = tx.upload(remoteStorageLocation, destFileName, (InputStream)uploadStreamInfo.left, s3Meta);
                } else {
                    PutObjectRequest putRequest = new PutObjectRequest(remoteStorageLocation, destFileName, srcFile);
                    putRequest.setMetadata(s3Meta);
                    myUpload = tx.upload(putRequest);
                }
                myUpload.waitForCompletion();
                stopwatch.stop();
                long uploadMillis = stopwatch.elapsedMillis();
                for (FileInputStream is : toClose) {
                    IOUtils.closeQuietly((InputStream)is);
                }
                if (uploadFromStream) {
                    logger.info("Uploaded data from input stream to S3 location: {}. It took {} ms with {} retries", destFileName, uploadMillis, retryCount);
                } else {
                    logger.info("Uploaded file {} to S3 location: {}. It took {} ms with {} retries", srcFile.getAbsolutePath(), destFileName, uploadMillis, retryCount);
                }
                return;
            }
            catch (Exception ex) {
                SnowflakeS3Client.handleS3Exception(ex, ++retryCount, "upload", session, command, this, queryId);
                if (uploadFromStream && fileBackedOutputStream == null) {
                    throw new SnowflakeSQLException(queryId, ex, "58000", ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during upload: " + ex.getMessage() + "\nCannot retry upload from stream.");
                }
                uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, fileBackedOutputStream, s3Meta, originalContentLength, toClose, queryId);
            }
            finally {
                if (tx != null) {
                    tx.shutdownNow(false);
                }
            }
        } while (retryCount <= this.getMaxRetries());
        for (FileInputStream is : toClose) {
            IOUtils.closeQuietly((InputStream)is);
        }
        throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected: upload unsuccessful without exception!");
    }

    private SFPair<InputStream, Boolean> createUploadStream(File srcFile, boolean uploadFromStream, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, ObjectMetadata meta, long originalContentLength, List<FileInputStream> toClose, String queryId) throws SnowflakeSQLException {
        InputStream result;
        logger.debug("createUploadStream({}, {}, {}, {}, {}, {}, {}) keySize: {}", this, srcFile, uploadFromStream, inputStream, fileBackedOutputStream, meta, toClose, this.getEncryptionKeySize());
        FileInputStream srcFileStream = null;
        if (this.isEncrypting() && this.getEncryptionKeySize() < 256) {
            try {
                InputStream inputStream2;
                if (uploadFromStream) {
                    inputStream2 = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
                } else {
                    srcFileStream = new FileInputStream(srcFile);
                    inputStream2 = srcFileStream;
                }
                InputStream uploadStream = inputStream2;
                toClose.add(srcFileStream);
                S3StorageObjectMetadata s3Metadata = new S3StorageObjectMetadata(meta);
                result = EncryptionProvider.encrypt(s3Metadata, originalContentLength, uploadStream, this.encMat, this);
                uploadFromStream = true;
            }
            catch (Exception ex) {
                logger.error("Failed to encrypt input", ex);
                throw new SnowflakeSQLLoggedException(queryId, this.session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "Failed to encrypt input", ex.getMessage());
            }
        }
        try {
            InputStream inputStream3;
            if (!this.isClientSideEncrypted) {
                meta.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
            }
            if (uploadFromStream) {
                inputStream3 = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
            } else {
                srcFileStream = new FileInputStream(srcFile);
                inputStream3 = srcFileStream;
            }
            result = inputStream3;
            toClose.add(srcFileStream);
        }
        catch (FileNotFoundException ex) {
            logger.error("Failed to open input file", ex);
            throw new SnowflakeSQLLoggedException(queryId, this.session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "Failed to open input file", ex.getMessage());
        }
        catch (IOException ex) {
            logger.error("Failed to open input stream", ex);
            throw new SnowflakeSQLLoggedException(queryId, this.session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "Failed to open input stream", ex.getMessage());
        }
        return SFPair.of(result, uploadFromStream);
    }

    @Override
    public void handleStorageException(Exception ex, int retryCount, String operation, SFSession session, String command, String queryId) throws SnowflakeSQLException {
        SnowflakeS3Client.handleS3Exception(ex, retryCount, operation, session, command, this, queryId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleS3Exception(Exception ex, int retryCount, String operation, SFSession session, String command, SnowflakeS3Client s3Client, String queryId) throws SnowflakeSQLException {
        if (ex.getCause() instanceof InvalidKeyException) {
            SnowflakeFileTransferAgent.throwJCEMissingError(operation, ex, queryId);
        }
        if (SnowflakeUtil.getRootCause(ex) instanceof IOException) {
            SnowflakeFileTransferAgent.throwNoSpaceLeftError(session, operation, ex, queryId);
        }
        if (ex instanceof AmazonClientException) {
            AmazonS3Exception s3ex;
            logger.debug("AmazonClientException: " + ex.getMessage(), new Object[0]);
            if (retryCount > s3Client.getMaxRetries() || s3Client.isClientException400Or404(ex)) {
                AmazonS3Exception ex1;
                String extendedRequestId = "none";
                if (ex instanceof AmazonS3Exception) {
                    ex1 = (AmazonS3Exception)ex;
                    extendedRequestId = ex1.getExtendedRequestId();
                }
                if (!(ex instanceof AmazonServiceException)) throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, "58000", (int)ErrorCode.AWS_CLIENT_ERROR.getMessageCode(), ex, operation, ex.getMessage());
                ex1 = (AmazonServiceException)ex;
                if (ex1.getStatusCode() != 400 || session == null) throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, "58000", (int)ErrorCode.S3_OPERATION_ERROR.getMessageCode(), (Throwable)ex1, operation, ex1.getErrorType().toString(), ex1.getErrorCode(), ex1.getMessage(), ex1.getRequestId(), extendedRequestId);
                SnowflakeFileTransferAgent.renewExpiredToken(session, command, s3Client);
                return;
            }
            logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
            logger.debug("Stack trace: ", ex);
            int backoffInMillis = s3Client.getRetryBackoffMin();
            if (retryCount > 1) {
                backoffInMillis <<= Math.min(retryCount - 1, s3Client.getRetryBackoffMaxExponent());
            }
            try {
                logger.debug("Sleep for {} milliseconds before retry", backoffInMillis);
                Thread.sleep(backoffInMillis);
            }
            catch (InterruptedException ex1) {
                // empty catch block
            }
            if (!(ex instanceof AmazonS3Exception) || !(s3ex = (AmazonS3Exception)ex).getErrorCode().equalsIgnoreCase(EXPIRED_AWS_TOKEN_ERROR_CODE)) return;
            if (session == null) throw new SnowflakeSQLException(queryId, s3ex.getErrorCode(), 240001, "S3 credentials have expired");
            SnowflakeFileTransferAgent.renewExpiredToken(session, command, s3Client);
            return;
        }
        if (!(ex instanceof InterruptedException) && !(SnowflakeUtil.getRootCause(ex) instanceof SocketTimeoutException)) throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), ex, "Encountered exception during " + operation + ": " + ex.getMessage());
        if (retryCount > s3Client.getMaxRetries()) {
            throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), ex, "Encountered exception during " + operation + ": " + ex.getMessage());
        }
        logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
    }

    public boolean isClientException400Or404(Exception ex) {
        if (ex instanceof AmazonServiceException) {
            AmazonServiceException asEx = (AmazonServiceException)ex;
            return asEx.getStatusCode() == 404 || asEx.getStatusCode() == 400;
        }
        return false;
    }

    @Override
    public String getMatdescKey() {
        return "x-amz-matdesc";
    }

    @Override
    public void addEncryptionMetadata(StorageObjectMetadata meta, MatDesc matDesc, byte[] ivData, byte[] encryptedKey, long contentLength) {
        meta.addUserMetadata(this.getMatdescKey(), matDesc.toString());
        meta.addUserMetadata(AMZ_KEY, Base64.getEncoder().encodeToString(encryptedKey));
        meta.addUserMetadata(AMZ_IV, Base64.getEncoder().encodeToString(ivData));
        meta.setContentLength(contentLength);
    }

    @Override
    public void addDigestMetadata(StorageObjectMetadata meta, String digest) {
        meta.addUserMetadata("sfc-digest", digest);
    }

    @Override
    public String getDigestMetadata(StorageObjectMetadata meta) {
        return meta.getUserMetadata().get("sfc-digest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SSLConnectionSocketFactory getSSLConnectionSocketFactory() {
        if (s3ConnectionSocketFactory != null) return s3ConnectionSocketFactory;
        Class<SnowflakeS3Client> clazz = SnowflakeS3Client.class;
        synchronized (SnowflakeS3Client.class) {
            if (s3ConnectionSocketFactory != null) return s3ConnectionSocketFactory;
            try {
                s3ConnectionSocketFactory = new SFSSLConnectionSocketFactory(null, HttpUtil.isSocksProxyDisabled());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new SSLInitializationException(e.getMessage(), (Throwable)e);
            }
            return s3ConnectionSocketFactory;
        }
    }

    @Override
    public void addStreamingIngestMetadata(StorageObjectMetadata meta, String clientName, String clientKey) {
        meta.addUserMetadata(S3_STREAMING_INGEST_CLIENT_NAME, clientName);
        meta.addUserMetadata(S3_STREAMING_INGEST_CLIENT_KEY, clientKey);
    }

    @Override
    public String getStreamingIngestClientName(StorageObjectMetadata meta) {
        return meta.getUserMetadata().get(S3_STREAMING_INGEST_CLIENT_NAME);
    }

    @Override
    public String getStreamingIngestClientKey(StorageObjectMetadata meta) {
        return meta.getUserMetadata().get(S3_STREAMING_INGEST_CLIENT_KEY);
    }
}

