/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.snowflake.client.ThrowingConsumer;
import net.snowflake.client.ThrowingRunnable;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

public class TestUtil {
    private static final SFLogger logger = SFLoggerFactory.getLogger(TestUtil.class);
    private static final Pattern QUERY_ID_REGEX = Pattern.compile("[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}");
    public static final String GENERATED_SCHEMA_PREFIX = "GENERATED_";
    public static final String ESCAPED_GENERATED_SCHEMA_PREFIX = "GENERATED_".replaceAll("_", "\\\\_");
    private static final List<String> schemaGeneratedInTestsPrefixes = Arrays.asList("GENERATED_", "GITHUB_", "GH_JOB_", "JDBCPERF", "SCHEMA_");

    public static boolean isSchemaGeneratedInTests(String schema) {
        return schemaGeneratedInTestsPrefixes.stream().anyMatch(prefix -> schema.startsWith((String)prefix));
    }

    public static void assertSFException(int errorCode, TestRunInterface testCode) {
        try {
            testCode.run();
            Assertions.fail();
        }
        catch (SFException e) {
            MatcherAssert.assertThat((Object)e.getVendorCode(), (Matcher)CoreMatchers.is((Object)errorCode));
        }
    }

    @Deprecated
    public static String systemGetEnv(String env) {
        try {
            return System.getenv(env);
        }
        catch (SecurityException ex) {
            logger.debug("Failed to get environment variable {}. Security exception raised: {}", new Object[]{env, ex.getMessage()});
            return null;
        }
    }

    public static void assertValidQueryId(String queryId) {
        Assertions.assertNotNull((Object)queryId);
        MatcherAssert.assertThat((String)("Expecting " + queryId + " is a valid UUID"), (Object)queryId, (Matcher)Matchers.matchesPattern((Pattern)QUERY_ID_REGEX));
    }

    public static void withSchema(Statement statement, String schemaName, ThrowingRunnable action) throws Exception {
        try {
            statement.execute("CREATE OR REPLACE SCHEMA " + schemaName);
            action.run();
        }
        finally {
            statement.execute("DROP SCHEMA " + schemaName);
        }
    }

    public static void withRandomSchema(Statement statement, ThrowingConsumer<String, Exception> action) throws Exception {
        String customSchema = GENERATED_SCHEMA_PREFIX + SnowflakeUtil.randomAlphaNumeric((int)5).toUpperCase();
        try {
            statement.execute("CREATE OR REPLACE SCHEMA " + customSchema);
            action.accept(customSchema);
        }
        finally {
            statement.execute("DROP SCHEMA " + customSchema);
        }
    }

    public static void expectSnowflakeLoggedFeatureNotSupportedException(MethodRaisesSQLException f) {
        try {
            f.run();
            Assertions.fail((String)"must raise exception");
        }
        catch (SQLException ex) {
            Assertions.assertEquals((Object)ex.getClass().getSimpleName(), (Object)"SnowflakeLoggedFeatureNotSupportedException");
        }
    }

    public static void assertEqualsIgnoringWhitespace(String expected, String actual) {
        Assertions.assertEquals((Object)expected.replaceAll("\\s+", ""), (Object)actual.replaceAll("\\s+", ""));
    }

    public static String randomTableName(String jiraId) {
        return ("TEST_" + (jiraId != null ? jiraId : "") + "_" + UUID.randomUUID()).replaceAll("-", "_");
    }

    public static List<Integer> randomIntList(int length, int modulo) {
        return new Random().ints().limit(length).mapToObj(i -> Math.abs(i) % modulo).collect(Collectors.toList());
    }

    public static interface MethodRaisesSQLException {
        public void run() throws SQLException;
    }

    @FunctionalInterface
    public static interface TestRunInterface {
        public void run() throws SFException;
    }
}

