/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.authentication;

import java.util.Properties;
import net.snowflake.client.jdbc.SnowflakeUtil;

public class AuthConnectionParameters {
    static final String SSO_USER = SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_BROWSER_USER");
    static final String HOST = SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_HOST");
    static final String SSO_PASSWORD = SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_OKTA_PASS");

    static Properties getBaseConnectionParameters() {
        Properties properties = new Properties();
        properties.put("host", HOST);
        properties.put("port", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_PORT"));
        properties.put("role", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_ROLE"));
        properties.put("account", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_ACCOUNT"));
        properties.put("db", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_DATABASE"));
        properties.put("schema", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_SCHEMA"));
        properties.put("warehouse", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_WAREHOUSE"));
        return properties;
    }

    static Properties getExternalBrowserConnectionParameters() {
        Properties properties = AuthConnectionParameters.getBaseConnectionParameters();
        properties.put("user", SSO_USER);
        properties.put("authenticator", "externalbrowser");
        return properties;
    }

    static Properties getStoreIDTokenConnectionParameters() {
        Properties properties = AuthConnectionParameters.getExternalBrowserConnectionParameters();
        properties.put("CLIENT_STORE_TEMPORARY_CREDENTIAL", (Object)true);
        return properties;
    }

    static Properties getOktaConnectionParameters() {
        Properties properties = AuthConnectionParameters.getBaseConnectionParameters();
        properties.put("user", SSO_USER);
        properties.put("password", SSO_PASSWORD);
        properties.put("authenticator", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_OAUTH_URL"));
        return properties;
    }

    static Properties getOauthConnectionParameters(String token) {
        Properties properties = AuthConnectionParameters.getBaseConnectionParameters();
        properties.put("user", SSO_USER);
        properties.put("authenticator", "OAUTH");
        properties.put("token", token);
        return properties;
    }
}

