/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.authentication;

import java.io.IOException;
import java.util.Properties;
import net.snowflake.client.authentication.AuthConnectionParameters;
import net.snowflake.client.authentication.AuthTestHelper;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="authentication")
class OktaAuthLatestIT {
    AuthTestHelper authTestHelper;

    OktaAuthLatestIT() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.authTestHelper = new AuthTestHelper();
    }

    @Test
    void shouldAuthenticateUsingOkta() {
        this.authTestHelper.connectAndExecuteSimpleQuery(AuthConnectionParameters.getOktaConnectionParameters(), null);
        this.authTestHelper.verifyExceptionIsNotThrown();
    }

    @Test
    void shouldAuthenticateUsingOktaWithOktaUsernameParam() {
        Properties properties = AuthConnectionParameters.getOktaConnectionParameters();
        properties.replace("user", "differentUsername");
        this.authTestHelper.connectAndExecuteSimpleQuery(properties, "oktausername=" + AuthConnectionParameters.SSO_USER);
        this.authTestHelper.verifyExceptionIsNotThrown();
    }

    @Test
    void shouldThrowErrorForWrongOktaCredentials() {
        Properties properties = AuthConnectionParameters.getOktaConnectionParameters();
        properties.put("user", "invalidUsername");
        properties.put("password", "fakepassword");
        this.authTestHelper.connectAndExecuteSimpleQuery(properties, null);
        this.authTestHelper.verifyExceptionIsThrown("JDBC driver encountered communication error. Message: HTTP status=401.");
    }

    @Test
    void shouldThrowErrorForWrongOktaCredentialsInOktaUsernameParam() {
        Properties properties = AuthConnectionParameters.getOktaConnectionParameters();
        properties.replace("user", "differentUsername");
        this.authTestHelper.connectAndExecuteSimpleQuery(properties, "oktausername=invalidUser");
        this.authTestHelper.verifyExceptionIsThrown("JDBC driver encountered communication error. Message: HTTP status=401.");
    }

    @Test
    void shouldThrowErrorForWrongOktaUrl() {
        Properties properties = AuthConnectionParameters.getOktaConnectionParameters();
        properties.put("authenticator", "https://invalid.okta.com/");
        this.authTestHelper.connectAndExecuteSimpleQuery(properties, null);
        this.authTestHelper.verifyExceptionIsThrown("The specified authenticator is not accepted by your Snowflake account configuration.  Please contact your local system administrator to get the correct URL to use.");
    }

    @Test
    @Disabled
    void shouldThrowErrorForWrongUrlWithoutOktaPath() {
        Properties properties = AuthConnectionParameters.getOktaConnectionParameters();
        properties.put("authenticator", "https://invalid.abc.com/");
        this.authTestHelper.connectAndExecuteSimpleQuery(properties, null);
        this.authTestHelper.verifyExceptionIsThrown("todo");
    }
}

