/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import net.snowflake.client.annotations.DontRunOnWindows;
import net.snowflake.client.config.SFClientConfigParser;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class SFPermissionsTest {
    Path configFilePath = Paths.get("config.json", new String[0]);
    String configJson = "{\"common\":{\"log_level\":\"debug\",\"log_path\":\"logs\"}}";

    @BeforeEach
    public void createConfigFile() throws IOException {
        Files.write(this.configFilePath, this.configJson.getBytes(), new OpenOption[0]);
    }

    @AfterEach
    public void cleanupConfigFile() throws IOException {
        Files.deleteIfExists(this.configFilePath);
    }

    @ParameterizedTest
    @CsvSource(value={"rwx------,false", "rw-------,false", "r-x------,false", "r--------,false", "rwxrwx---,true", "rwxrw----,true", "rwxr-x---,false", "rwxr-----,false", "rwx-wx---,true", "rwx-w----,true", "rwx--x---,false", "rwx---rwx,true", "rwx---rw-,true", "rwx---r-x,false", "rwx---r--,false", "rwx----wx,true", "rwx----w-,true", "rwx-----x,false"})
    @DontRunOnWindows
    public void testLogDirectoryPermissions(String permission, boolean isSucceed) throws IOException {
        Files.setPosixFilePermissions(this.configFilePath, PosixFilePermissions.fromString(permission));
        Boolean result = SFClientConfigParser.checkGroupOthersWritePermissions((String)this.configFilePath.toString());
        if (isSucceed != result) {
            Assertions.fail((String)("testLogDirectoryPermissions failed. Expected " + isSucceed));
        }
    }
}

