/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.microsoft.azure.storage.OperationContext;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Properties;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.core.AssertUtil;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.S3HttpUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CoreUtilsMiscellaneousTest {
    @Test
    public void testSnowflakeAssertTrue() {
        try {
            AssertUtil.assertTrue((boolean)false, (String)"Numbers do not match");
        }
        catch (SFException e) {
            Assertions.assertEquals((Object)"JDBC driver internal error: Numbers do not match.", (Object)e.getMessage());
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testgetOS() {
        Constants.clearOSForTesting();
        String originalOS = SnowflakeUtil.systemGetProperty((String)"os.name");
        System.setProperty("os.name", "Windows");
        Assertions.assertEquals((Object)Constants.OS.WINDOWS, (Object)Constants.getOS());
        Constants.clearOSForTesting();
        System.setProperty("os.name", "Linux");
        Assertions.assertEquals((Object)Constants.OS.LINUX, (Object)Constants.getOS());
        Constants.clearOSForTesting();
        System.setProperty("os.name", "Macintosh");
        Assertions.assertEquals((Object)Constants.OS.MAC, (Object)Constants.getOS());
        Constants.clearOSForTesting();
        System.setProperty("os.name", "Sunos");
        Assertions.assertEquals((Object)Constants.OS.SOLARIS, (Object)Constants.getOS());
        Constants.clearOSForTesting();
        System.setProperty("os.name", originalOS);
    }

    @Test
    public void testHttpClientSettingsKey() {
        HttpClientSettingsKey testKey1 = new HttpClientSettingsKey(OCSPMode.FAIL_OPEN, "snowflakecomputing.com", 443, "*.foo.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        HttpClientSettingsKey testKey2 = new HttpClientSettingsKey(OCSPMode.FAIL_OPEN, "snowflakecomputing.com", 443, "*.baz.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        HttpClientSettingsKey testKey3 = new HttpClientSettingsKey(OCSPMode.FAIL_CLOSED, "jdbc", Boolean.valueOf(false));
        Assertions.assertTrue((boolean)testKey1.equals((Object)testKey2));
        Assertions.assertEquals((Object)"*.foo.com", (Object)testKey2.getNonProxyHosts());
        Assertions.assertFalse((boolean)testKey1.equals((Object)testKey3));
    }

    @Test
    public void testSetProxyForS3() {
        HttpClientSettingsKey testKey = new HttpClientSettingsKey(OCSPMode.FAIL_OPEN, "snowflakecomputing.com", 443, "*.foo.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        ClientConfiguration clientConfig = new ClientConfiguration();
        S3HttpUtil.setProxyForS3((HttpClientSettingsKey)testKey, (ClientConfiguration)clientConfig);
        Assertions.assertEquals((Object)Protocol.HTTPS, (Object)clientConfig.getProxyProtocol());
        Assertions.assertEquals((Object)"snowflakecomputing.com", (Object)clientConfig.getProxyHost());
        Assertions.assertEquals((int)443, (int)clientConfig.getProxyPort());
        Assertions.assertEquals((Object)"*.foo.com", (Object)clientConfig.getNonProxyHosts());
        Assertions.assertEquals((Object)"pw", (Object)clientConfig.getProxyPassword());
        Assertions.assertEquals((Object)"testuser", (Object)clientConfig.getProxyUsername());
    }

    @Test
    public void testSetSessionlessProxyForS3() throws SnowflakeSQLException {
        Properties props = new Properties();
        props.put("useProxy", "true");
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "8084");
        props.put("proxyUser", "testuser");
        props.put("proxyPassword", "pw");
        props.put("nonProxyHosts", "baz.com | foo.com");
        props.put("proxyProtocol", "http");
        ClientConfiguration clientConfig = new ClientConfiguration();
        S3HttpUtil.setSessionlessProxyForS3((Properties)props, (ClientConfiguration)clientConfig);
        Assertions.assertEquals((Object)Protocol.HTTP, (Object)clientConfig.getProxyProtocol());
        Assertions.assertEquals((Object)"localhost", (Object)clientConfig.getProxyHost());
        Assertions.assertEquals((int)8084, (int)clientConfig.getProxyPort());
        Assertions.assertEquals((Object)"baz.com | foo.com", (Object)clientConfig.getNonProxyHosts());
        Assertions.assertEquals((Object)"pw", (Object)clientConfig.getProxyPassword());
        Assertions.assertEquals((Object)"testuser", (Object)clientConfig.getProxyUsername());
        props.put("proxyPort", "invalidnumber");
        try {
            S3HttpUtil.setSessionlessProxyForS3((Properties)props, (ClientConfiguration)clientConfig);
        }
        catch (SnowflakeSQLException e) {
            Assertions.assertEquals((int)ErrorCode.INVALID_PROXY_PROPERTIES.getMessageCode(), (int)e.getErrorCode());
        }
    }

    @Test
    public void testSetProxyForAzure() {
        OperationContext op = new OperationContext();
        HttpClientSettingsKey testKey = new HttpClientSettingsKey(OCSPMode.FAIL_OPEN, "snowflakecomputing.com", 443, "*.foo.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        HttpUtil.setProxyForAzure((HttpClientSettingsKey)testKey, (OperationContext)op);
        Proxy proxy = op.getProxy();
        Assertions.assertEquals((Object)((Object)Proxy.Type.HTTP), (Object)((Object)proxy.type()));
        Assertions.assertEquals((Object)new InetSocketAddress("snowflakecomputing.com", 443), (Object)proxy.address());
    }

    @Test
    public void testSetSessionlessProxyForAzure() throws SnowflakeSQLException {
        Properties props = new Properties();
        props.put("useProxy", "true");
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "8084");
        OperationContext op = new OperationContext();
        HttpUtil.setSessionlessProxyForAzure((Properties)props, (OperationContext)op);
        Proxy proxy = op.getProxy();
        Assertions.assertEquals((Object)((Object)Proxy.Type.HTTP), (Object)((Object)proxy.type()));
        Assertions.assertEquals((Object)new InetSocketAddress("localhost", 8084), (Object)proxy.address());
        props.put("proxyPort", "invalidnumber");
        try {
            HttpUtil.setSessionlessProxyForAzure((Properties)props, (OperationContext)op);
        }
        catch (SnowflakeSQLException e) {
            Assertions.assertEquals((int)ErrorCode.INVALID_PROXY_PROPERTIES.getMessageCode(), (int)e.getErrorCode());
        }
    }

    @Test
    public void testSizeOfHttpClientMapWithVariableNonProxyHosts() {
        HttpUtil.httpClient = new HashMap();
        HttpUtil.httpClientRoutePlanner = new HashMap();
        HttpClientSettingsKey key1 = new HttpClientSettingsKey(null, "localhost", 8080, "google.com | baz.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        HttpUtil.getHttpClient((HttpClientSettingsKey)key1);
        Assertions.assertEquals((int)1, (int)HttpUtil.httpClient.size());
        HttpClientSettingsKey key2 = new HttpClientSettingsKey(null, "localhost", 8080, "snowflake.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        HttpUtil.getHttpClient((HttpClientSettingsKey)key2);
        Assertions.assertEquals((int)1, (int)HttpUtil.httpClient.size());
        Assertions.assertEquals((Object)"snowflake.com", (Object)key1.getNonProxyHosts());
        HttpClientSettingsKey key3 = new HttpClientSettingsKey(null, "differenthost.com", 8080, "snowflake.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        HttpUtil.getHttpClient((HttpClientSettingsKey)key3);
        Assertions.assertEquals((int)2, (int)HttpUtil.httpClient.size());
    }

    @Test
    public void testSizeOfHttpClientMapWithGzipAndUserAgentSuffix() {
        HttpUtil.httpClient = new HashMap();
        HttpClientSettingsKey key1 = new HttpClientSettingsKey(null, "localhost", 8080, "google.com | baz.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        HttpUtil.getHttpClient((HttpClientSettingsKey)key1);
        Assertions.assertEquals((int)1, (int)HttpUtil.httpClient.size());
        HttpClientSettingsKey key2 = new HttpClientSettingsKey(null, "localhost", 8080, "google.com | baz.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(true));
        HttpUtil.getHttpClient((HttpClientSettingsKey)key2);
        Assertions.assertEquals((int)2, (int)HttpUtil.httpClient.size());
        HttpClientSettingsKey key3 = new HttpClientSettingsKey(null, "localhost", 8080, "google.com | baz.com", "testuser", "pw", "https", "odbc", Boolean.valueOf(true));
        HttpUtil.getHttpClient((HttpClientSettingsKey)key3);
        Assertions.assertEquals((int)3, (int)HttpUtil.httpClient.size());
    }

    @Test
    public void testConvertProxyPropertiesToHttpClientKey() throws SnowflakeSQLException {
        OCSPMode mode = OCSPMode.FAIL_OPEN;
        Properties props = new Properties();
        HttpClientSettingsKey expectedNoProxy = new HttpClientSettingsKey(mode);
        HttpClientSettingsKey settingsKey = SnowflakeUtil.convertProxyPropertiesToHttpClientKey((OCSPMode)mode, (Properties)props);
        Assertions.assertTrue((boolean)expectedNoProxy.equals((Object)settingsKey));
        props.put("useProxy", "false");
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "8084");
        settingsKey = SnowflakeUtil.convertProxyPropertiesToHttpClientKey((OCSPMode)mode, (Properties)props);
        Assertions.assertTrue((boolean)expectedNoProxy.equals((Object)settingsKey));
        props.put("useProxy", "true");
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "8084");
        props.put("proxyUser", "testuser");
        props.put("proxyPassword", "pw");
        props.put("nonProxyHosts", "baz.com | foo.com");
        props.put("proxyProtocol", "http");
        props.put("user_agent_suffix", "jdbc");
        settingsKey = SnowflakeUtil.convertProxyPropertiesToHttpClientKey((OCSPMode)mode, (Properties)props);
        HttpClientSettingsKey expectedWithProxy = new HttpClientSettingsKey(OCSPMode.FAIL_OPEN, "localhost", 8084, "baz.com | foo.com", "testuser", "pw", "http", "jdbc", Boolean.valueOf(false));
        Assertions.assertTrue((boolean)expectedWithProxy.equals((Object)settingsKey));
        props.put("gzipDisabled", "true");
        settingsKey = SnowflakeUtil.convertProxyPropertiesToHttpClientKey((OCSPMode)mode, (Properties)props);
        expectedWithProxy = new HttpClientSettingsKey(OCSPMode.FAIL_OPEN, "localhost", 8084, "baz.com | foo.com", "testuser", "pw", "http", "jdbc", Boolean.valueOf(true));
        Assertions.assertTrue((boolean)expectedWithProxy.equals((Object)settingsKey));
        props.put("proxyPort", "invalidnumber");
        try {
            settingsKey = SnowflakeUtil.convertProxyPropertiesToHttpClientKey((OCSPMode)mode, (Properties)props);
        }
        catch (SnowflakeSQLException e) {
            Assertions.assertEquals((int)ErrorCode.INVALID_PROXY_PROPERTIES.getMessageCode(), (int)e.getErrorCode());
        }
    }

    @Test
    public void testNullAndEmptyProxySettingsForS3() {
        HttpClientSettingsKey testKey = new HttpClientSettingsKey(OCSPMode.FAIL_OPEN, null, 443, null, null, null, "", "", Boolean.valueOf(false));
        ClientConfiguration clientConfig = new ClientConfiguration();
        S3HttpUtil.setProxyForS3((HttpClientSettingsKey)testKey, (ClientConfiguration)clientConfig);
        Assertions.assertEquals((Object)Protocol.HTTP, (Object)clientConfig.getProxyProtocol());
        Assertions.assertEquals((Object)"", (Object)clientConfig.getProxyHost());
        Assertions.assertEquals((int)443, (int)clientConfig.getProxyPort());
        Assertions.assertEquals((Object)"", (Object)clientConfig.getNonProxyHosts());
        Assertions.assertNull((Object)clientConfig.getProxyUsername());
        Assertions.assertNull((Object)clientConfig.getProxyPassword());
    }
}

