/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;
import net.snowflake.client.core.BasicEvent;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventUtil;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class EventTest {
    @TempDir
    private File tmpFolder;
    private File homeDirectory;
    private File dmpDirectory;

    @BeforeEach
    public void setUp() throws IOException {
        this.homeDirectory = new File(this.tmpFolder, "homedir");
        this.homeDirectory.mkdirs();
        this.dmpDirectory = new File(this.homeDirectory, "snowflake_dumps");
        this.dmpDirectory.mkdirs();
    }

    @AfterEach
    public void tearDown() {
        this.dmpDirectory.delete();
    }

    @Test
    public void testEvent() {
        BasicEvent event = new BasicEvent(Event.EventType.NONE, "basic event");
        event.setType(Event.EventType.NETWORK_ERROR);
        event.setMessage("network timeout");
        Assertions.assertEquals((int)1, (int)event.getType().getId());
        Assertions.assertEquals((Object)"network timeout", (Object)event.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteEventDumpLine() throws IOException {
        try {
            String dumpPath = this.homeDirectory.getCanonicalPath();
            System.setProperty("snowflake.dump_path", dumpPath);
            EventUtil.setDumpPathPrefixForTesting((String)dumpPath);
            BasicEvent event = new BasicEvent(Event.EventType.NETWORK_ERROR, "network timeout");
            event.writeEventDumpLine("network timeout after 60 seconds");
            String dmpPath1 = EventUtil.getDumpPathPrefix();
            String dmpPath2 = this.dmpDirectory.getCanonicalPath();
            Assertions.assertEquals((Object)dmpPath2, (Object)dmpPath1, (String)("dump path is: " + EventUtil.getDumpPathPrefix()));
            File dumpFile = new File(EventUtil.getDumpPathPrefix() + File.separator + "sf_event_" + EventUtil.getDumpFileId() + ".dmp.gz");
            GZIPInputStream gzip = new GZIPInputStream(Files.newInputStream(dumpFile.toPath(), new OpenOption[0]));
            StringWriter sWriter = new StringWriter();
            IOUtils.copy((InputStream)gzip, (Writer)sWriter, (String)"UTF-8");
            Assertions.assertTrue((boolean)sWriter.toString().contains("network timeout after 60 seconds"));
            gzip.close();
            sWriter.close();
            dumpFile.delete();
        }
        finally {
            System.clearProperty("snowflake.dump_path");
            EventUtil.setDumpPathPrefixForTesting((String)EventUtil.getDumpPathPrefix());
        }
    }
}

