/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExecTimeTelemetryDataTest {
    @Test
    public void testExecTimeTelemetryData() throws ParseException {
        ExecTimeTelemetryData execTimeTelemetryData = new ExecTimeTelemetryData();
        execTimeTelemetryData.sendData = true;
        execTimeTelemetryData.setBindStart();
        execTimeTelemetryData.setOCSPStatus(Boolean.valueOf(true));
        execTimeTelemetryData.setBindEnd();
        execTimeTelemetryData.setHttpClientStart();
        execTimeTelemetryData.setHttpClientEnd();
        execTimeTelemetryData.setGzipStart();
        execTimeTelemetryData.setGzipEnd();
        execTimeTelemetryData.setQueryEnd();
        execTimeTelemetryData.setQueryId("queryid");
        execTimeTelemetryData.setProcessResultChunkStart();
        execTimeTelemetryData.setProcessResultChunkEnd();
        execTimeTelemetryData.setResponseIOStreamStart();
        execTimeTelemetryData.setResponseIOStreamEnd();
        execTimeTelemetryData.setCreateResultSetStart();
        execTimeTelemetryData.setCreateResultSetEnd();
        execTimeTelemetryData.incrementRetryCount();
        execTimeTelemetryData.setRequestId("mockId");
        execTimeTelemetryData.addRetryLocation("retry");
        String telemetry = execTimeTelemetryData.generateTelemetry();
        JSONParser parser = new JSONParser(4032);
        JSONObject json = (JSONObject)parser.parse(telemetry);
        Assertions.assertNotNull((Object)json.get((Object)"BindStart"));
        Assertions.assertNotNull((Object)json.get((Object)"BindEnd"));
        Assertions.assertEquals((Object)json.get((Object)"ocspEnabled"), (Object)true);
        Assertions.assertNotNull((Object)json.get((Object)"HttpClientStart"));
        Assertions.assertNotNull((Object)json.get((Object)"HttpClientEnd"));
        Assertions.assertNotNull((Object)json.get((Object)"GzipStart"));
        Assertions.assertNotNull((Object)json.get((Object)"GzipEnd"));
        Assertions.assertNotNull((Object)json.get((Object)"QueryEnd"));
        Assertions.assertEquals((Object)json.get((Object)"QueryID"), (Object)"queryid");
        Assertions.assertNotNull((Object)json.get((Object)"ProcessResultChunkStart"));
        Assertions.assertNotNull((Object)json.get((Object)"ProcessResultChunkEnd"));
        Assertions.assertNotNull((Object)json.get((Object)"ResponseIOStreamStart"));
        Assertions.assertNotNull((Object)json.get((Object)"CreateResultSetStart"));
        Assertions.assertNotNull((Object)json.get((Object)"CreateResultSetEnd"));
        Assertions.assertNotNull((Object)json.get((Object)"ElapsedQueryTime"));
        Assertions.assertNotNull((Object)json.get((Object)"ElapsedResultProcessTime"));
        Assertions.assertNull((Object)json.get((Object)"QueryFunction"));
        Assertions.assertNull((Object)json.get((Object)"BatchID"));
        Assertions.assertEquals((int)((Long)json.get((Object)"RetryCount")).intValue(), (int)1);
        Assertions.assertEquals((Object)json.get((Object)"RequestID"), (Object)"mockId");
        Assertions.assertEquals((Object)json.get((Object)"RetryLocations"), (Object)"retry");
        Assertions.assertEquals((Object)json.get((Object)"Urgent"), (Object)true);
        Assertions.assertEquals((Object)json.get((Object)"eventType"), (Object)"ExecutionTimeRecord");
    }

    @Test
    public void testRetryLocation() throws ParseException {
        TelemetryService.enableHTAP();
        ExecTimeTelemetryData execTimeTelemetryData = new ExecTimeTelemetryData("queryFunction", "batchId");
        execTimeTelemetryData.addRetryLocation("hello");
        execTimeTelemetryData.addRetryLocation("world");
        execTimeTelemetryData.sendData = true;
        String telemetry = execTimeTelemetryData.generateTelemetry();
        JSONParser parser = new JSONParser(4032);
        JSONObject json = (JSONObject)parser.parse(telemetry);
        Assertions.assertEquals((Object)json.get((Object)"QueryFunction"), (Object)"queryFunction");
        Assertions.assertEquals((Object)json.get((Object)"BatchID"), (Object)"batchId");
        Assertions.assertNotNull((Object)json.get((Object)"QueryStart"));
        Assertions.assertEquals((Object)json.get((Object)"RetryLocations"), (Object)"hello, world");
        TelemetryService.disableHTAP();
    }
}

