/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.snowflake.client.annotations.RunOnLinuxOrMac;
import net.snowflake.client.core.FileCacheManager;
import net.snowflake.client.core.FileUtil;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@Nested
@Tag(value="core")
class FileCacheManagerTest
extends BaseJDBCTest {
    private static final String CACHE_FILE_NAME = "temporary_credential.json";
    private static final String CACHE_DIR_PROP = "net.snowflake.jdbc.temporaryCredentialCacheDir";
    private static final String CACHE_DIR_ENV = "SF_TEMPORARY_CREDENTIAL_CACHE_DIR";
    private static final long CACHE_EXPIRATION_IN_SECONDS = 86400L;
    private static final long CACHE_FILE_LOCK_EXPIRATION_IN_SECONDS = 60L;
    private FileCacheManager fileCacheManager;
    private File cacheFile;

    FileCacheManagerTest() {
    }

    @BeforeEach
    public void setup() throws IOException {
        this.fileCacheManager = FileCacheManager.builder().setCacheDirectorySystemProperty(CACHE_DIR_PROP).setCacheDirectoryEnvironmentVariable(CACHE_DIR_ENV).setBaseCacheFileName(CACHE_FILE_NAME).setCacheExpirationInSeconds(86400L).setCacheFileLockExpirationInSeconds(60L).build();
        this.cacheFile = this.createCacheFile();
    }

    @AfterEach
    public void clean() throws IOException {
        if (Files.exists(this.cacheFile.toPath(), new LinkOption[0])) {
            Files.delete(this.cacheFile.toPath());
        }
    }

    @ParameterizedTest
    @CsvSource(value={"rwx------,false", "rw-------,true", "r-x------,false", "r--------,true", "rwxrwx---,false", "rwxrw----,false", "rwxr-x---,false", "rwxr-----,false", "rwx-wx---,false", "rwx-w----,false", "rwx--x---,false", "rwx---rwx,false", "rwx---rw-,false", "rwx---r-x,false", "rwx---r--,false", "rwx----wx,false", "rwx----w-,false", "rwx-----x,false"})
    @RunOnLinuxOrMac
    public void throwWhenReadCacheFileWithPermissionDifferentThanReadWriteForUserTest(String permission, boolean isSucceed) throws IOException {
        this.fileCacheManager.overrideCacheFile(this.cacheFile);
        Files.setPosixFilePermissions(this.cacheFile.toPath(), PosixFilePermissions.fromString(permission));
        if (isSucceed) {
            Assertions.assertDoesNotThrow(() -> this.fileCacheManager.readCacheFile());
        } else {
            SecurityException ex = (SecurityException)Assertions.assertThrows(SecurityException.class, () -> this.fileCacheManager.readCacheFile());
            Assertions.assertTrue((boolean)ex.getMessage().contains("is wider than allowed only to the owner"));
        }
    }

    @Test
    @RunOnLinuxOrMac
    public void throwWhenOverrideCacheFileHasDifferentOwnerThanCurrentUserTest() {
        try (MockedStatic fileUtilMock = Mockito.mockStatic(FileUtil.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            fileUtilMock.when(() -> FileUtil.getFileOwnerName((Path)((Path)ArgumentMatchers.isA(Path.class)))).thenReturn((Object)"anotherUser");
            SecurityException ex = (SecurityException)Assertions.assertThrows(SecurityException.class, () -> this.fileCacheManager.readCacheFile());
            Assertions.assertTrue((boolean)ex.getMessage().contains("The file owner is different than current user"));
        }
    }

    @Test
    @RunOnLinuxOrMac
    public void notThrowForToWidePermissionsWhenOnlyOwnerPermissionsSetFalseTest() throws IOException {
        this.fileCacheManager.setOnlyOwnerPermissions(false);
        Files.setPosixFilePermissions(this.cacheFile.toPath(), PosixFilePermissions.fromString("rwxrwx---"));
        Assertions.assertDoesNotThrow(() -> this.fileCacheManager.readCacheFile());
    }

    @Test
    @RunOnLinuxOrMac
    public void throwWhenOverrideCacheFileNotFound() {
        Path wrongPath = Paths.get(SnowflakeUtil.systemGetProperty((String)"user.home"), ".cache", "snowflake2", "wrongFileName");
        SecurityException ex = (SecurityException)Assertions.assertThrows(SecurityException.class, () -> this.fileCacheManager.overrideCacheFile(wrongPath.toFile()));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Unable to access the file to check the permissions. Error: java.nio.file.NoSuchFileException:"));
    }

    private File createCacheFile() {
        Path cacheFile = Paths.get(SnowflakeUtil.systemGetProperty((String)"user.home"), ".cache", "snowflake2", CACHE_FILE_NAME);
        try {
            if (Files.exists(cacheFile, new LinkOption[0])) {
                Files.delete(cacheFile);
            }
            Files.createDirectories(cacheFile.getParent(), new FileAttribute[0]);
            Files.createFile(cacheFile, PosixFilePermissions.asFileAttribute(Stream.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE).collect(Collectors.toSet())));
            ObjectNode cacheContent = StmtUtil.mapper.createObjectNode();
            cacheContent.put("token", "tokenValue");
            this.fileCacheManager.overrideCacheFile(cacheFile.toFile());
            this.fileCacheManager.writeCacheFile((JsonNode)cacheContent);
            return cacheFile.toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

