/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.OCSPMode;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Tag(value="core")
public class HttpUtilLatestIT {
    private static final String HANG_WEBSERVER_ADDRESS = "http://localhost:12345/hang";

    @BeforeEach
    public void resetHttpClientsCache() {
        HttpUtil.httpClient.clear();
    }

    @Test
    public void shouldGetDefaultConnectionAndSocketTimeouts() {
        Assertions.assertEquals((Object)Duration.ofMillis(60000L), (Object)HttpUtil.getConnectionTimeout());
        Assertions.assertEquals((Object)Duration.ofMillis(300000L), (Object)HttpUtil.getSocketTimeout());
    }

    @Test
    @Timeout(value=1L)
    public void shouldOverrideConnectionAndSocketTimeouts() {
        HttpUtil.setConnectionTimeout((int)100);
        HttpUtil.setSocketTimeout((int)200);
        CloseableHttpClient httpClient = HttpUtil.getHttpClient((HttpClientSettingsKey)new HttpClientSettingsKey(OCSPMode.INSECURE));
        try {
            httpClient.execute((HttpUriRequest)new HttpGet(HANG_WEBSERVER_ADDRESS));
            Assertions.fail((String)"Request should fail with exception");
        }
        catch (IOException e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(SocketTimeoutException.class));
        }
        finally {
            HttpUtil.setConnectionTimeout((int)60000);
            HttpUtil.setSocketTimeout((int)300000);
        }
    }
}

