/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class MockMacKeychainManager {
    private static final Map<String, Map<String, MockMacKeychainItem>> keychainManager = new HashMap<String, Map<String, MockMacKeychainItem>>();

    MockMacKeychainManager() {
    }

    static void addCredential(byte[] targetName, byte[] userName, int credLength, byte[] credData) {
        String target = new String(targetName);
        String user = new String(userName);
        keychainManager.computeIfAbsent(target, newMap -> new HashMap());
        Map<String, MockMacKeychainItem> currentTargetMap = keychainManager.get(target);
        currentTargetMap.put(user, MockMacKeychainManager.buildMacKeychainItem(credLength, credData));
    }

    static MockMacKeychainItem getCredential(byte[] targetName, byte[] userName) {
        Map<String, MockMacKeychainItem> targetMap = keychainManager.get(new String(targetName));
        return targetMap != null ? targetMap.get(new String(userName)) : null;
    }

    static void replaceCredential(Pointer itemRef, int credLength, byte[] credData) {
        for (Map.Entry<String, Map<String, MockMacKeychainItem>> elem : keychainManager.entrySet()) {
            Map<String, MockMacKeychainItem> targetMap = elem.getValue();
            for (Map.Entry<String, MockMacKeychainItem> elem0 : targetMap.entrySet()) {
                if (!elem0.getValue().getPointer().toString().equals(itemRef.toString())) continue;
                targetMap.put(elem0.getKey(), MockMacKeychainManager.buildMacKeychainItem(credLength, credData));
                return;
            }
        }
    }

    static void deleteCredential(Pointer itemRef) {
        for (Map.Entry<String, Map<String, MockMacKeychainItem>> targetMap : keychainManager.entrySet()) {
            Iterator<Map.Entry<String, MockMacKeychainItem>> userIter = targetMap.getValue().entrySet().iterator();
            while (userIter.hasNext()) {
                Map.Entry<String, MockMacKeychainItem> cred = userIter.next();
                if (!cred.getValue().getPointer().toString().equals(itemRef.toString())) continue;
                userIter.remove();
                return;
            }
        }
    }

    static MockMacKeychainItem buildMacKeychainItem(int itemLength, byte[] itemData) {
        Memory itemMem = new Memory((long)itemLength);
        itemMem.write(0L, itemData, 0, itemLength);
        return new MockMacKeychainItem(itemLength, (Pointer)itemMem);
    }

    static class MockMacKeychainItem {
        private int length;
        private Pointer pointer;

        MockMacKeychainItem(int length, Pointer pointer) {
            this.length = length;
            this.pointer = pointer;
        }

        void setLength(int length) {
            this.length = length;
        }

        int getLength() {
            return this.length;
        }

        void setPointer(Pointer pointer) {
            this.pointer = pointer;
        }

        Pointer getPointer() {
            return this.pointer;
        }
    }
}

