/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Base64;
import java.util.stream.Stream;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class ObjectMapperTest {
    private static final int jacksonDefaultMaxStringLength = 20000000;
    static String originalLogger;

    @BeforeAll
    public static void setProperty() {
        originalLogger = System.getProperty("net.snowflake.jdbc.loggerImpl");
        System.setProperty("net.snowflake.jdbc.loggerImpl", "net.snowflake.client.log.JDK14Logger");
    }

    @AfterAll
    public static void clearProperty() {
        if (originalLogger != null) {
            System.setProperty("net.snowflake.jdbc.loggerImpl", originalLogger);
        } else {
            System.clearProperty("net.snowflake.jdbc.loggerImpl");
        }
        System.clearProperty("net.snowflake.jdbc.objectMapper.maxJsonStringLength");
    }

    private static void setJacksonDefaultMaxStringLength(int maxJsonStringLength) {
        System.setProperty("net.snowflake.jdbc.objectMapper.maxJsonStringLength", Integer.toString(maxJsonStringLength));
    }

    @Test
    public void testInvalidMaxJsonStringLength() throws SQLException {
        System.setProperty("net.snowflake.jdbc.objectMapper.maxJsonStringLength", "abc");
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        int stringLengthInMapper = mapper.getFactory().streamReadConstraints().getMaxStringLength();
        Assertions.assertEquals((int)180000000, (int)stringLengthInMapper);
    }

    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    public void testObjectMapperWithLargeJsonString(int lobSizeInBytes, int maxJsonStringLength) {
        ObjectMapperTest.setJacksonDefaultMaxStringLength(maxJsonStringLength);
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        try {
            JsonNode jsonNode = mapper.readTree(this.generateBase64EncodedJsonString(lobSizeInBytes));
            Assertions.assertNotNull((Object)jsonNode);
        }
        catch (Exception e) {
            Assertions.assertEquals((int)20000000, (int)maxJsonStringLength);
        }
    }

    private String generateBase64EncodedJsonString(int numChar) {
        StringBuilder jsonStr = new StringBuilder();
        String largeStr = SnowflakeUtil.randomAlphaNumeric((int)numChar);
        jsonStr.append("[\"").append(this.encodeStringToBase64(largeStr)).append("\"]");
        return jsonStr.toString();
    }

    private String encodeStringToBase64(String stringToBeEncoded) {
        return Base64.getEncoder().encodeToString(stringToBeEncoded.getBytes(StandardCharsets.UTF_8));
    }

    static class DataProvider
    implements ArgumentsProvider {
        DataProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            return Stream.of(Arguments.of((Object[])new Object[]{0x1000000, 20000000}), Arguments.of((Object[])new Object[]{0x1000000, 23000000}), Arguments.of((Object[])new Object[]{0x2000000, 45000000}), Arguments.of((Object[])new Object[]{0x4000000, 90000000}), Arguments.of((Object[])new Object[]{0x8000000, 180000000}));
        }
    }
}

