/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.util.stream.Stream;
import net.snowflake.client.core.PrivateLinkDetector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class PrivateLinkDetectorTest {
    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    public void shouldDetectPrivateLinkHost(String host, boolean expectedToBePrivateLink) {
        Assertions.assertEquals((Object)expectedToBePrivateLink, (Object)PrivateLinkDetector.isPrivateLink((String)host), (String)String.format("Expecting %s to be private link: %s", host, expectedToBePrivateLink));
    }

    static class DataProvider
    implements ArgumentsProvider {
        DataProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            return Stream.of(Arguments.of((Object[])new Object[]{"snowhouse.snowflakecomputing.com", false}), Arguments.of((Object[])new Object[]{"snowhouse.privatelink.snowflakecomputing.com", true}), Arguments.of((Object[])new Object[]{"snowhouse.PRIVATELINK.snowflakecomputing.com", true}), Arguments.of((Object[])new Object[]{"snowhouse.snowflakecomputing.cn", false}), Arguments.of((Object[])new Object[]{"snowhouse.privatelink.snowflakecomputing.cn", true}), Arguments.of((Object[])new Object[]{"snowhouse.PRIVATELINK.snowflakecomputing.cn", true}), Arguments.of((Object[])new Object[]{"snowhouse.snowflakecomputing.xyz", false}), Arguments.of((Object[])new Object[]{"snowhouse.privatelink.snowflakecomputing.xyz", true}), Arguments.of((Object[])new Object[]{"snowhouse.PRIVATELINK.snowflakecomputing.xyz", true}));
        }
    }
}

