/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.net.ssl.SSLHandshakeException;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.AnyOf;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="core")
public class SFTrustManagerIT
extends BaseJDBCTest {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFTrustManagerIT.class);
    private boolean defaultState;
    @TempDir
    File tmpFolder;

    @BeforeEach
    public void setUp() {
        TelemetryService service = TelemetryService.getInstance();
        service.updateContextForIT(SFTrustManagerIT.getConnectionParameters());
        this.defaultState = service.isEnabled();
        service.setNumOfRetryToTriggerTelemetry(3);
        service.enable();
    }

    @AfterEach
    public void tearDown() throws InterruptedException {
        TelemetryService service = TelemetryService.getInstance();
        TimeUnit.SECONDS.sleep(5L);
        if (this.defaultState) {
            service.enable();
        } else {
            service.disable();
        }
        System.clearProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED");
        System.clearProperty("SF_OCSP_RESPONSE_CACHE_SERVER_URL");
    }

    @ParameterizedTest
    @ArgumentsSource(value=HostProvider.class)
    public void testOcsp(String host) throws Throwable {
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.TRUE.toString());
        CloseableHttpClient client = HttpUtil.buildHttpClient((HttpClientSettingsKey)new HttpClientSettingsKey(OCSPMode.FAIL_CLOSED), null, (boolean)false);
        SFTrustManagerIT.accessHost(host, (HttpClient)client);
    }

    @ParameterizedTest
    @ArgumentsSource(value=HostProvider.class)
    public void testOcspWithFileCache(String host) throws Throwable {
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.FALSE.toString());
        File ocspCacheFile = new File(this.tmpFolder, "ocsp-cache");
        ocspCacheFile.createNewFile();
        CloseableHttpClient client = HttpUtil.buildHttpClient((HttpClientSettingsKey)new HttpClientSettingsKey(OCSPMode.FAIL_CLOSED), (File)ocspCacheFile, (boolean)false);
        SFTrustManagerIT.accessHost(host, (HttpClient)client);
    }

    @ParameterizedTest
    @ArgumentsSource(value=HostProvider.class)
    public void testOcspWithServerCache(String host) throws Throwable {
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.TRUE.toString());
        File ocspCacheFile = new File(this.tmpFolder, "ocsp-cache");
        ocspCacheFile.createNewFile();
        CloseableHttpClient client = HttpUtil.buildHttpClient((HttpClientSettingsKey)new HttpClientSettingsKey(OCSPMode.FAIL_CLOSED), (File)ocspCacheFile, (boolean)false);
        SFTrustManagerIT.accessHost(host, (HttpClient)client);
    }

    @ParameterizedTest
    @ArgumentsSource(value=HostProvider.class)
    public void testOcspWithoutServerCache(String host) throws Throwable {
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.FALSE.toString());
        File ocspCacheFile = new File(this.tmpFolder, "ocsp-cache");
        ocspCacheFile.createNewFile();
        CloseableHttpClient client = HttpUtil.buildHttpClient((HttpClientSettingsKey)new HttpClientSettingsKey(OCSPMode.FAIL_OPEN), (File)ocspCacheFile, (boolean)false);
        SFTrustManagerIT.accessHost(host, (HttpClient)client);
    }

    @ParameterizedTest
    @ArgumentsSource(value=HostProvider.class)
    public void testInvalidCacheFile(String host) throws Throwable {
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.TRUE.toString());
        File ocspCacheFile = new File("NEVER_EXISTS", "NEVER_EXISTS");
        CloseableHttpClient client = HttpUtil.buildHttpClient((HttpClientSettingsKey)new HttpClientSettingsKey(OCSPMode.FAIL_CLOSED), (File)ocspCacheFile, (boolean)false);
        SFTrustManagerIT.accessHost(host, (HttpClient)client);
    }

    private static void accessHost(String host, HttpClient client) throws IOException, InterruptedException {
        HttpResponse response = SFTrustManagerIT.executeWithRetries(host, client);
        Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> response.getStatusLine().getStatusCode(), CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)-1)));
        MatcherAssert.assertThat((String)String.format("response code for %s", host), (Object)response.getStatusLine().getStatusCode(), (Matcher)AnyOf.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)200), CoreMatchers.equalTo((Object)400), CoreMatchers.equalTo((Object)403), CoreMatchers.equalTo((Object)404), CoreMatchers.equalTo((Object)513)}));
    }

    private static HttpResponse executeWithRetries(String host, HttpClient client) throws IOException, InterruptedException {
        int maxRetries = host.equals("storage.googleapis.com") ? 5 : 0;
        int retries = 0;
        HttpGet httpRequest = new HttpGet(String.format("https://%s:443/", host));
        while (true) {
            try {
                return client.execute((HttpUriRequest)httpRequest);
            }
            catch (SSLHandshakeException e) {
                logger.warn("SSL handshake failed (host = {}, retries={}}", new Object[]{host, retries, e});
                if (++retries >= maxRetries) {
                    throw e;
                }
                Thread.sleep(retries * 1000);
                continue;
            }
            break;
        }
    }

    private List<X509Certificate> getX509CertificatesFromFile(String filename) throws Throwable {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        for (Certificate certificate : fact.generateCertificates(this.getFile(filename))) {
            certList.add((X509Certificate)certificate);
        }
        return certList;
    }

    private InputStream getFile(String fileName) throws Throwable {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL url = classLoader.getResource(fileName);
        return url != null ? url.openStream() : null;
    }

    private static class HostProvider
    implements ArgumentsProvider {
        private HostProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            return Stream.of(Arguments.of((Object[])new Object[]{"ocspssd.us-east-1.snowflakecomputing.com/ocsp/fetch"}), Arguments.of((Object[])new Object[]{"sfcsupport.snowflakecomputing.com"}), Arguments.of((Object[])new Object[]{"sfcsupport.us-east-1.snowflakecomputing.com"}), Arguments.of((Object[])new Object[]{"sfcsupport.eu-central-1.snowflakecomputing.com"}), Arguments.of((Object[])new Object[]{"sfc-dev1-regression.s3.amazonaws.com"}), Arguments.of((Object[])new Object[]{"sfc-ds2-customer-stage.s3.amazonaws.com"}), Arguments.of((Object[])new Object[]{"snowflake.okta.com"}), Arguments.of((Object[])new Object[]{"sfcdev2.blob.core.windows.net"}));
        }
    }
}

