/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.SystemUtil;
import net.snowflake.client.core.auth.AuthenticatorType;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

@Tag(value="core")
public class SessionUtilLatestIT
extends BaseJDBCTest {
    @Disabled
    @Test
    public void testJwtAuthTimeoutRetry() throws SFException, SnowflakeSQLException {
        SFLoginInput loginInput = this.initMockLoginInput();
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);
        SnowflakeSQLException ex = new SnowflakeSQLException(ErrorCode.AUTHENTICATOR_REQUEST_TIMEOUT, 0, true, 0L);
        mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpRequestBase.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenThrow(new Throwable[]{ex}).thenReturn((Object)"{\"data\":null,\"code\":null,\"message\":null,\"success\":true}");
        SessionUtil.openSession((SFLoginInput)loginInput, connectionPropertiesMap, (String)"ALL");
    }

    private SFLoginInput initMockLoginInput() {
        SFLoginInput loginInput = (SFLoginInput)Mockito.mock(SFLoginInput.class);
        Mockito.when((Object)loginInput.getServerUrl()).thenReturn((Object)TestUtil.systemGetEnv("SNOWFLAKE_TEST_HOST"));
        Mockito.when((Object)loginInput.getAuthenticator()).thenReturn((Object)AuthenticatorType.SNOWFLAKE_JWT.name());
        Mockito.when((Object)loginInput.getPrivateKeyFile()).thenReturn((Object)TestUtil.systemGetEnv("SNOWFLAKE_TEST_PRIVATE_KEY_FILE"));
        Mockito.when((Object)loginInput.getPrivateKeyPwd()).thenReturn((Object)TestUtil.systemGetEnv("SNOWFLAKE_TEST_PRIVATE_KEY_PWD"));
        Mockito.when((Object)loginInput.getUserName()).thenReturn((Object)TestUtil.systemGetEnv("SNOWFLAKE_TEST_USER"));
        Mockito.when((Object)loginInput.getAccountName()).thenReturn((Object)"testaccount");
        Mockito.when((Object)loginInput.getAppId()).thenReturn((Object)"testid");
        Mockito.when((Object)loginInput.getOCSPMode()).thenReturn((Object)OCSPMode.FAIL_OPEN);
        Mockito.when((Object)loginInput.getHttpClientSettingsKey()).thenReturn((Object)new HttpClientSettingsKey(OCSPMode.FAIL_OPEN));
        return loginInput;
    }

    private Map<SFSessionProperty, Object> initConnectionPropertiesMap() {
        HashMap<SFSessionProperty, Object> connectionPropertiesMap = new HashMap<SFSessionProperty, Object>();
        connectionPropertiesMap.put(SFSessionProperty.TRACING, "ALL");
        return connectionPropertiesMap;
    }

    @Test
    public void testConvertSystemPropertyToIntValue() {
        Assertions.assertEquals((int)60, (int)SystemUtil.convertSystemPropertyToIntValue((String)"net.snowflake.jdbc.ttl", (int)60));
        System.setProperty("net.snowflake.jdbc.ttl", "-1");
        Assertions.assertEquals((int)-1, (int)SystemUtil.convertSystemPropertyToIntValue((String)"net.snowflake.jdbc.ttl", (int)60));
    }

    @Test
    public void testForwardedHeaders() throws Throwable {
        SFLoginInput input = this.createLoginInput();
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        additionalHeaders.put("Extra-Snowflake-Header", "present");
        input.setAdditionalHttpHeadersForSnowsight(additionalHeaders);
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            MockedStatic.Verification httpCalledWithHeaders = () -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.argThat(arg -> {
                for (Map.Entry definedHeader : additionalHeaders.entrySet()) {
                    Header actualHeader = arg.getLastHeader((String)definedHeader.getKey());
                    if (actualHeader == null) {
                        return false;
                    }
                    if (((String)definedHeader.getValue()).equals(actualHeader.getValue())) continue;
                    return false;
                }
                return true;
            })), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)));
            mockedHttpUtil.when(httpCalledWithHeaders).thenReturn((Object)"{\"data\":null,\"code\":null,\"message\":null,\"success\":true}");
            mockedHttpUtil.when(() -> HttpUtil.applyAdditionalHeadersForSnowsight((HttpRequestBase)((HttpRequestBase)ArgumentMatchers.any()), (Map)((Map)ArgumentMatchers.any()))).thenCallRealMethod();
            SessionUtil.openSession((SFLoginInput)input, connectionPropertiesMap, (String)"ALL");
            mockedHttpUtil.verify(httpCalledWithHeaders, Mockito.times((int)1));
        }
    }

    @Test
    public void testForwardInflightCtx() throws Throwable {
        SFLoginInput input = this.createLoginInput();
        String inflightCtx = UUID.randomUUID().toString();
        input.setInFlightCtx(inflightCtx);
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            MockedStatic.Verification httpCalledWithHeaders = () -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.argThat(arg -> {
                try {
                    HttpEntity entity = ((HttpPost)arg).getEntity();
                    InputStream is = entity.getContent();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)is, (OutputStream)out);
                    String body = new String(out.toByteArray());
                    return body.contains("inFlightCtx") && body.contains(inflightCtx);
                }
                catch (IOException | UnsupportedOperationException exception) {
                    return false;
                }
            })), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)));
            mockedHttpUtil.when(httpCalledWithHeaders).thenReturn((Object)"{\"data\":null,\"code\":null,\"message\":null,\"success\":true}");
            mockedHttpUtil.when(() -> HttpUtil.applyAdditionalHeadersForSnowsight((HttpRequestBase)((HttpRequestBase)ArgumentMatchers.any()), (Map)((Map)ArgumentMatchers.any()))).thenCallRealMethod();
            SessionUtil.openSession((SFLoginInput)input, connectionPropertiesMap, (String)"ALL");
            mockedHttpUtil.verify(httpCalledWithHeaders, Mockito.times((int)1));
        }
    }

    private SFLoginInput createLoginInput() {
        SFLoginInput input = new SFLoginInput();
        input.setServerUrl("MOCK_TEST_HOST");
        input.setUserName("MOCK_USERNAME");
        input.setPassword("MOCK_PASSWORD");
        input.setAccountName("MOCK_ACCOUNT_NAME");
        input.setAppId("MOCK_APP_ID");
        input.setOCSPMode(OCSPMode.FAIL_OPEN);
        input.setHttpClientSettingsKey(new HttpClientSettingsKey(OCSPMode.FAIL_OPEN));
        input.setLoginTimeout(1000);
        input.setSessionParameters(new HashMap());
        return input;
    }

    @Test
    public void testOktaAuthPostFail() throws Throwable {
        SFLoginInput loginInput = this.createLoginInput();
        loginInput.setAuthenticator("https://testauth.okta.com");
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpPost.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"code\":null,\"message\":\"POST request failed\",\"success\":false}");
            SessionUtil.openSession((SFLoginInput)loginInput, connectionPropertiesMap, (String)"ALL");
            Assertions.fail((String)"Exception should have been thrown");
        }
        catch (SnowflakeSQLException e) {
            Assertions.assertEquals((Object)"POST request failed", (Object)e.getMessage());
            Assertions.assertEquals((Object)"08001", (Object)e.getSQLState());
        }
    }

    @Test
    public void testOktaAuthMalformedUrl() throws Throwable {
        SFLoginInput loginInput = this.createLoginInput();
        loginInput.setAuthenticator("invalid!@url$%^");
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpPost.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"data\":{\"tokenUrl\":\"invalid!@url$%^\",\"ssoUrl\":\"invalid!@url$%^\",\"proofKey\":null},\"code\":null,\"message\":null,\"success\":true}");
            SessionUtil.openSession((SFLoginInput)loginInput, connectionPropertiesMap, (String)"ALL");
            Assertions.fail((String)"Exception should have been thrown");
        }
        catch (SnowflakeSQLException e) {
            Assertions.assertEquals((int)ErrorCode.NETWORK_ERROR.getMessageCode(), (int)e.getErrorCode());
            Assertions.assertEquals((Object)"58030", (Object)e.getSQLState());
        }
    }

    @Test
    public void testOktaAuthURISyntaxError() throws Throwable {
        SFLoginInput loginInput = this.createLoginInput();
        loginInput.setAuthenticator("https://testauth.okta.com/^123");
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpPost.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"data\":{\"tokenUrl\":\"https://testauth.okta.com/^123\",\"ssoUrl\":\"https://testauth.okta.com/^123\",\"proofKey\":null},\"code\":null,\"message\":null,\"success\":true}");
            SessionUtil.openSession((SFLoginInput)loginInput, connectionPropertiesMap, (String)"ALL");
            Assertions.fail((String)"Exception should have been thrown");
        }
        catch (SnowflakeSQLException e) {
            Assertions.assertEquals((int)ErrorCode.CONNECTION_ERROR.getMessageCode(), (int)e.getErrorCode());
            Assertions.assertEquals((Object)"08001", (Object)e.getSQLState());
        }
    }

    @Test
    public void testOktaAuthGetFail() throws Throwable {
        SFLoginInput loginInput = this.createLoginInput();
        loginInput.setAuthenticator("https://testauth.okta.com");
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpPost.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"data\":{\"tokenUrl\":\"https://testauth.okta.com/api/v1/authn\",\"ssoUrl\":\"https://testauth.okta.com/app/snowflake/abcdefghijklmnopqrstuvwxyz/sso/saml\",\"proofKey\":null},\"code\":null,\"message\":null,\"success\":true}");
            mockedHttpUtil.when(() -> HttpUtil.executeRequestWithoutCookies((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpRequestBase.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (AtomicBoolean)((AtomicBoolean)Mockito.nullable(AtomicBoolean.class)), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"expiresAt\":\"2023-10-13T19:18:09.000Z\",\"status\":\"SUCCESS\",\"sessionToken\":\"testsessiontoken\"}");
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpGet.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenThrow(new Throwable[]{new IOException()});
            SessionUtil.openSession((SFLoginInput)loginInput, connectionPropertiesMap, (String)"ALL");
            Assertions.fail((String)"Exception should have been thrown");
        }
        catch (SnowflakeSQLException e) {
            Assertions.assertEquals((int)ErrorCode.NETWORK_ERROR.getMessageCode(), (int)e.getErrorCode());
            Assertions.assertEquals((Object)"58030", (Object)e.getSQLState());
        }
    }

    private SFLoginInput createOktaLoginInput() {
        SFLoginInput input = new SFLoginInput();
        input.setServerUrl("https://testauth.okta.com");
        input.setUserName("MOCK_USERNAME");
        input.setPassword("MOCK_PASSWORD");
        input.setAccountName("MOCK_ACCOUNT_NAME");
        input.setAppId("MOCK_APP_ID");
        input.setOCSPMode(OCSPMode.FAIL_OPEN);
        input.setHttpClientSettingsKey(new HttpClientSettingsKey(OCSPMode.FAIL_OPEN));
        input.setLoginTimeout(1000);
        input.setSessionParameters(new HashMap());
        input.setAuthenticator("https://testauth.okta.com");
        return input;
    }

    @Test
    public void testOktaAuthRetry() throws Throwable {
        SFLoginInput loginInput = this.createOktaLoginInput();
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        SnowflakeSQLException ex = new SnowflakeSQLException(ErrorCode.AUTHENTICATOR_REQUEST_TIMEOUT, 0, true, 0L);
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpPost.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"data\":{\"tokenUrl\":\"https://testauth.okta.com/api/v1/authn\",\"ssoUrl\":\"https://testauth.okta.com/app/snowflake/abcdefghijklmnopqrstuvwxyz/sso/saml\",\"proofKey\":null},\"code\":null,\"message\":null,\"success\":true}").thenThrow(new Throwable[]{ex}).thenReturn((Object)"{\"data\":{\"tokenUrl\":\"https://testauth.okta.com/api/v1/authn\",\"ssoUrl\":\"https://testauth.okta.com/app/snowflake/abcdefghijklmnopqrstuvwxyz/sso/saml\",\"proofKey\":null},\"code\":null,\"message\":null,\"success\":true}");
            mockedHttpUtil.when(() -> HttpUtil.executeRequestWithoutCookies((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpRequestBase.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (AtomicBoolean)((AtomicBoolean)Mockito.nullable(AtomicBoolean.class)), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"expiresAt\":\"2023-10-13T19:18:09.000Z\",\"status\":\"SUCCESS\",\"sessionToken\":\"testsessiontoken\"}");
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpGet.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"<body><form action=\"https://testauth.okta.com\"></form></body>");
            SessionUtil.openSession((SFLoginInput)loginInput, connectionPropertiesMap, (String)"ALL");
        }
    }

    @Test
    public void testOktaDisableSamlUrlCheck() throws Throwable {
        SFLoginInput loginInput = this.createOktaLoginInput();
        loginInput.setDisableSamlURLCheck(true);
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpPost.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"data\":{\"tokenUrl\":\"https://testauth.okta.com/api/v1/authn\",\"ssoUrl\":\"https://testauth.okta.com/app/snowflake/abcdefghijklmnopqrstuvwxyz/sso/saml\",\"proofKey\":null},\"code\":null,\"message\":null,\"success\":true}");
            mockedHttpUtil.when(() -> HttpUtil.executeRequestWithoutCookies((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpRequestBase.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (AtomicBoolean)((AtomicBoolean)Mockito.nullable(AtomicBoolean.class)), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"expiresAt\":\"2023-10-13T19:18:09.000Z\",\"status\":\"SUCCESS\",\"sessionToken\":\"testsessiontoken\"}");
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpGet.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"<body><form action=\"invalidformError\"></form></body>");
            SessionUtil.openSession((SFLoginInput)loginInput, connectionPropertiesMap, (String)"ALL");
        }
    }

    @Test
    public void testInvalidOktaSamlFormat() throws Throwable {
        SFLoginInput loginInput = this.createOktaLoginInput();
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpPost.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"data\":{\"tokenUrl\":\"https://testauth.okta.com/api/v1/authn\",\"ssoUrl\":\"https://testauth.okta.com/app/snowflake/abcdefghijklmnopqrstuvwxyz/sso/saml\",\"proofKey\":null},\"code\":null,\"message\":null,\"success\":true}");
            mockedHttpUtil.when(() -> HttpUtil.executeRequestWithoutCookies((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpRequestBase.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (AtomicBoolean)((AtomicBoolean)Mockito.nullable(AtomicBoolean.class)), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"expiresAt\":\"2023-10-13T19:18:09.000Z\",\"status\":\"SUCCESS\",\"sessionToken\":\"testsessiontoken\"}");
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpGet.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"<body><form action=\"invalidformError\"></form></body>");
            SessionUtil.openSession((SFLoginInput)loginInput, connectionPropertiesMap, (String)"ALL");
            Assertions.fail((String)"Should be failed because of the invalid form");
        }
        catch (SnowflakeSQLException ex) {
            Assertions.assertEquals((int)ErrorCode.NETWORK_ERROR.getMessageCode(), (int)ex.getErrorCode());
        }
    }

    @Test
    public void testOktaWithInvalidHostName() throws Throwable {
        SFLoginInput loginInput = this.createOktaLoginInput();
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpPost.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"data\":{\"tokenUrl\":\"https://testauth.okta.com/api/v1/authn\",\"ssoUrl\":\"https://testauth.okta.com/app/snowflake/abcdefghijklmnopqrstuvwxyz/sso/saml\",\"proofKey\":null},\"code\":null,\"message\":null,\"success\":true}");
            mockedHttpUtil.when(() -> HttpUtil.executeRequestWithoutCookies((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpRequestBase.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (AtomicBoolean)((AtomicBoolean)Mockito.nullable(AtomicBoolean.class)), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"expiresAt\":\"2023-10-13T19:18:09.000Z\",\"status\":\"SUCCESS\",\"sessionToken\":\"testsessiontoken\"}");
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpGet.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"<body><form action=\"https://helloworld.okta.com\"></form></body>");
            SessionUtil.openSession((SFLoginInput)loginInput, connectionPropertiesMap, (String)"ALL");
            Assertions.fail((String)"Should be failed because of the invalid form");
        }
        catch (SnowflakeSQLException ex) {
            Assertions.assertEquals((int)ErrorCode.IDP_INCORRECT_DESTINATION.getMessageCode(), (int)ex.getErrorCode());
        }
    }
}

