/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.fasterxml.jackson.databind.node.BooleanNode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFTrustManager;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.SystemUtil;
import net.snowflake.client.jdbc.MockConnectionTest;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SessionUtilTest {
    private static String originalUrlValue;
    private static String originalRetryUrlPattern;

    @BeforeAll
    public static void saveStaticValues() {
        originalUrlValue = SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE;
        originalRetryUrlPattern = SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN;
    }

    @AfterAll
    public static void restoreStaticValues() {
        SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE = originalUrlValue;
        SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN = originalRetryUrlPattern;
    }

    @Test
    public void testIsPrefixEqual() throws Exception {
        MatcherAssert.assertThat((String)"no port number", (boolean)SessionUtil.isPrefixEqual((String)"https://testaccount.snowflakecomputing.com/blah", (String)"https://testaccount.snowflakecomputing.com/"));
        MatcherAssert.assertThat((String)"no port number with a slash", (boolean)SessionUtil.isPrefixEqual((String)"https://testaccount.snowflakecomputing.com/blah", (String)"https://testaccount.snowflakecomputing.com"));
        MatcherAssert.assertThat((String)"including a port number on one of them", (boolean)SessionUtil.isPrefixEqual((String)"https://testaccount.snowflakecomputing.com/blah", (String)"https://testaccount.snowflakecomputing.com:443/"));
        MatcherAssert.assertThat((String)"different hostnames", (!SessionUtil.isPrefixEqual((String)"https://testaccount1.snowflakecomputing.com/blah", (String)"https://testaccount2.snowflakecomputing.com/") ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"different port numbers", (!SessionUtil.isPrefixEqual((String)"https://testaccount.snowflakecomputing.com:123/blah", (String)"https://testaccount.snowflakecomputing.com:443/") ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"different protocols", (!SessionUtil.isPrefixEqual((String)"http://testaccount.snowflakecomputing.com/blah", (String)"https://testaccount.snowflakecomputing.com/") ? 1 : 0) != 0);
    }

    @Test
    public void testParameterParsing() {
        HashMap<String, BooleanNode> parameterMap = new HashMap<String, BooleanNode>();
        parameterMap.put("other_parameter", BooleanNode.getTrue());
        SFBaseSession session = new MockConnectionTest.MockSnowflakeConnectionImpl().getSFSession();
        SessionUtil.updateSfDriverParamValues(parameterMap, (SFBaseSession)session);
        Assertions.assertTrue((boolean)((BooleanNode)session.getOtherParameter("other_parameter")).asBoolean());
    }

    @Test
    public void testConvertSystemPropertyToIntValue() {
        System.setProperty("net.snowflake.jdbc.max_connections", "500");
        Assertions.assertEquals((int)500, (int)SystemUtil.convertSystemPropertyToIntValue((String)"net.snowflake.jdbc.max_connections", (int)300));
        System.setProperty("net.snowflake.jdbc.max_connections", "notAnInteger");
        Assertions.assertEquals((int)300, (int)SystemUtil.convertSystemPropertyToIntValue((String)"net.snowflake.jdbc.max_connections", (int)300));
        System.setProperty("net.snowflake.jdbc.max_connections_per_route", "30");
        Assertions.assertEquals((int)30, (int)SystemUtil.convertSystemPropertyToIntValue((String)"net.snowflake.jdbc.max_connections_per_route", (int)300));
    }

    @Test
    public void testIsLoginRequest() {
        ArrayList<String> testCases = new ArrayList<String>();
        testCases.add("/session/v1/login-request");
        testCases.add("/session/token-request");
        testCases.add("/session/authenticator-request");
        for (String testCase : testCases) {
            try {
                URIBuilder uriBuilder = new URIBuilder("https://test.snowflakecomputing.com");
                uriBuilder.setPath(testCase);
                URI uri = uriBuilder.build();
                HttpPost postRequest = new HttpPost(uri);
                Assertions.assertTrue((boolean)SessionUtil.isNewRetryStrategyRequest((HttpRequestBase)postRequest));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void testIsLoginRequestInvalidURIPath() {
        ArrayList<String> testCases = new ArrayList<String>();
        testCases.add("/session/not-a-real-path");
        for (String testCase : testCases) {
            try {
                URIBuilder uriBuilder = new URIBuilder("https://test.snowflakecomputing.com");
                uriBuilder.setPath(testCase);
                URI uri = uriBuilder.build();
                HttpPost postRequest = new HttpPost(uri);
                Assertions.assertFalse((boolean)SessionUtil.isNewRetryStrategyRequest((HttpRequestBase)postRequest));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void shouldDerivePrivateLinkOcspCacheServerUrlBasedOnHost() throws IOException {
        this.resetOcspConfiguration();
        SessionUtil.resetOCSPUrlIfNecessary((String)"https://test.privatelink.snowflakecomputing.com");
        Assertions.assertEquals((Object)"http://ocsp.test.privatelink.snowflakecomputing.com/ocsp_response_cache.json", (Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE);
        Assertions.assertEquals((Object)"http://ocsp.test.privatelink.snowflakecomputing.com/retry/%s/%s", (Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN);
        this.resetOcspConfiguration();
        SessionUtil.resetOCSPUrlIfNecessary((String)"https://test.privatelink.snowflakecomputing.cn");
        Assertions.assertEquals((Object)"http://ocsp.test.privatelink.snowflakecomputing.cn/ocsp_response_cache.json", (Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE);
        Assertions.assertEquals((Object)"http://ocsp.test.privatelink.snowflakecomputing.cn/retry/%s/%s", (Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN);
        this.resetOcspConfiguration();
        SessionUtil.resetOCSPUrlIfNecessary((String)"https://test.privatelink.snowflakecomputing.xyz");
        Assertions.assertEquals((Object)"http://ocsp.test.privatelink.snowflakecomputing.xyz/ocsp_response_cache.json", (Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE);
        Assertions.assertEquals((Object)"http://ocsp.test.privatelink.snowflakecomputing.xyz/retry/%s/%s", (Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN);
    }

    private void resetOcspConfiguration() {
        SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE = null;
        SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN = null;
    }
}

