/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SfTimestampUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Disabled
public class SqlInputTimestampUtilTest {
    private static final String TIMESTAMP_IN_FORMAT_1 = "2021-12-22 09:43:44.000 +0100";
    private static final String TIMESTAMP_IN_FORMAT_2 = "Wed, 22 Dec 2021 09:43:44 +0100";
    private static final Map<String, Object> CONNECTION_PARAMS = new HashMap<String, Object>();
    private static final Timestamp EXPECTED_TIMESTAMP = Timestamp.valueOf(LocalDateTime.of(2021, 12, 22, 9, 43, 44));
    private static SFBaseSession mockSession;

    @BeforeAll
    public static void setup() {
        CONNECTION_PARAMS.put("TIMESTAMP_OUTPUT_FORMAT", "YYYY-MM-DD HH24:MI:SS.FF3 TZHTZM");
        CONNECTION_PARAMS.put("TIMESTAMP_TZ_OUTPUT_FORMAT", "DY, DD MON YYYY HH24:MI:SS TZHTZM");
        mockSession = (SFBaseSession)Mockito.mock(SFBaseSession.class);
        Mockito.when((Object)mockSession.getCommonParameters()).thenReturn(CONNECTION_PARAMS);
    }

    @Test
    public void shouldGetTimestampForDifferentType() {
        Timestamp resultLtz = this.getFromType(50000, TIMESTAMP_IN_FORMAT_1, null);
        Timestamp resultTz = this.getFromType(50001, TIMESTAMP_IN_FORMAT_2, null);
        Timestamp resultNtz = this.getFromType(50002, TIMESTAMP_IN_FORMAT_1, null);
        Assertions.assertEquals((Object)EXPECTED_TIMESTAMP, (Object)resultLtz);
        Assertions.assertEquals((Object)EXPECTED_TIMESTAMP, (Object)resultTz);
        Assertions.assertEquals((Object)EXPECTED_TIMESTAMP, (Object)resultNtz);
    }

    private Timestamp getFromType(int type, String value, TimeZone explicitTimezone) {
        return SfTimestampUtil.getTimestampFromType((int)type, (String)value, (SFBaseSession)mockSession, (TimeZone)TimeZone.getTimeZone("GMT"), (TimeZone)explicitTimezone);
    }
}

