/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import net.snowflake.client.core.URLUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class URLUtilTest {
    @Test
    public void testValidURL() throws Exception {
        Assertions.assertTrue((boolean)URLUtil.isValidURL((String)"https://ssoTestURL.okta.com"));
        Assertions.assertTrue((boolean)URLUtil.isValidURL((String)"https://ssoTestURL.okta.com:8080"));
        Assertions.assertTrue((boolean)URLUtil.isValidURL((String)"https://ssoTestURL.okta.com/testpathvalue"));
    }

    @Test
    public void testInvalidURL() throws Exception {
        Assertions.assertFalse((boolean)URLUtil.isValidURL((String)"-a Calculator"));
        Assertions.assertFalse((boolean)URLUtil.isValidURL((String)"This is random text"));
        Assertions.assertFalse((boolean)URLUtil.isValidURL((String)"file://TestForFile"));
    }

    @Test
    public void testEncodeURL() throws Exception {
        Assertions.assertEquals((Object)URLUtil.urlEncode((String)"Hello @World"), (Object)"Hello+%40World");
        Assertions.assertEquals((Object)URLUtil.urlEncode((String)"Test//String"), (Object)"Test%2F%2FString");
    }
}

