/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Random;
import java.util.TimeZone;
import java.util.stream.Stream;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.arrow.ArrowResultUtil;
import net.snowflake.client.providers.TimezoneProvider;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class ArrowResultUtilTest {
    @AfterAll
    public static void clearTimeZone() {
        System.clearProperty("user.timezone");
    }

    public static void setTimeZone(String string) {
        System.setProperty("user.timezone", string);
    }

    @ParameterizedTest(name="Timezone = {0}")
    @ArgumentsSource(value=TimezoneProvider.class)
    @Disabled
    public void testGetDatePerformance(String timezone) throws SFException {
        int i;
        ArrowResultUtilTest.setTimeZone(timezone);
        Random random = new Random();
        int dateBound = 50000;
        int times = 100000;
        SFSession session = new SFSession();
        long start = System.currentTimeMillis();
        TimeZone tz = TimeZone.getDefault();
        int[] days = new int[times];
        for (i = 0; i < times; ++i) {
            days[i] = random.nextInt(dateBound) - dateBound / 2;
        }
        for (i = 0; i < times; ++i) {
            ResultUtil.getDate((String)Integer.toString(days[i]), (TimeZone)tz, (SFBaseSession)session);
        }
        long duration1 = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        for (int i2 = 0; i2 < times; ++i2) {
            ArrowResultUtil.getDate((int)days[i2], (TimeZone)tz, (TimeZone)tz);
        }
        long duration2 = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        for (int i3 = 0; i3 < times; ++i3) {
            ArrowResultUtil.getDate((int)days[i3]);
        }
        long duration3 = System.currentTimeMillis() - start;
        System.out.println(duration1 + " " + duration2 + " " + duration3);
    }

    @ParameterizedTest
    @ArgumentsSource(value=testCasesProvider.class)
    public void testToJavaTimestamp(String timezone, long cas, long millisecs, int nanos) {
        ArrowResultUtilTest.setTimeZone(timezone);
        int scale = 9;
        Timestamp ts = ArrowResultUtil.toJavaTimestamp((long)cas, (int)scale);
        Assertions.assertEquals((long)millisecs, (long)ts.getTime());
        Assertions.assertEquals((int)nanos, (int)ts.getNanos());
    }

    private static class testCasesProvider
    implements ArgumentsProvider {
        private testCasesProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            ArrayList<String> timezones = new ArrayList<String>(){
                {
                    this.add("UTC");
                    this.add("America/Los_Angeles");
                    this.add("America/New_York");
                    this.add("Asia/Singapore");
                    this.add("MEZ");
                }
            };
            long[] cases = new long[]{-1123456789L, -123456789L, 123456789L, 123123456789L, -123123456789L};
            long[] millisecs = new long[]{-1124L, -124L, 123L, 123123L, -123124L};
            int[] nanos = new int[]{876543211, 876543211, 123456789, 123456789, 876543211};
            ArrayList<Arguments> args = new ArrayList<Arguments>();
            for (String timezone : timezones) {
                for (int i = 0; i < cases.length; ++i) {
                    args.add(Arguments.of((Object[])new Object[]{timezone, cases[i], millisecs[i], nanos[i]}));
                }
            }
            return args.stream();
        }
    }
}

