/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.BitToBooleanConverter;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BitToBooleanConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();

    @Test
    public void testConvertToString() throws SFException {
        int rowCount = 1000;
        ArrayList<Boolean> expectedValues = new ArrayList<Boolean>();
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        for (int i = 0; i < 1000; ++i) {
            expectedValues.add(this.random.nextBoolean());
        }
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "BOOLEAN");
        FieldType fieldType = new FieldType(true, Types.MinorType.BIT.getType(), null, customFieldMeta);
        BitVector vector = new BitVector("col_one", fieldType, this.allocator);
        for (int i = 0; i < 1000; ++i) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(i);
                nullValIndex.add(i);
                continue;
            }
            vector.setSafe(i, (Boolean)expectedValues.get(i) != false ? 1 : 0);
        }
        BitToBooleanConverter converter = new BitToBooleanConverter((ValueVector)vector, 0, (DataConversionContext)this);
        for (int i = 0; i < 1000; ++i) {
            boolean boolVal = converter.toBoolean(i);
            Object objectVal = converter.toObject(i);
            String stringVal = converter.toString(i);
            if (stringVal != null) {
                Assertions.assertFalse((boolean)converter.isNull(i));
            } else {
                Assertions.assertTrue((boolean)converter.isNull(i));
            }
            if (nullValIndex.contains(i)) {
                MatcherAssert.assertThat((Object)boolVal, (Matcher)CoreMatchers.is((Object)false));
                MatcherAssert.assertThat((Object)objectVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)stringVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)converter.toBytes(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            MatcherAssert.assertThat((Object)boolVal, (Matcher)CoreMatchers.is((Object)((Boolean)expectedValues.get(i))));
            MatcherAssert.assertThat((Object)objectVal, (Matcher)CoreMatchers.is(expectedValues.get(i)));
            MatcherAssert.assertThat((Object)stringVal, (Matcher)CoreMatchers.is((Object)((Boolean)expectedValues.get(i)).toString().toUpperCase()));
            if (boolVal) {
                MatcherAssert.assertThat((Object)1, (Matcher)CoreMatchers.is((Object)converter.toBytes(i)[0]));
                continue;
            }
            MatcherAssert.assertThat((Object)0, (Matcher)CoreMatchers.is((Object)converter.toBytes(i)[0]));
        }
        vector.clear();
    }
}

