/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.TimeZone;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.TinyIntToFixedConverter;
import net.snowflake.client.core.arrow.TinyIntToScaledFixedConverter;
import net.snowflake.client.jdbc.ErrorCode;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TinyIntToFixedConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();

    @Test
    public void testFixedNoScale() throws SFException {
        int rowCount = 1000;
        ArrayList<Byte> expectedValues = new ArrayList<Byte>();
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        for (int i = 0; i < 1000; ++i) {
            expectedValues.add((byte)this.random.nextInt(256));
        }
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "0");
        FieldType fieldType = new FieldType(true, Types.MinorType.TINYINT.getType(), null, customFieldMeta);
        TinyIntVector vector = new TinyIntVector("col_one", fieldType, this.allocator);
        for (int i = 0; i < 1000; ++i) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(i);
                nullValIndex.add(i);
                continue;
            }
            vector.setSafe(i, ((Byte)expectedValues.get(i)).byteValue());
        }
        TinyIntToFixedConverter converter = new TinyIntToFixedConverter((ValueVector)vector, 0, (DataConversionContext)this);
        for (int i = 0; i < 1000; ++i) {
            byte byteVal = converter.toByte(i);
            Object longObject = converter.toObject(i);
            String byteString = converter.toString(i);
            if (nullValIndex.contains(i)) {
                MatcherAssert.assertThat((Object)byteVal, (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)longObject, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)byteString, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            MatcherAssert.assertThat((Object)byteVal, (Matcher)CoreMatchers.is((Object)((Byte)expectedValues.get(i))));
            Assertions.assertEquals((Object)longObject, (Object)((Byte)expectedValues.get(i)));
            MatcherAssert.assertThat((Object)byteString, (Matcher)CoreMatchers.is((Object)((Byte)expectedValues.get(i)).toString()));
        }
        vector.clear();
    }

    @Test
    public void testFixedWithScale() throws SFException {
        int rowCount = 1000;
        ArrayList<Byte> expectedValues = new ArrayList<Byte>();
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        for (int i = 0; i < 1000; ++i) {
            expectedValues.add((byte)this.random.nextInt(256));
        }
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "1");
        FieldType fieldType = new FieldType(true, Types.MinorType.TINYINT.getType(), null, customFieldMeta);
        TinyIntVector vector = new TinyIntVector("col_one", fieldType, this.allocator);
        for (int i = 0; i < 1000; ++i) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(i);
                nullValIndex.add(i);
                continue;
            }
            vector.setSafe(i, ((Byte)expectedValues.get(i)).byteValue());
        }
        TinyIntToScaledFixedConverter converter = new TinyIntToScaledFixedConverter((ValueVector)vector, 0, (DataConversionContext)this, 1);
        for (int i = 0; i < 1000; ++i) {
            BigDecimal bigDecimalVal = converter.toBigDecimal(i);
            Object objectVal = converter.toObject(i);
            String stringVal = converter.toString(i);
            if (nullValIndex.contains(i)) {
                MatcherAssert.assertThat((Object)bigDecimalVal, (Matcher)CoreMatchers.nullValue());
                MatcherAssert.assertThat((Object)objectVal, (Matcher)CoreMatchers.nullValue());
                MatcherAssert.assertThat((Object)stringVal, (Matcher)CoreMatchers.nullValue());
                continue;
            }
            BigDecimal expectedVal = BigDecimal.valueOf(((Byte)expectedValues.get(i)).byteValue(), 1);
            MatcherAssert.assertThat((Object)bigDecimalVal, (Matcher)CoreMatchers.is((Object)expectedVal));
            MatcherAssert.assertThat((Object)objectVal, (Matcher)CoreMatchers.is((Object)expectedVal));
            MatcherAssert.assertThat((Object)stringVal, (Matcher)CoreMatchers.is((Object)expectedVal.toString()));
        }
        vector.clear();
    }

    @Test
    public void testInvalidConversion() {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "1");
        FieldType fieldType = new FieldType(true, Types.MinorType.TINYINT.getType(), null, customFieldMeta);
        TinyIntVector vector = new TinyIntVector("col_one", fieldType, this.allocator);
        vector.setSafe(0, 200);
        TinyIntToScaledFixedConverter converter = new TinyIntToScaledFixedConverter((ValueVector)vector, 0, (DataConversionContext)this, 1);
        int invalidConversionErrorCode = ErrorCode.INVALID_VALUE_CONVERT.getMessageCode();
        TestUtil.assertSFException(invalidConversionErrorCode, () -> TinyIntToFixedConverterTest.lambda$testInvalidConversion$0((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> TinyIntToFixedConverterTest.lambda$testInvalidConversion$1((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> TinyIntToFixedConverterTest.lambda$testInvalidConversion$2((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> TinyIntToFixedConverterTest.lambda$testInvalidConversion$3((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> this.lambda$testInvalidConversion$4((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> TinyIntToFixedConverterTest.lambda$testInvalidConversion$5((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> TinyIntToFixedConverterTest.lambda$testInvalidConversion$6((ArrowVectorConverter)converter));
        vector.clear();
    }

    @Test
    public void testGetSmallerIntegralType() throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "0");
        FieldType fieldType = new FieldType(true, Types.MinorType.TINYINT.getType(), null, customFieldMeta);
        TinyIntVector vectorBar = new TinyIntVector("col_one", fieldType, this.allocator);
        vectorBar.setSafe(0, 10);
        vectorBar.setSafe(1, -10);
        TinyIntToFixedConverter converterBar = new TinyIntToFixedConverter((ValueVector)vectorBar, 0, (DataConversionContext)this);
        MatcherAssert.assertThat((Object)converterBar.toShort(0), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)converterBar.toShort(1), (Matcher)CoreMatchers.is((Object)-10));
        MatcherAssert.assertThat((Object)converterBar.toInt(0), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)converterBar.toInt(1), (Matcher)CoreMatchers.is((Object)-10));
        MatcherAssert.assertThat((Object)converterBar.toLong(0), (Matcher)CoreMatchers.is((Object)10L));
        MatcherAssert.assertThat((Object)converterBar.toLong(1), (Matcher)CoreMatchers.is((Object)-10L));
        vectorBar.clear();
    }

    @Test
    public void testGetBooleanNoScale() throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "0");
        FieldType fieldType = new FieldType(true, Types.MinorType.TINYINT.getType(), null, customFieldMeta);
        TinyIntVector vector = new TinyIntVector("col_one", fieldType, this.allocator);
        vector.setSafe(0, 0);
        vector.setSafe(1, 1);
        vector.setNull(2);
        vector.setSafe(3, 5);
        TinyIntToFixedConverter converter = new TinyIntToFixedConverter((ValueVector)vector, 0, (DataConversionContext)this);
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(0)));
        MatcherAssert.assertThat((Object)true, (Matcher)CoreMatchers.is((Object)converter.toBoolean(1)));
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(2)));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> TinyIntToFixedConverterTest.lambda$testGetBooleanNoScale$7((ArrowVectorConverter)converter));
        vector.close();
    }

    @Test
    public void testGetBooleanWithScale() throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "3");
        FieldType fieldType = new FieldType(true, Types.MinorType.TINYINT.getType(), null, customFieldMeta);
        TinyIntVector vector = new TinyIntVector("col_one", fieldType, this.allocator);
        vector.setSafe(0, 0);
        vector.setSafe(1, 1);
        vector.setNull(2);
        vector.setSafe(3, 5);
        TinyIntToScaledFixedConverter converter = new TinyIntToScaledFixedConverter((ValueVector)vector, 0, (DataConversionContext)this, 3);
        Assertions.assertFalse((boolean)converter.toBoolean(0));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> TinyIntToFixedConverterTest.lambda$testGetBooleanWithScale$8((ArrowVectorConverter)converter));
        Assertions.assertFalse((boolean)converter.toBoolean(2));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> TinyIntToFixedConverterTest.lambda$testGetBooleanWithScale$9((ArrowVectorConverter)converter));
        Assertions.assertFalse((boolean)converter.isNull(0));
        Assertions.assertFalse((boolean)converter.isNull(1));
        Assertions.assertTrue((boolean)converter.isNull(2));
        Assertions.assertFalse((boolean)converter.isNull(3));
        vector.close();
    }

    private static /* synthetic */ void lambda$testGetBooleanWithScale$9(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(3);
    }

    private static /* synthetic */ void lambda$testGetBooleanWithScale$8(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(3);
    }

    private static /* synthetic */ void lambda$testGetBooleanNoScale$7(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(3);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$6(ArrowVectorConverter converter) throws SFException {
        converter.toTimestamp(0, TimeZone.getDefault());
    }

    private static /* synthetic */ void lambda$testInvalidConversion$5(ArrowVectorConverter converter) throws SFException {
        converter.toTime(0);
    }

    private /* synthetic */ void lambda$testInvalidConversion$4(ArrowVectorConverter converter) throws SFException {
        converter.toDate(0, this.getTimeZone(), false);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$3(ArrowVectorConverter converter) throws SFException {
        converter.toShort(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$2(ArrowVectorConverter converter) throws SFException {
        converter.toInt(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$1(ArrowVectorConverter converter) throws SFException {
        converter.toLong(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$0(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(0);
    }
}

