/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.json;

import net.snowflake.client.core.SFException;
import net.snowflake.client.core.json.BooleanConverter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BooleanConverterTest {
    private final BooleanConverter booleanConverter = new BooleanConverter();

    @Test
    public void testConvertBoolean() throws SFException {
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)true, 16), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)false, 16), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testConvertNumeric() throws SFException {
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)1, 4), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)1, 5), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)1, -6), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)1, -5), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)1, -7), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)1, 3), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)0, 4), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)0, 5), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)0, -6), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)0, -5), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)0, -7), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)0, 3), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testConvertString() throws SFException {
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)"1", 12), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)"1", 1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)"true", 12), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)"TRUE", 1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)"0", 12), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)"0", 1), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)"false", 12), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.booleanConverter.getBoolean((Object)"FALSE", 1), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testConvertOtherType() {
        Assertions.assertThrows(SFException.class, () -> this.booleanConverter.getBoolean((Object)"1", -2));
    }
}

