/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.json;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.json.BytesConverter;
import net.snowflake.client.core.json.Converters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BytesConverterTest {
    private final Converters converters = new Converters(null, (SFBaseSession)new SFSession(), 0L, false, false, false, false, null, null, null, null, null, null);
    private final BytesConverter bytesConverter = new BytesConverter(this.converters);

    @Test
    public void testConvertFloatingPointToBytes() throws SFException {
        byte[] expected = ByteBuffer.allocate(8).putDouble(0, 12.5).array();
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.bytesConverter.getBytes((Object)Float.valueOf(12.5f), 6, 6, Integer.valueOf(0)));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.bytesConverter.getBytes((Object)Float.valueOf(12.5f), 8, 8, Integer.valueOf(0)));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.bytesConverter.getBytes((Object)12.5, 6, 8, Integer.valueOf(0)));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.bytesConverter.getBytes((Object)12.5, 8, 8, Integer.valueOf(0)));
    }

    @Test
    public void testConvertIntegerNumberToBytes() throws SFException {
        byte[] expected = new BigInteger("12").toByteArray();
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.bytesConverter.getBytes((Object)12, 2, 2, Integer.valueOf(0)));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.bytesConverter.getBytes((Object)12, 4, 4, Integer.valueOf(0)));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.bytesConverter.getBytes((Object)12, 5, 5, Integer.valueOf(0)));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.bytesConverter.getBytes((Object)12, -6, -6, Integer.valueOf(0)));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.bytesConverter.getBytes((Object)12, -5, -5, Integer.valueOf(0)));
    }

    @Test
    public void testString() throws SFException {
        Assertions.assertArrayEquals((byte[])"abc".getBytes(), (byte[])this.bytesConverter.getBytes((Object)"abc", 12, 12, Integer.valueOf(0)));
    }

    @Test
    public void testConvertBooleanToBytes() throws SFException {
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])this.bytesConverter.getBytes((Object)true, 16, 16, Integer.valueOf(0)));
        Assertions.assertArrayEquals((byte[])new byte[]{0}, (byte[])this.bytesConverter.getBytes((Object)false, 16, 16, Integer.valueOf(0)));
    }
}

