/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.json;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.TimeZone;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.json.DateTimeConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DateTimeConverterTest {
    private final TimeZone honoluluTimeZone = TimeZone.getTimeZone(ZoneId.of("Pacific/Honolulu"));
    private final TimeZone nuukTimeZone = TimeZone.getTimeZone(ZoneId.of("America/Nuuk"));
    private final DateTimeConverter dateTimeConverter = new DateTimeConverter(this.honoluluTimeZone, (SFBaseSession)new SFSession(), 1L, true, false, false, false);
    private final DateTimeConverter dateTimeConverterWithUseSessionTimeZone = new DateTimeConverter(this.honoluluTimeZone, (SFBaseSession)new SFSession(), 1L, true, false, true, false);
    private final DateTimeConverter dateTimeConverterWithTreatNTZAsUTC = new DateTimeConverter(this.honoluluTimeZone, (SFBaseSession)new SFSession(), 1L, true, true, false, false);

    @Test
    public void testGetVariousTypesWhenNullObjectGiven() throws SFException {
        Assertions.assertNull((Object)this.dateTimeConverter.getTimestamp(null, 93, 93, null, 0));
        Assertions.assertNull((Object)this.dateTimeConverter.getTime(null, 93, 93, null, 0));
        Assertions.assertNull((Object)this.dateTimeConverter.getDate(null, 93, 93, null, 0));
    }

    @Test
    public void testGetTimestampWithDefaultTimeZone() throws SFException {
        Assertions.assertEquals((Object)Timestamp.valueOf(LocalDateTime.of(2023, 8, 9, 8, 2, 3)), (Object)this.dateTimeConverter.getTimestamp((Object)"1691568123", 93, 93, null, 0));
        Assertions.assertEquals((Object)Timestamp.valueOf(LocalDateTime.of(2023, 8, 9, 8, 2, 3, 456789000)), (Object)this.dateTimeConverter.getTimestamp((Object)"1691568123.456789", 93, 93, null, 0));
        Assertions.assertEquals((Object)Timestamp.valueOf(LocalDateTime.of(2023, 8, 9, 8, 2, 3, 456789123)), (Object)this.dateTimeConverter.getTimestamp((Object)"1691568123.456789123", 93, 93, null, 0));
    }

    @Test
    public void testGetTimestampWithSpecificTimeZone() throws SFException {
        Assertions.assertEquals((Object)Timestamp.valueOf(LocalDateTime.of(2023, 8, 9, 8, 2, 3)).toString(), (Object)this.dateTimeConverterWithTreatNTZAsUTC.getTimestamp((Object)"1691568123", 93, 93, this.nuukTimeZone, 0).toString());
        Assertions.assertEquals((Object)Timestamp.valueOf(LocalDateTime.of(2023, 8, 9, 8, 2, 3, 456789000)).toString(), (Object)this.dateTimeConverterWithTreatNTZAsUTC.getTimestamp((Object)"1691568123.456789", 93, 93, this.nuukTimeZone, 0).toString());
        Assertions.assertEquals((Object)Timestamp.valueOf(LocalDateTime.of(2023, 8, 9, 8, 2, 3, 456789123)).toString(), (Object)this.dateTimeConverterWithTreatNTZAsUTC.getTimestamp((Object)"1691568123.456789123", 93, 93, this.nuukTimeZone, 0).toString());
    }

    @Test
    public void testGetTimeWithDefaultTimeZone() throws SFException {
        Assertions.assertEquals((Object)Time.valueOf(LocalTime.of(8, 2, 3)).toString(), (Object)this.dateTimeConverter.getTime((Object)"1691568123", 93, 93, null, 0).toString());
        Assertions.assertEquals((Object)Time.valueOf(LocalTime.of(8, 2, 3)).toString(), (Object)this.dateTimeConverter.getTime((Object)"1691568123.456789", 93, 93, null, 0).toString());
        Assertions.assertEquals((Object)Time.valueOf(LocalTime.of(8, 2, 3)).toString(), (Object)this.dateTimeConverter.getTime((Object)"1691568123.456789123", 93, 93, null, 0).toString());
    }

    @Test
    public void testGetTimeWithSessionTimeZone() throws SFException {
        Time expected = Time.valueOf(LocalTime.of(22, 2, 3));
        Time actual = this.dateTimeConverterWithUseSessionTimeZone.getTime((Object)"1691568123", 93, 50000, null, 0);
        Assertions.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }

    @Test
    public void testGetDateWithDefaultTimeZone() throws SFException {
        Assertions.assertEquals((Object)Date.valueOf(LocalDate.of(2023, 8, 9)).toString(), (Object)this.dateTimeConverter.getDate((Object)"1691568123", 93, 93, null, 0).toString());
        Assertions.assertEquals((Object)Date.valueOf(LocalDate.of(2023, 8, 9)).toString(), (Object)this.dateTimeConverter.getDate((Object)"1691568123.456789", 93, 93, null, 0).toString());
        Assertions.assertEquals((Object)Date.valueOf(LocalDate.of(2023, 8, 9)).toString(), (Object)this.dateTimeConverter.getDate((Object)"1691568123.456789123", 93, 93, null, 0).toString());
    }

    @Test
    public void testGetDateWithSpecificTimeZone() throws SFException {
        Assertions.assertEquals((Object)Date.valueOf(LocalDate.of(2023, 8, 9)).toString(), (Object)this.dateTimeConverter.getDate((Object)"1691568123", 93, 93, this.nuukTimeZone, 0).toString());
        Assertions.assertEquals((Object)Date.valueOf(LocalDate.of(2023, 8, 9)).toString(), (Object)this.dateTimeConverter.getDate((Object)"1691568123.456789", 93, 93, this.nuukTimeZone, 0).toString());
        Assertions.assertEquals((Object)Date.valueOf(LocalDate.of(2023, 8, 9)).toString(), (Object)this.dateTimeConverter.getDate((Object)"1691568123.456789123", 93, 93, this.nuukTimeZone, 0).toString());
    }

    @Test
    public void testGetDateWithSessionTimeZone() throws SFException {
        Date expected = Date.valueOf(LocalDate.of(2023, 8, 8));
        Date actual = this.dateTimeConverterWithUseSessionTimeZone.getDate((Object)"1691568123", 93, 50000, null, 0);
        Assertions.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }
}

