/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.json;

import java.time.ZoneId;
import java.util.TimeZone;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.json.Converters;
import net.snowflake.client.core.json.StringConverter;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.common.core.SFBinaryFormat;
import net.snowflake.common.core.SnowflakeDateTimeFormat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class StringConverterTest {
    private final TimeZone honoluluTimeZone = TimeZone.getTimeZone(ZoneId.of("America/Nuuk"));
    private final SnowflakeResultSetSerializableV1 resultSetSerializableV1 = (SnowflakeResultSetSerializableV1)Mockito.mock(SnowflakeResultSetSerializableV1.class);
    private Converters converters;
    private StringConverter stringConverter;

    @BeforeEach
    public void init() {
        SnowflakeDateTimeFormat timestampNTZFormatter = SnowflakeDateTimeFormat.fromSqlFormat((String)"YYYY-MM-DD HH24:MI:SS.FF3");
        SnowflakeDateTimeFormat timestampLTZFormatter = SnowflakeDateTimeFormat.fromSqlFormat((String)"YYYY/DD/MM HH24:MI:SS.FF3");
        SnowflakeDateTimeFormat timestampTZFormatter = SnowflakeDateTimeFormat.fromSqlFormat((String)"YYYY MM DD HH24:MI:SS.FF3");
        SnowflakeDateTimeFormat dateFormatter = SnowflakeDateTimeFormat.fromSqlFormat((String)"YYYY-MM-DD");
        SnowflakeDateTimeFormat timeFormatter = SnowflakeDateTimeFormat.fromSqlFormat((String)"HH24:MI:SS.FF3");
        this.converters = new Converters(this.honoluluTimeZone, (SFBaseSession)new SFSession(), 1L, false, false, false, false, SFBinaryFormat.BASE64, dateFormatter, timeFormatter, timestampNTZFormatter, timestampLTZFormatter, timestampTZFormatter);
        this.stringConverter = this.converters.getStringConverter();
    }

    @Test
    public void testConvertingString() throws SFException {
        Assertions.assertEquals((Object)"test", (Object)this.stringConverter.getString((Object)"test", 12, 12, 0));
    }

    @Test
    public void testConvertingBoolean() throws SFException {
        Assertions.assertEquals((Object)"TRUE", (Object)this.stringConverter.getString((Object)true, 16, 16, 0));
        Assertions.assertEquals((Object)"TRUE", (Object)this.stringConverter.getString((Object)"true", 16, 16, 0));
        Assertions.assertEquals((Object)"FALSE", (Object)this.stringConverter.getString((Object)false, 16, 16, 0));
        Assertions.assertEquals((Object)"FALSE", (Object)this.stringConverter.getString((Object)"false", 16, 16, 0));
    }

    @Test
    public void testConvertingNumbers() throws SFException {
        Assertions.assertEquals((Object)"12", (Object)this.stringConverter.getString((Object)12, 4, 4, 0));
        Assertions.assertEquals((Object)"12", (Object)this.stringConverter.getString((Object)12, -6, -6, 0));
        Assertions.assertEquals((Object)"12", (Object)this.stringConverter.getString((Object)12, 5, 5, 0));
        Assertions.assertEquals((Object)"12", (Object)this.stringConverter.getString((Object)12L, -5, -5, 0));
        Assertions.assertEquals((Object)"12.5", (Object)this.stringConverter.getString((Object)12.5, 8, 8, 0));
        Assertions.assertEquals((Object)"12.5", (Object)this.stringConverter.getString((Object)Float.valueOf(12.5f), 6, 6, 0));
    }

    @Test
    public void testConvertingTimestamp() throws SFException {
        Assertions.assertEquals((Object)"1988-03-21 22:33:15.000", (Object)this.stringConverter.getString((Object)"574986795", 93, 93, 0));
        Assertions.assertEquals((Object)"1988-03-21 19:33:15.000", (Object)this.stringConverter.getString((Object)"574986795", 93, 50000, 0));
        Assertions.assertEquals((Object)"1988-03-21 14:33:15.000", (Object)this.stringConverter.getString((Object)"574986795 960", 93, 50001, 0));
    }

    @Test
    public void testConvertingDate() throws SFException {
        Assertions.assertEquals((Object)"2023-12-18", (Object)this.stringConverter.getString((Object)"19709", 91, 91, 0));
    }

    @Test
    public void testConvertingTime() throws SFException {
        Assertions.assertEquals((Object)"00:13:18.000", (Object)this.stringConverter.getString((Object)"798.838000000", 92, 92, 0));
    }

    @Test
    public void testConvertingBinary() throws SFException {
        Assertions.assertEquals((Object)"AQID", (Object)this.stringConverter.getString((Object)"010203", -2, -2, 0));
    }
}

