/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.ErrorCode;
import org.junit.jupiter.api.Assertions;

public class BaseJDBCTest
extends AbstractDriverIT {
    static final String TEST_UUID = UUID.randomUUID().toString();

    protected void expectConnectionAlreadyClosedException(MethodRaisesSQLException f) {
        try {
            f.run();
            Assertions.fail((String)"must raise exception");
        }
        catch (SQLException ex) {
            Assertions.assertEquals((int)ErrorCode.CONNECTION_CLOSED.getMessageCode(), (int)ex.getErrorCode());
        }
    }

    protected void expectStatementAlreadyClosedException(MethodRaisesSQLException f) {
        try {
            f.run();
            Assertions.fail((String)"must raise exception");
        }
        catch (SQLException ex) {
            Assertions.assertEquals((int)ErrorCode.STATEMENT_CLOSED.getMessageCode(), (int)ex.getErrorCode());
        }
    }

    protected void expectResultSetAlreadyClosedException(MethodRaisesSQLException f) {
        try {
            f.run();
            Assertions.fail((String)"must raise exception");
        }
        catch (SQLException ex) {
            Assertions.assertEquals((int)ErrorCode.RESULTSET_ALREADY_CLOSED.getMessageCode(), (int)ex.getErrorCode());
        }
    }

    protected void expectFeatureNotSupportedException(MethodRaisesSQLException f) {
        try {
            f.run();
            Assertions.fail((String)"must raise exception");
        }
        catch (SQLException ex) {
            Assertions.assertTrue((boolean)(ex instanceof SQLFeatureNotSupportedException));
        }
    }

    protected void expectSQLClientInfoException(MethodRaisesSQLClientInfoException f) {
        try {
            f.run();
            Assertions.fail((String)"must raise exception");
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            // empty catch block
        }
    }

    int getSizeOfResultSet(ResultSet rs) throws SQLException {
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        return count;
    }

    List<String> getInfoBySQL(String sqlCmd) throws SQLException {
        Connection con = BaseJDBCTest.getConnection();
        Statement st = con.createStatement();
        ArrayList<String> result = new ArrayList<String>();
        ResultSet rs = st.executeQuery(sqlCmd);
        while (rs.next()) {
            result.add(rs.getString(1));
        }
        return result;
    }

    ZonedDateTime parseTimestampTZ(String dateTimeString) {
        String[] dts = dateTimeString.split("\\s");
        return ZonedDateTime.parse(dts[0] + "T" + dts[1] + dts[2].substring(0, 3) + ":" + dts[2].substring(3));
    }

    LocalDateTime parseTimestampNTZ(String dateTimeString) {
        String[] dts = dateTimeString.split("\\s");
        return LocalDateTime.parse(dts[0] + "T" + dts[1]);
    }

    class FakeCalendar
    extends Calendar {
        FakeCalendar() {
        }

        @Override
        protected void computeTime() {
        }

        @Override
        protected void computeFields() {
        }

        @Override
        public void add(int field, int amount) {
        }

        @Override
        public void roll(int field, boolean up) {
        }

        @Override
        public int getMinimum(int field) {
            return 0;
        }

        @Override
        public int getMaximum(int field) {
            return 0;
        }

        @Override
        public int getGreatestMinimum(int field) {
            return 0;
        }

        @Override
        public int getLeastMaximum(int field) {
            return 0;
        }
    }

    class FakeInputStream
    extends InputStream {
        FakeInputStream() {
        }

        @Override
        public int read() throws IOException {
            return 0;
        }
    }

    class FakeReader
    extends Reader {
        FakeReader() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return 0;
        }

        @Override
        public void close() throws IOException {
        }
    }

    class FakeSQLXML
    implements SQLXML {
        FakeSQLXML() {
        }

        @Override
        public void free() throws SQLException {
        }

        @Override
        public InputStream getBinaryStream() throws SQLException {
            return null;
        }

        @Override
        public OutputStream setBinaryStream() throws SQLException {
            return null;
        }

        @Override
        public Reader getCharacterStream() throws SQLException {
            return null;
        }

        @Override
        public Writer setCharacterStream() throws SQLException {
            return null;
        }

        @Override
        public String getString() throws SQLException {
            return null;
        }

        @Override
        public void setString(String value) throws SQLException {
        }

        @Override
        public <T extends Source> T getSource(Class<T> sourceClass) throws SQLException {
            return null;
        }

        @Override
        public <T extends Result> T setResult(Class<T> resultClass) throws SQLException {
            return null;
        }
    }

    class FakeNClob
    implements NClob {
        FakeNClob() {
        }

        @Override
        public long length() throws SQLException {
            return 0L;
        }

        @Override
        public String getSubString(long pos, int length) throws SQLException {
            return null;
        }

        @Override
        public Reader getCharacterStream() throws SQLException {
            return null;
        }

        @Override
        public InputStream getAsciiStream() throws SQLException {
            return null;
        }

        @Override
        public long position(String searchstr, long start) throws SQLException {
            return 0L;
        }

        @Override
        public long position(Clob searchstr, long start) throws SQLException {
            return 0L;
        }

        @Override
        public int setString(long pos, String str) throws SQLException {
            return 0;
        }

        @Override
        public int setString(long pos, String str, int offset, int len) throws SQLException {
            return 0;
        }

        @Override
        public OutputStream setAsciiStream(long pos) throws SQLException {
            return null;
        }

        @Override
        public Writer setCharacterStream(long pos) throws SQLException {
            return null;
        }

        @Override
        public void truncate(long len) throws SQLException {
        }

        @Override
        public void free() throws SQLException {
        }

        @Override
        public Reader getCharacterStream(long pos, long length) throws SQLException {
            return null;
        }
    }

    class FakeRowId
    implements RowId {
        FakeRowId() {
        }

        @Override
        public byte[] getBytes() {
            return new byte[0];
        }
    }

    class FakeArray
    implements Array {
        FakeArray() {
        }

        @Override
        public String getBaseTypeName() throws SQLException {
            return null;
        }

        @Override
        public int getBaseType() throws SQLException {
            return 0;
        }

        @Override
        public Object getArray() throws SQLException {
            return null;
        }

        @Override
        public Object getArray(Map<String, Class<?>> map) throws SQLException {
            return null;
        }

        @Override
        public Object getArray(long index, int count) throws SQLException {
            return null;
        }

        @Override
        public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
            return null;
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            return null;
        }

        @Override
        public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
            return null;
        }

        @Override
        public ResultSet getResultSet(long index, int count) throws SQLException {
            return null;
        }

        @Override
        public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
            return null;
        }

        @Override
        public void free() throws SQLException {
        }
    }

    class FakeBlob
    implements Blob {
        FakeBlob() {
        }

        @Override
        public long length() throws SQLException {
            return 0L;
        }

        @Override
        public byte[] getBytes(long pos, int length) throws SQLException {
            return new byte[0];
        }

        @Override
        public InputStream getBinaryStream() throws SQLException {
            return null;
        }

        @Override
        public long position(byte[] pattern, long start) throws SQLException {
            return 0L;
        }

        @Override
        public long position(Blob pattern, long start) throws SQLException {
            return 0L;
        }

        @Override
        public int setBytes(long pos, byte[] bytes) throws SQLException {
            return 0;
        }

        @Override
        public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
            return 0;
        }

        @Override
        public OutputStream setBinaryStream(long pos) throws SQLException {
            return null;
        }

        @Override
        public void truncate(long len) throws SQLException {
        }

        @Override
        public void free() throws SQLException {
        }

        @Override
        public InputStream getBinaryStream(long pos, long length) throws SQLException {
            return null;
        }
    }

    class FakeRef
    implements Ref {
        FakeRef() {
        }

        @Override
        public String getBaseTypeName() throws SQLException {
            return null;
        }

        @Override
        public Object getObject(Map<String, Class<?>> map) throws SQLException {
            return null;
        }

        @Override
        public Object getObject() throws SQLException {
            return null;
        }

        @Override
        public void setObject(Object value) throws SQLException {
        }
    }

    protected static interface MethodRaisesSQLClientInfoException {
        public void run() throws SQLClientInfoException;
    }

    protected static interface MethodRaisesSFException {
        public void run() throws SFException;
    }

    protected static interface MethodRaisesSQLException {
        public void run() throws SQLException;
    }
}

