/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.AssumptionUtils;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;

abstract class BaseWiremockTest {
    protected static final SFLogger logger = SFLoggerFactory.getLogger(BaseWiremockTest.class);
    protected static final String WIREMOCK_HOME_DIR = ".wiremock";
    protected static final String WIREMOCK_M2_PATH = "/.m2/repository/org/wiremock/wiremock-standalone/3.8.0/wiremock-standalone-3.8.0.jar";
    protected static final String WIREMOCK_HOST = "localhost";
    protected static final String TRUST_STORE_PROPERTY = "javax.net.ssl.trustStore";
    protected static int wiremockHttpPort;
    protected static int wiremockHttpsPort;
    private static String originalTrustStorePath;
    protected static Process wiremockStandalone;

    BaseWiremockTest() {
    }

    @BeforeAll
    public static void setUpClass() {
        AssumptionUtils.assumeNotRunningOnJava8();
        AssumptionUtils.assumeNotRunningOnJava21();
        AssumptionUtils.assumeNotRunningOnGithubActionsMac();
        originalTrustStorePath = SnowflakeUtil.systemGetProperty((String)TRUST_STORE_PROPERTY);
        BaseWiremockTest.startWiremockStandAlone();
    }

    @AfterEach
    public void tearDown() {
        BaseWiremockTest.restoreTrustStorePathProperty();
        this.resetWiremock();
        HttpUtil.httpClient.clear();
    }

    @AfterAll
    public static void tearDownClass() {
        BaseWiremockTest.stopWiremockStandAlone();
    }

    protected static void startWiremockStandAlone() {
        Awaitility.await().alias("wait for wiremock responding").atMost(Duration.ofSeconds(10L)).until(() -> {
            try {
                wiremockHttpPort = BaseWiremockTest.findFreePort();
                wiremockHttpsPort = BaseWiremockTest.findFreePort();
                wiremockStandalone = new ProcessBuilder("java", "-jar", BaseWiremockTest.getWiremockStandAlonePath(), "--root-dir", System.getProperty("user.dir") + File.separator + WIREMOCK_HOME_DIR + File.separator, "--enable-browser-proxying", "--proxy-pass-through", "false", "--port", String.valueOf(wiremockHttpPort), "--https-port", String.valueOf(wiremockHttpsPort), "--https-keystore", BaseWiremockTest.getResourceURL("wiremock" + File.separator + "ca-cert.jks"), "--ca-keystore", BaseWiremockTest.getResourceURL("wiremock" + File.separator + "ca-cert.jks")).inheritIO().start();
                BaseWiremockTest.waitForWiremock();
                return true;
            }
            catch (Exception e) {
                logger.warn("Failed to start wiremock, retrying: ", (Throwable)e);
                return false;
            }
        });
    }

    protected void resetWiremock() {
        HttpPost postRequest = new HttpPost("http://localhost:" + this.getAdminPort() + "/__admin/reset");
        try (CloseableHttpClient client = HttpClients.createDefault();
             CloseableHttpResponse response = client.execute((HttpUriRequest)postRequest);){
            Assertions.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getWiremockStandAlonePath() {
        return System.getProperty("user.home") + WIREMOCK_M2_PATH;
    }

    private static void waitForWiremock() {
        Awaitility.await().pollDelay(Duration.ofSeconds(1L)).atMost(Duration.ofSeconds(3L)).until(BaseWiremockTest::isWiremockResponding);
    }

    private static boolean isWiremockResponding() {
        boolean bl;
        block8: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                HttpGet request = new HttpGet(String.format("http://%s:%d/__admin/mappings", WIREMOCK_HOST, wiremockHttpPort));
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                boolean bl2 = bl = response.getStatusLine().getStatusCode() == 200;
                if (httpClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.warn("Waiting for wiremock to respond: ", (Throwable)e);
                    return false;
                }
            }
            httpClient.close();
        }
        return bl;
    }

    protected static void stopWiremockStandAlone() {
        if (wiremockStandalone != null) {
            wiremockStandalone.destroyForcibly();
            Awaitility.await().alias("stop wiremock").atMost(Duration.ofSeconds(10L)).until(() -> !wiremockStandalone.isAlive());
        }
    }

    private static int findFreePort() {
        try {
            ServerSocket socket = new ServerSocket(0);
            int port = socket.getLocalPort();
            socket.close();
            return port;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Properties getProperties() {
        Map<String, String> params = AbstractDriverIT.getConnectionParameters();
        Properties props = new Properties();
        props.put("host", params.get("host"));
        props.put("port", params.get("port"));
        props.put("account", params.get("account"));
        props.put("user", params.get("user"));
        props.put("role", params.get("role"));
        props.put("password", params.get("password"));
        props.put("warehouse", params.get("warehouse"));
        props.put("db", params.get("database"));
        props.put("ssl", params.get("ssl"));
        props.put("insecureMode", (Object)true);
        return props;
    }

    protected HttpPost createWiremockPostRequest(String body, String path) {
        StringEntity entity;
        HttpPost postRequest = new HttpPost("http://localhost:" + this.getAdminPort() + path);
        try {
            entity = new StringEntity(body);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        postRequest.setEntity((HttpEntity)entity);
        postRequest.setHeader("Accept", "application/json");
        postRequest.setHeader("Content-type", "application/json");
        return postRequest;
    }

    protected static void restoreTrustStorePathProperty() {
        if (originalTrustStorePath != null) {
            System.setProperty(TRUST_STORE_PROPERTY, originalTrustStorePath);
        } else {
            System.clearProperty(TRUST_STORE_PROPERTY);
        }
    }

    private int getAdminPort() {
        return wiremockHttpPort;
    }

    private static String getResourceURL(String relativePath) {
        return Paths.get(SnowflakeUtil.systemGetProperty((String)"user.dir"), "src", "test", "resources", relativePath).toAbsolutePath().toString();
    }

    protected void setCustomTrustStorePropertyPath() {
        System.setProperty(TRUST_STORE_PROPERTY, BaseWiremockTest.getResourceURL("wiremock" + File.separator + "ca-cert.jks"));
    }

    protected void importMapping(String mappingImport) {
        HttpPost request = this.createWiremockPostRequest(mappingImport, "/__admin/mappings/import");
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            Assumptions.assumeTrue((response.getStatusLine().getStatusCode() == 200 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            logger.error("Importing mapping failed", (Throwable)e);
            Assumptions.abort((String)"Importing mapping failed");
        }
    }

    protected void addMapping(String mapping) {
        HttpPost postRequest = this.createWiremockPostRequest(mapping, "/__admin/mappings");
        try (CloseableHttpClient client = HttpClients.createDefault();
             CloseableHttpResponse response = client.execute((HttpUriRequest)postRequest);){
            Assertions.assertEquals((int)201, (int)response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

