/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import net.snowflake.client.TestUtil;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="statement")
public class BatchExecutionIT
extends BaseJDBCTest {
    @Test
    public void testClearingBatchAfterStatementExecution() throws SQLException {
        String tableName = TestUtil.randomTableName("SNOW-1853752");
        int itemsInBatch = 3;
        try (Connection connection = BatchExecutionIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(String.format("CREATE OR REPLACE TABLE %s(id int, s varchar(2))", tableName));
            List<ThrowingCallable> executeMethods = Arrays.asList(() -> statement.executeBatch().length, () -> statement.executeLargeBatch().length);
            for (ThrowingCallable executeMethod : executeMethods) {
                for (int i : TestUtil.randomIntList(itemsInBatch, 10)) {
                    statement.addBatch(String.format("INSERT INTO %s(id, s) VALUES (%d, 's%d')", tableName, i, i));
                }
                Assertions.assertEquals((int)itemsInBatch, (Integer)((Integer)executeMethod.call()));
                Assertions.assertEquals((int)itemsInBatch, (Integer)((Integer)executeMethod.call()));
                statement.clearBatch();
                for (int i : TestUtil.randomIntList(itemsInBatch, 10)) {
                    statement.addBatch(String.format("INSERT INTO %s(id, s) VALUES (%d, 'longer string %d')", tableName, i, i));
                }
                Assertions.assertThrows(BatchUpdateException.class, executeMethod::call);
                Assertions.assertThrows(BatchUpdateException.class, executeMethod::call);
                statement.clearBatch();
            }
        }
    }

    @FunctionalInterface
    static interface ThrowingCallable<A, T extends Throwable> {
        public A call() throws T;
    }
}

