/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.bind.BindUploader;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.BindUploaderIT;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class BindUploaderLatestIT
extends BaseJDBCTest {
    BindUploader bindUploader;
    Connection conn;
    SFSession session;
    TimeZone prevTimeZone;

    @BeforeAll
    public static void classSetUp() throws Exception {
        BindUploaderIT.classSetUp();
    }

    @AfterAll
    public static void classTearDown() throws Exception {
        BindUploaderIT.classTearDown();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.conn = BindUploaderLatestIT.getConnection();
        this.session = this.conn.unwrap(SnowflakeConnectionV1.class).getSfSession();
        this.bindUploader = BindUploader.newInstance((SFBaseSession)this.session, (String)"binduploaderit");
        this.prevTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @AfterEach
    public void tearDown() throws SQLException {
        this.conn.close();
        this.bindUploader.close();
        TimeZone.setDefault(this.prevTimeZone);
    }

    @Test
    public void testUploadedResultsMultiple() throws Exception {
        int lengthOfOneRow = "42,1234,12.34,12.34,42,row1,807F,1970-01-01,00:00:00.000000000,1970-01-01 00:00:00.000000000 Z".getBytes("UTF-8").length;
        this.bindUploader.setInputStreamBufferSize(lengthOfOneRow);
        this.bindUploader.upload(BindUploaderIT.getBindings(this.conn));
        Assertions.assertEquals((int)2, (int)this.bindUploader.getFileCount());
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select $1, $2, $3, $4, $5, $6, $7, $8, $9, $10 from '@SYSTEM$BIND/binduploaderit' ORDER BY $1 ASC");
        rs.next();
        Assertions.assertEquals((Object)"42,1234,12.34,12.34,42,row1,807F,1970-01-01,00:00:00.000000000,1970-01-01 00:00:00.000000000 Z", (Object)BindUploaderIT.parseRow(rs));
        rs.next();
        Assertions.assertEquals((Object)"420,12340,120.34,120.34,420,row2,7F80,1970-01-01,00:00:00.001000000,1970-01-01 00:00:00.001000000 Z", (Object)BindUploaderIT.parseRow(rs));
        Assertions.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
    }

    @Test
    public void testUploadedResultsSimple() throws Exception {
        this.bindUploader.upload(BindUploaderIT.getBindings(this.conn));
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select $1, $2, $3, $4, $5, $6, $7, $8, $9, $10 from '@SYSTEM$BIND/binduploaderit' ORDER BY $1 ASC");
        rs.next();
        Assertions.assertEquals((Object)"42,1234,12.34,12.34,42,row1,807F,1970-01-01,00:00:00.000000000,1970-01-01 00:00:00.000000000 Z", (Object)BindUploaderIT.parseRow(rs));
        rs.next();
        Assertions.assertEquals((Object)"420,12340,120.34,120.34,420,row2,7F80,1970-01-01,00:00:00.001000000,1970-01-01 00:00:00.001000000 Z", (Object)BindUploaderIT.parseRow(rs));
        Assertions.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
    }

    @Test
    public void testUploadStreamLargeBatch() throws Exception {
        int batchSize = 0x100000;
        SnowflakePreparedStatementV1 stmt = (SnowflakePreparedStatementV1)this.conn.prepareStatement("insert into test_binduploader VALUES(?,?,?,?,?,?,?,?,?,?)");
        for (int i = 0; i < batchSize; ++i) {
            BindUploaderIT.bind(stmt, BindUploaderIT.row1);
        }
        Map parameterBindings = stmt.getBatchParameterBindings();
        this.bindUploader.upload(parameterBindings);
        ResultSet rs = stmt.executeQuery("select $1, $2, $3, $4, $5, $6, $7, $8, $9, $10 from '@SYSTEM$BIND/binduploaderit' ORDER BY $1 ASC");
        for (int i = 0; i < batchSize; ++i) {
            rs.next();
            Assertions.assertEquals((Object)"42,1234,12.34,12.34,42,row1,807F,1970-01-01,00:00:00.000000000,1970-01-01 00:00:00.000000000 Z", (Object)BindUploaderIT.parseRow(rs));
        }
        Assertions.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
    }
}

