/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class BindingDataLatestIT
extends AbstractDriverIT {
    TimeZone origTz = TimeZone.getDefault();
    TimeZone tokyoTz = TimeZone.getTimeZone("Asia/Tokyo");
    TimeZone australiaTz = TimeZone.getTimeZone("Australia/Sydney");
    Calendar tokyo = Calendar.getInstance(this.tokyoTz);

    @Test
    public void testBindTimestampTZ() throws SQLException {
        try (Connection connection = BindingDataLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("create or replace table testBindTimestampTZ(cola int, colb timestamp_tz)");
            statement.execute("alter session set CLIENT_TIMESTAMP_TYPE_MAPPING=TIMESTAMP_TZ");
            long milliSeconds = System.currentTimeMillis();
            Timestamp ts = new Timestamp(milliSeconds);
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into testBindTimestampTZ values (?, ?)");){
                prepStatement.setInt(1, 123);
                prepStatement.setTimestamp(2, ts, Calendar.getInstance(TimeZone.getTimeZone("EST")));
                prepStatement.execute();
            }
            try (ResultSet resultSet = statement.executeQuery("select cola, colb from testBindTimestampTz");){
                Assertions.assertTrue((boolean)resultSet.next());
                MatcherAssert.assertThat((String)"integer", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)123));
                MatcherAssert.assertThat((String)"timestamp_tz", (Object)resultSet.getTimestamp(2), (Matcher)CoreMatchers.equalTo((Object)ts));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testTimestampBindingWithNTZType() throws SQLException {
        TimeZone.setDefault(this.tokyoTz);
        try (Connection connection = BindingDataLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table stageinsert(ind int, ltz0 timestamp_ltz, tz0 timestamp_tz, ntz0 timestamp_ntz)");
                statement.execute("create or replace table regularinsert(ind int, ltz0 timestamp_ltz, tz0 timestamp_tz, ntz0 timestamp_ntz)");
                statement.execute("alter session set CLIENT_TIMESTAMP_TYPE_MAPPING=TIMESTAMP_NTZ");
                statement.execute("alter session set TIMEZONE='Asia/Tokyo'");
                Timestamp currT = new Timestamp(System.currentTimeMillis());
                try (PreparedStatement prepStatement = connection.prepareStatement("insert into regularinsert values (?,?,?,?)");){
                    prepStatement.setInt(1, 1);
                    prepStatement.setTimestamp(2, currT, this.tokyo);
                    prepStatement.setTimestamp(3, currT, this.tokyo);
                    prepStatement.setTimestamp(4, currT);
                    prepStatement.addBatch();
                    prepStatement.executeBatch();
                }
                statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 1");
                this.executePsStatementForTimestampTest(connection, "stageinsert", currT);
                try (ResultSet rs1 = statement.executeQuery("select * from stageinsert");
                     ResultSet rs2 = statement.executeQuery("select * from regularinsert");){
                    Assertions.assertTrue((boolean)rs1.next());
                    Assertions.assertTrue((boolean)rs2.next());
                    Assertions.assertEquals((int)rs1.getInt(1), (int)rs2.getInt(1));
                    Assertions.assertEquals((Object)rs1.getTimestamp(2), (Object)rs1.getTimestamp(3));
                    Assertions.assertEquals((Object)rs1.getTimestamp(2), (Object)rs2.getTimestamp(2));
                    Assertions.assertEquals((Object)rs1.getTimestamp(3), (Object)rs2.getTimestamp(3));
                    Assertions.assertEquals((Object)rs1.getTimestamp(4), (Object)rs2.getTimestamp(4));
                }
            }
            finally {
                statement.execute("drop table if exists stageinsert");
                statement.execute("drop table if exists regularinsert");
                TimeZone.setDefault(this.origTz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testTimestampBindingWithLTZType() throws SQLException {
        TimeZone.setDefault(this.tokyoTz);
        try (Connection connection = BindingDataLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table stageinsert(ind int, ltz0 timestamp_ltz, tz0 timestamp_tz, ntz0 timestamp_ntz)");
                statement.execute("create or replace table regularinsert(ind int, ltz0 timestamp_ltz, tz0 timestamp_tz, ntz0 timestamp_ntz)");
                statement.execute("alter session set CLIENT_TIMESTAMP_TYPE_MAPPING=TIMESTAMP_LTZ");
                statement.execute("alter session set TIMEZONE='Asia/Tokyo'");
                Timestamp currT = new Timestamp(System.currentTimeMillis());
                this.executePsStatementForTimestampTest(connection, "regularinsert", currT);
                statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 1");
                this.executePsStatementForTimestampTest(connection, "stageinsert", currT);
                try (ResultSet rs1 = statement.executeQuery("select * from stageinsert");
                     ResultSet rs2 = statement.executeQuery("select * from regularinsert");){
                    Assertions.assertTrue((boolean)rs1.next());
                    Assertions.assertTrue((boolean)rs2.next());
                    Assertions.assertEquals((int)rs1.getInt(1), (int)rs2.getInt(1));
                    Assertions.assertEquals((Object)rs1.getTimestamp(2), (Object)rs1.getTimestamp(3));
                    Assertions.assertEquals((Object)rs1.getTimestamp(3), (Object)rs1.getTimestamp(4));
                    Assertions.assertEquals((Object)rs1.getTimestamp(2), (Object)rs2.getTimestamp(2));
                    Assertions.assertEquals((Object)rs1.getTimestamp(3), (Object)rs2.getTimestamp(3));
                    Assertions.assertEquals((Object)rs1.getTimestamp(4), (Object)rs2.getTimestamp(4));
                }
            }
            finally {
                statement.execute("drop table if exists stageinsert");
                statement.execute("drop table if exists regularinsert");
                TimeZone.setDefault(this.origTz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testTimestampBindingWithLTZTypeForDayLightSavingTimeZone() throws SQLException {
        Calendar australia = Calendar.getInstance(this.australiaTz);
        TimeZone.setDefault(this.australiaTz);
        try (Connection connection = BindingDataLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table stageinsert(ind int, ltz0 timestamp_ltz, ltz1 timestamp_ltz, ltz2 timestamp_ltz, tz0 timestamp_tz, tz1 timestamp_tz, tz2 timestamp_tz, ntz0 timestamp_ntz, ntz1 timestamp_ntz, ntz2 timestamp_ntz)");
                statement.execute("create or replace table regularinsert(ind int, ltz0 timestamp_ltz, ltz1 timestamp_ltz, ltz2 timestamp_ltz, tz0 timestamp_tz, tz1 timestamp_tz, tz2 timestamp_tz, ntz0 timestamp_ntz, ntz1 timestamp_ntz, ntz2 timestamp_ntz)");
                statement.execute("alter session set CLIENT_TIMESTAMP_TYPE_MAPPING=TIMESTAMP_LTZ");
                statement.execute("alter session set TIMEZONE='UTC'");
                Timestamp ts1 = new Timestamp(1403049600000L);
                Timestamp ts2 = new Timestamp(1388016000000L);
                Timestamp ts3 = new Timestamp(System.currentTimeMillis());
                try (PreparedStatement prepStatement = connection.prepareStatement("insert into regularinsert values (?,?,?,?,?,?,?,?,?,?)");){
                    prepStatement.setInt(1, 1);
                    prepStatement.setTimestamp(2, ts1);
                    prepStatement.setTimestamp(3, ts2);
                    prepStatement.setTimestamp(4, ts3);
                    prepStatement.setTimestamp(5, ts1);
                    prepStatement.setTimestamp(6, ts2);
                    prepStatement.setTimestamp(7, ts3);
                    prepStatement.setTimestamp(8, ts1, australia);
                    prepStatement.setTimestamp(9, ts2, australia);
                    prepStatement.setTimestamp(10, ts3, australia);
                    prepStatement.addBatch();
                    prepStatement.executeBatch();
                }
                statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 1");
                prepStatement = connection.prepareStatement("insert into stageinsert values (?,?,?,?,?,?,?,?,?,?)");
                try {
                    prepStatement.setInt(1, 1);
                    prepStatement.setTimestamp(2, ts1);
                    prepStatement.setTimestamp(3, ts2);
                    prepStatement.setTimestamp(4, ts3);
                    prepStatement.setTimestamp(5, ts1);
                    prepStatement.setTimestamp(6, ts2);
                    prepStatement.setTimestamp(7, ts3);
                    prepStatement.setTimestamp(8, ts1);
                    prepStatement.setTimestamp(9, ts2);
                    prepStatement.setTimestamp(10, ts3);
                    prepStatement.addBatch();
                    prepStatement.executeBatch();
                }
                finally {
                    if (prepStatement != null) {
                        prepStatement.close();
                    }
                }
                try (ResultSet rs1 = statement.executeQuery("select * from stageinsert");
                     ResultSet rs2 = statement.executeQuery("select * from regularinsert");){
                    Assertions.assertTrue((boolean)rs1.next());
                    Assertions.assertTrue((boolean)rs2.next());
                    Assertions.assertEquals((int)rs1.getInt(1), (int)rs2.getInt(1));
                    Assertions.assertEquals((Object)rs1.getTimestamp(2), (Object)rs2.getTimestamp(2));
                    Assertions.assertEquals((Object)rs1.getTimestamp(3), (Object)rs2.getTimestamp(3));
                    Assertions.assertEquals((Object)rs1.getTimestamp(4), (Object)rs2.getTimestamp(4));
                    Assertions.assertEquals((Object)rs1.getTimestamp(5), (Object)rs2.getTimestamp(5));
                    Assertions.assertEquals((Object)rs1.getTimestamp(6), (Object)rs2.getTimestamp(6));
                    Assertions.assertEquals((Object)rs1.getTimestamp(7), (Object)rs2.getTimestamp(7));
                    Assertions.assertEquals((Object)rs1.getTimestamp(8), (Object)rs2.getTimestamp(8));
                    Assertions.assertEquals((Object)rs1.getTimestamp(9), (Object)rs2.getTimestamp(9));
                    Assertions.assertEquals((Object)rs1.getTimestamp(10), (Object)rs2.getTimestamp(10));
                    Assertions.assertEquals((long)ts1.getTime(), (long)rs1.getTimestamp(2).getTime());
                    Assertions.assertEquals((long)ts2.getTime(), (long)rs1.getTimestamp(3).getTime());
                    Assertions.assertEquals((long)ts3.getTime(), (long)rs1.getTimestamp(4).getTime());
                    Assertions.assertEquals((long)ts1.getTime(), (long)rs1.getTimestamp(5).getTime());
                    Assertions.assertEquals((long)ts2.getTime(), (long)rs1.getTimestamp(6).getTime());
                    Assertions.assertEquals((long)ts3.getTime(), (long)rs1.getTimestamp(7).getTime());
                    Assertions.assertEquals((long)ts1.getTime(), (long)rs1.getTimestamp(8).getTime());
                    Assertions.assertEquals((long)ts2.getTime(), (long)rs1.getTimestamp(9).getTime());
                    Assertions.assertEquals((long)ts3.getTime(), (long)rs1.getTimestamp(10).getTime());
                    Assertions.assertEquals((long)ts1.getTime(), (long)rs2.getTimestamp(2).getTime());
                    Assertions.assertEquals((long)ts2.getTime(), (long)rs2.getTimestamp(3).getTime());
                    Assertions.assertEquals((long)ts3.getTime(), (long)rs2.getTimestamp(4).getTime());
                    Assertions.assertEquals((long)ts1.getTime(), (long)rs2.getTimestamp(5).getTime());
                    Assertions.assertEquals((long)ts2.getTime(), (long)rs2.getTimestamp(6).getTime());
                    Assertions.assertEquals((long)ts3.getTime(), (long)rs2.getTimestamp(7).getTime());
                    Assertions.assertEquals((long)ts1.getTime(), (long)rs2.getTimestamp(8).getTime());
                    Assertions.assertEquals((long)ts2.getTime(), (long)rs2.getTimestamp(9).getTime());
                    Assertions.assertEquals((long)ts3.getTime(), (long)rs2.getTimestamp(10).getTime());
                }
            }
            finally {
                statement.execute("drop table if exists stageinsert");
                statement.execute("drop table if exists regularinsert");
                TimeZone.setDefault(this.origTz);
            }
        }
    }

    public void executePsStatementForTimestampTest(Connection connection, String tableName, Timestamp timestamp) throws SQLException {
        try (PreparedStatement prepStatement = connection.prepareStatement("insert into " + tableName + " values (?,?,?,?)");){
            prepStatement.setInt(1, 1);
            prepStatement.setTimestamp(2, timestamp);
            prepStatement.setTimestamp(3, timestamp);
            prepStatement.setTimestamp(4, timestamp);
            prepStatement.addBatch();
            prepStatement.executeBatch();
        }
    }
}

