/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class CallableStatementITBase
extends BaseJDBCTest {
    private final String createStoredProcedure = "create or replace procedure square_it(num FLOAT) returns float not null language javascript as $$ return NUM * NUM; $$";
    private final String createSecondStoredProcedure = "create or replace procedure add_nums(x DOUBLE, y DOUBLE) returns double not null language javascript as $$ return X + Y; $$";
    private final String deleteStoredProcedure = "drop procedure if exists square_it(FLOAT)";
    private final String deleteSecondStoredProcedure = "drop procedure if exists add_nums(INT, INT)";

    public static Connection getConnection() throws SQLException {
        return BaseJDBCTest.getConnection();
    }

    public static Connection getConnection(String queryResultFormat) throws SQLException {
        Connection conn = BaseJDBCTest.getConnection();
        try (Statement stmt = conn.createStatement();){
            stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
        }
        return conn;
    }

    @BeforeEach
    public void setUp() throws SQLException {
        try (Connection con = CallableStatementITBase.getConnection();
             Statement statement = con.createStatement();){
            statement.execute("create or replace procedure square_it(num FLOAT) returns float not null language javascript as $$ return NUM * NUM; $$");
            statement.execute("create or replace procedure add_nums(x DOUBLE, y DOUBLE) returns double not null language javascript as $$ return X + Y; $$");
        }
    }

    @AfterEach
    public void tearDown() throws SQLException {
        try (Connection con = CallableStatementITBase.getConnection();
             Statement statement = con.createStatement();){
            statement.execute("drop procedure if exists square_it(FLOAT)");
            statement.execute("drop procedure if exists add_nums(INT, INT)");
        }
    }
}

