/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.snowflake.client.jdbc.CallableStatementITBase;
import net.snowflake.client.jdbc.SnowflakeCallableStatementV1;
import net.snowflake.client.providers.SimpleResultFormatProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="statement")
public class CallableStatementLatestIT
extends CallableStatementITBase {
    @Test
    public void testParseSqlEscapeSyntaxFunction() {
        String[] callStatements = new String[]{"{call square_it(5)}", "call no_bracket_function(44)", "call {bracket_function(a=?)}"};
        String[] expectedStatements = new String[]{"call square_it(5)", "call no_bracket_function(44)", "call {bracket_function(a=?)}"};
        for (int i = 0; i < callStatements.length; ++i) {
            Assertions.assertEquals((Object)expectedStatements[i], (Object)SnowflakeCallableStatementV1.parseSqlEscapeSyntax((String)callStatements[i]));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testPrepareCallWithCurlyBracketSyntax(String queryResultFormat) throws SQLException {
        try (Connection connection = CallableStatementLatestIT.getConnection(queryResultFormat);){
            ResultSet rs;
            try (CallableStatement callableStatement = connection.prepareCall("{call square_it(5)}");){
                MatcherAssert.assertThat((Object)callableStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)0));
            }
            callableStatement = connection.prepareCall("{call square_it(?)}");
            try {
                MatcherAssert.assertThat((Object)callableStatement.getParameterMetaData().getParameterType(1), (Matcher)CoreMatchers.is((Object)12));
                callableStatement.getParameterMetaData().getParameterTypeName(1);
                MatcherAssert.assertThat((Object)callableStatement.getParameterMetaData().getParameterTypeName(1), (Matcher)CoreMatchers.is((Object)"text"));
                callableStatement.setFloat(1, 7.0f);
                rs = callableStatement.executeQuery();
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((float)49.0f, (float)rs.getFloat(1), (float)1.0f);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            callableStatement = connection.prepareCall("{call add_nums(?,?)}");
            try {
                callableStatement.setDouble(1, 32.0);
                callableStatement.setDouble(2, 15.0);
                rs = callableStatement.executeQuery();
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((double)47.0, (double)rs.getDouble(1), (double)0.5);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
        }
    }
}

