/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.snowflake.client.jdbc.CompressedStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompressedStreamFactoryTest {
    private final CompressedStreamFactory factory = new CompressedStreamFactory();

    @Test
    public void testDetectContentEncodingAndGetInputStream_Gzip() throws Exception {
        byte[] gzipData;
        String originalData = "Some data in GZIP";
        BasicHeader encodingHeader = new BasicHeader("Content-Encoding", "gzip");
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
            gzipOutputStream.write(originalData.getBytes(StandardCharsets.UTF_8));
            gzipOutputStream.close();
            gzipData = byteArrayOutputStream.toByteArray();
        }
        ByteArrayInputStream gzipStream = new ByteArrayInputStream(gzipData);
        InputStream resultStream = this.factory.createBasedOnEncodingHeader((InputStream)gzipStream, (Header)encodingHeader);
        Assertions.assertTrue((boolean)(resultStream instanceof GZIPInputStream));
        String decompressedData = IOUtils.toString((InputStream)resultStream, (Charset)StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)originalData, (Object)decompressedData);
    }

    @Test
    public void testDetectContentEncodingAndGetInputStream_Zstd() throws Exception {
        byte[] zstdData;
        String originalData = "Some data in ZSTD";
        BasicHeader encodingHeader = new BasicHeader("Content-Encoding", "zstd");
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             ZstdOutputStream zstdOutputStream = new ZstdOutputStream((OutputStream)byteArrayOutputStream);){
            zstdOutputStream.write(originalData.getBytes(StandardCharsets.UTF_8));
            zstdOutputStream.close();
            zstdData = byteArrayOutputStream.toByteArray();
        }
        ByteArrayInputStream zstdStream = new ByteArrayInputStream(zstdData);
        InputStream resultStream = this.factory.createBasedOnEncodingHeader((InputStream)zstdStream, (Header)encodingHeader);
        Assertions.assertTrue((boolean)(resultStream instanceof ZstdInputStream));
        String decompressedData = IOUtils.toString((InputStream)resultStream, (Charset)StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)originalData, (Object)decompressedData);
    }
}

