/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.util.Properties;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="connection")
public class ConnectionAlreadyClosedIT
extends BaseJDBCTest {
    @Test
    public void testClosedConnection() throws Throwable {
        Connection connection = ConnectionAlreadyClosedIT.getConnection();
        connection.close();
        this.expectConnectionAlreadyClosedException(connection::getMetaData);
        this.expectConnectionAlreadyClosedException(connection::getAutoCommit);
        this.expectConnectionAlreadyClosedException(connection::commit);
        this.expectConnectionAlreadyClosedException(connection::rollback);
        this.expectConnectionAlreadyClosedException(connection::isReadOnly);
        this.expectConnectionAlreadyClosedException(connection::getCatalog);
        this.expectConnectionAlreadyClosedException(connection::getSchema);
        this.expectConnectionAlreadyClosedException(connection::getTransactionIsolation);
        this.expectConnectionAlreadyClosedException(connection::getWarnings);
        this.expectConnectionAlreadyClosedException(connection::clearWarnings);
        this.expectConnectionAlreadyClosedException(() -> connection.nativeSQL("select 1"));
        this.expectConnectionAlreadyClosedException(() -> connection.setAutoCommit(false));
        this.expectConnectionAlreadyClosedException(() -> connection.setReadOnly(false));
        this.expectConnectionAlreadyClosedException(() -> connection.setCatalog("fakedb"));
        this.expectConnectionAlreadyClosedException(() -> connection.setSchema("fakedb"));
        this.expectConnectionAlreadyClosedException(() -> connection.setTransactionIsolation(2));
        this.expectSQLClientInfoException(() -> connection.setClientInfo(new Properties()));
        this.expectSQLClientInfoException(() -> connection.setClientInfo("name", "value"));
    }
}

