/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import net.snowflake.client.TestUtil;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.annotations.RunOnAWS;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.QueryStatus;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.auth.AuthenticatorType;
import net.snowflake.client.core.auth.ClientAuthnDTO;
import net.snowflake.client.core.auth.ClientAuthnParameter;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.QueryStatusV2;
import net.snowflake.client.jdbc.SnowflakeBasicDataSource;
import net.snowflake.client.jdbc.SnowflakeConnection;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakePreparedStatement;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatement;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.AnyOf;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@Tag(value="connection")
public class ConnectionLatestIT
extends BaseJDBCTest {
    @TempDir
    private File tmpFolder;
    private static final SFLogger logger = SFLoggerFactory.getLogger(ConnectionLatestIT.class);
    private boolean defaultState;

    @BeforeEach
    public void setUp() {
        TelemetryService service = TelemetryService.getInstance();
        service.updateContextForIT(ConnectionLatestIT.getConnectionParameters());
        this.defaultState = service.isEnabled();
        service.setNumOfRetryToTriggerTelemetry(3);
        TelemetryService.enable();
    }

    @AfterEach
    public void tearDown() throws InterruptedException {
        TelemetryService service = TelemetryService.getInstance();
        TimeUnit.SECONDS.sleep(5L);
        if (this.defaultState) {
            TelemetryService.enable();
        } else {
            TelemetryService.disable();
        }
        service.resetNumOfRetryToTriggerTelemetry();
        System.clearProperty("net.snowflake.jdbc.enableBouncyCastle");
    }

    @Test
    public void testDisableQueryContextCache() throws SQLException {
        Properties props = new Properties();
        props.put("disableQueryContextCache", "true");
        try (Connection con = ConnectionLatestIT.getConnection(props);
             Statement statement = con.createStatement();){
            statement.execute("select 1");
            SFSession session = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
            Assertions.assertNull((Object)session.getQueryContextDTO());
        }
    }

    @Test
    public void testHeartbeatFrequencyValidValue() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY", (Object)1800);
        try (Connection connection = ConnectionLatestIT.getConnection(paramProperties);){
            Enumeration<?> enums = paramProperties.propertyNames();
            while (enums.hasMoreElements()) {
                String key = (String)enums.nextElement();
                ResultSet rs = connection.createStatement().executeQuery(String.format("show parameters like '%s'", key));
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    String value = rs.getString("value");
                    MatcherAssert.assertThat((String)key, (Object)value, (Matcher)CoreMatchers.equalTo((Object)paramProperties.get(key).toString()));
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            SFSession session = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            Assertions.assertEquals((int)1800, (int)session.getHeartbeatFrequency());
        }
    }

    @Test
    public void testHeartbeatFrequencyTooSmall() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY", (Object)2);
        try (Connection connection = ConnectionLatestIT.getConnection(paramProperties);){
            Enumeration<?> enums = paramProperties.propertyNames();
            while (enums.hasMoreElements()) {
                String key = (String)enums.nextElement();
                ResultSet rs = connection.createStatement().executeQuery(String.format("show parameters like '%s'", key));
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    String value = rs.getString("value");
                    MatcherAssert.assertThat((String)key, (Object)value, (Matcher)CoreMatchers.equalTo((Object)"900"));
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            SFSession session = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            Assertions.assertEquals((int)900, (int)session.getHeartbeatFrequency());
        }
    }

    @Test
    @DontRunOnGithubActions
    public void putGetStatementsHaveQueryID() throws Throwable {
        try (Connection con = ConnectionLatestIT.getConnection();
             Statement statement = con.createStatement();){
            String sourceFilePath = ConnectionLatestIT.getFullPathFileInResource("orders_100.csv");
            File destFolder = new File(this.tmpFolder, "dest");
            destFolder.mkdirs();
            String destFolderCanonicalPath = destFolder.getCanonicalPath();
            statement.execute("CREATE OR REPLACE STAGE testPutGet_stage");
            SnowflakeStatement snowflakeStatement = statement.unwrap(SnowflakeStatement.class);
            String createStageQueryId = snowflakeStatement.getQueryID();
            TestUtil.assertValidQueryId(createStageQueryId);
            String putStatement = "PUT file://" + sourceFilePath + " @testPutGet_stage";
            String resultSetPutQueryId = "";
            try (ResultSet resultSet = snowflakeStatement.executeAsyncQuery(putStatement);){
                String statementPutQueryId = snowflakeStatement.getQueryID();
                TestUtil.assertValidQueryId(statementPutQueryId);
                Assertions.assertNotEquals((Object)createStageQueryId, (Object)statementPutQueryId, (String)"create query id is override by put query id");
                resultSetPutQueryId = resultSet.unwrap(SnowflakeResultSet.class).getQueryID();
                TestUtil.assertValidQueryId(resultSetPutQueryId);
                Assertions.assertEquals((Object)resultSetPutQueryId, (Object)statementPutQueryId);
            }
            resultSet = snowflakeStatement.executeAsyncQuery("GET @testPutGet_stage 'file://" + destFolderCanonicalPath + "' parallel=8");
            try {
                String statementGetQueryId = snowflakeStatement.getQueryID();
                String resultSetGetQueryId = resultSet.unwrap(SnowflakeResultSet.class).getQueryID();
                TestUtil.assertValidQueryId(resultSetGetQueryId);
                Assertions.assertNotEquals((Object)resultSetGetQueryId, (Object)resultSetPutQueryId, (String)"put and get query id should be different");
                Assertions.assertEquals((Object)resultSetGetQueryId, (Object)statementGetQueryId);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void putGetStatementsHaveQueryIDEvenWhenFail() throws Throwable {
        try (Connection con = ConnectionLatestIT.getConnection();
             Statement statement = con.createStatement();){
            String sourceFilePath = ConnectionLatestIT.getFullPathFileInResource("orders_100.csv");
            File destFolder = new File(this.tmpFolder, "dest");
            destFolder.mkdirs();
            String destFolderCanonicalPath = destFolder.getCanonicalPath();
            SnowflakeStatement snowflakeStatement = statement.unwrap(SnowflakeStatement.class);
            try {
                statement.executeQuery("PUT file://" + sourceFilePath + " @not_existing_state");
                Assertions.fail((String)"PUT statement should fail");
            }
            catch (SnowflakeSQLException e) {
                TestUtil.assertValidQueryId(snowflakeStatement.getQueryID());
                Assertions.assertEquals((Object)snowflakeStatement.getQueryID(), (Object)e.getQueryId());
            }
            String putQueryId = snowflakeStatement.getQueryID();
            try {
                statement.executeQuery("GET @not_existing_state 'file://" + destFolderCanonicalPath + "' parallel=8");
                Assertions.fail((String)"GET statement should fail");
            }
            catch (SnowflakeSQLException e) {
                TestUtil.assertValidQueryId(snowflakeStatement.getQueryID());
                Assertions.assertEquals((Object)snowflakeStatement.getQueryID(), (Object)e.getQueryId());
            }
            String getQueryId = snowflakeStatement.getQueryID();
            Assertions.assertNotEquals((Object)putQueryId, (Object)getQueryId, (String)"put and get query id should be different");
            String stageName = "stage_" + SnowflakeUtil.randomAlphaNumeric((int)10);
            statement.execute("CREATE OR REPLACE STAGE " + stageName);
            TestUtil.assertValidQueryId(snowflakeStatement.getQueryID());
            try {
                statement.executeQuery("PUT file://not_existing_file @" + stageName);
                Assertions.fail((String)"PUT statement should fail");
            }
            catch (SnowflakeSQLException e) {
                TestUtil.assertValidQueryId(snowflakeStatement.getQueryID());
                Assertions.assertEquals((Object)snowflakeStatement.getQueryID(), (Object)e.getQueryId());
            }
        }
    }

    @Test
    public void testAsyncQueryOpenAndCloseConnection() throws SQLException, IOException, InterruptedException {
        String queryID = null;
        try (Connection con = ConnectionLatestIT.getConnection();
             Statement statement = con.createStatement();
             ResultSet rs1 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("CALL SYSTEM$WAIT(60, 'SECONDS')");){
            queryID = rs1.unwrap(SnowflakeResultSet.class).getQueryID();
            SnowflakeResultSet sfrs = rs1.unwrap(SnowflakeResultSet.class);
            Awaitility.await().atMost(Duration.ofSeconds(5L)).until(() -> sfrs.getStatusV2().getStatus(), CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)QueryStatus.NO_DATA)));
            QueryStatusV2 statusV2 = sfrs.getStatusV2();
            Assertions.assertEquals((Object)QueryStatus.RUNNING, (Object)statusV2.getStatus());
            Assertions.assertEquals((Object)QueryStatus.RUNNING.name(), (Object)statusV2.getName());
        }
        Thread.sleep(70000L);
        con = ConnectionLatestIT.getConnection();
        try {
            ResultSet rs;
            try {
                rs = con.unwrap(SnowflakeConnection.class).createResultSet("Totally invalid query ID");
                try {
                    Assertions.fail((String)"Query ID should be rejected");
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SQLException e) {
                Assertions.assertEquals((Object)"22023", (Object)e.getSQLState());
            }
            rs = con.unwrap(SnowflakeConnection.class).createResultSet(queryID);
            try {
                QueryStatusV2 statusV2 = rs.unwrap(SnowflakeResultSet.class).getStatusV2();
                Assertions.assertEquals((Object)QueryStatus.SUCCESS, (Object)statusV2.getStatus());
                Assertions.assertEquals((Object)"No error reported", (Object)statusV2.getErrorMessage());
                Assertions.assertEquals((int)0, (int)statusV2.getErrorCode());
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(rs));
                try (Statement statement = con.createStatement();
                     ResultSet rs1 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from nonexistentTable");){
                    Thread.sleep(100L);
                    SnowflakeResultSet sfrs1 = rs1.unwrap(SnowflakeResultSet.class);
                    Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> sfrs1.getStatusV2().getStatus() == QueryStatus.FAILED_WITH_ERROR);
                    statusV2 = sfrs1.getStatusV2();
                    Assertions.assertEquals((int)2003, (int)statusV2.getErrorCode());
                    Assertions.assertEquals((Object)"SQL compilation error:\nObject 'NONEXISTENTTABLE' does not exist or not authorized.", (Object)statusV2.getErrorMessage());
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    @Test
    public void testGetErrorMessageFromAsyncQuery() throws SQLException {
        try (Connection con = ConnectionLatestIT.getConnection();
             Statement statement = con.createStatement();){
            try (ResultSet rs1 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("bad query!");){
                try {
                    rs1.next();
                }
                catch (SQLException ex) {
                    Assertions.assertEquals((Object)"Status of query associated with resultSet is FAILED_WITH_ERROR. SQL compilation error:\nsyntax error line 1 at position 0 unexpected 'bad'. Results not generated.", (Object)ex.getMessage());
                    Assertions.assertEquals((Object)"SQL compilation error:\nsyntax error line 1 at position 0 unexpected 'bad'.", (Object)rs1.unwrap(SnowflakeResultSet.class).getQueryErrorMessage());
                }
            }
            try (ResultSet rs2 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select 1");){
                rs2.next();
                Assertions.assertEquals((Object)"No error reported", (Object)rs2.unwrap(SnowflakeResultSet.class).getQueryErrorMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncAndSynchronousQueries() throws SQLException {
        try (Connection con = ConnectionLatestIT.getConnection();
             Statement statement = con.createStatement();){
            try {
                statement.execute("alter session set CLIENT_TIMESTAMP_TYPE_MAPPING=TIMESTAMP_TZ");
                statement.execute("create or replace table smallTable (colA string, colB int)");
                statement.execute("create or replace table uselessTable (colA string, colB int)");
                statement.execute("insert into smallTable values ('row1', 1), ('row2', 2), ('row3', 3)");
                statement.execute("insert into uselessTable values ('row1', 1), ('row2', 2), ('row3', 3)");
                try (ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from smallTable");
                     ResultSet rs1 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from uselessTable");
                     ResultSet rs2 = statement.executeQuery("drop table uselessTable");){
                    while (rs2.next()) {
                        Assertions.assertEquals((Object)"USELESSTABLE successfully dropped.", (Object)rs2.getString(1));
                    }
                    Assertions.assertEquals((int)3, (int)this.getSizeOfResultSet(rs1));
                    statement.execute("alter session set CLIENT_TIMESTAMP_TYPE_MAPPING=TIMESTAMP_LTZ");
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((Object)rs.getString(1), (Object)"row1");
                    Assertions.assertEquals((int)rs.getInt(2), (int)1);
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((Object)rs.getString(1), (Object)"row2");
                    Assertions.assertEquals((int)rs.getInt(2), (int)2);
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((Object)rs.getString(1), (Object)"row3");
                    Assertions.assertEquals((int)rs.getInt(2), (int)3);
                }
            }
            finally {
                statement.execute("drop table smallTable");
            }
        }
    }

    @Test
    public void testQueryStatusErrorMessageAndErrorCodeChangeOnAsyncQuery() throws SQLException {
        try (Connection con = ConnectionLatestIT.getConnection();
             Statement statement = con.createStatement();
             ResultSet rs1 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select count(*) from table(generator(timeLimit => 2))");){
            SnowflakeResultSet sfResultSet = rs1.unwrap(SnowflakeResultSet.class);
            Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> sfResultSet.getStatusV2().getStatus(), CoreMatchers.equalTo((Object)QueryStatus.RUNNING));
            Awaitility.await().atMost(Duration.ofSeconds(360L)).until(() -> sfResultSet.getStatusV2().getStatus(), CoreMatchers.equalTo((Object)QueryStatus.SUCCESS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreparedStatementAsyncQuery() throws SQLException {
        try (Connection con = ConnectionLatestIT.getConnection();
             Statement statement = con.createStatement();){
            try {
                statement.execute("create or replace table testTable(colA string, colB boolean)");
                try (PreparedStatement prepStatement = con.prepareStatement("insert into testTable values (?,?)");){
                    prepStatement.setInt(1, 33);
                    prepStatement.setBoolean(2, true);
                    try (ResultSet rs = prepStatement.unwrap(SnowflakePreparedStatement.class).executeAsyncQuery();){
                        Assertions.assertTrue((boolean)rs.next());
                        Assertions.assertEquals((Object)rs.getString(1), (Object)"1");
                    }
                }
            }
            finally {
                statement.execute("drop table testTable");
            }
        }
    }

    @Test
    public void testIsStillRunning() {
        QueryStatus[] runningStatuses = new QueryStatus[]{QueryStatus.RUNNING, QueryStatus.RESUMING_WAREHOUSE, QueryStatus.QUEUED, QueryStatus.QUEUED_REPAIRING_WAREHOUSE, QueryStatus.NO_DATA, QueryStatus.BLOCKED};
        QueryStatus[] otherStatuses = new QueryStatus[]{QueryStatus.ABORTED, QueryStatus.ABORTING, QueryStatus.SUCCESS, QueryStatus.FAILED_WITH_ERROR, QueryStatus.FAILED_WITH_INCIDENT, QueryStatus.DISCONNECTED, QueryStatus.RESTARTED};
        for (QueryStatus qs : runningStatuses) {
            Assertions.assertEquals((Object)true, (Object)QueryStatus.isStillRunning((QueryStatus)qs));
        }
        for (QueryStatus qs : otherStatuses) {
            Assertions.assertEquals((Object)false, (Object)QueryStatus.isStillRunning((QueryStatus)qs));
        }
    }

    @Test
    public void testIsAnError() {
        QueryStatus[] errorStatuses;
        QueryStatus[] otherStatuses = new QueryStatus[]{QueryStatus.RUNNING, QueryStatus.RESUMING_WAREHOUSE, QueryStatus.QUEUED, QueryStatus.QUEUED_REPAIRING_WAREHOUSE, QueryStatus.SUCCESS, QueryStatus.RESTARTED, QueryStatus.NO_DATA};
        for (QueryStatus qs : errorStatuses = new QueryStatus[]{QueryStatus.ABORTED, QueryStatus.ABORTING, QueryStatus.FAILED_WITH_ERROR, QueryStatus.FAILED_WITH_INCIDENT, QueryStatus.DISCONNECTED, QueryStatus.BLOCKED}) {
            Assertions.assertEquals((Object)true, (Object)QueryStatus.isAnError((QueryStatus)qs));
        }
        for (QueryStatus qs : otherStatuses) {
            Assertions.assertEquals((Object)false, (Object)QueryStatus.isAnError((QueryStatus)qs));
        }
    }

    public void testQueryStatuses() throws SQLException, IOException, InterruptedException {
        try (Connection con = ConnectionLatestIT.getConnection();
             Statement statement = con.createStatement();
             ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select count(*) from table(generator(timeLimit => 5))");){
            Thread.sleep(100L);
            QueryStatus status = rs.unwrap(SnowflakeResultSet.class).getStatus();
            Assertions.assertEquals((Object)QueryStatus.RESUMING_WAREHOUSE, (Object)status);
            try (ResultSet rs1 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select count(*) from table(generator(timeLimit => 60))");
                 ResultSet rs2 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select count(*) from table(generator(timeLimit => 60))");
                 ResultSet rs3 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select count(*) from table(generator(timeLimit => 60))");
                 ResultSet rs4 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select count(*) from table(generator(timeLimit => 60))");){
                Thread.sleep(100L);
                status = rs4.unwrap(SnowflakeResultSet.class).getStatus();
                Assertions.assertEquals((Object)QueryStatus.QUEUED, (Object)status);
            }
        }
    }

    @Test
    public void testHttpsLoginTimeoutWithOutSSL() throws InterruptedException {
        Properties properties = new Properties();
        properties.put("account", "wrongaccount");
        properties.put("loginTimeout", "20");
        properties.put("user", "fakeuser");
        properties.put("password", "fakepassword");
        properties.put("authenticator", AuthenticatorType.SNOWFLAKE.toString());
        properties.put("ssl", "off");
        int count = TelemetryService.getInstance().getEventCount();
        try {
            Map<String, String> params = ConnectionLatestIT.getConnectionParameters();
            String host = params.get("host");
            String[] hostItems = host.split("\\.");
            String wrongUri = params.get("uri").replace("://" + hostItems[0], "://wrongaccount");
            DriverManager.getConnection(wrongUri, properties);
        }
        catch (SQLException e) {
            if (TelemetryService.getInstance().getServerDeploymentName().equals(TelemetryService.TELEMETRY_SERVER_DEPLOYMENT.DEV.getName()) || TelemetryService.getInstance().getServerDeploymentName().equals(TelemetryService.TELEMETRY_SERVER_DEPLOYMENT.REG.getName())) {
                MatcherAssert.assertThat((String)"Communication error", (Object)e.getErrorCode(), (Matcher)AnyOf.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)390100), CoreMatchers.equalTo((Object)390400)}));
                Thread.sleep(5000L);
                if (TelemetryService.getInstance().isDeploymentEnabled()) {
                    MatcherAssert.assertThat((String)"Telemetry should not create new event", (Object)TelemetryService.getInstance().getEventCount(), (Matcher)CoreMatchers.equalTo((Object)count));
                }
            } else {
                MatcherAssert.assertThat((String)"Communication error", (Object)e.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
                if (TelemetryService.getInstance().isDeploymentEnabled()) {
                    MatcherAssert.assertThat((String)("Telemetry event has not been reported successfully. Error: " + TelemetryService.getInstance().getLastClientError()), (Object)TelemetryService.getInstance().getClientFailureCount(), (Matcher)CoreMatchers.equalTo((Object)0));
                }
            }
            return;
        }
        Assertions.fail();
    }

    @Test
    public void testWrongHostNameTimeout() throws InterruptedException {
        long connStart = 0L;
        Properties properties = new Properties();
        properties.put("account", "testaccount");
        properties.put("loginTimeout", "20");
        properties.put("user", "fakeuser");
        properties.put("password", "fakepassword");
        properties.put("authenticator", AuthenticatorType.SNOWFLAKE.toString());
        try {
            connStart = System.currentTimeMillis();
            Map<String, String> params = ConnectionLatestIT.getConnectionParameters();
            String host = params.get("host");
            String[] hostItems = host.split("\\.");
            String wrongUri = params.get("uri").replace("." + hostItems[hostItems.length - 2] + ".", ".wronghostname.");
            DriverManager.getConnection(wrongUri, properties);
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((String)"Communication error", (Object)e.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            long conEnd = System.currentTimeMillis();
            MatcherAssert.assertThat((String)"Login time out not taking effective", (conEnd - connStart < 300000L ? 1 : 0) != 0);
            Thread.sleep(5000L);
            if (TelemetryService.getInstance().isDeploymentEnabled()) {
                MatcherAssert.assertThat((String)("Telemetry event has not been reported successfully. Error: " + TelemetryService.getInstance().getLastClientError()), (Object)TelemetryService.getInstance().getClientFailureCount(), (Matcher)CoreMatchers.equalTo((Object)0));
            }
            return;
        }
        Assertions.fail();
    }

    @Test
    public void testHttpsLoginTimeoutWithSSL() throws InterruptedException {
        long connStart = 0L;
        Properties properties = new Properties();
        properties.put("account", "wrongaccount");
        properties.put("loginTimeout", "5");
        properties.put("user", "fakeuser");
        properties.put("password", "fakepassword");
        properties.put("ssl", "on");
        try {
            connStart = System.currentTimeMillis();
            Map<String, String> params = ConnectionLatestIT.getConnectionParameters();
            String host = params.get("host");
            String[] hostItems = host.split("\\.");
            String wrongUri = params.get("uri").replace("://" + hostItems[0], "://wrongaccount");
            DriverManager.getConnection(wrongUri, properties);
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((String)"Communication error", (Object)e.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            long conEnd = System.currentTimeMillis();
            MatcherAssert.assertThat((String)"Login time out not taking effective", (conEnd - connStart < 300000L ? 1 : 0) != 0);
            Thread.sleep(5000L);
            if (TelemetryService.getInstance().isDeploymentEnabled()) {
                MatcherAssert.assertThat((String)("Telemetry event has not been reported successfully. Error: " + TelemetryService.getInstance().getLastClientError()), (Object)TelemetryService.getInstance().getClientFailureCount(), (Matcher)CoreMatchers.equalTo((Object)0));
            }
            return;
        }
        Assertions.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testKeyPairFileDataSourceSerialization() throws Exception {
        Map<String, String> params = ConnectionLatestIT.getConnectionParameters();
        try {
            SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
            ds.setServerName(params.get("host"));
            ds.setSsl("on".equals(params.get("ssl")));
            ds.setAccount(params.get("account"));
            ds.setPortNumber(Integer.parseInt(params.get("port")));
            ds.setUser(params.get("user"));
            String privateKeyLocation = ConnectionLatestIT.getFullPathFileInResource("encrypted_rsa_key.p8");
            ds.setPrivateKeyFile(privateKeyLocation, "test");
            ConnectionLatestIT.setUpPublicKey("encrypted_rsa_key.pub", params.get("user"));
            ConnectionLatestIT.connectAndExecuteSelect1(ds);
            File serializedFile = new File(this.tmpFolder, "serializedStuff.ser");
            serializedFile.createNewFile();
            try (FileOutputStream outputFile = new FileOutputStream(serializedFile);
                 ObjectOutputStream out = new ObjectOutputStream(outputFile);){
                out.writeObject(ds);
            }
            try (FileInputStream inputFile = new FileInputStream(serializedFile);
                 ObjectInputStream in = new ObjectInputStream(inputFile);){
                SnowflakeBasicDataSource ds2 = (SnowflakeBasicDataSource)in.readObject();
                ConnectionLatestIT.connectAndExecuteSelect1(ds2);
            }
        }
        finally {
            ConnectionLatestIT.unsetPublicKey(params.get("user"));
        }
    }

    private static String readPrivateKeyFileToBase64Content(String fileName) throws IOException {
        return Base64.getEncoder().encodeToString(Files.readAllBytes(Paths.get(ConnectionLatestIT.getFullPathFileInResource(fileName), new String[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testKeyPairBase64DataSourceSerialization() throws Exception {
        Map<String, String> params = ConnectionLatestIT.getConnectionParameters();
        try {
            SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
            ds.setServerName(params.get("host"));
            ds.setSsl("on".equals(params.get("ssl")));
            ds.setAccount(params.get("account"));
            ds.setPortNumber(Integer.parseInt(params.get("port")));
            ds.setUser(params.get("user"));
            String privateKeyBase64 = ConnectionLatestIT.readPrivateKeyFileToBase64Content("encrypted_rsa_key.p8");
            ds.setPrivateKeyBase64(privateKeyBase64, "test");
            ConnectionLatestIT.setUpPublicKey("encrypted_rsa_key.pub", params.get("user"));
            ConnectionLatestIT.connectAndExecuteSelect1(ds);
            File serializedFile = new File(this.tmpFolder, "serializedStuff.ser");
            serializedFile.createNewFile();
            try (FileOutputStream outputFile = new FileOutputStream(serializedFile);
                 ObjectOutputStream out = new ObjectOutputStream(outputFile);){
                out.writeObject(ds);
            }
            try (FileInputStream inputFile = new FileInputStream(serializedFile);
                 ObjectInputStream in = new ObjectInputStream(inputFile);){
                SnowflakeBasicDataSource ds2 = (SnowflakeBasicDataSource)in.readObject();
                ConnectionLatestIT.connectAndExecuteSelect1(ds2);
            }
        }
        finally {
            ConnectionLatestIT.unsetPublicKey(params.get("user"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testPrivateKeyInConnectionString() throws SQLException, IOException {
        Map<String, String> parameters = ConnectionLatestIT.getConnectionParameters();
        String testUser = parameters.get("user");
        String baseUri = parameters.get("uri");
        try {
            ConnectionLatestIT.setUpPublicKey("rsa_key.pub", testUser);
            Properties properties = ConnectionLatestIT.preparePropertiesForPrivateKeyTests(parameters);
            String privateKeyLocation = ConnectionLatestIT.getFullPathFileInResource("rsa_key.p8");
            String uri = ConnectionLatestIT.uriWithPrivateKeyFile(baseUri, privateKeyLocation);
            ConnectionLatestIT.connectSuccessfully(uri, properties);
            privateKeyLocation = ConnectionLatestIT.getFullPathFileInResource("rsa_key.pem");
            uri = ConnectionLatestIT.uriWithPrivateKeyFile(baseUri, privateKeyLocation);
            ConnectionLatestIT.connectSuccessfully(uri, properties);
            ConnectionLatestIT.setUpPublicKey("encrypted_rsa_key.pub", testUser);
            privateKeyLocation = ConnectionLatestIT.getFullPathFileInResource("encrypted_rsa_key.p8");
            uri = ConnectionLatestIT.uriWithPrivateKeyFileAndPassword(baseUri, privateKeyLocation, "test");
            ConnectionLatestIT.connectSuccessfully(uri, properties);
            uri = ConnectionLatestIT.uriWithPrivateKeyFileAndPassword(baseUri, privateKeyLocation, "wrong_password");
            ConnectionLatestIT.connectExpectingInvalidOrUnsupportedPrivateKey(uri, properties);
            ConnectionLatestIT.setUpPublicKey("rsa_key.pub", testUser);
            privateKeyLocation = ConnectionLatestIT.getFullPathFileInResource("encrypted_rsa_key.p8");
            uri = ConnectionLatestIT.uriWithPrivateKeyFileAndPassword(baseUri, privateKeyLocation, "test");
            ConnectionLatestIT.connectExpectingError390144(uri, properties);
            privateKeyLocation = ConnectionLatestIT.getFullPathFileInResource("invalid_private_key.pem");
            uri = ConnectionLatestIT.uriWithPrivateKeyFile(baseUri, privateKeyLocation);
            ConnectionLatestIT.connectExpectingInvalidOrUnsupportedPrivateKey(uri, properties);
        }
        finally {
            ConnectionLatestIT.unsetPublicKey(testUser);
        }
    }

    private static String uriWithPrivateKeyFile(String baseUri, String privateKeyLocation) {
        return baseUri + "/?" + SFSessionProperty.PRIVATE_KEY_FILE.getPropertyKey() + "=" + privateKeyLocation;
    }

    private static String uriWithPrivateKeyFileAndPassword(String baseUri, String privateKeyLocation, String password) {
        return ConnectionLatestIT.uriWithPrivateKeyFile(baseUri, privateKeyLocation) + "&" + SFSessionProperty.PRIVATE_KEY_FILE_PWD.getPropertyKey() + "=" + password;
    }

    private static void connectExpectingError390144(String fullUri, Properties properties) {
        try (Connection connection = DriverManager.getConnection(fullUri, properties);){
            Assertions.fail();
        }
        catch (SQLException e) {
            Assertions.assertEquals((int)390144, (int)e.getErrorCode());
        }
    }

    private static void connectSuccessfully(String uri, Properties properties) throws SQLException {
        Connection connection = DriverManager.getConnection(uri, properties);
        if (connection != null) {
            connection.close();
        }
    }

    private static void setUpPublicKey(String fileName, String testUser) throws SQLException, IOException {
        Properties properties = new Properties();
        properties.put("role", "accountadmin");
        try (Connection connection = ConnectionLatestIT.getConnection(properties);
             Statement statement = connection.createStatement();){
            String pathfile = ConnectionLatestIT.getFullPathFileInResource(fileName);
            String pubKey = new String(Files.readAllBytes(Paths.get(pathfile, new String[0])));
            pubKey = pubKey.replace("-----BEGIN PUBLIC KEY-----", "");
            pubKey = pubKey.replace("-----END PUBLIC KEY-----", "");
            statement.execute(String.format("alter user %s set rsa_public_key='%s'", testUser, pubKey));
        }
    }

    private static void unsetPublicKey(String testUser) throws SQLException {
        Properties props = new Properties();
        props.put("role", "accountadmin");
        try (Connection connection = ConnectionLatestIT.getConnection(props);
             Statement statement = connection.createStatement();){
            statement.execute(String.format("alter user %s unset rsa_public_key", testUser));
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testPrivateKeyInConnectionStringWithBouncyCastle() throws SQLException, IOException {
        System.setProperty("net.snowflake.jdbc.enableBouncyCastle", "true");
        this.testPrivateKeyInConnectionString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testPrivateKeyBase64InConnectionString() throws SQLException, IOException {
        Map<String, String> parameters = ConnectionLatestIT.getConnectionParameters();
        String testUser = parameters.get("user");
        String baseUri = parameters.get("uri");
        try {
            ConnectionLatestIT.setUpPublicKey("rsa_key.pub", testUser);
            Properties properties = ConnectionLatestIT.preparePropertiesForPrivateKeyTests(parameters);
            String privateKeyBase64 = ConnectionLatestIT.readPrivateKeyFileToBase64Content("rsa_key.p8");
            String uri = ConnectionLatestIT.uriWithPrivateKeyBase64(baseUri, privateKeyBase64);
            ConnectionLatestIT.connectSuccessfully(uri, properties);
            privateKeyBase64 = ConnectionLatestIT.readPrivateKeyFileToBase64Content("rsa_key.pem");
            uri = ConnectionLatestIT.uriWithPrivateKeyBase64(baseUri, privateKeyBase64);
            ConnectionLatestIT.connectSuccessfully(uri, properties);
            ConnectionLatestIT.setUpPublicKey("encrypted_rsa_key.pub", testUser);
            privateKeyBase64 = ConnectionLatestIT.readPrivateKeyFileToBase64Content("encrypted_rsa_key.p8");
            uri = ConnectionLatestIT.uriWithPrivateKeyBase64AndPassword(baseUri, privateKeyBase64, "test");
            ConnectionLatestIT.connectSuccessfully(uri, properties);
            uri = ConnectionLatestIT.uriWithPrivateKeyBase64AndPassword(baseUri, privateKeyBase64, "wrong_password");
            ConnectionLatestIT.connectExpectingInvalidOrUnsupportedPrivateKey(uri, properties);
            ConnectionLatestIT.setUpPublicKey("rsa_key.pub", testUser);
            privateKeyBase64 = ConnectionLatestIT.readPrivateKeyFileToBase64Content("encrypted_rsa_key.p8");
            uri = ConnectionLatestIT.uriWithPrivateKeyBase64AndPassword(baseUri, privateKeyBase64, "test");
            ConnectionLatestIT.connectExpectingError390144(uri, properties);
            privateKeyBase64 = ConnectionLatestIT.readPrivateKeyFileToBase64Content("invalid_private_key.pem");
            uri = ConnectionLatestIT.uriWithPrivateKeyBase64(baseUri, privateKeyBase64);
            ConnectionLatestIT.connectExpectingInvalidOrUnsupportedPrivateKey(uri, properties);
        }
        finally {
            ConnectionLatestIT.unsetPublicKey(testUser);
        }
    }

    private static String uriWithPrivateKeyBase64(String baseUri, String privateKeyBase64) {
        return baseUri + "/?" + SFSessionProperty.PRIVATE_KEY_BASE64.getPropertyKey() + "=" + privateKeyBase64;
    }

    private static String uriWithPrivateKeyBase64AndPassword(String baseUri, String privateKeyBase64, String password) {
        return ConnectionLatestIT.uriWithPrivateKeyBase64(baseUri, privateKeyBase64) + "&" + SFSessionProperty.PRIVATE_KEY_FILE_PWD.getPropertyKey() + "=" + password;
    }

    private static Properties preparePropertiesForPrivateKeyTests(Map<String, String> parameters) {
        Properties properties = new Properties();
        properties.put("account", parameters.get("account"));
        properties.put("user", parameters.get("user"));
        properties.put("ssl", parameters.get("ssl"));
        properties.put("port", parameters.get("port"));
        return properties;
    }

    private static void connectExpectingInvalidOrUnsupportedPrivateKey(String uri, Properties properties) {
        try (Connection connection = DriverManager.getConnection(uri, properties);){
            Assertions.fail();
        }
        catch (SQLException e) {
            Assertions.assertEquals((int)ErrorCode.INVALID_OR_UNSUPPORTED_PRIVATE_KEY.getMessageCode(), (int)e.getErrorCode());
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testPrivateKeyBase64InConnectionStringWithBouncyCastle() throws SQLException, IOException {
        System.setProperty("net.snowflake.jdbc.enableBouncyCastle", "true");
        this.testPrivateKeyBase64InConnectionString();
    }

    @Test
    @DontRunOnGithubActions
    public void testBasicDataSourceSerialization() throws Exception {
        Map<String, String> params = ConnectionLatestIT.getConnectionParameters();
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        ds.setServerName(params.get("host"));
        ds.setSsl("on".equals(params.get("ssl")));
        ds.setAccount(params.get("account"));
        ds.setPortNumber(Integer.parseInt(params.get("port")));
        ds.setUser(params.get("user"));
        ds.setPassword(params.get("password"));
        ConnectionLatestIT.connectAndExecuteSelect1(ds);
        File serializedFile = new File(this.tmpFolder, "serializedStuff.ser");
        serializedFile.createNewFile();
        try (FileOutputStream outputFile = new FileOutputStream(serializedFile);
             ObjectOutputStream out = new ObjectOutputStream(outputFile);){
            out.writeObject(ds);
        }
        try (FileInputStream inputFile = new FileInputStream(serializedFile);
             ObjectInputStream in = new ObjectInputStream(inputFile);){
            SnowflakeBasicDataSource ds2 = (SnowflakeBasicDataSource)in.readObject();
            ConnectionLatestIT.connectAndExecuteSelect1(ds2);
        }
    }

    private static void connectAndExecuteSelect1(SnowflakeBasicDataSource ds) throws SQLException {
        try (Connection con = ds.getConnection();
             Statement statement = con.createStatement();
             ResultSet resultSet = statement.executeQuery("select 1");){
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((int)1, (int)resultSet.getInt(1));
        }
    }

    private void waitForAsyncQueryDone(Connection connection, String queryID) throws Exception {
        SFSession session = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
        QueryStatus qs = session.getQueryStatus(queryID);
        while (QueryStatus.isStillRunning((QueryStatus)qs)) {
            Thread.sleep(1000L);
            qs = session.getQueryStatus(queryID);
        }
    }

    @Test
    public void testGetChildQueryIdsForAsyncSingleStatement() throws Exception {
        String queryID = null;
        String[] queryIDs = null;
        try (Connection connection = ConnectionLatestIT.getConnection();
             Connection connection2 = ConnectionLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            String query0 = "create or replace temporary table test_multi (cola int);";
            String query1 = "insert into test_multi VALUES (111), (222);";
            String query2 = "select cola from test_multi order by cola asc";
            try (ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(query0);){
                queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
                this.waitForAsyncQueryDone(connection, queryID);
                queryIDs = connection.unwrap(SnowflakeConnectionV1.class).getChildQueryIds(queryID);
                Assertions.assertEquals((int)queryIDs.length, (int)1);
            }
            rs = connection.unwrap(SnowflakeConnection.class).createResultSet(queryIDs[0]);
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)rs.getString(1), (Object)"Table TEST_MULTI successfully created.");
                Assertions.assertFalse((boolean)rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(query1);
            try {
                queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
                this.waitForAsyncQueryDone(connection2, queryID);
                queryIDs = connection2.unwrap(SnowflakeConnectionV1.class).getChildQueryIds(queryID);
                Assertions.assertEquals((int)queryIDs.length, (int)1);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection2.unwrap(SnowflakeConnection.class).createResultSet(queryIDs[0]);
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)rs.getInt(1), (int)2);
                Assertions.assertFalse((boolean)rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(query2);
            try {
                queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
                this.waitForAsyncQueryDone(connection2, queryID);
                queryIDs = connection2.unwrap(SnowflakeConnectionV1.class).getChildQueryIds(queryID);
                Assertions.assertEquals((int)queryIDs.length, (int)1);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection2.unwrap(SnowflakeConnection.class).createResultSet(queryIDs[0]);
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)rs.getInt(1), (int)111);
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)rs.getInt(1), (int)222);
                Assertions.assertFalse((boolean)rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testGetChildQueryIdsForAsyncMultiStatement() throws Exception {
        String queryID = null;
        String[] queryIDs = null;
        try (Connection connection = ConnectionLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            String multiStmtQuery = "create or replace temporary table test_multi (cola int);insert into test_multi VALUES (111), (222);select cola from test_multi order by cola asc";
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
            try (ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(multiStmtQuery);){
                queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
            }
        }
        connection = ConnectionLatestIT.getConnection();
        try {
            this.waitForAsyncQueryDone(connection, queryID);
            queryIDs = connection.unwrap(SnowflakeConnectionV1.class).getChildQueryIds(queryID);
            Assertions.assertEquals((int)queryIDs.length, (int)3);
            try (ResultSet rs = connection.unwrap(SnowflakeConnection.class).createResultSet(queryIDs[0]);){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)rs.getString(1), (Object)"Table TEST_MULTI successfully created.");
                Assertions.assertFalse((boolean)rs.next());
            }
            rs = connection.unwrap(SnowflakeConnection.class).createResultSet(queryIDs[1]);
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)rs.getInt(1), (int)2);
                Assertions.assertFalse((boolean)rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.unwrap(SnowflakeConnection.class).createResultSet(queryIDs[2]);
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)rs.getInt(1), (int)111);
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)rs.getInt(1), (int)222);
                Assertions.assertFalse((boolean)rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetChildQueryIdsNegativeTestQueryIsRunning() throws Exception {
        String queryID = null;
        try (Connection connection = ConnectionLatestIT.getConnection();){
            Statement statement;
            try {
                statement = connection.createStatement();
                try {
                    String multiStmtQuery = "select 1; call system$wait(10); select 2";
                    statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
                    try (ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(multiStmtQuery);){
                        queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
                    }
                    try {
                        connection.unwrap(SnowflakeConnectionV1.class).getChildQueryIds(queryID);
                        Assertions.fail((String)"The getChildQueryIds() should fail because query is running");
                    }
                    catch (SQLException ex) {
                        String msg = ex.getMessage();
                        if (!msg.contains("Status of query associated with resultSet is") || !msg.contains("Results not generated.")) {
                            ex.printStackTrace();
                            QueryStatus qs = connection.unwrap(SnowflakeConnectionV1.class).getSfSession().getQueryStatus(queryID);
                            Assertions.fail((String)("Don't get expected message, query Status: " + qs + " actual message is: " + msg));
                        }
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (Throwable throwable) {
                try (Statement statement2 = connection.createStatement();){
                    statement2.execute("select system$cancel_query('" + queryID + "')");
                }
                throw throwable;
            }
            statement = connection.createStatement();
            try {
                statement.execute("select system$cancel_query('" + queryID + "')");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    @Test
    public void testGetChildQueryIdsNegativeTestQueryFailed() throws Exception {
        String queryID = null;
        try (Connection connection = ConnectionLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            String multiStmtQuery = "select 1; select to_date('not_date'); select 2";
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
            try (ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(multiStmtQuery);){
                queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
            }
            try {
                this.waitForAsyncQueryDone(connection, queryID);
                connection.unwrap(SnowflakeConnectionV1.class).getChildQueryIds(queryID);
                Assertions.fail((String)"The getChildQueryIds() should fail because the query fails");
            }
            catch (SQLException ex) {
                Assertions.assertTrue((boolean)ex.getMessage().contains("Uncaught Execution of multiple statements failed on statement \"select to_date('not_date')\""));
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testAuthenticatorEndpointWithDashInAccountName() throws Exception {
        Map<String, String> params = ConnectionLatestIT.getConnectionParameters();
        String serverUrl = String.format("%s://%s:%s", params.get("ssl").equals("on") ? "https" : "http", params.get("host"), params.get("port"));
        HttpPost postRequest = new HttpPost(new URIBuilder(serverUrl).setPath("/session/authenticator-request").build());
        Map<String, String> data = Collections.singletonMap(ClientAuthnParameter.ACCOUNT_NAME.name(), "snowhouse-local");
        ClientAuthnDTO authnData = new ClientAuthnDTO(data, null);
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        String json = mapper.writeValueAsString((Object)authnData);
        StringEntity input = new StringEntity(json, StandardCharsets.UTF_8);
        input.setContentType("application/json");
        postRequest.setEntity((HttpEntity)input);
        postRequest.addHeader("accept", "application/json");
        String theString = HttpUtil.executeGeneralRequest((HttpRequestBase)postRequest, (int)60, (int)0, (int)0, (int)0, (HttpClientSettingsKey)new HttpClientSettingsKey(null));
        JsonNode jsonNode = mapper.readTree(theString);
        Assertions.assertEquals((Object)"{\"data\":null,\"code\":null,\"message\":null,\"success\":true}", (Object)jsonNode.toString());
    }

    @Test
    public void testReadOnly() throws Throwable {
        try (Connection connection = ConnectionLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            connection.setReadOnly(true);
            Assertions.assertEquals((Object)connection.isReadOnly(), (Object)false);
            connection.setReadOnly(false);
            try {
                statement.execute("create or replace table readonly_test(c1 int)");
                Assertions.assertFalse((boolean)connection.isReadOnly());
            }
            finally {
                statement.execute("drop table if exists readonly_test");
            }
        }
    }

    @Test
    @RunOnAWS
    public void testDownloadStreamWithFileNotFoundException() throws SQLException {
        try (Connection connection = ConnectionLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("CREATE OR REPLACE TEMP STAGE testDownloadStream_stage");
            long startDownloadTime = System.currentTimeMillis();
            try {
                connection.unwrap(SnowflakeConnection.class).downloadStream("@testDownloadStream_stage", "/fileNotExist.gz", true);
            }
            catch (SQLException ex) {
                MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.FILE_NOT_FOUND.getMessageCode()));
            }
            long endDownloadTime = System.currentTimeMillis();
            Assertions.assertTrue((endDownloadTime - startDownloadTime < 400000L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIsAsyncSession() throws SQLException, InterruptedException {
        try (Connection con = ConnectionLatestIT.getConnection();
             Statement statement = con.createStatement();
             ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select count(*) from table(generator(timeLimit => 4))");){
            long start = System.currentTimeMillis();
            SnowflakeConnectionV1 snowflakeConnection = con.unwrap(SnowflakeConnectionV1.class);
            Assertions.assertTrue((boolean)snowflakeConnection.getSfSession().isAsyncSession());
            Assertions.assertFalse((boolean)snowflakeConnection.getSfSession().isSafeToClose());
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertTrue((Duration.ofMillis(System.currentTimeMillis() - start).compareTo(Duration.ofSeconds(4L)) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)snowflakeConnection.getSfSession().isSafeToClose());
            Assertions.assertFalse((boolean)snowflakeConnection.getSfSession().isAsyncSession());
        }
    }

    private Boolean isPbes2KeySupported() throws SQLException, IOException, SecurityException {
        String privateKeyFileNameEnv = "SNOWFLAKE_PRIVATE_KEY_FILENAME";
        String publicKeyFileNameEnv = "SNOWFLAKE_PUBLIC_KEY_FILENAME";
        String passphraseEnv = "SNOWFLAKE_TEST_PASSPHRASE";
        String privateKeyFile = System.getenv("SNOWFLAKE_PRIVATE_KEY_FILENAME");
        String publicKeyFile = System.getenv("SNOWFLAKE_PUBLIC_KEY_FILENAME");
        String passphrase = System.getenv("SNOWFLAKE_TEST_PASSPHRASE");
        Assertions.assertNotNull((Object)passphrase, (String)"SNOWFLAKE_PRIVATE_KEY_FILENAME environment variable can't be empty. Please provide the filename for your private key located in the resource folder");
        Assertions.assertNotNull((Object)passphrase, (String)"SNOWFLAKE_PUBLIC_KEY_FILENAME environment variable can't be empty. Please provide the filename for your public key located in the resource folder");
        Assertions.assertNotNull((Object)passphrase, (String)"SNOWFLAKE_TEST_PASSPHRASE environment variable is required to decrypt private key.");
        Map<String, String> parameters = ConnectionLatestIT.getConnectionParameters();
        String testUser = parameters.get("user");
        Properties properties = new Properties();
        properties.put("account", parameters.get("account"));
        properties.put("user", testUser);
        properties.put("ssl", parameters.get("ssl"));
        properties.put("port", parameters.get("port"));
        Connection connection = ConnectionLatestIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("use role accountadmin");
        String pathFile = ConnectionLatestIT.getFullPathFileInResource(publicKeyFile);
        String pubKey = new String(Files.readAllBytes(Paths.get(pathFile, new String[0])));
        pubKey = pubKey.replace("-----BEGIN PUBLIC KEY-----", "");
        pubKey = pubKey.replace("-----END PUBLIC KEY-----", "");
        pubKey = pubKey.replace("\n", "");
        statement.execute(String.format("alter user %s set rsa_public_key='%s'", testUser, pubKey));
        connection.close();
        String privateKeyLocation = ConnectionLatestIT.getFullPathFileInResource(privateKeyFile);
        String uri = parameters.get("uri") + "/?private_key_pwd=" + passphrase + "&private_key_file=" + privateKeyLocation;
        try {
            Connection conn = DriverManager.getConnection(uri, properties);
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            return false;
        }
        ConnectionLatestIT.unsetPublicKey(testUser);
        return true;
    }

    @Test
    @Disabled
    @DontRunOnGithubActions
    public void testPbes2Support() throws SQLException, IOException {
        System.clearProperty("net.snowflake.jdbc.enableBouncyCastle");
        boolean pbes2Supported = this.isPbes2KeySupported();
        String failureMessage = "The failure means that the JDK version can decrypt a private key generated by OpenSSL v3 and BouncyCastle shouldn't be needed anymore";
        Assertions.assertFalse((boolean)pbes2Supported, (String)failureMessage);
        System.setProperty("net.snowflake.jdbc.enableBouncyCastle", "true");
        pbes2Supported = this.isPbes2KeySupported();
        failureMessage = "Bouncy Castle Provider should have been loaded with the -Dnet.snowflake.jdbc.enableBouncyCastleJVM argument and this should have decrypted the private key generated by OpenSSL v3";
        Assertions.assertTrue((boolean)pbes2Supported, (String)failureMessage);
    }

    @Test
    @Disabled
    public void testDataSourceOktaGenerates429StatusCode() throws Exception {
        Map<String, String> params = ConnectionLatestIT.getConnectionParameters();
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        ds.setServerName(params.get("host"));
        ds.setSsl("on".equals(params.get("ssl")));
        ds.setAccount(params.get("account"));
        ds.setPortNumber(Integer.parseInt(params.get("port")));
        ds.setUser(params.get("ssoUser"));
        ds.setPassword(params.get("ssoPassword"));
        ds.setAuthenticator("<okta address>");
        Runnable r = () -> {
            try {
                ds.getConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        };
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (int i = 0; i < 30; ++i) {
            threadList.add(new Thread(r));
        }
        threadList.forEach(Thread::start);
        for (Thread thread : threadList) {
            thread.join();
        }
    }

    @Test
    public void shouldGetDifferentTimestampLtzConsistentBetweenFormats() throws Exception {
        try (Connection connection = ConnectionLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate("create or replace table DATETIMETZ_TYPE(timestamp_tzcol timestamp_ltz, timestamp_tzpcol timestamp_ltz(6), timestamptzcol timestampltz, timestampwtzcol timestamp with local time zone);");
            Arrays.asList("insert into DATETIMETZ_TYPE values('9999-12-31 23:59:59.999999999','9999-12-31 23:59:59.999999','9999-12-31 23:59:59.999999999','9999-12-31 23:59:59.999999999');", "insert into DATETIMETZ_TYPE values('1582-01-01 00:00:00.000000001','1582-01-01 00:00:00.000001','1582-01-01 00:00:00.000000001','1582-01-01 00:00:00.000000001');", "insert into DATETIMETZ_TYPE values('2000-06-18 18:29:30.123456789 +0100','2000-06-18 18:29:30.123456 +0100','2000-06-18 18:29:30.123456789 +0100','2000-06-18 18:29:30.123456789 +0100');", "insert into DATETIMETZ_TYPE values(current_timestamp(),current_timestamp(),current_timestamp(),current_timestamp());", "insert into DATETIMETZ_TYPE values('2000-06-18 18:29:30.12345 -0530','2000-06-18 18:29:30.123 -0530','2000-06-18 18:29:30.123456 -0530','2000-06-18 18:29:30.123 -0530');", "insert into DATETIMETZ_TYPE values('2000-06-18 18:29:30','2000-06-18 18:29:30','2000-06-18 18:29:30','2000-06-18 18:29:30');", "insert into DATETIMETZ_TYPE values('1582-10-04 00:00:00.000000001','1582-10-04 00:00:00.000001','1582-10-04 00:00:00.000000001','1582-10-04 00:00:00.000000001');", "insert into DATETIMETZ_TYPE values('1582-10-05 00:00:00.000000001','1582-10-05 00:00:00.000001','1582-10-05 00:00:00.000000001','1582-10-05 00:00:00.000000001');", "insert into DATETIMETZ_TYPE values('1583-10-05 00:00:00.000000001','1583-10-05 00:00:00.000001','1583-10-05 00:00:00.000000001','1583-10-05 00:00:00.000000001');").forEach(insert -> {
                try {
                    statement.executeUpdate((String)insert);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
            try (ResultSet arrowResultSet = statement.executeQuery("select * from DATETIMETZ_TYPE");
                 Connection jsonConnection = ConnectionLatestIT.getConnection();
                 Statement jsonStatement = jsonConnection.createStatement();){
                jsonStatement.execute("alter session set JDBC_QUERY_RESULT_FORMAT=JSON");
                try (ResultSet jsonResultSet = jsonStatement.executeQuery("select * from DATETIMETZ_TYPE");){
                    int rowIdx = 0;
                    while (arrowResultSet.next()) {
                        logger.debug("Checking row " + rowIdx, new Object[0]);
                        Assertions.assertTrue((boolean)jsonResultSet.next());
                        for (int column = 1; column <= 4; ++column) {
                            logger.trace("JSON row[{}],column[{}] as string '{}', timestamp string '{}', as timestamp numeric '{}', tz offset={}, timestamp class {}", new Object[]{rowIdx, column, jsonResultSet.getString(column), jsonResultSet.getTimestamp(column), jsonResultSet.getTimestamp(column).getTime(), jsonResultSet.getTimestamp(column).getTimezoneOffset(), jsonResultSet.getTimestamp(column).getClass()});
                            logger.trace("ARROW row[{}],column[{}] as string '{}', timestamp string '{}', as timestamp numeric '{}', tz offset={}, timestamp class {}", new Object[]{rowIdx, column, arrowResultSet.getString(column), arrowResultSet.getTimestamp(column), arrowResultSet.getTimestamp(column).getTime(), arrowResultSet.getTimestamp(column).getTimezoneOffset(), arrowResultSet.getTimestamp(column).getClass()});
                            Assertions.assertEquals((Object)jsonResultSet.getString(column), (Object)arrowResultSet.getString(column), (String)("Expecting that string representation are the same for row " + rowIdx + " and column " + column));
                            Assertions.assertEquals((Object)jsonResultSet.getTimestamp(column).toString(), (Object)arrowResultSet.getTimestamp(column).toString(), (String)("Expecting that string representation (via toString) are the same for row " + rowIdx + " and column " + column));
                            Assertions.assertEquals((Object)jsonResultSet.getTimestamp(column), (Object)arrowResultSet.getTimestamp(column), (String)("Expecting that timestamps are the same for row " + rowIdx + " and column " + column));
                        }
                        ++rowIdx;
                    }
                }
            }
        }
    }

    @Test
    public void testSetHoldability() throws Throwable {
        try (Connection connection = ConnectionLatestIT.getConnection();){
            try {
                connection.setHoldability(2);
            }
            catch (SQLFeatureNotSupportedException ex) {
                Assertions.fail((String)"should not fail");
            }
            Assertions.assertEquals((int)2, (int)connection.getHoldability());
            connection.close();
            this.expectConnectionAlreadyClosedException(() -> connection.setHoldability(2));
        }
    }

    @Test
    public void shouldGetOverridenConnectionAndSocketTimeouts() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("HTTP_CLIENT_CONNECTION_TIMEOUT", (Object)100);
        paramProperties.put("HTTP_CLIENT_SOCKET_TIMEOUT", (Object)200);
        try (Connection connection = ConnectionLatestIT.getConnection(paramProperties);){
            Assertions.assertEquals((Object)Duration.ofMillis(100L), (Object)HttpUtil.getConnectionTimeout());
            Assertions.assertEquals((Object)Duration.ofMillis(200L), (Object)HttpUtil.getSocketTimeout());
        }
    }

    @Test
    public void shouldFailOnSslExceptionWithLinkToTroubleShootingGuide() throws InterruptedException {
        Properties properties = new Properties();
        properties.put("user", "fakeuser");
        properties.put("password", "testpassword");
        properties.put("ocspFailOpen", Boolean.FALSE.toString());
        try {
            DriverManager.getConnection("jdbc:snowflake://expired.badssl.com/", properties);
            Assertions.fail((String)"should fail");
        }
        catch (SQLException e) {
            if (!(e.getCause() instanceof SSLHandshakeException) && e.getCause().getMessage().toLowerCase().contains("timed out")) {
                return;
            }
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(SSLHandshakeException.class));
            Assertions.assertTrue((boolean)e.getMessage().contains("https://docs.snowflake.com/en/user-guide/client-connectivity-troubleshooting/overview"));
        }
    }

    @Test
    public void testDisableOCSPChecksMode() throws SQLException {
        String deploymentUrl = "jdbc:snowflake://sfcsupport.snowflakecomputing.com";
        Properties properties = new Properties();
        properties.put("user", "fakeuser");
        properties.put("password", "fakepwd");
        properties.put("account", "fakeaccount");
        properties.put("disableOCSPChecks", (Object)true);
        SQLException thrown = (SQLException)Assertions.assertThrows(SQLException.class, () -> DriverManager.getConnection(deploymentUrl, properties));
        MatcherAssert.assertThat((Object)thrown.getErrorCode(), (Matcher)AnyOf.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)390100), CoreMatchers.is((Object)390400)}));
    }
}

