/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Properties;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.SessionUtil;
import org.junit.jupiter.api.Assertions;

public class ConnectionManual {
    public static void main(String[] args) throws Throwable {
        ConnectionManual test = new ConnectionManual();
        test.setTokenValidityForTest();
        try {
            test.testSSO();
        }
        finally {
            test.resetTokenValidity();
        }
    }

    private Properties getProperties() {
        String account = TestUtil.systemGetEnv("SNOWFLAKE_TEST_ACCOUNT");
        String ssoUser = TestUtil.systemGetEnv("SNOWFLAKE_TEST_SSO_USER");
        String ssl = TestUtil.systemGetEnv("SNOWFLAKE_TEST_SSL");
        Properties properties = new Properties();
        properties.put("user", ssoUser);
        properties.put("account", account);
        properties.put("ssl", ssl);
        properties.put("tracing", "FINEST");
        properties.put("authenticator", "externalbrowser");
        properties.put("CLIENT_STORE_TEMPORARY_CREDENTIAL", (Object)true);
        return properties;
    }

    private String getUrl() {
        String account = TestUtil.systemGetEnv("SNOWFLAKE_TEST_ACCOUNT");
        String port = TestUtil.systemGetEnv("SNOWFLAKE_TEST_PORT");
        return String.format("jdbc:snowflake://%s.reg.snowflakecomputing.com:%s", account, port);
    }

    private Connection getAdminConnection() throws Throwable {
        String adminAccount = TestUtil.systemGetEnv("SNOWFLAKE_TEST_ADMIN_ACCOUNT");
        if (adminAccount == null) {
            adminAccount = "snowflake";
        }
        String adminUser = TestUtil.systemGetEnv("SNOWFLAKE_TEST_ADMIN_USER");
        String adminPassword = TestUtil.systemGetEnv("SNOWFLAKE_TEST_ADMIN_PASSWORD");
        String port = TestUtil.systemGetEnv("SNOWFLAKE_TEST_PORT");
        String ssl = TestUtil.systemGetEnv("SNOWFLAKE_TEST_SSL");
        if (ssl == null) {
            ssl = "on";
        }
        Properties properties = new Properties();
        properties.put("user", adminUser);
        properties.put("password", adminPassword);
        properties.put("account", adminAccount);
        properties.put("ssl", ssl);
        String url = String.format("jdbc:snowflake://%s.reg.snowflakecomputing.com:%s", adminAccount, port);
        return DriverManager.getConnection(url, properties);
    }

    private void setTokenValidityForTest() throws Throwable {
        try (Connection con = this.getAdminConnection();
             Statement statement = con.createStatement();){
            statement.execute("alter system set MASTER_TOKEN_VALIDITY=60, SESSION_TOKEN_VALIDITY=30, ID_TOKEN_VALIDITY=60");
            statement.execute("alter account testaccount set ID_TOKEN_FEATURE_ENABLED=true;");
            statement.execute("alter account testaccount set ALLOW_ID_TOKEN=true;");
        }
    }

    private void resetTokenValidity() throws Throwable {
        try (Connection con = this.getAdminConnection();
             Statement statement = con.createStatement();){
            statement.execute("alter system set MASTER_TOKEN_VALIDITY=default, SESSION_TOKEN_VALIDITY=default, ID_TOKEN_VALIDITY=default");
        }
    }

    private void testSSO() throws Throwable {
        Statement statement;
        String database = TestUtil.systemGetEnv("SNOWFLAKE_TEST_DATABASE");
        String schema1 = TestUtil.systemGetEnv("SNOWFLAKE_TEST_SCHEMA");
        String schema2 = TestUtil.systemGetEnv("SNOWFLAKE_TEST_SCHEMA2");
        Properties properties = this.getProperties();
        String url = this.getUrl();
        SessionUtil.deleteIdTokenCache((String)String.format("%s.reg.snowflakecomputing.com", properties.getProperty("account")), (String)properties.getProperty("user"));
        System.out.println("[INFO] 1st connection gets id token and stores in the cache file. This popup a browser to SSO login");
        try (Connection con1 = DriverManager.getConnection(url, properties);){
            Assertions.assertTrue((boolean)database.equalsIgnoreCase(con1.getCatalog()));
            Assertions.assertTrue((boolean)schema1.equalsIgnoreCase(con1.getSchema()));
        }
        System.out.println("[INFO] 2nd connection reads the cache file and uses the id token. This should not popups a browser.");
        properties.setProperty("database", database);
        properties.setProperty("schema", schema1);
        try (Connection con2 = DriverManager.getConnection(url, properties);){
            statement = con2.createStatement();
            try {
                Assertions.assertTrue((boolean)database.equalsIgnoreCase(con2.getCatalog()));
                Assertions.assertTrue((boolean)schema1.equalsIgnoreCase(con2.getSchema()));
                System.out.println("[INFO] Running a statement... 10 seconds");
                statement.execute("select seq8() from table(generator(timelimit=>10))");
                Assertions.assertTrue((boolean)database.equalsIgnoreCase(con2.getCatalog()));
                Assertions.assertTrue((boolean)schema1.equalsIgnoreCase(con2.getSchema()));
                System.out.println("[INFO] Running a statement... 1 second");
                statement.execute("select seq8() from table(generator(timelimit=>1))");
                Assertions.assertTrue((boolean)database.equalsIgnoreCase(con2.getCatalog()));
                Assertions.assertTrue((boolean)schema1.equalsIgnoreCase(con2.getSchema()));
                System.out.println("[INFO] Running a statement... 90 seconds");
                statement.execute("select seq8() from table(generator(timelimit=>90))");
                Assertions.assertTrue((boolean)database.equalsIgnoreCase(con2.getCatalog()));
                Assertions.assertTrue((boolean)schema1.equalsIgnoreCase(con2.getSchema()));
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        System.out.println("[INFO] 3rd connection reads the cache file and uses the id token. This should work even after closing the previous connections. A specified schema should be set in the connection object.");
        properties.setProperty("schema", schema2);
        try (Connection con3 = DriverManager.getConnection(url, properties);){
            Assertions.assertTrue((boolean)database.equalsIgnoreCase(con3.getCatalog()));
            Assertions.assertTrue((boolean)schema1.equalsIgnoreCase(con3.getSchema()));
        }
        System.out.println("[INFO] 4th connection reads the cache file and tries to use the id token. However we manually banned IdToken by set some parameters. So a web browser pop up is expected to show up here.");
        try (Connection conAdmin = this.getAdminConnection();){
            statement = conAdmin.createStatement();
            try {
                statement.execute("alter account testaccount set ID_TOKEN_FEATURE_ENABLED=false;");
                statement.execute("alter account testaccount set ALLOW_ID_TOKEN=false;");
                try (Connection con4 = DriverManager.getConnection(url, properties);){
                    System.out.println("Finished. You might need to close login page in web browser to exit this test.");
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }
}

