/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import net.snowflake.client.core.SFTrustManager;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="connection")
public class ConnectionWithDisableOCSPModeLatestIT
extends BaseJDBCTest {
    public static final int INVALID_CONNECTION_INFO_CODE = 390100;
    private static final int DISABLE_OCSP_INSECURE_MODE_MISMATCH = 200064;
    public static final int BAD_REQUEST_GS_CODE = 390400;

    @BeforeEach
    public void setUp() {
        SFTrustManager.deleteCache();
    }

    @AfterEach
    public void tearDown() {
        SFTrustManager.cleanTestSystemParameters();
    }

    @Test
    public void testDisableOCSPChecksModeAndInsecureModeSet() throws SQLException {
        boolean disableOCSPChecks = true;
        boolean insecureMode = true;
        MatcherAssert.assertThat((Object)this.returnErrorCodeFromConnection(disableOCSPChecks, insecureMode), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)390100), CoreMatchers.is((Object)390400)}));
    }

    @Test
    public void testDisableOCSPChecksModeSet() throws SQLException {
        boolean disableOCSPChecks = true;
        MatcherAssert.assertThat((Object)this.returnErrorCodeFromConnection(disableOCSPChecks, null), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)390100), CoreMatchers.is((Object)390400)}));
    }

    @Test
    public void testInsecureModeSet() throws SQLException {
        boolean insecureMode = true;
        MatcherAssert.assertThat((Object)this.returnErrorCodeFromConnection(null, insecureMode), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)390100), CoreMatchers.is((Object)390400)}));
    }

    @Test
    public void testDisableOCSPChecksModeAndInsecureModeMismatched() throws SQLException {
        boolean disableOCSPChecks = true;
        boolean insecureMode = false;
        MatcherAssert.assertThat((Object)this.returnErrorCodeFromConnection(disableOCSPChecks, insecureMode), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)200064)}));
    }

    public int returnErrorCodeFromConnection(Boolean disableOSCPChecks, Boolean isInsecureMode) throws SQLException {
        String deploymentUrl = "jdbc:snowflake://sfcsupport.snowflakecomputing.com";
        Properties properties = new Properties();
        properties.put("user", "fakeuser");
        properties.put("password", "fakepwd");
        properties.put("account", "fakeaccount");
        if (disableOSCPChecks != null) {
            properties.put("disableOCSPChecks", disableOSCPChecks);
        }
        if (isInsecureMode != null) {
            properties.put("insecureMode", isInsecureMode);
        }
        SQLException thrown = (SQLException)Assertions.assertThrows(SQLException.class, () -> DriverManager.getConnection(deploymentUrl, properties));
        return thrown.getErrorCode();
    }
}

