/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.DBMetadataResultSetMetadata;
import net.snowflake.client.jdbc.DatabaseMetaDataIT;
import net.snowflake.client.jdbc.ErrorCode;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class DatabaseMetaDataInternalIT
extends BaseJDBCTest {
    private Connection connection;
    private Statement statement;
    private DatabaseMetaData databaseMetaData;
    private ResultSet resultSet;
    private static final String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    @BeforeEach
    public void setUp() throws SQLException {
        try (Connection con = DatabaseMetaDataInternalIT.getConnection();){
            DatabaseMetaDataInternalIT.initMetaData(con);
        }
    }

    static void initMetaData(Connection con) throws SQLException {
        try (Statement st = con.createStatement();){
            st.execute("create or replace database JDBC_DB1");
            st.execute("create or replace schema JDBC_SCHEMA11");
            st.execute("create or replace table JDBC_TBL111(colA string, colB decimal, colC timestamp)");
            st.execute("create or replace schema TEST_CTX");
            st.execute("create or replace table JDBC_A (colA string, colB decimal, colC number PRIMARY KEY);");
            st.execute("create or replace table JDBC_B (colA string, colB decimal, colC number FOREIGN KEY REFERENCES JDBC_A(colC));");
            st.execute("create or replace schema JDBC_SCHEMA12");
            st.execute("create or replace table JDBC_TBL121(colA varchar)");
            st.execute("create or replace table JDBC_TBL122(colA NUMBER(20, 2) AUTOINCREMENT comment 'cmt colA', colB NUMBER(20, 2) DEFAULT(3) NOT NULL, colC NUMBER(20,2) IDENTITY(20, 2))");
            st.execute("create or replace database JDBC_DB2");
            st.execute("create or replace schema JDBC_SCHEMA21");
            st.execute("create or replace table JDBC_TBL211(colA string)");
            st.execute("create or replace table JDBC_BIN(bin1 binary(8388608), bin2 binary(100))");
        }
    }

    @AfterEach
    public void tearDown() throws SQLException {
        try (Connection con = DatabaseMetaDataInternalIT.getConnection();){
            DatabaseMetaDataInternalIT.endMetaData(con);
        }
    }

    static void endMetaData(Connection con) throws SQLException {
        try (Statement st = con.createStatement();){
            st.execute("drop database if exists JDBC_DB1");
            st.execute("drop database if exists JDBC_DB2");
        }
    }

    @Test
    @Disabled
    @DontRunOnGithubActions
    public void testGetColumn() throws SQLException {
        String getAllColumnsCount = "select count(*) from db.information_schema.columns";
        this.connection = DatabaseMetaDataInternalIT.getConnection();
        this.statement = this.connection.createStatement();
        this.databaseMetaData = this.connection.getMetaData();
        ResultSet snowflakeResultSet = this.databaseMetaData.getColumns("SNOWFLAKE", null, null, null);
        int numSnowflakeColumns = this.getSizeOfResultSet(snowflakeResultSet);
        this.resultSet = this.databaseMetaData.getColumns(null, null, null, null);
        Assertions.assertEquals((int)this.getAllObjectCountInDBViaInforSchema(getAllColumnsCount), (int)(this.getSizeOfResultSet(this.resultSet) - numSnowflakeColumns));
        this.resultSet = this.databaseMetaData.getColumns(null, "JDBC_SCHEMA11", null, null);
        Assertions.assertEquals((int)3, (int)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getColumns(null, "JDBC_SCH_MA11", null, null);
        Assertions.assertEquals((int)3, (int)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getColumns(null, "JDBC%", null, null);
        Assertions.assertEquals((int)10, (int)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getColumns(null, "JDBC_SCHEMA1_", null, null);
        Assertions.assertEquals((int)7, (int)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getColumns(null, "JDBC_SCHEMA21", "JDBC_BIN", "BIN1");
        this.resultSet.next();
        Assertions.assertEquals((int)0x800000, (int)this.resultSet.getInt("COLUMN_SIZE"));
        Assertions.assertEquals((int)1, (int)(this.getSizeOfResultSet(this.resultSet) + 1));
        this.resultSet = this.databaseMetaData.getColumns(null, "JDBC_SCHEMA21", "JDBC_BIN", "BIN2");
        this.resultSet.next();
        Assertions.assertEquals((int)100, (int)this.resultSet.getInt("COLUMN_SIZE"));
        Assertions.assertEquals((int)1, (int)(this.getSizeOfResultSet(this.resultSet) + 1));
        this.resultSet = this.databaseMetaData.getColumns("JDBC_DB1", "JDBC_SCHEMA12", "JDBC_TBL122", "COLA");
        this.resultSet.next();
        Assertions.assertEquals((Object)"JDBC_DB1", (Object)this.resultSet.getString("TABLE_CAT"));
        Assertions.assertEquals((Object)"JDBC_SCHEMA12", (Object)this.resultSet.getString("TABLE_SCHEM"));
        Assertions.assertEquals((Object)"JDBC_TBL122", (Object)this.resultSet.getString("TABLE_NAME"));
        Assertions.assertEquals((Object)"COLA", (Object)this.resultSet.getString("COLUMN_NAME"));
        Assertions.assertEquals((int)3, (int)this.resultSet.getInt("DATA_TYPE"));
        Assertions.assertEquals((Object)"NUMBER", (Object)this.resultSet.getString("TYPE_NAME"));
        Assertions.assertEquals((Object)"20", (Object)this.resultSet.getString("COLUMN_SIZE"));
        Assertions.assertEquals((Object)"2", (Object)this.resultSet.getString("DECIMAL_DIGITS"));
        Assertions.assertEquals((int)1, (int)this.resultSet.getInt("NULLABLE"));
        Assertions.assertEquals((Object)"cmt colA", (Object)this.resultSet.getString("REMARKS"));
        Assertions.assertEquals(null, (Object)this.resultSet.getString("COLUMN_DEF"));
        Assertions.assertEquals((Object)"YES", (Object)this.resultSet.getString("IS_NULLABLE"));
        Assertions.assertEquals((Object)"YES", (Object)this.resultSet.getString("IS_AUTOINCREMENT"));
        this.resultSet.close();
        this.resultSet = this.databaseMetaData.getColumns("JDBC_DB1", "JDBC_SCHEMA12", "JDBC_TBL122", "COLB");
        this.resultSet.next();
        Assertions.assertEquals((int)0, (int)this.resultSet.getInt(11));
        Assertions.assertEquals((Object)"3", (Object)this.resultSet.getString(13));
        Assertions.assertEquals((Object)"NO", (Object)this.resultSet.getString(23));
        this.resultSet.close();
        this.resultSet = this.databaseMetaData.getColumns("JDBC_DB1", "JDBC_SCHEMA1_", null, "COL_");
        this.resultSet = this.databaseMetaData.getColumns("JDBC_DB1", "JDBC_SCHEMA12", "JDBC_TBL122", "COLC");
        this.resultSet.next();
        Assertions.assertEquals(null, (Object)this.resultSet.getString(13));
        Assertions.assertEquals((Object)"YES", (Object)this.resultSet.getString(23));
        this.statement.execute("create or replace table \"@@specialchartable$1234\"(colA int)");
        this.resultSet = this.databaseMetaData.getColumns(null, null, "@@specialchartable$%", null);
        Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(this.resultSet));
        this.resultSet.close();
        this.resultSet.next();
        this.connection.close();
    }

    @Test
    @DontRunOnGithubActions
    public void testGetFunctions() throws SQLException {
        this.connection = DatabaseMetaDataInternalIT.getConnection();
        this.statement = this.connection.createStatement();
        this.statement.execute("create or replace function JDBC_DB1.JDBC_SCHEMA11.JDBCFUNCTEST111 (a number, b number) RETURNS NUMBER COMMENT='multiply numbers' as 'a*b'");
        this.statement.execute("create or replace function JDBC_DB1.JDBC_SCHEMA12.JDBCFUNCTEST121 (a number, b number) RETURNS NUMBER COMMENT='multiply numbers' as 'a*b'");
        this.statement.execute("create or replace function JDBC_DB1.JDBC_SCHEMA12.JDBCFUNCTEST122 (a number, b number) RETURNS NUMBER COMMENT='multiply numbers' as 'a*b'");
        this.statement.execute("create or replace function JDBC_DB2.JDBC_SCHEMA21.JDBCFUNCTEST211 (a number, b number) RETURNS NUMBER COMMENT='multiply numbers' as 'a*b'");
        this.statement.execute("create or replace function JDBC_DB2.JDBC_SCHEMA21.JDBCFUNCTEST212 () RETURNS TABLE(colA varchar) as 'select COLA from JDBC_DB2.JDBC_SCHEMA21.JDBC_TBL211'");
        this.databaseMetaData = this.connection.getMetaData();
        this.resultSet = this.databaseMetaData.getFunctions("JDBC_DB1", "JDBC_SCHEMA11", "JDBCFUNCTEST111");
        DatabaseMetaDataIT.verifyResultSetMetaDataColumns(this.resultSet, DBMetadataResultSetMetadata.GET_FUNCTIONS);
        this.resultSet.next();
        Assertions.assertEquals((Object)"JDBC_DB1", (Object)this.resultSet.getString("FUNCTION_CAT"));
        Assertions.assertEquals((Object)"JDBC_SCHEMA11", (Object)this.resultSet.getString("FUNCTION_SCHEM"));
        Assertions.assertEquals((Object)"JDBCFUNCTEST111", (Object)this.resultSet.getString("FUNCTION_NAME"));
        Assertions.assertEquals((Object)"multiply numbers", (Object)this.resultSet.getString("REMARKS"));
        Assertions.assertEquals((int)1, (int)this.resultSet.getInt("FUNCTION_TYPE"));
        Assertions.assertEquals((Object)"JDBCFUNCTEST111", (Object)this.resultSet.getString("SPECIFIC_NAME"));
        Assertions.assertFalse((boolean)this.resultSet.next());
        this.resultSet = this.databaseMetaData.getFunctions("JDBC_DB2", "JDBC_SCHEMA21", "JDBCFUNCTEST212");
        this.resultSet.next();
        Assertions.assertEquals((int)2, (int)this.resultSet.getInt("FUNCTION_TYPE"));
        Assertions.assertFalse((boolean)this.resultSet.next());
        this.resultSet = this.databaseMetaData.getFunctions(null, null, "AND");
        this.resultSet.next();
        Assertions.assertEquals((Object)"", (Object)this.resultSet.getString("FUNCTION_CAT"));
        Assertions.assertEquals((Object)"", (Object)this.resultSet.getString("FUNCTION_SCHEM"));
        Assertions.assertEquals((Object)"AND", (Object)this.resultSet.getString("FUNCTION_NAME"));
        Assertions.assertEquals((int)1, (int)this.resultSet.getInt("FUNCTION_TYPE"));
        Assertions.assertEquals((Object)"AND", (Object)this.resultSet.getString("SPECIFIC_NAME"));
        Assertions.assertFalse((boolean)this.resultSet.next());
        this.resultSet = this.databaseMetaData.getFunctions(null, null, "JDBCFUNCTEST%");
        Assertions.assertEquals((int)5, (int)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getFunctions(null, "JDBC_SCHEMA1_", "_DBCFUNCTEST%");
        Assertions.assertEquals((int)3, (int)this.getSizeOfResultSet(this.resultSet));
        try {
            this.resultSet = this.databaseMetaData.getFunctions("JDBC_DB3", "JDBC_SCHEMA1_", "_DBCFUNCTEST%");
        }
        catch (SQLException e) {
            Assertions.assertEquals((int)2003, (int)e.getErrorCode());
        }
        this.resultSet = this.databaseMetaData.getFunctions("JDBC_DB1", "JDBC_SCHEMA__", "_DBCFUNCTEST%");
        Assertions.assertEquals((int)3, (int)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getFunctions("JDBC_DB1", "JDBC_SCHEMA1_", "_DBCFUNCTEST11_");
        Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getFunctions("JDBC_DB1", null, "_DBCFUNCTEST11_");
        Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(this.resultSet));
        this.resultSet.close();
        this.resultSet.next();
        this.statement.close();
        this.connection.close();
    }

    @Test
    @Disabled
    @DontRunOnGithubActions
    public void testGetSchema() throws SQLException {
        String getSchemaCount = "select count(*) from db.information_schema.schemata";
        this.connection = DatabaseMetaDataInternalIT.getConnection();
        this.databaseMetaData = this.connection.getMetaData();
        Assertions.assertEquals((Object)"schema", (Object)this.databaseMetaData.getSchemaTerm());
        ResultSet snowflakeResultSet = this.databaseMetaData.getSchemas("SNOWFLAKE", null);
        int numSnowflakeSchemas = this.getSizeOfResultSet(snowflakeResultSet);
        this.resultSet = this.databaseMetaData.getSchemas();
        Assertions.assertEquals((int)this.getAllObjectCountInDBViaInforSchema(getSchemaCount), (int)(this.getSizeOfResultSet(this.resultSet) - numSnowflakeSchemas));
        this.resultSet = this.databaseMetaData.getSchemas(null, null);
        Assertions.assertEquals((int)this.getAllObjectCountInDBViaInforSchema(getSchemaCount), (int)(this.getSizeOfResultSet(this.resultSet) - numSnowflakeSchemas));
        this.resultSet = this.databaseMetaData.getSchemas("JDBC_DB1", "%");
        this.resultSet.next();
        Assertions.assertEquals((Object)"INFORMATION_SCHEMA", (Object)this.resultSet.getString(1));
        Assertions.assertEquals((Object)"JDBC_DB1", (Object)this.resultSet.getString(2));
        this.resultSet.next();
        Assertions.assertEquals((Object)"JDBC_SCHEMA11", (Object)this.resultSet.getString(1));
        Assertions.assertEquals((Object)"JDBC_DB1", (Object)this.resultSet.getString(2));
        this.resultSet.next();
        Assertions.assertEquals((Object)"JDBC_SCHEMA12", (Object)this.resultSet.getString(1));
        Assertions.assertEquals((Object)"JDBC_DB1", (Object)this.resultSet.getString(2));
        this.resultSet.next();
        Assertions.assertEquals((Object)"PUBLIC", (Object)this.resultSet.getString(1));
        Assertions.assertEquals((Object)"JDBC_DB1", (Object)this.resultSet.getString(2));
        this.resultSet = this.databaseMetaData.getSchemas("JDBC_DB1", "JDBC%");
        Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(this.resultSet));
        this.resultSet.close();
        this.resultSet.next();
        this.connection.close();
    }

    @Test
    @Disabled
    @DontRunOnGithubActions
    public void testGetTablesReusingCachedResults() throws SQLException {
        Connection snowflakeConnection = DatabaseMetaDataInternalIT.getSnowflakeAdminConnection();
        Statement snowflake = snowflakeConnection.createStatement();
        snowflake.execute("alter system set OVERRIDE_USE_CACHED_RESULT = true;");
        this.connection = DatabaseMetaDataInternalIT.getConnection();
        this.databaseMetaData = this.connection.getMetaData();
        Statement stmt = this.connection.createStatement();
        stmt.execute("select system$drop_result_reuse_cache();");
        stmt.execute("alter session set USE_CACHED_RESULT = true;");
        stmt.execute("alter session set USE_CACHED_SHOW_RESULT = true;");
        String accountName = this.getAccountName(stmt);
        long accountId = this.getAccountId(stmt, accountName);
        String dbname = "JDBC_DSHOW";
        String schemaname = "SSHOW_" + DatabaseMetaDataInternalIT.randomAlphaNumeric(6);
        stmt.execute("create or replace database " + dbname);
        stmt.execute("create or replace schema " + schemaname);
        stmt.execute("use schema " + dbname + "." + schemaname);
        stmt.execute("create table show1(c1 number);");
        long oldNumCacheRes = this.getNumCachedResults(stmt, accountId);
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        long newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assertions.assertEquals((long)1L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assertions.assertEquals((long)0L, (long)(newNumCacheRes - oldNumCacheRes));
        stmt.execute("create table show2(c2 number);");
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assertions.assertEquals((long)1L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assertions.assertEquals((long)0L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        stmt.execute("alter table show2 rename to show3");
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assertions.assertEquals((long)1L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assertions.assertEquals((long)0L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        stmt.execute("alter table show3 set comment = 'show3'");
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assertions.assertEquals((long)1L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assertions.assertEquals((long)0L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        stmt.execute("insert into show3 values (3),(4)");
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assertions.assertEquals((long)0L, (long)(newNumCacheRes - oldNumCacheRes));
        stmt.execute("drop table show1");
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assertions.assertEquals((long)1L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assertions.assertEquals((long)0L, (long)(newNumCacheRes - oldNumCacheRes));
        stmt.execute("drop database if exists " + dbname);
        stmt.execute("alter session set USE_CACHED_RESULT = default;");
        snowflake.execute("alter system set OVERRIDE_USE_CACHED_RESULT = true;");
        stmt.execute("alter session set USE_CACHED_SHOW_RESULT = default;");
        stmt.close();
        snowflake.close();
        snowflakeConnection.close();
        this.connection.close();
    }

    private long getNumCachedResults(Statement stmt, long accountId) throws SQLException {
        String query = "select count($1:\"JobResultDPO:share\")\nfrom table(dposcan('\n  {\n    \"slices\" : [{\"name\" : \"JobResultDPO:share\"}],\n    \"ranges\" : [\n            {\"name\" : \"accountId\", \"value\" : %d}\n          ]\n   }'));";
        stmt.execute(String.format(query, accountId));
        this.resultSet = stmt.getResultSet();
        Assertions.assertTrue((boolean)this.resultSet.next());
        return this.resultSet.getLong(1);
    }

    public static String randomAlphaNumeric(int count) {
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    private String getAccountName(Statement stmt) throws SQLException {
        stmt.execute("select current_account_locator()");
        this.resultSet = stmt.getResultSet();
        Assertions.assertTrue((boolean)this.resultSet.next());
        return this.resultSet.getString(1);
    }

    private long getAccountId(Statement stmt, String accountName) throws SQLException {
        stmt.execute("select to_number($1:\"AccountDPO:active_by_name\":id) as id\nfrom table(dposcan('\n  {\n    \"slices\" : [{\"name\" : \"AccountDPO:active_by_name\"}],\n    \"ranges\" : [\n            {\"name\": \"name\", \"value\": \"" + accountName + "\"}\n          ]\n   }'));");
        this.resultSet = stmt.getResultSet();
        Assertions.assertTrue((boolean)this.resultSet.next());
        return this.resultSet.getLong(1);
    }

    @Test
    @Disabled
    @DontRunOnGithubActions
    public void testGetTables() throws SQLException {
        String getAllTable = "select count(*) from db.information_schema.tables";
        String getAllBaseTable = "select count(*) from db.information_schema.tables where table_type = 'BASE TABLE'";
        String getAllView = "select count(*) from db.information_schema.tables where table_type = 'VIEW'";
        try (Connection connection = DatabaseMetaDataInternalIT.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.execute("alter session set ENABLE_DRIVER_TERSE_SHOW = true;");
            stmt.execute("alter session set qa_mode = false;");
            this.databaseMetaData = connection.getMetaData();
            try {
                ResultSet resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"ALIAS"});
            }
            catch (SQLException e) {
                Assertions.assertEquals((Object)ErrorCode.FEATURE_UNSUPPORTED.getSqlState(), (Object)e.getSQLState());
                Assertions.assertEquals((int)ErrorCode.FEATURE_UNSUPPORTED.getMessageCode(), (int)e.getErrorCode());
            }
            try (ResultSet resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"SYSTEM_TABLE"});){
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(resultSet));
            }
            int numSnowflakeTables = 0;
            try (ResultSet snowflakeResultSet = this.databaseMetaData.getTables("SNOWFLAKE", null, null, null);){
                numSnowflakeTables = this.getSizeOfResultSet(snowflakeResultSet);
            }
            try (ResultSet resultSet = this.databaseMetaData.getTables(null, null, null, null);){
                Assertions.assertEquals((int)this.getAllObjectCountInDBViaInforSchema(getAllTable), (int)(this.getSizeOfResultSet(resultSet) - numSnowflakeTables));
            }
            resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"VIEW", "SYSTEM_TABLE"});
            try {
                Assertions.assertEquals((int)this.getAllObjectCountInDBViaInforSchema(getAllView), (int)(this.getSizeOfResultSet(resultSet) - numSnowflakeTables));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"TABLE", "SYSTEM_TABLE"});
            try {
                Assertions.assertEquals((int)this.getAllObjectCountInDBViaInforSchema(getAllBaseTable), (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"TABLE", "VIEW", "SYSTEM_TABLE"});
            try {
                Assertions.assertEquals((int)this.getAllObjectCountInDBViaInforSchema(getAllTable), (int)(this.getSizeOfResultSet(resultSet) - numSnowflakeTables));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"TABLE", "VIEW"});
            try {
                Assertions.assertEquals((int)this.getAllObjectCountInDBViaInforSchema(getAllTable), (int)(this.getSizeOfResultSet(resultSet) - numSnowflakeTables));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"TABLE"});
            try {
                Assertions.assertEquals((int)this.getAllObjectCountInDBViaInforSchema(getAllBaseTable), (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"VIEW"});
            try {
                Assertions.assertEquals((int)this.getAllObjectCountInDBViaInforSchema(getAllView), (int)(this.getSizeOfResultSet(resultSet) - numSnowflakeTables));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = this.databaseMetaData.getTables("JDBC_DB1", "JDBC_SCHEMA11", null, new String[]{"TABLE"});
            try {
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = this.databaseMetaData.getTables("JDBC_DB1", "JDBC\\_SCHEMA11", "%", new String[]{"TABLE"});
            try {
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = this.databaseMetaData.getTables("JDBC_DB1", "JDBC%", null, new String[]{"TABLE"});
            try {
                Assertions.assertEquals((int)3, (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            stmt.execute("alter session set ENABLE_KEY_VALUE_TABLE = false;");
            resultSet = this.databaseMetaData.getTables("JDBC_DB1", "JDBC_SCH%", "J_BC_TBL122", new String[]{"TABLE"});
            try {
                resultSet.next();
                Assertions.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString(1));
                Assertions.assertEquals((Object)"JDBC_SCHEMA12", (Object)resultSet.getString(2));
                Assertions.assertEquals((Object)"JDBC_TBL122", (Object)resultSet.getString(3));
                Assertions.assertEquals((Object)"TABLE", (Object)resultSet.getString(4));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString(5));
                stmt.execute("alter session unset ENABLE_KEY_VALUE_TABLE;");
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = this.databaseMetaData.getTables("JDBC_DB1", null, "JDBC_TBL211", new String[]{"TABLE"});
            try {
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = this.databaseMetaData.getTableTypes();
            try {
                resultSet.next();
                Assertions.assertEquals((Object)"TABLE", (Object)resultSet.getString(1));
                resultSet.next();
                Assertions.assertEquals((Object)"VIEW", (Object)resultSet.getString(1));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            stmt.execute("alter session set ENABLE_DRIVER_TERSE_SHOW = default;");
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testGetMetaDataUseConnectionCtx() throws SQLException {
        try (Connection connection = DatabaseMetaDataInternalIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("use database JDBC_DB1");
            statement.execute("use schema JDBC_SCHEMA11");
            statement.execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getSchemas(null, null);){
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
            }
            resultSet = databaseMetaData.getTables(null, null, null, null);
            try {
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            statement.execute("use schema JDBC_SCHEMA12");
            resultSet = databaseMetaData.getTables(null, null, null, null);
            try {
                Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = databaseMetaData.getColumns(null, null, null, null);
            try {
                Assertions.assertEquals((int)4, (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            statement.execute("use schema TEST_CTX");
            resultSet = databaseMetaData.getPrimaryKeys(null, null, null);
            try {
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = databaseMetaData.getImportedKeys(null, null, null);
            try {
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = databaseMetaData.getExportedKeys(null, null, null);
            try {
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = databaseMetaData.getCrossReference(null, null, null, null, null, null);
            try {
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    private int getAllObjectCountInDBViaInforSchema(String SQLCmdTemplate) throws SQLException {
        int objectCount = 0;
        try (Connection con = DatabaseMetaDataInternalIT.getConnection();
             Statement st = con.createStatement();){
            st.execute("alter session set ENABLE_BUILTIN_SCHEMAS = true");
            try (ResultSet dbNameRS = st.executeQuery("select database_name from information_schema.databases");){
                while (dbNameRS.next()) {
                    String databaseName = dbNameRS.getString(1);
                    String execSQLCmd = SQLCmdTemplate.replaceAll("db", databaseName);
                    ResultSet object = st.executeQuery(execSQLCmd);
                    object.next();
                    objectCount += object.getInt(1);
                }
            }
        }
        return objectCount;
    }
}

