/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.DatabaseMetaDataInternalIT;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class DatabaseMetaDataInternalLatestIT
extends BaseJDBCTest {
    @BeforeEach
    public void setUp() throws Exception {
        try (Connection con = DatabaseMetaDataInternalLatestIT.getConnection();){
            DatabaseMetaDataInternalIT.initMetaData(con);
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        try (Connection con = DatabaseMetaDataInternalLatestIT.getConnection();){
            DatabaseMetaDataInternalIT.endMetaData(con);
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testGetMetaDataUseConnectionCtx() throws SQLException {
        try (Connection connection = DatabaseMetaDataInternalLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("use database JDBC_DB1");
            statement.execute("use schema JDBC_SCHEMA11");
            statement.execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(null, null, null, null);){
                resultSet.next();
                Assertions.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString(1));
                Assertions.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString(2));
            }
            resultSet = databaseMetaData.getColumns(null, null, null, null);
            try {
                resultSet.next();
                Assertions.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString(1));
                Assertions.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString(2));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testGetFunctionColumns() throws SQLException {
        try (Connection connection = DatabaseMetaDataInternalLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("create or replace function JDBC_DB1.JDBC_SCHEMA11.FUNC111 (a number, b number) RETURNS NUMBER COMMENT='multiply numbers' as 'a*b'");
            statement.execute("create or replace table JDBC_DB1.JDBC_SCHEMA11.BIN_TABLE(bin1 binary, bin2 binary(100), sharedCol decimal)");
            statement.execute("create or replace function JDBC_DB1.JDBC_SCHEMA11.FUNC112 () RETURNS TABLE(colA string(16777216), colB decimal, bin2 binary(8388608), sharedCol decimal) COMMENT= 'returns table of 4 columns' as 'select JDBC_DB1.JDBC_SCHEMA11.JDBC_TBL111.colA, JDBC_DB1.JDBC_SCHEMA11.JDBC_TBL111.colB, JDBC_DB1.JDBC_SCHEMA11.BIN_TABLE.bin2, JDBC_DB1.JDBC_SCHEMA11.BIN_TABLE.sharedCol from JDBC_DB1.JDBC_SCHEMA11.JDBC_TBL111 inner join JDBC_DB1.JDBC_SCHEMA11.BIN_TABLE on JDBC_DB1.JDBC_SCHEMA11.JDBC_TBL111.colB = JDBC_DB1.JDBC_SCHEMA11.BIN_TABLE.sharedCol'");
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getFunctionColumns("JDBC_DB1", "JDBC_SCHEMA11", "FUNC111", "%");){
                resultSet.next();
                Assertions.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"FUNC111", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)4, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"NUMBER(38,0)", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)38, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getShort("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"multiply numbers", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"FUNC111(NUMBER, NUMBER) RETURN NUMBER", (Object)resultSet.getString("SPECIFIC_NAME"));
                resultSet.next();
                Assertions.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"FUNC111", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"A", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)1, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)38, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getShort("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"multiply numbers", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)1, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"FUNC111(NUMBER, NUMBER) RETURN NUMBER", (Object)resultSet.getString("SPECIFIC_NAME"));
                resultSet.next();
                Assertions.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"FUNC111", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"B", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)1, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)38, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getShort("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"multiply numbers", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"FUNC111(NUMBER, NUMBER) RETURN NUMBER", (Object)resultSet.getString("SPECIFIC_NAME"));
                Assertions.assertFalse((boolean)resultSet.next());
            }
            resultSet = databaseMetaData.getFunctionColumns("JDBC_DB1", "JDBC_SCHEMA11", "FUNC112", "%");
            try {
                resultSet.next();
                Assertions.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"COLA", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)5, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)12, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"VARCHAR", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)databaseMetaData.getMaxCharLiteralLength(), (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)1, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
                resultSet.next();
                Assertions.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"COLB", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)5, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)38, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
                resultSet.next();
                Assertions.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"BIN2", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)5, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)-2, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"BINARY", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)38, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)databaseMetaData.getMaxBinaryLiteralLength(), (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)3, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
                resultSet.next();
                Assertions.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"SHAREDCOL", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)5, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)38, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)4, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = databaseMetaData.getFunctionColumns("%", "%", "%", "%");
            try {
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testGetTablesRaceCondition() throws SQLException, ExecutionException, InterruptedException {
        try (Connection connection = DatabaseMetaDataInternalLatestIT.getConnection();){
            int i;
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ExecutorService executorService = Executors.newFixedThreadPool(10);
            ArrayList futures = new ArrayList();
            for (i = 0; i < 10; ++i) {
                futures.add(executorService.submit(() -> {
                    try {
                        databaseMetaData.getTables(database, schema, null, null);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }));
            }
            executorService.shutdown();
            for (i = 0; i < 10; ++i) {
                ((Future)futures.get(i)).get();
            }
        }
    }
}

