/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import net.snowflake.client.TestUtil;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.jdbc.BaseJDBCWithSharedConnectionIT;
import net.snowflake.client.jdbc.DBMetadataResultSetMetadata;
import net.snowflake.client.jdbc.DatabaseMetaDataIT;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeDatabaseMetaData;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import net.snowflake.client.jdbc.SnowflakeStatement;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class DatabaseMetaDataLatestIT
extends BaseJDBCWithSharedConnectionIT {
    private static final String TEST_PROC = "create or replace procedure testproc(param1 float, param2 string)\n    returns varchar\n    language javascript\n    as\n    $$\n    var sql_command = \"Hello, world!\"\n    $$\n    ;";
    private static final String PI_PROCEDURE = "create or replace procedure GETPI()\n    returns float not null\n    language javascript\n    as\n    $$\n    return 3.1415926;\n    $$\n    ;";
    private static final String MESSAGE_PROCEDURE = "create or replace procedure MESSAGE_PROC(message varchar)\n    returns varchar not null\n    language javascript\n    as\n    $$\n    return message;\n    $$\n    ;";
    private static final String ENABLE_PATTERN_SEARCH = SFSessionProperty.ENABLE_PATTERN_SEARCH.getPropertyKey();
    private static final String startingSchema;
    private static final String startingDatabase;

    public void createDoubleQuotedSchemaAndCatalog(Statement statement) throws SQLException {
        statement.execute("create or replace database \"dbwith\"\"quotes\"");
        statement.execute("create or replace schema \"dbwith\"\"quotes\".\"schemawith\"\"quotes\"");
    }

    @BeforeEach
    public void setUp() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute("USE DATABASE " + startingDatabase);
            stmt.execute("USE SCHEMA " + startingSchema);
        }
    }

    @Test
    public void testUseConnectionCtx() throws Exception {
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
            String schema = connection.getSchema();
            TestUtil.withRandomSchema(statement, customSchema -> {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                statement.execute("create or replace table CTX_TBL_A (colA string, colB decimal, colC number PRIMARY KEY);");
                statement.execute("create or replace table CTX_TBL_B (colA string, colB decimal, colC number FOREIGN KEY REFERENCES CTX_TBL_A (colC));");
                statement.execute("create or replace table CTX_TBL_C (colA string, colB decimal, colC number, colD int, colE timestamp, colF string, colG number);");
                statement.execute("use schema " + schema);
                statement.execute("create or replace table CTX_TBL_D (colA string, colB decimal, colC number PRIMARY KEY);");
                statement.execute("create or replace table CTX_TBL_E (colA string, colB decimal, colC number FOREIGN KEY REFERENCES CTX_TBL_D (colC));");
                statement.execute("create or replace table CTX_TBL_F (colA string, colB decimal, colC number, colD int, colE timestamp, colF string, colG number);");
                statement.execute("use schema " + customSchema);
                try (ResultSet resultSet = databaseMetaData.getSchemas(null, null);){
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
                }
                resultSet = databaseMetaData.getTables(null, null, null, null);
                try {
                    Assertions.assertEquals((int)3, (int)this.getSizeOfResultSet(resultSet));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = databaseMetaData.getColumns(null, null, null, null);
                try {
                    Assertions.assertEquals((int)13, (int)this.getSizeOfResultSet(resultSet));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = databaseMetaData.getPrimaryKeys(null, null, null);
                try {
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = databaseMetaData.getImportedKeys(null, null, null);
                try {
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = databaseMetaData.getExportedKeys(null, null, null);
                try {
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = databaseMetaData.getCrossReference(null, null, null, null, null, null);
                try {
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                statement.execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=false");
                databaseMetaData = connection.getMetaData();
                resultSet = databaseMetaData.getSchemas(null, null);
                try {
                    MatcherAssert.assertThat((Object)this.getSizeOfResultSet(resultSet), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = databaseMetaData.getTables(null, null, null, null);
                try {
                    MatcherAssert.assertThat((Object)this.getSizeOfResultSet(resultSet), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(6)));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = databaseMetaData.getColumns(null, null, null, null);
                try {
                    MatcherAssert.assertThat((Object)this.getSizeOfResultSet(resultSet), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(26)));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = databaseMetaData.getPrimaryKeys(null, null, null);
                try {
                    MatcherAssert.assertThat((Object)this.getSizeOfResultSet(resultSet), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = databaseMetaData.getImportedKeys(null, null, null);
                try {
                    MatcherAssert.assertThat((Object)this.getSizeOfResultSet(resultSet), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = databaseMetaData.getExportedKeys(null, null, null);
                try {
                    MatcherAssert.assertThat((Object)this.getSizeOfResultSet(resultSet), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = databaseMetaData.getCrossReference(null, null, null, null, null, null);
                try {
                    MatcherAssert.assertThat((Object)this.getSizeOfResultSet(resultSet), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            });
        }
    }

    @Test
    public void testDoubleQuotedDatabaseAndSchema() throws Exception {
        try (Statement statement = connection.createStatement();){
            String database = startingDatabase;
            String schemaRandomPart = SnowflakeUtil.randomAlphaNumeric((int)5);
            String querySchema = TestUtil.ESCAPED_GENERATED_SCHEMA_PREFIX + "TEST\\_SCHEMA\\_\"WITH\\_QUOTES" + schemaRandomPart + "\"";
            String queryTable = "TESTTABLE\\_\"WITH\\_QUOTES\"";
            String schemaName = "\"GENERATED_TEST_SCHEMA_\"\"WITH_QUOTES" + schemaRandomPart + "\"\"\"";
            TestUtil.withSchema(statement, schemaName, () -> {
                statement.execute("create or replace table \"TESTTABLE_\"\"WITH_QUOTES\"\"\" (AMOUNT number, \"COL_\"\"QUOTED\"\"\" string)");
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet rs = metaData.getTables(database, querySchema, queryTable, null);){
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(rs));
                }
                rs = metaData.getColumns(database, querySchema, queryTable, null);
                try {
                    Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(rs));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                rs = metaData.getColumns(database, querySchema, queryTable, "COL\\_\"QUOTED\"");
                try {
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(rs));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                rs = metaData.getSchemas(database, querySchema);
                try {
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(rs));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            });
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testDoubleQuotedDatabaseInGetSchemas() throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("create or replace database \"\"\"quoteddb\"\"\"");
            statement.execute("create or replace database \"unquoteddb\"");
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet rs = metaData.getSchemas("\"quoteddb\"", null);){
                Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(rs));
            }
            rs = metaData.getSchemas("quoteddb", null);
            try {
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(rs));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = metaData.getSchemas("unquoteddb", null);
            try {
                Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(rs));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = metaData.getSchemas("\"unquoteddb\"", null);
            try {
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(rs));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testDoubleQuotedDatabaseInGetTables() throws SQLException {
        try (Statement statement = connection.createStatement();){
            this.createDoubleQuotedSchemaAndCatalog(statement);
            statement.execute("create or replace table \"dbwith\"\"quotes\".\"schemawith\"\"quotes\".\"testtable\" (col1 string, col2 string)");
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet rs = metaData.getTables("dbwith\"quotes", "schemawith\"quotes", null, null);){
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(rs));
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testDoubleQuotedDatabaseInGetColumns() throws SQLException {
        try (Statement statement = connection.createStatement();){
            this.createDoubleQuotedSchemaAndCatalog(statement);
            statement.execute("create or replace table \"dbwith\"\"quotes\".\"schemawith\"\"quotes\".\"testtable\"  (col1 string, col2 string)");
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet rs = metaData.getColumns("dbwith\"quotes", "schemawith\"quotes", null, null);){
                Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(rs));
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testDoubleQuotedDatabaseforGetPrimaryKeysAndForeignKeys() throws SQLException {
        try (Statement statement = connection.createStatement();){
            this.createDoubleQuotedSchemaAndCatalog(statement);
            statement.execute("create or replace table \"dbwith\"\"quotes\".\"schemawith\"\"quotes\".\"test1\"  (col1 integer not null, col2 integer not null, constraint pkey_1 primary key (col1, col2) not enforced)");
            statement.execute("create or replace table \"dbwith\"\"quotes\".\"schemawith\"\"quotes\".\"test2\" (col_a integer not null, col_b integer not null, constraint fkey_1 foreign key (col_a, col_b) references \"test1\" (col1, col2) not enforced)");
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet rs = metaData.getPrimaryKeys("dbwith\"quotes", "schemawith\"quotes", null);){
                Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(rs));
            }
            rs = metaData.getImportedKeys("dbwith\"quotes", "schemawith\"quotes", null);
            try {
                Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(rs));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testDoubleQuotedDatabaseforGetPrimaryKeysAndForeignKeysWithPatternSearchDisabled() throws SQLException {
        Properties properties = new Properties();
        properties.put(ENABLE_PATTERN_SEARCH, (Object)false);
        try (Connection con = DatabaseMetaDataLatestIT.getConnection(properties);
             Statement statement = con.createStatement();){
            this.createDoubleQuotedSchemaAndCatalog(statement);
            statement.execute("create or replace table \"dbwith\"\"quotes\".\"schemawith\"\"quotes\".\"test1\"  (col1 integer not null, col2 integer not null, constraint pkey_1 primary key (col1, col2) not enforced)");
            statement.execute("create or replace table \"dbwith\"\"quotes\".\"schemawith\"\"quotes\".\"test2\" (col_a integer not null, col_b integer not null, constraint fkey_1 foreign key (col_a, col_b) references \"test1\" (col1, col2) not enforced)");
            DatabaseMetaData metaData = con.getMetaData();
            try (ResultSet rs = metaData.getPrimaryKeys("dbwith\"quotes", "schemawith\"quotes", null);){
                Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(rs));
            }
            rs = metaData.getImportedKeys("dbwith\"quotes", "schemawith\"quotes", null);
            try {
                Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(rs));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testDoubleQuotedDatabaseInGetProcedures() throws SQLException {
        try (Statement statement = connection.createStatement();){
            this.createDoubleQuotedSchemaAndCatalog(statement);
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
            statement.execute("USE DATABASE \"dbwith\"\"quotes\"; USE SCHEMA \"schemawith\"\"quotes\"; create or replace procedure testproc(param1 float, param2 string)\n    returns varchar\n    language javascript\n    as\n    $$\n    var sql_command = \"Hello, world!\"\n    $$\n    ;");
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet rs = metaData.getProcedures("dbwith\"quotes", null, "TESTPROC");){
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(rs));
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testDoubleQuotedDatabaseInGetTablePrivileges() throws SQLException {
        try (Statement statement = connection.createStatement();){
            this.createDoubleQuotedSchemaAndCatalog(statement);
            statement.execute("create or replace table \"dbwith\"\"quotes\".\"schemawith\"\"quotes\".\"testtable\" (col1 string, col2 string)");
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet rs = metaData.getTablePrivileges("dbwith\"quotes", null, "%");){
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(rs));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFunctionSqlInjectionProtection() throws Throwable {
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("alter session set MULTI_STATEMENT_COUNT=0");
                DatabaseMetaData metaData = connection.getMetaData();
                String schemaSqlInection = "%' in database testwh; select 11 as bar; show databases like '%";
                try (ResultSet resultSet = metaData.getSchemas(null, schemaSqlInection);){
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                String columnSqlInjection = "%' in schema testschema; show columns like '%";
                try (ResultSet resultSet = metaData.getColumns(null, null, null, columnSqlInjection);){
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                String functionSqlInjection = "%' in account snowflake; show functions like '%";
                try (ResultSet resultSet = metaData.getColumns(null, null, null, functionSqlInjection);){
                    Assertions.assertFalse((boolean)resultSet.next());
                }
            }
            finally {
                statement.execute("alter session unset MULTI_STATEMENT_COUNT");
            }
        }
    }

    @Test
    public void testGetProcedureColumnsWildcards() throws Exception {
        try (Statement statement = connection.createStatement();){
            String database = startingDatabase;
            String schemaPrefix = "GENERATED_" + SnowflakeUtil.randomAlphaNumeric((int)5).toUpperCase();
            String schema1 = schemaPrefix + "SCH1";
            String schema2 = schemaPrefix + "SCH2";
            TestUtil.withSchema(statement, schema1, () -> {
                statement.execute(TEST_PROC);
                TestUtil.withSchema(statement, schema2, () -> {
                    statement.execute(TEST_PROC);
                    DatabaseMetaData metaData = connection.getMetaData();
                    try (ResultSet rs = metaData.getProcedureColumns(database, schemaPrefix + "SCH_", "TESTPROC", "PARAM1");){
                        Assertions.assertEquals((int)4, (int)this.getSizeOfResultSet(rs));
                    }
                });
            });
        }
    }

    @Test
    public void testGetFunctions() throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        String supportedStringFuncs = metadata.getStringFunctions();
        Assertions.assertEquals((Object)"ASCII,BIT_LENGTH,CHAR,CONCAT,INSERT,LCASE,LEFT,LENGTH,LPAD,LOCATE,LTRIM,OCTET_LENGTH,PARSE_IP,PARSE_URL,REPEAT,REVERSE,REPLACE,RPAD,RTRIMMED_LENGTH,SPACE,SPLIT,SPLIT_PART,SPLIT_TO_TABLE,STRTOK,STRTOK_TO_ARRAY,STRTOK_SPLIT_TO_TABLE,TRANSLATE,TRIM,UNICODE,UUID_STRING,INITCAP,LOWER,UPPER,REGEXP,REGEXP_COUNT,REGEXP_INSTR,REGEXP_LIKE,REGEXP_REPLACE,REGEXP_SUBSTR,RLIKE,CHARINDEX,CONTAINS,EDITDISTANCE,ENDSWITH,ILIKE,ILIKE ANY,LIKE,LIKE ALL,LIKE ANY,POSITION,REPLACE,RIGHT,STARTSWITH,SUBSTRING,COMPRESS,DECOMPRESS_BINARY,DECOMPRESS_STRING,BASE64_DECODE_BINARY,BASE64_DECODE_STRING,BASE64_ENCODE,HEX_DECODE_BINARY,HEX_DECODE_STRING,HEX_ENCODE,TRY_BASE64_DECODE_BINARY,TRY_BASE64_DECODE_STRING,TRY_HEX_DECODE_BINARY,TRY_HEX_DECODE_STRING,MD_5,MD5_HEX,MD5_BINARY,SHA1,SHA1_HEX,SHA2,SHA1_BINARY,SHA2_HEX,SHA2_BINARY, HASH,HASH_AGG,COLLATE,COLLATION", (Object)supportedStringFuncs);
        String supportedNumberFuncs = metadata.getNumericFunctions();
        Assertions.assertEquals((Object)"ABS,ACOS,ASIN,ATAN,ATAN2,CBRT,CEILING,COS,COT,DEGREES,EXP,FACTORIAL,FLOOR,HAVERSINE,LN,LOG,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,SQUARE,TAN,TRUNCATE", (Object)supportedNumberFuncs);
        String supportedSystemFuncs = metadata.getSystemFunctions();
        Assertions.assertEquals((Object)"DATABASE,IFNULL,USER", (Object)supportedSystemFuncs);
    }

    @Test
    public void testGetStringValueFromColumnDef() throws SQLException {
        Map<String, String> params = DatabaseMetaDataLatestIT.getConnectionParameters();
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        properties.put("stringsQuotedForColumnDef", "true");
        try (Connection connection = DriverManager.getConnection(params.get("uri"), properties);
             Statement statement = connection.createStatement();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable = "T0";
            statement.execute("create or replace table T0(C1 string, C2 string default '', C3 string default 'apples', C4 string default '\"apples\"', C5 int, C6 int default 5, C7 string default '''', C8 string default '''apples''''', C9  string default '%')");
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getColumns(database, schema, "T0", "%");){
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"''", (Object)resultSet.getString("COLUMN_DEF"));
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"'apples'", (Object)resultSet.getString("COLUMN_DEF"));
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"'\"apples\"'", (Object)resultSet.getString("COLUMN_DEF"));
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"5", (Object)resultSet.getString("COLUMN_DEF"));
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"''''", (Object)resultSet.getString("COLUMN_DEF"));
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"'''apples'''''", (Object)resultSet.getString("COLUMN_DEF"));
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"'%'", (Object)resultSet.getString("COLUMN_DEF"));
            }
        }
    }

    @Test
    public void testGetColumnsNullable() throws Throwable {
        try (Statement statement = connection.createStatement();){
            String database = startingDatabase;
            String schema = startingSchema;
            String targetTable = "T0";
            statement.execute("create or replace table T0(C1 int, C2 varchar(100), C3 string default '', C4 number(18,4), C5 double, C6 boolean, C7 date not null, C8 time, C9 timestamp_ntz(7), C10 binary,C11 variant, C12 timestamp_ltz(8), C13 timestamp_tz(3))");
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getColumns(database, schema, "T0", "%");){
                DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_COLUMNS);
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertTrue((boolean)resultSet.getBoolean("NULLABLE"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testSessionDatabaseParameter() throws Throwable {
        String altdb = "ALTERNATEDB";
        String altschema1 = "ALTERNATESCHEMA1";
        String altschema2 = "ALTERNATESCHEMA2";
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            String catalog = connection.getCatalog();
            String schema = connection.getSchema();
            try {
                statement.execute("create or replace database " + altdb);
                statement.execute("create or replace schema " + altschema1);
                statement.execute("create or replace schema " + altschema2);
                statement.execute("create or replace table " + altdb + "." + altschema1 + ".testtable1 (colA string, colB number)");
                statement.execute("create or replace table " + altdb + "." + altschema2 + ".testtable2 (colA string, colB number)");
                statement.execute("create or replace table " + catalog + "." + schema + ".testtable3 (colA string, colB number)");
                statement.execute("use database " + altdb);
                statement.execute("use schema " + altschema1);
                statement.execute("ALTER SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
                statement.execute("ALTER SESSION set CLIENT_METADATA_USE_SESSION_DATABASE=true");
                DatabaseMetaData metadata = connection.getMetaData();
                try (ResultSet resultSet = metadata.getColumns(null, null, "%", "COLA");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                resultSet = metadata.getColumns(null, altschema2, "%", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metadata.getColumns(altdb, null, "%", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metadata.getColumns(altdb, altschema2, "%", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                statement.execute("ALTER SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=false");
                metadata = connection.getMetaData();
                resultSet = metadata.getColumns(null, null, "%", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metadata.getColumns(null, altschema2, "%", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metadata.getColumns(altdb, null, "%", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metadata.getColumns(altdb, altschema2, "%", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                statement.execute("ALTER SESSION set CLIENT_METADATA_USE_SESSION_DATABASE=false");
                metadata = connection.getMetaData();
                resultSet = metadata.getColumns(null, null, "TESTTABLE_", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metadata.getColumns(null, altschema2, "%", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metadata.getColumns(altdb, null, "%", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metadata.getColumns(altdb, altschema2, "%", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                statement.execute("ALTER SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
                metadata = connection.getMetaData();
                resultSet = metadata.getColumns(null, null, "%", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metadata.getColumns(null, altschema2, "%", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metadata.getColumns(altdb, null, "%", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metadata.getColumns(altdb, altschema2, "%", "COLA");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                statement.execute("use database " + catalog);
                statement.execute("drop schema " + altdb + "." + altschema1);
                statement.execute("drop schema " + altdb + "." + altschema2);
                statement.execute("drop database " + altdb);
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testGetFunctionColumns() throws Exception {
        try (Statement statement = connection.createStatement();){
            String database = startingDatabase;
            String schema = startingSchema;
            statement.execute("create or replace table FuncColTest (colA int, colB string, colC number);");
            statement.execute("INSERT INTO FuncColTest VALUES (4, 'Hello', 6);");
            statement.execute("INSERT INTO FuncColTest VALUES (8, 'World', 10);");
            statement.execute("create or replace function total_rows_in_table() returns number as 'select count(*) from FuncColTest';");
            statement.execute("create or replace function FUNC111 (a number, b number) RETURNS NUMBER COMMENT='multiply numbers' as 'a*b'");
            statement.execute("create or replace table BIN_TABLE(bin1 binary, bin2 binary(100), sharedCol decimal)");
            statement.execute("create or replace table JDBC_TBL111(colA string, colB decimal, colC timestamp)");
            statement.execute("create or replace function FUNC112 () RETURNS TABLE(colA string(16777216), colB decimal, bin2 binary(8388608) , sharedCol decimal) COMMENT= 'returns table of 4 columns' as 'select JDBC_TBL111.colA, JDBC_TBL111.colB, BIN_TABLE.bin2, BIN_TABLE.sharedCol from JDBC_TBL111 inner join BIN_TABLE on JDBC_TBL111.colB =BIN_TABLE.sharedCol'");
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getFunctionColumns(database, schema, "FUNC111", "%");){
                DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_FUNCTION_COLUMNS);
                resultSet.next();
                Assertions.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"FUNC111", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)4, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"NUMBER(38,0)", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)38, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getShort("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"multiply numbers", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"FUNC111(NUMBER, NUMBER) RETURN NUMBER", (Object)resultSet.getString("SPECIFIC_NAME"));
                resultSet.next();
                Assertions.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"FUNC111", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"A", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)1, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)38, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getShort("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"multiply numbers", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)1, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"FUNC111(NUMBER, NUMBER) RETURN NUMBER", (Object)resultSet.getString("SPECIFIC_NAME"));
                resultSet.next();
                Assertions.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"FUNC111", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"B", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)1, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)38, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getShort("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"multiply numbers", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"FUNC111(NUMBER, NUMBER) RETURN NUMBER", (Object)resultSet.getString("SPECIFIC_NAME"));
                Assertions.assertFalse((boolean)resultSet.next());
            }
            resultSet = metaData.getFunctionColumns(database, schema, "FUNC112", "%");
            try {
                resultSet.next();
                Assertions.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"COLA", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)5, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)12, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"VARCHAR", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)0x1000000, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)1, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
                resultSet.next();
                Assertions.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"COLB", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)5, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)38, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
                resultSet.next();
                Assertions.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"BIN2", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)5, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)-2, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"BINARY", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)38, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)0x800000, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)3, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
                resultSet.next();
                Assertions.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"SHAREDCOL", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)5, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)38, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)4, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
                Assertions.assertFalse((boolean)resultSet.next());
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = metaData.getFunctionColumns("%", "%", "%", "%");
            try {
                Assertions.assertFalse((boolean)resultSet.next());
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = metaData.getFunctionColumns(database, schema, "total_rows_in_table%", "%");
            try {
                Assertions.assertEquals((int)17, (int)resultSet.getMetaData().getColumnCount());
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = metaData.getFunctionColumns(database, schema, "total_rows_in_table%", "%");
            try {
                resultSet.next();
                Assertions.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
                Assertions.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
                Assertions.assertEquals((Object)"TOTAL_ROWS_IN_TABLE", (Object)resultSet.getString("FUNCTION_NAME"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)4, (int)resultSet.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"NUMBER(38,0)", (Object)resultSet.getString("TYPE_NAME"));
                Assertions.assertEquals((int)38, (int)resultSet.getInt("PRECISION"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getShort("SCALE"));
                Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                Assertions.assertEquals((int)2, (int)resultSet.getInt("NULLABLE"));
                Assertions.assertEquals((Object)"user-defined function", (Object)resultSet.getString("REMARKS"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                Assertions.assertEquals((int)0, (int)resultSet.getInt("ORDINAL_POSITION"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
                Assertions.assertEquals((Object)"TOTAL_ROWS_IN_TABLE() RETURN NUMBER", (Object)resultSet.getString("SPECIFIC_NAME"));
                Assertions.assertFalse((boolean)resultSet.next());
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    @Test
    public void testHandlingSpecialChars() throws Exception {
        try (Statement statement = connection.createStatement();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            DatabaseMetaData metaData = connection.getMetaData();
            String escapeChar = metaData.getSearchStringEscape();
            statement.execute("create or replace table \"TEST\\1\\_1\" (\"C%1\" integer,\"C\\1\\\\11\" integer)");
            statement.execute("INSERT INTO \"TEST\\1\\_1\" (\"C%1\",\"C\\1\\\\11\") VALUES (0,0)");
            String specialSchemaSuffix = SnowflakeUtil.randomAlphaNumeric((int)5);
            String specialSchema = "\"GENERATED_SPECIAL%_\\SCHEMA" + specialSchemaSuffix + "\"";
            TestUtil.withSchema(statement, specialSchema, () -> {
                statement.execute("create or replace table " + specialSchema + ".\"TEST_1_1\" ( \"RNUM\" integer not null, \"C21\" integer,\"C11\" integer,\"C%1\" integer,\"C\\1\\\\11\" integer , primary key (\"RNUM\"))");
                statement.execute("INSERT INTO \"TEST_1_1\" (RNUM,C21,C11,\"C%1\",\"C\\1\\\\11\") VALUES (0,0,0,0,0)");
                String escapedTable1 = "TEST" + escapeChar + "\\1" + escapeChar + "\\" + escapeChar + "_1";
                try (ResultSet resultSet = metaData.getColumns(database, schema, escapedTable1, null);){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"C%1", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"C\\1\\\\11", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                String partiallyEscapedTable1 = "TEST" + escapeChar + "\\1" + escapeChar + "\\_1";
                try (ResultSet resultSet = metaData.getColumns(database, schema, partiallyEscapedTable1, null);){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"C%1", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"C\\1\\\\11", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                String escapedTable2 = "TEST" + escapeChar + "_1" + escapeChar + "_1";
                String escapedSchema = TestUtil.ESCAPED_GENERATED_SCHEMA_PREFIX + "SPECIAL%" + escapeChar + "_" + escapeChar + "\\SCHEMA" + specialSchemaSuffix;
                try (ResultSet resultSet = metaData.getColumns(database, escapedSchema, escapedTable2, null);){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"RNUM", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"C21", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"C11", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"C%1", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"C\\1\\\\11", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
            });
            statement.execute("create or replace table " + schema + ".\"TABLE_A\" (colA string)");
            statement.execute("create or replace table " + schema + ".\"TABLE_B\" (colB number)");
            String escapedTable = "TABLE" + escapeChar + "__";
            try (ResultSet resultSet = metaData.getColumns(database, schema, escapedTable, null);){
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"COLA", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"COLB", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertFalse((boolean)resultSet.next());
            }
            resultSet = metaData.getColumns(database, schema, escapedTable, "COLB");
            try {
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"COLB", (Object)resultSet.getString("COLUMN_NAME"));
                Assertions.assertFalse((boolean)resultSet.next());
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            statement.execute("create or replace table " + schema + ".\"special%table\" (colA string)");
            resultSet = metaData.getColumns(database, schema, "special" + escapeChar + "%table", null);
            try {
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"COLA", (Object)resultSet.getString("COLUMN_NAME"));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    @Test
    public void testUnderscoreInSchemaNamePatternForPrimaryAndForeignKeys() throws Exception {
        try (Statement statement = connection.createStatement();){
            String database = startingDatabase;
            TestUtil.withRandomSchema(statement, customSchema -> {
                String escapedSchema = customSchema.replace("_", "\\_");
                statement.execute("use schema " + customSchema);
                statement.execute("create or replace table PK_TEST (c1 int PRIMARY KEY, c2 VARCHAR(10))");
                statement.execute("create or replace table FK_TEST (c1 int REFERENCES PK_TEST(c1), c2 VARCHAR(10))");
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet rs = metaData.getPrimaryKeys(database, escapedSchema, null);){
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(rs));
                }
                rs = metaData.getImportedKeys(database, escapedSchema, null);
                try {
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(rs));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            });
        }
    }

    @Test
    public void testUnderscoreInSchemaNamePatternForPrimaryAndForeignKeysWithPatternSearchDisabled() throws Exception {
        Properties properties = new Properties();
        properties.put(ENABLE_PATTERN_SEARCH, (Object)false);
        try (Connection con = DatabaseMetaDataLatestIT.getConnection(properties);
             Statement statement = con.createStatement();){
            String database = con.getCatalog();
            TestUtil.withRandomSchema(statement, customSchema -> {
                String escapedSchema = customSchema.replace("_", "\\_");
                statement.execute("use schema " + customSchema);
                statement.execute("create or replace table PK_TEST (c1 int PRIMARY KEY, c2 VARCHAR(10))");
                statement.execute("create or replace table FK_TEST (c1 int REFERENCES PK_TEST(c1), c2 VARCHAR(10))");
                DatabaseMetaData metaData = con.getMetaData();
                try (ResultSet rs = metaData.getPrimaryKeys(database, escapedSchema, null);){
                    Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(rs));
                }
                rs = metaData.getImportedKeys(database, escapedSchema, null);
                try {
                    Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(rs));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                rs = metaData.getPrimaryKeys(database, (String)customSchema, null);
                try {
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(rs));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                rs = metaData.getImportedKeys(database, (String)customSchema, null);
                try {
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(rs));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            });
        }
    }

    @Test
    public void testTimestampWithTimezoneDataType() throws Exception {
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeQuery("create or replace table ts_test(ts timestamp_tz)");
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getColumns(database, schema, "TS_TEST", "TS");){
                resultSet.next();
                Assertions.assertEquals((Object)resultSet.getObject("DATA_TYPE"), (Object)2014);
            }
            SFBaseSession baseSession = connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession();
            Field field = SFBaseSession.class.getDeclaredField("enableReturnTimestampWithTimeZone");
            field.setAccessible(true);
            field.set(baseSession, false);
            metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getColumns(database, schema, "TS_TEST", "TS");){
                resultSet.next();
                Assertions.assertEquals((Object)resultSet.getObject("DATA_TYPE"), (Object)93);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetColumns() throws Throwable {
        try (Statement statement = connection.createStatement();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable = "T0";
            try {
                statement.execute("create or replace table T0(C1 int, C2 varchar(100), C3 string(16777216) default '', C4 number(18,4), C5 double, C6 boolean, C7 date not null, C8 time, C9 timestamp_ntz(7), C10 binary(8388608),C11 variant, C12 timestamp_ltz(8), C13 timestamp_tz(3))");
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet resultSet = metaData.getColumns(database, schema, "T0", "%");){
                    DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_COLUMNS);
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString(3));
                    Assertions.assertEquals((Object)"C1", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)-5, (int)resultSet.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)38, (int)resultSet.getInt("COLUMN_SIZE"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("DECIMAL_DIGITS"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NUM_PREC_RADIX"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("NULLABLE"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("ORDINAL_POSITION"));
                    Assertions.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
                    Assertions.assertEquals((short)0, (short)resultSet.getShort("SOURCE_DATA_TYPE"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString(3));
                    Assertions.assertEquals((Object)"C2", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)12, (int)resultSet.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"VARCHAR", (Object)resultSet.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)100, (int)resultSet.getInt("COLUMN_SIZE"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("DECIMAL_DIGITS"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NUM_PREC_RADIX"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("NULLABLE"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertEquals((int)100, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                    Assertions.assertEquals((int)2, (int)resultSet.getInt("ORDINAL_POSITION"));
                    Assertions.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
                    Assertions.assertEquals((short)0, (short)resultSet.getShort("SOURCE_DATA_TYPE"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString(3));
                    Assertions.assertEquals((Object)"C3", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)12, (int)resultSet.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"VARCHAR", (Object)resultSet.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)0x1000000, (int)resultSet.getInt("COLUMN_SIZE"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("DECIMAL_DIGITS"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NUM_PREC_RADIX"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("NULLABLE"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertEquals((int)0x1000000, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                    Assertions.assertEquals((int)3, (int)resultSet.getInt("ORDINAL_POSITION"));
                    Assertions.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
                    Assertions.assertEquals((short)0, (short)resultSet.getShort("SOURCE_DATA_TYPE"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString(3));
                    Assertions.assertEquals((Object)"C4", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)3, (int)resultSet.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)18, (int)resultSet.getInt("COLUMN_SIZE"));
                    Assertions.assertEquals((int)4, (int)resultSet.getInt("DECIMAL_DIGITS"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NUM_PREC_RADIX"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("NULLABLE"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                    Assertions.assertEquals((int)4, (int)resultSet.getInt("ORDINAL_POSITION"));
                    Assertions.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
                    Assertions.assertEquals((short)0, (short)resultSet.getShort("SOURCE_DATA_TYPE"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString(3));
                    Assertions.assertEquals((Object)"C5", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)8, (int)resultSet.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"DOUBLE", (Object)resultSet.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("COLUMN_SIZE"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("DECIMAL_DIGITS"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NUM_PREC_RADIX"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("NULLABLE"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                    Assertions.assertEquals((int)5, (int)resultSet.getInt("ORDINAL_POSITION"));
                    Assertions.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
                    Assertions.assertEquals((short)0, (short)resultSet.getShort("SOURCE_DATA_TYPE"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString(3));
                    Assertions.assertEquals((Object)"C6", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)16, (int)resultSet.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"BOOLEAN", (Object)resultSet.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("COLUMN_SIZE"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("DECIMAL_DIGITS"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NUM_PREC_RADIX"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("NULLABLE"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                    Assertions.assertEquals((int)6, (int)resultSet.getInt("ORDINAL_POSITION"));
                    Assertions.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
                    Assertions.assertEquals((short)0, (short)resultSet.getShort("SOURCE_DATA_TYPE"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString(3));
                    Assertions.assertEquals((Object)"C7", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)91, (int)resultSet.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"DATE", (Object)resultSet.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("COLUMN_SIZE"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("DECIMAL_DIGITS"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NUM_PREC_RADIX"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NULLABLE"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                    Assertions.assertEquals((int)7, (int)resultSet.getInt("ORDINAL_POSITION"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_NULLABLE"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
                    Assertions.assertEquals((short)0, (short)resultSet.getShort("SOURCE_DATA_TYPE"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString(3));
                    Assertions.assertEquals((Object)"C8", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)92, (int)resultSet.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"TIME", (Object)resultSet.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("COLUMN_SIZE"));
                    Assertions.assertEquals((int)9, (int)resultSet.getInt("DECIMAL_DIGITS"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NUM_PREC_RADIX"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("NULLABLE"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                    Assertions.assertEquals((int)8, (int)resultSet.getInt("ORDINAL_POSITION"));
                    Assertions.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
                    Assertions.assertEquals((short)0, (short)resultSet.getShort("SOURCE_DATA_TYPE"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString(3));
                    Assertions.assertEquals((Object)"C9", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)93, (int)resultSet.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"TIMESTAMPNTZ", (Object)resultSet.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("COLUMN_SIZE"));
                    Assertions.assertEquals((int)7, (int)resultSet.getInt("DECIMAL_DIGITS"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NUM_PREC_RADIX"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("NULLABLE"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                    Assertions.assertEquals((int)9, (int)resultSet.getInt("ORDINAL_POSITION"));
                    Assertions.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
                    Assertions.assertEquals((short)0, (short)resultSet.getShort("SOURCE_DATA_TYPE"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString(3));
                    Assertions.assertEquals((Object)"C10", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)-2, (int)resultSet.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"BINARY", (Object)resultSet.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)0x800000, (int)resultSet.getInt("COLUMN_SIZE"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("DECIMAL_DIGITS"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NUM_PREC_RADIX"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("NULLABLE"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                    Assertions.assertEquals((int)10, (int)resultSet.getInt("ORDINAL_POSITION"));
                    Assertions.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
                    Assertions.assertEquals((short)0, (short)resultSet.getShort("SOURCE_DATA_TYPE"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString(3));
                    Assertions.assertEquals((Object)"C11", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)12, (int)resultSet.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"VARIANT", (Object)resultSet.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("COLUMN_SIZE"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("DECIMAL_DIGITS"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NUM_PREC_RADIX"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("NULLABLE"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                    Assertions.assertEquals((int)11, (int)resultSet.getInt("ORDINAL_POSITION"));
                    Assertions.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
                    Assertions.assertEquals((short)0, (short)resultSet.getShort("SOURCE_DATA_TYPE"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString(3));
                    Assertions.assertEquals((Object)"C12", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)93, (int)resultSet.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"TIMESTAMPLTZ", (Object)resultSet.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("COLUMN_SIZE"));
                    Assertions.assertEquals((int)8, (int)resultSet.getInt("DECIMAL_DIGITS"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NUM_PREC_RADIX"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("NULLABLE"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                    Assertions.assertEquals((int)12, (int)resultSet.getInt("ORDINAL_POSITION"));
                    Assertions.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
                    Assertions.assertEquals((short)0, (short)resultSet.getShort("SOURCE_DATA_TYPE"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString(3));
                    Assertions.assertEquals((Object)"C13", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)2014, (int)resultSet.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"TIMESTAMPTZ", (Object)resultSet.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("COLUMN_SIZE"));
                    Assertions.assertEquals((int)3, (int)resultSet.getInt("DECIMAL_DIGITS"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NUM_PREC_RADIX"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("NULLABLE"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                    Assertions.assertEquals((int)13, (int)resultSet.getInt("ORDINAL_POSITION"));
                    Assertions.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
                    Assertions.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
                    Assertions.assertEquals((short)0, (short)resultSet.getShort("SOURCE_DATA_TYPE"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
                }
                statement.execute("create or replace table T0(C1 string, C2 string default '', C3 string default 'apples', C4 string default '\"apples\"', C5 int, C6 int default 5, C7 string default '''', C8 string default '''apples''''', C9  string default '%')");
                metaData = connection.getMetaData();
                resultSet = metaData.getColumns(database, schema, "T0", "%");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"apples", (Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"\"apples\"", (Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"5", (Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"'", (Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"'apples''", (Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"%", (Object)resultSet.getString("COLUMN_DEF"));
                    try {
                        resultSet.getString("INVALID_COLUMN");
                        Assertions.fail((String)"must fail");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metaData.getColumnPrivileges(database, schema, "T0", "C1");
                try {
                    Assertions.assertEquals((int)0, (int)super.getSizeOfResultSet(resultSet));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists T0");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetStreams() throws SQLException {
        String targetStream = "S0";
        String targetTable = "T0";
        try (Statement statement = connection.createStatement();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String owner = connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession().getRole();
            String tableName = database + "." + schema + "." + "T0";
            try {
                statement.execute("create or replace table T0(C1 int)");
                statement.execute("create or replace stream S0 on table T0");
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet resultSet = metaData.unwrap(SnowflakeDatabaseMetaData.class).getStreams(database, schema, "%");){
                    DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_STREAMS);
                    HashSet<String> streams = new HashSet<String>();
                    while (resultSet.next()) {
                        streams.add(resultSet.getString(1));
                    }
                    Assertions.assertTrue((boolean)streams.contains("S0"));
                }
                resultSet = metaData.unwrap(SnowflakeDatabaseMetaData.class).getStreams(database, schema, "S0");
                try {
                    resultSet.next();
                    Assertions.assertEquals((Object)"S0", (Object)resultSet.getString(1));
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString(2));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString(3));
                    Assertions.assertEquals((Object)owner, (Object)resultSet.getString(4));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString(5));
                    Assertions.assertEquals((Object)tableName, (Object)resultSet.getString(6));
                    Assertions.assertEquals((Object)"Table", (Object)resultSet.getString(7));
                    Assertions.assertEquals((Object)tableName, (Object)resultSet.getString(8));
                    Assertions.assertEquals((Object)"DELTA", (Object)resultSet.getString(9));
                    Assertions.assertEquals((Object)"false", (Object)resultSet.getString(10));
                    Assertions.assertEquals((Object)"DEFAULT", (Object)resultSet.getString(11));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists T0");
                statement.execute("drop stream if exists S0");
            }
        }
    }

    @Test
    @Disabled
    public void testGetProceduresWithReaderAccount() throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        try (ResultSet rs = metadata.getProcedures(null, null, null);){
            Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(rs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testGetProcedureColumns() throws Exception {
        try (Statement statement = connection.createStatement();){
            String database = startingDatabase;
            String schema = startingSchema;
            try {
                statement.execute(PI_PROCEDURE);
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet resultSet = metaData.getProcedureColumns(database, schema, "GETPI", "%");){
                    DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_PROCEDURE_COLUMNS);
                    resultSet.next();
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("PROCEDURE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("PROCEDURE_SCHEM"));
                    Assertions.assertEquals((Object)"GETPI", (Object)resultSet.getString("PROCEDURE_NAME"));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)5, (int)resultSet.getInt("COLUMN_TYPE"));
                    Assertions.assertEquals((int)6, (int)resultSet.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"FLOAT", (Object)resultSet.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)38, (int)resultSet.getInt("PRECISION"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("LENGTH"));
                    Assertions.assertEquals((int)0, (int)resultSet.getShort("SCALE"));
                    Assertions.assertEquals((int)10, (int)resultSet.getInt("RADIX"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("NULLABLE"));
                    Assertions.assertEquals((Object)"user-defined procedure", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertNull((Object)resultSet.getString("COLUMN_DEF"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("SQL_DATA_TYPE"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("SQL_DATETIME_SUB"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("CHAR_OCTET_LENGTH"));
                    Assertions.assertEquals((int)0, (int)resultSet.getInt("ORDINAL_POSITION"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_NULLABLE"));
                    Assertions.assertEquals((Object)"GETPI() RETURN FLOAT", (Object)resultSet.getString("SPECIFIC_NAME"));
                }
            }
            finally {
                statement.execute("drop procedure if exists GETPI()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProcedureColumnsReturnsResultSet() throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table testtable (id int, name varchar(20), address varchar(20));");
                statement.execute("create or replace procedure PROCTEST()\nreturns table (\"id\" number(38,0), \"name\" varchar(20), \"address\" varchar(20))\nlanguage sql\nexecute as owner\nas 'declare\n    res resultset default (select * from testtable);\n  begin\n    return table(res);\n  end';");
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet res = metaData.getProcedureColumns(connection.getCatalog(), null, "PROCTEST", "%");){
                    res.next();
                    Assertions.assertEquals((Object)"PROCTEST", (Object)res.getString("PROCEDURE_NAME"));
                    Assertions.assertEquals((Object)"id", (Object)res.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)3, (int)res.getInt("COLUMN_TYPE"));
                    Assertions.assertEquals((int)2, (int)res.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"NUMBER", (Object)res.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)1, (int)res.getInt("ORDINAL_POSITION"));
                    res.next();
                    Assertions.assertEquals((Object)"name", (Object)res.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)3, (int)res.getInt("COLUMN_TYPE"));
                    Assertions.assertEquals((int)12, (int)res.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"VARCHAR", (Object)res.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)2, (int)res.getInt("ORDINAL_POSITION"));
                    res.next();
                    Assertions.assertEquals((Object)"address", (Object)res.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)3, (int)res.getInt("COLUMN_TYPE"));
                    Assertions.assertEquals((int)12, (int)res.getInt("DATA_TYPE"));
                    Assertions.assertEquals((Object)"VARCHAR", (Object)res.getString("TYPE_NAME"));
                    Assertions.assertEquals((int)3, (int)res.getInt("ORDINAL_POSITION"));
                }
            }
            finally {
                statement.execute("drop table if exists testtable");
            }
        }
    }

    @Test
    public void testGetProcedureColumnsReturnsValue() throws SQLException {
        try (Statement statement = connection.createStatement();){
            DatabaseMetaData metaData = connection.getMetaData();
            statement.execute(PI_PROCEDURE);
            try (ResultSet res = metaData.getProcedureColumns(connection.getCatalog(), null, "GETPI", "%");){
                res.next();
                Assertions.assertEquals((Object)"GETPI", (Object)res.getString("PROCEDURE_NAME"));
                Assertions.assertEquals((Object)"", (Object)res.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)5, (int)res.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)6, (int)res.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"FLOAT", (Object)res.getString("TYPE_NAME"));
                Assertions.assertEquals((int)0, (int)res.getInt("ORDINAL_POSITION"));
            }
            statement.execute(MESSAGE_PROCEDURE);
            res = metaData.getProcedureColumns(connection.getCatalog(), null, "MESSAGE_PROC", "%");
            try {
                res.next();
                Assertions.assertEquals((Object)"MESSAGE_PROC", (Object)res.getString("PROCEDURE_NAME"));
                Assertions.assertEquals((Object)"", (Object)res.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)5, (int)res.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)12, (int)res.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"VARCHAR", (Object)res.getString("TYPE_NAME"));
                Assertions.assertEquals((int)0, (int)res.getInt("ORDINAL_POSITION"));
                res.next();
                Assertions.assertEquals((Object)"MESSAGE", (Object)res.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)1, (int)res.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)12, (int)res.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"VARCHAR", (Object)res.getString("TYPE_NAME"));
                Assertions.assertEquals((int)1, (int)res.getInt("ORDINAL_POSITION"));
            }
            finally {
                if (res != null) {
                    res.close();
                }
            }
        }
    }

    @Test
    public void testGetProcedureColumnsReturnsNull() throws SQLException {
        try (Statement statement = connection.createStatement();){
            DatabaseMetaData metaData = connection.getMetaData();
            statement.execute("create or replace table testtable (id int, name varchar(20), address varchar(20));");
            statement.execute("create or replace procedure insertproc() \nreturns varchar \nlanguage javascript as \n'var sqlcommand = \n`insert into testtable (id, name, address) values (1, \\'Tom\\', \\'Pacific Avenue\\');` \nsnowflake.execute({sqlText: sqlcommand}); \n';");
            try (ResultSet res = metaData.getProcedureColumns(connection.getCatalog(), null, "INSERTPROC", "%");){
                res.next();
                Assertions.assertEquals((Object)"INSERTPROC", (Object)res.getString("PROCEDURE_NAME"));
                Assertions.assertEquals((Object)"", (Object)res.getString("COLUMN_NAME"));
                Assertions.assertEquals((int)5, (int)res.getInt("COLUMN_TYPE"));
                Assertions.assertEquals((int)12, (int)res.getInt("DATA_TYPE"));
                Assertions.assertEquals((Object)"VARCHAR", (Object)res.getString("TYPE_NAME"));
                Assertions.assertEquals((int)0, (int)res.getInt("ORDINAL_POSITION"));
            }
        }
    }

    @Test
    public void testUpdateLocatorsCopyUnsupported() throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        Assertions.assertFalse((boolean)metaData.locatorsUpdateCopy());
    }

    @Test
    public void testNoPatternSearchAllowedForPrimaryAndForeignKeys() throws Exception {
        Properties properties = new Properties();
        properties.put(ENABLE_PATTERN_SEARCH, "false");
        String table1 = "PATTERN_SEARCH_TABLE1";
        String table2 = "PATTERN_SEARCH_TABLE2";
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection(properties);
             Statement statement = connection.createStatement();){
            String schemaRandomPart = SnowflakeUtil.randomAlphaNumeric((int)5);
            String schemaName = "\"GENERATED_TEST_PATTERNS_SCHEMA_" + schemaRandomPart + "\"";
            TestUtil.withSchema(statement, schemaName, () -> {
                String schema = connection.getSchema();
                statement.execute("create or replace table PATTERN_SEARCH_TABLE1(C1 int primary key, C2 string)");
                statement.execute("create or replace table PATTERN_SEARCH_TABLE2(C1 int primary key, C2 string, C3 int references PATTERN_SEARCH_TABLE1)");
                DatabaseMetaData dbmd = connection.getMetaData();
                String schemaPattern1 = schema.substring(0, schema.length() - 1).concat("%");
                String schemaPattern2 = schema.substring(0, schema.length() - 1).concat("_");
                String tablePattern1 = "PATTERN_SEARCH_TABLE%";
                String tablePattern2 = "PATTERN_SEARCH_TABLE_";
                String database = connection.getCatalog();
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, schema, "PATTERN_SEARCH_TABLE1")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, schemaPattern1, "PATTERN_SEARCH_TABLE1")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, schemaPattern2, "PATTERN_SEARCH_TABLE1")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, schemaPattern1, null)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, schemaPattern2, null)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, schema, tablePattern1)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, schema, tablePattern2)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, null, tablePattern1)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, null, tablePattern2)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, schemaPattern1, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, schemaPattern1, null)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, schemaPattern2, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, schemaPattern2, null)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, null, tablePattern1)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, null, tablePattern2)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, schema, tablePattern1)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, schema, tablePattern2)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getExportedKeys(database, schema, "PATTERN_SEARCH_TABLE1")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getExportedKeys(database, schemaPattern1, "PATTERN_SEARCH_TABLE1")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getExportedKeys(database, null, tablePattern1)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getExportedKeys(database, null, tablePattern2)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getExportedKeys(database, schema, tablePattern1)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getExportedKeys(database, schema, tablePattern2)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schemaPattern1, "PATTERN_SEARCH_TABLE1", database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schemaPattern2, "PATTERN_SEARCH_TABLE1", database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schemaPattern1, null, database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schemaPattern2, null, database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, schemaPattern1, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, schemaPattern2, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, schemaPattern1, null)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, schemaPattern2, null)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, null, tablePattern1, database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, null, tablePattern2, database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, tablePattern1, database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, tablePattern2, database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, null, tablePattern1)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, null, tablePattern2)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, schema, tablePattern1)));
                Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, schema, tablePattern2)));
            });
        }
    }

    @Test
    public void testPatternSearchAllowedForPrimaryAndForeignKeys() throws Exception {
        String table1 = "PATTERN_SEARCH_TABLE1";
        String table2 = "PATTERN_SEARCH_TABLE2";
        try (Statement statement = connection.createStatement();){
            String schemaRandomPart = SnowflakeUtil.randomAlphaNumeric((int)5);
            String schemaName = "\"GENERATED_TEST_PATTERNS_SCHEMA_" + schemaRandomPart + "\"";
            TestUtil.withSchema(statement, schemaName, () -> {
                String schema = connection.getSchema();
                statement.execute("create or replace table PATTERN_SEARCH_TABLE1(C1 int primary key, C2 string)");
                statement.execute("create or replace table PATTERN_SEARCH_TABLE2(C1 int primary key, C2 string, C3 int references PATTERN_SEARCH_TABLE1)");
                DatabaseMetaData dbmd = connection.getMetaData();
                String schemaPattern1 = schema.substring(0, schema.length() - 1).concat("%");
                String schemaPattern2 = schema.substring(0, schema.length() - 1).concat("_");
                String tablePattern1 = "PATTERN_SEARCH_TABLE%";
                String tablePattern2 = "PATTERN_SEARCH_TABLE_";
                String database = connection.getCatalog();
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, schema, "PATTERN_SEARCH_TABLE1")));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, schemaPattern1, "PATTERN_SEARCH_TABLE1")));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, schemaPattern2, "PATTERN_SEARCH_TABLE1")));
                Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, schemaPattern1, null)));
                Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, schemaPattern2, null)));
                Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, schema, tablePattern1)));
                Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, schema, tablePattern2)));
                MatcherAssert.assertThat((Object)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, null, tablePattern1)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
                MatcherAssert.assertThat((Object)this.getSizeOfResultSet(dbmd.getPrimaryKeys(database, null, tablePattern2)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, schemaPattern1, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, schemaPattern1, null)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, schemaPattern2, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, schemaPattern2, null)));
                MatcherAssert.assertThat((Object)this.getSizeOfResultSet(dbmd.getImportedKeys(database, null, tablePattern1)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
                MatcherAssert.assertThat((Object)this.getSizeOfResultSet(dbmd.getImportedKeys(database, null, tablePattern2)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, schema, tablePattern1)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getImportedKeys(database, schema, tablePattern2)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getExportedKeys(database, schema, "PATTERN_SEARCH_TABLE1")));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getExportedKeys(database, schemaPattern1, "PATTERN_SEARCH_TABLE1")));
                MatcherAssert.assertThat((Object)this.getSizeOfResultSet(dbmd.getExportedKeys(database, null, tablePattern1)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
                MatcherAssert.assertThat((Object)this.getSizeOfResultSet(dbmd.getExportedKeys(database, null, tablePattern2)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getExportedKeys(database, schema, tablePattern1)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getExportedKeys(database, schema, tablePattern2)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schemaPattern1, "PATTERN_SEARCH_TABLE1", database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schemaPattern2, "PATTERN_SEARCH_TABLE1", database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schemaPattern1, null, database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schemaPattern2, null, database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, schemaPattern1, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, schemaPattern2, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, schemaPattern1, null)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, schemaPattern2, null)));
                MatcherAssert.assertThat((Object)this.getSizeOfResultSet(dbmd.getCrossReference(database, null, tablePattern1, database, schema, "PATTERN_SEARCH_TABLE2")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
                MatcherAssert.assertThat((Object)this.getSizeOfResultSet(dbmd.getCrossReference(database, null, tablePattern2, database, schema, "PATTERN_SEARCH_TABLE2")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, tablePattern1, database, schema, "PATTERN_SEARCH_TABLE2")));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, tablePattern2, database, schema, "PATTERN_SEARCH_TABLE2")));
                MatcherAssert.assertThat((Object)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, null, tablePattern1)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
                MatcherAssert.assertThat((Object)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, null, tablePattern2)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, schema, tablePattern1)));
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(dbmd.getCrossReference(database, schema, "PATTERN_SEARCH_TABLE1", database, schema, tablePattern2)));
            });
        }
    }

    @Test
    public void testGetJDBCVersion() throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        Assertions.assertEquals((int)4, (int)metaData.getJDBCMajorVersion());
        Assertions.assertEquals((int)2, (int)metaData.getJDBCMinorVersion());
    }

    @Test
    public void testKeywordsCount() throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        Assertions.assertEquals((int)43, (int)metaData.getSQLKeywords().split(",").length);
    }

    @Test
    public void testVectorDimension() throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("create or replace table JDBC_VECTOR(text_col varchar(32), float_vec VECTOR(FLOAT, 256), int_vec VECTOR(INT, 16))");
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getColumns(connection.getCatalog(), connection.getSchema().replaceAll("_", "\\\\_"), "JDBC\\_VECTOR", null);){
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)32, (Object)resultSet.getObject("COLUMN_SIZE"));
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)256, (Object)resultSet.getObject("COLUMN_SIZE"));
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)16, (Object)resultSet.getObject("COLUMN_SIZE"));
                Assertions.assertFalse((boolean)resultSet.next());
            }
            resultSet = statement.executeQuery("Select text_col, float_vec, int_vec from JDBC_VECTOR");
            try {
                SnowflakeResultSetMetaData unwrapResultSetMetadata = resultSet.getMetaData().unwrap(SnowflakeResultSetMetaData.class);
                Assertions.assertEquals((int)0, (int)unwrapResultSetMetadata.getDimension("TEXT_COL"));
                Assertions.assertEquals((int)0, (int)unwrapResultSetMetadata.getDimension(1));
                Assertions.assertEquals((int)256, (int)unwrapResultSetMetadata.getDimension("FLOAT_VEC"));
                Assertions.assertEquals((int)256, (int)unwrapResultSetMetadata.getDimension(2));
                Assertions.assertEquals((int)16, (int)unwrapResultSetMetadata.getDimension("INT_VEC"));
                Assertions.assertEquals((int)16, (int)unwrapResultSetMetadata.getDimension(3));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    static {
        try {
            startingSchema = connection.getSchema();
            startingDatabase = connection.getCatalog();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

