/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import net.snowflake.client.jdbc.BaseJDBCWithSharedConnectionIT;
import net.snowflake.client.jdbc.SnowflakeDatabaseMetaDataResultSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class DatabaseMetaDataResultsetIT
extends BaseJDBCWithSharedConnectionIT {
    private static final int columnCount = 9;
    private static final int INT_DATA = 1;
    private static final String TEXT_DATA = "TEST";
    private static final String EPOCH_DATE = "1970-01-01";
    private static final double DOUBLE_DATA = 9.5555555;
    private static final double DELTA = 1.0E-4;
    private static final long NOW = System.currentTimeMillis();
    private static final Time TIME_DATA = new Time(NOW);
    private static final Timestamp TIMESTAMP_DATA = new Timestamp(NOW);
    private static final boolean BOOLEAN_DATA = true;
    private static final BigDecimal DECIMAL_DATA = new BigDecimal(0.01);
    private static final long BIGINT_DATA = 10100000L;
    private static final List<String> columnNames = Arrays.asList("int", "text", "date", "double", "time", "timestamp", "bool", "decimal", "bigint");
    private static final List<String> columnTypeNames = Arrays.asList("INTEGER", "TEXT", "DATA", "DOUBLE", "TIME", "TIMESTAMP", "BOOLEAN", "DECIMAL", "BIGINT");
    private static final List<Integer> columnTypes = Arrays.asList(4, 12, 91, 8, 92, 93, 16, 3, -5);
    private static final Object[][] rows = new Object[][]{{1, "TEST", Date.valueOf("1970-01-01"), 9.5555555, TIME_DATA, TIMESTAMP_DATA, true, DECIMAL_DATA, 10100000L}, {0, null, null, 0, null, null, false, null, 0}};

    @Test
    public void testRowIndex() throws SQLException {
        try (ResultSet resultSet = this.getResultSet(false);){
            Assertions.assertEquals((int)9, (int)resultSet.getMetaData().getColumnCount());
            Assertions.assertEquals((int)-1, (int)resultSet.getRow());
            Assertions.assertTrue((boolean)resultSet.isBeforeFirst());
            Assertions.assertFalse((boolean)resultSet.isFirst());
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((int)0, (int)resultSet.getRow());
            Assertions.assertFalse((boolean)resultSet.isBeforeFirst());
            Assertions.assertTrue((boolean)resultSet.isFirst());
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((int)1, (int)resultSet.getRow());
            Assertions.assertTrue((boolean)resultSet.isLast());
            Assertions.assertFalse((boolean)resultSet.isAfterLast());
            Assertions.assertFalse((boolean)resultSet.next());
            Assertions.assertEquals((int)2, (int)resultSet.getRow());
            Assertions.assertFalse((boolean)resultSet.isLast());
            Assertions.assertTrue((boolean)resultSet.isAfterLast());
        }
    }

    private ResultSet getResultSet(boolean doNext) throws SQLException {
        Statement st = connection.createStatement();
        SnowflakeDatabaseMetaDataResultSet resultSet = new SnowflakeDatabaseMetaDataResultSet(columnNames, columnTypeNames, columnTypes, rows, st);
        if (doNext) {
            resultSet.next();
        }
        return resultSet;
    }

    @Test
    public void testGetInt() throws SQLException {
        try (ResultSet resultSet = this.getResultSet(true);){
            Assertions.assertEquals((int)1, (int)resultSet.getInt("int"));
        }
    }

    @Test
    public void testGetString() throws SQLException {
        try (ResultSet resultSet = this.getResultSet(true);){
            Assertions.assertEquals((Object)TEXT_DATA, (Object)resultSet.getString("text"));
        }
    }

    @Test
    public void testGetDate() throws SQLException {
        try (ResultSet resultSet = this.getResultSet(true);){
            Assertions.assertEquals((Object)Date.valueOf(EPOCH_DATE), (Object)resultSet.getDate("date"));
        }
    }

    @Test
    public void testGetDouble() throws SQLException {
        try (ResultSet resultSet = this.getResultSet(true);){
            Assertions.assertEquals((double)9.5555555, (double)resultSet.getDouble("double"), (double)1.0E-4);
        }
    }

    @Test
    public void testGetTime() throws SQLException {
        try (ResultSet resultSet = this.getResultSet(true);){
            Assertions.assertEquals((Object)TIME_DATA, (Object)resultSet.getTime("time"));
        }
    }

    @Test
    public void testGetTimestamp() throws SQLException {
        try (ResultSet resultSet = this.getResultSet(true);){
            Assertions.assertEquals((Object)TIMESTAMP_DATA, (Object)resultSet.getTimestamp("timestamp"));
        }
    }

    @Test
    public void testGetBoolean() throws SQLException {
        try (ResultSet resultSet = this.getResultSet(true);){
            Assertions.assertEquals((Object)true, (Object)resultSet.getBoolean("bool"));
        }
    }

    @Test
    public void testGetObject() throws SQLException {
        try (ResultSet resultSet = this.getResultSet(true);){
            Assertions.assertEquals((Object)1, (Object)resultSet.getObject(1));
            Assertions.assertEquals((Object)TEXT_DATA, (Object)resultSet.getObject(2));
            Assertions.assertEquals((Object)Date.valueOf(EPOCH_DATE), (Object)resultSet.getObject(3));
            Assertions.assertEquals((Object)9.5555555, (Object)resultSet.getObject(4));
            Assertions.assertEquals((Object)TIME_DATA, (Object)resultSet.getObject(5));
            Assertions.assertEquals((Object)TIMESTAMP_DATA, (Object)resultSet.getObject(6));
            Assertions.assertEquals((Object)true, (Object)resultSet.getObject(7));
            Assertions.assertEquals((Object)DECIMAL_DATA, (Object)resultSet.getObject(8));
            Assertions.assertEquals((Object)10100000L, (Object)resultSet.getObject(9));
        }
    }
}

