/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SessionUtilExternalBrowser;
import net.snowflake.client.jdbc.MockAuthExternalBrowserHandlers;
import org.mockito.Mockito;

class FakeSessionUtilExternalBrowser
extends SessionUtilExternalBrowser {
    private static final String MOCK_SAML_TOKEN = "MOCK_SAML_TOKEN";
    private final ServerSocket mockServerSocket;

    FakeSessionUtilExternalBrowser(SFLoginInput loginInput) {
        super(loginInput, (SessionUtilExternalBrowser.AuthExternalBrowserHandlers)new MockAuthExternalBrowserHandlers());
        try {
            this.mockServerSocket = FakeSessionUtilExternalBrowser.initMockServerSocket();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to initialize ServerSocket mock");
        }
    }

    private static ServerSocket initMockServerSocket() throws IOException {
        Socket mockSocket = (Socket)Mockito.mock(Socket.class);
        String str = String.format("GET /?token=%s HTTP/1.1\r\nUSER-AGENT: snowflake client", MOCK_SAML_TOKEN);
        ByteArrayInputStream stream = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
        Mockito.when((Object)mockSocket.getInputStream()).thenReturn((Object)stream);
        Mockito.when((Object)mockSocket.getOutputStream()).thenReturn((Object)new NullOutputStream());
        ServerSocket mockServerSocket = (ServerSocket)Mockito.mock(ServerSocket.class);
        Mockito.when((Object)mockServerSocket.getLocalPort()).thenReturn((Object)12345);
        Mockito.when((Object)mockServerSocket.accept()).thenReturn((Object)mockSocket);
        return mockServerSocket;
    }

    protected ServerSocket getServerSocket() throws SFException {
        return this.mockServerSocket;
    }

    protected int getLocalPort(ServerSocket ssocket) {
        return super.getLocalPort(ssocket);
    }

    static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

